package software.amazon.awscdk.services.eks;

/**
 * Properties for configuring an Amazon EKS Access Policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.eks.*;
 * AccessPolicyArn accessPolicyArn;
 * AccessPolicyProps accessPolicyProps = AccessPolicyProps.builder()
 *         .accessScope(AccessScope.builder()
 *                 .type(AccessScopeType.NAMESPACE)
 *                 // the properties below are optional
 *                 .namespaces(List.of("namespaces"))
 *                 .build())
 *         .policy(accessPolicyArn)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:31.273Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AccessPolicyProps")
@software.amazon.jsii.Jsii.Proxy(AccessPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AccessPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The scope of the access policy, which determines the level of access granted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AccessScope getAccessScope();

    /**
     * The access policy itself, which defines the specific permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.AccessPolicyArn getPolicy();

    /**
     * @return a {@link Builder} of {@link AccessPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AccessPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AccessPolicyProps> {
        software.amazon.awscdk.services.eks.AccessScope accessScope;
        software.amazon.awscdk.services.eks.AccessPolicyArn policy;

        /**
         * Sets the value of {@link AccessPolicyProps#getAccessScope}
         * @param accessScope The scope of the access policy, which determines the level of access granted. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessScope(software.amazon.awscdk.services.eks.AccessScope accessScope) {
            this.accessScope = accessScope;
            return this;
        }

        /**
         * Sets the value of {@link AccessPolicyProps#getPolicy}
         * @param policy The access policy itself, which defines the specific permissions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.services.eks.AccessPolicyArn policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AccessPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AccessPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AccessPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccessPolicyProps {
        private final software.amazon.awscdk.services.eks.AccessScope accessScope;
        private final software.amazon.awscdk.services.eks.AccessPolicyArn policy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessScope = software.amazon.jsii.Kernel.get(this, "accessScope", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessScope.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AccessPolicyArn.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessScope = java.util.Objects.requireNonNull(builder.accessScope, "accessScope is required");
            this.policy = java.util.Objects.requireNonNull(builder.policy, "policy is required");
        }

        @Override
        public final software.amazon.awscdk.services.eks.AccessScope getAccessScope() {
            return this.accessScope;
        }

        @Override
        public final software.amazon.awscdk.services.eks.AccessPolicyArn getPolicy() {
            return this.policy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accessScope", om.valueToTree(this.getAccessScope()));
            data.set("policy", om.valueToTree(this.getPolicy()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.AccessPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AccessPolicyProps.Jsii$Proxy that = (AccessPolicyProps.Jsii$Proxy) o;

            if (!accessScope.equals(that.accessScope)) return false;
            return this.policy.equals(that.policy);
        }

        @Override
        public final int hashCode() {
            int result = this.accessScope.hashCode();
            result = 31 * result + (this.policy.hashCode());
            return result;
        }
    }
}
