package software.amazon.awscdk.services.eks;

/**
 * Properties for KubernetesObjectValue.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // query the load balancer address
 * KubernetesObjectValue myServiceAddress = KubernetesObjectValue.Builder.create(this, "LoadBalancerAttribute")
 *         .cluster(cluster)
 *         .objectType("service")
 *         .objectName("my-service")
 *         .jsonPath(".status.loadBalancer.ingress[0].hostname")
 *         .build();
 * // pass the address to a lambda function
 * Function proxyFunction = Function.Builder.create(this, "ProxyFunction")
 *         .handler("index.handler")
 *         .code(Code.fromInline("my-code"))
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .environment(Map.of(
 *                 "myServiceAddress", myServiceAddress.getValue()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:31.387Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.KubernetesObjectValueProps")
@software.amazon.jsii.Jsii.Proxy(KubernetesObjectValueProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KubernetesObjectValueProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The EKS cluster to fetch attributes from.
     * <p>
     * [disable-awslint:ref-via-interface]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getCluster();

    /**
     * JSONPath to the specific value.
     * <p>
     * @see <a href="https://kubernetes.io/docs/reference/kubectl/jsonpath/">https://kubernetes.io/docs/reference/kubectl/jsonpath/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJsonPath();

    /**
     * The name of the object to query.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectName();

    /**
     * The object type to query.
     * <p>
     * (e.g 'service', 'pod'...)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getObjectType();

    /**
     * The namespace the object belongs to.
     * <p>
     * Default: 'default'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getObjectNamespace() {
        return null;
    }

    /**
     * Timeout for waiting on a value.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KubernetesObjectValueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KubernetesObjectValueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KubernetesObjectValueProps> {
        software.amazon.awscdk.services.eks.ICluster cluster;
        java.lang.String jsonPath;
        java.lang.String objectName;
        java.lang.String objectType;
        java.lang.String objectNamespace;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link KubernetesObjectValueProps#getCluster}
         * @param cluster The EKS cluster to fetch attributes from. This parameter is required.
         *                [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.eks.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesObjectValueProps#getJsonPath}
         * @param jsonPath JSONPath to the specific value. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonPath(java.lang.String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesObjectValueProps#getObjectName}
         * @param objectName The name of the object to query. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectName(java.lang.String objectName) {
            this.objectName = objectName;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesObjectValueProps#getObjectType}
         * @param objectType The object type to query. This parameter is required.
         *                   (e.g 'service', 'pod'...)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectType(java.lang.String objectType) {
            this.objectType = objectType;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesObjectValueProps#getObjectNamespace}
         * @param objectNamespace The namespace the object belongs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectNamespace(java.lang.String objectNamespace) {
            this.objectNamespace = objectNamespace;
            return this;
        }

        /**
         * Sets the value of {@link KubernetesObjectValueProps#getTimeout}
         * @param timeout Timeout for waiting on a value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KubernetesObjectValueProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KubernetesObjectValueProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KubernetesObjectValueProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KubernetesObjectValueProps {
        private final software.amazon.awscdk.services.eks.ICluster cluster;
        private final java.lang.String jsonPath;
        private final java.lang.String objectName;
        private final java.lang.String objectType;
        private final java.lang.String objectNamespace;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
            this.jsonPath = software.amazon.jsii.Kernel.get(this, "jsonPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.objectName = software.amazon.jsii.Kernel.get(this, "objectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.objectType = software.amazon.jsii.Kernel.get(this, "objectType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.objectNamespace = software.amazon.jsii.Kernel.get(this, "objectNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(builder.cluster, "cluster is required");
            this.jsonPath = java.util.Objects.requireNonNull(builder.jsonPath, "jsonPath is required");
            this.objectName = java.util.Objects.requireNonNull(builder.objectName, "objectName is required");
            this.objectType = java.util.Objects.requireNonNull(builder.objectType, "objectType is required");
            this.objectNamespace = builder.objectNamespace;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.eks.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.String getJsonPath() {
            return this.jsonPath;
        }

        @Override
        public final java.lang.String getObjectName() {
            return this.objectName;
        }

        @Override
        public final java.lang.String getObjectType() {
            return this.objectType;
        }

        @Override
        public final java.lang.String getObjectNamespace() {
            return this.objectNamespace;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("jsonPath", om.valueToTree(this.getJsonPath()));
            data.set("objectName", om.valueToTree(this.getObjectName()));
            data.set("objectType", om.valueToTree(this.getObjectType()));
            if (this.getObjectNamespace() != null) {
                data.set("objectNamespace", om.valueToTree(this.getObjectNamespace()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.KubernetesObjectValueProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KubernetesObjectValueProps.Jsii$Proxy that = (KubernetesObjectValueProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!jsonPath.equals(that.jsonPath)) return false;
            if (!objectName.equals(that.objectName)) return false;
            if (!objectType.equals(that.objectType)) return false;
            if (this.objectNamespace != null ? !this.objectNamespace.equals(that.objectNamespace) : that.objectNamespace != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.jsonPath.hashCode());
            result = 31 * result + (this.objectName.hashCode());
            result = 31 * result + (this.objectType.hashCode());
            result = 31 * result + (this.objectNamespace != null ? this.objectNamespace.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
