package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * The prefix to use for source NAT for a dual-stack network load balancer with UDP listeners.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * IVpc dualstackVpc;
 * ISubnet subnet;
 * ISubnet dualstackSubnet;
 * CfnEIP cfnEip;
 * // Internet facing Network Load Balancer with an Elastic IPv4 address
 * // Internet facing Network Load Balancer with an Elastic IPv4 address
 * NetworkLoadBalancer.Builder.create(this, "InternetFacingLb")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .subnetMappings(List.of(SubnetMapping.builder()
 *                 .subnet(subnet)
 *                 // The allocation ID of the Elastic IP address
 *                 .allocationId(cfnEip.getAttrAllocationId())
 *                 .build()))
 *         .build();
 * // Internal Network Load Balancer with a private IPv4 address
 * // Internal Network Load Balancer with a private IPv4 address
 * NetworkLoadBalancer.Builder.create(this, "InternalLb")
 *         .vpc(vpc)
 *         .internetFacing(false)
 *         .subnetMappings(List.of(SubnetMapping.builder()
 *                 .subnet(subnet)
 *                 // The private IPv4 address from the subnet
 *                 // The address must be in the subnet's CIDR range and
 *                 // can not be configured for a internet facing Network Load Balancer.
 *                 .privateIpv4Address("10.0.12.29")
 *                 .build()))
 *         .build();
 * // Dualstack Network Load Balancer with an IPv6 address and prefix for source NAT
 * // Dualstack Network Load Balancer with an IPv6 address and prefix for source NAT
 * NetworkLoadBalancer.Builder.create(this, "DualstackLb")
 *         .vpc(dualstackVpc)
 *         // Configure the dualstack Network Load Balancer
 *         .ipAddressType(IpAddressType.DUAL_STACK)
 *         .enablePrefixForIpv6SourceNat(true)
 *         .subnetMappings(List.of(SubnetMapping.builder()
 *                 .subnet(dualstackSubnet)
 *                 // The IPv6 address from the subnet
 *                 // `ipAddresstype` must be `DUAL_STACK` or `DUAL_STACK_WITHOUT_PUBLIC_IPV4` to set the IPv6 address.
 *                 .ipv6Address("2001:db8:1234:1a00::10")
 *                 // The IPv6 prefix to use for source NAT
 *                 // `enablePrefixForIpv6SourceNat` must be `true` to set `sourceNatIpv6Prefix`.
 *                 .sourceNatIpv6Prefix(SourceNatIpv6Prefix.autoAssigned())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:31.670Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.SourceNatIpv6Prefix")
public class SourceNatIpv6Prefix extends software.amazon.jsii.JsiiObject {

    protected SourceNatIpv6Prefix(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SourceNatIpv6Prefix(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param prefix The IPv6 prefix. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SourceNatIpv6Prefix(final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Use an automatically assigned IPv6 prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix autoAssigned() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix.class, "autoAssigned", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix.class));
    }

    /**
     * Use a custom IPv6 prefix with /80 netmask.
     * <p>
     * @param prefix The IPv6 prefix. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix fromIpv6Prefix(final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix.class, "fromIpv6Prefix", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.SourceNatIpv6Prefix.class), new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * The IPv6 prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPrefix() {
        return software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
