package software.amazon.awscdk.services.emr;

/**
 * Properties for defining a <code>CfnStep</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * CfnStepProps cfnStepProps = CfnStepProps.builder()
 *         .actionOnFailure("actionOnFailure")
 *         .hadoopJarStep(HadoopJarStepConfigProperty.builder()
 *                 .jar("jar")
 *                 // the properties below are optional
 *                 .args(List.of("args"))
 *                 .mainClass("mainClass")
 *                 .stepProperties(List.of(KeyValueProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .jobFlowId("jobFlowId")
 *         .name("name")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:31.812Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnStepProps")
@software.amazon.jsii.Jsii.Proxy(CfnStepProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStepProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * This specifies what action to take when the cluster step fails.
     * <p>
     * Possible values are <code>CANCEL_AND_WAIT</code> and <code>CONTINUE</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html#cfn-emr-step-actiononfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html#cfn-emr-step-actiononfailure</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getActionOnFailure();

    /**
     * The <code>HadoopJarStepConfig</code> property type specifies a job flow step consisting of a JAR file whose main function will be executed.
     * <p>
     * The main function submits a job for the cluster to execute as a step on the master node, and then waits for the job to finish or fail before executing subsequent steps.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html#cfn-emr-step-hadoopjarstep">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html#cfn-emr-step-hadoopjarstep</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getHadoopJarStep();

    /**
     * A string that uniquely identifies the cluster (job flow).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html#cfn-emr-step-jobflowid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html#cfn-emr-step-jobflowid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobFlowId();

    /**
     * The name of the cluster step.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html#cfn-emr-step-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-step.html#cfn-emr-step-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * @return a {@link Builder} of {@link CfnStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStepProps> {
        java.lang.String actionOnFailure;
        java.lang.Object hadoopJarStep;
        java.lang.String jobFlowId;
        java.lang.String name;

        /**
         * Sets the value of {@link CfnStepProps#getActionOnFailure}
         * @param actionOnFailure This specifies what action to take when the cluster step fails. This parameter is required.
         *                        Possible values are <code>CANCEL_AND_WAIT</code> and <code>CONTINUE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionOnFailure(java.lang.String actionOnFailure) {
            this.actionOnFailure = actionOnFailure;
            return this;
        }

        /**
         * Sets the value of {@link CfnStepProps#getHadoopJarStep}
         * @param hadoopJarStep The <code>HadoopJarStepConfig</code> property type specifies a job flow step consisting of a JAR file whose main function will be executed. This parameter is required.
         *                      The main function submits a job for the cluster to execute as a step on the master node, and then waits for the job to finish or fail before executing subsequent steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hadoopJarStep(software.amazon.awscdk.IResolvable hadoopJarStep) {
            this.hadoopJarStep = hadoopJarStep;
            return this;
        }

        /**
         * Sets the value of {@link CfnStepProps#getHadoopJarStep}
         * @param hadoopJarStep The <code>HadoopJarStepConfig</code> property type specifies a job flow step consisting of a JAR file whose main function will be executed. This parameter is required.
         *                      The main function submits a job for the cluster to execute as a step on the master node, and then waits for the job to finish or fail before executing subsequent steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hadoopJarStep(software.amazon.awscdk.services.emr.CfnStep.HadoopJarStepConfigProperty hadoopJarStep) {
            this.hadoopJarStep = hadoopJarStep;
            return this;
        }

        /**
         * Sets the value of {@link CfnStepProps#getJobFlowId}
         * @param jobFlowId A string that uniquely identifies the cluster (job flow). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobFlowId(java.lang.String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStepProps#getName}
         * @param name The name of the cluster step. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStepProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStepProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStepProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStepProps {
        private final java.lang.String actionOnFailure;
        private final java.lang.Object hadoopJarStep;
        private final java.lang.String jobFlowId;
        private final java.lang.String name;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionOnFailure = software.amazon.jsii.Kernel.get(this, "actionOnFailure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hadoopJarStep = software.amazon.jsii.Kernel.get(this, "hadoopJarStep", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.jobFlowId = software.amazon.jsii.Kernel.get(this, "jobFlowId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionOnFailure = java.util.Objects.requireNonNull(builder.actionOnFailure, "actionOnFailure is required");
            this.hadoopJarStep = java.util.Objects.requireNonNull(builder.hadoopJarStep, "hadoopJarStep is required");
            this.jobFlowId = java.util.Objects.requireNonNull(builder.jobFlowId, "jobFlowId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
        }

        @Override
        public final java.lang.String getActionOnFailure() {
            return this.actionOnFailure;
        }

        @Override
        public final java.lang.Object getHadoopJarStep() {
            return this.hadoopJarStep;
        }

        @Override
        public final java.lang.String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionOnFailure", om.valueToTree(this.getActionOnFailure()));
            data.set("hadoopJarStep", om.valueToTree(this.getHadoopJarStep()));
            data.set("jobFlowId", om.valueToTree(this.getJobFlowId()));
            data.set("name", om.valueToTree(this.getName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnStepProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStepProps.Jsii$Proxy that = (CfnStepProps.Jsii$Proxy) o;

            if (!actionOnFailure.equals(that.actionOnFailure)) return false;
            if (!hadoopJarStep.equals(that.hadoopJarStep)) return false;
            if (!jobFlowId.equals(that.jobFlowId)) return false;
            return this.name.equals(that.name);
        }

        @Override
        public final int hashCode() {
            int result = this.actionOnFailure.hashCode();
            result = 31 * result + (this.hadoopJarStep.hashCode());
            result = 31 * result + (this.jobFlowId.hashCode());
            result = 31 * result + (this.name.hashCode());
            return result;
        }
    }
}
