package software.amazon.awscdk.services.evidently;

/**
 * Properties for defining a <code>CfnProject</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.evidently.*;
 * CfnProjectProps cfnProjectProps = CfnProjectProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .appConfigResource(AppConfigResourceObjectProperty.builder()
 *                 .applicationId("applicationId")
 *                 .environmentId("environmentId")
 *                 .build())
 *         .dataDelivery(DataDeliveryObjectProperty.builder()
 *                 .logGroup("logGroup")
 *                 .s3(S3DestinationProperty.builder()
 *                         .bucketName("bucketName")
 *                         // the properties below are optional
 *                         .prefix("prefix")
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:32.063Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnProjectProps")
@software.amazon.jsii.Jsii.Proxy(CfnProjectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnProjectProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name for the project.
     * <p>
     * It can include up to 127 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Use this parameter if the project will use <em>client-side evaluation powered by AWS AppConfig</em> .
     * <p>
     * Client-side evaluation allows your application to assign variations to user sessions locally instead of by calling the <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature</a> operation. This mitigates the latency and availability risks that come with an API call. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html">Use client-side evaluation - powered by AWS AppConfig .</a>
     * <p>
     * This parameter is a structure that contains information about the AWS AppConfig application that will be used as for client-side evaluation.
     * <p>
     * To create a project that uses client-side evaluation, you must have the <code>evidently:ExportProjectAsConfiguration</code> permission.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-appconfigresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-appconfigresource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAppConfigResource() {
        return null;
    }

    /**
     * A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so.
     * <p>
     * If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.
     * <p>
     * You can't specify both <code>CloudWatchLogs</code> and <code>S3Destination</code> in the same operation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-datadelivery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-datadelivery</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataDelivery() {
        return null;
    }

    /**
     * An optional description of the project.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Assigns one or more tags (key-value pairs) to the project.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * <p>
     * You can associate as many as 50 tags with a project.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-project.html#cfn-evidently-project-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnProjectProps> {
        java.lang.String name;
        java.lang.Object appConfigResource;
        java.lang.Object dataDelivery;
        java.lang.String description;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnProjectProps#getName}
         * @param name The name for the project. This parameter is required.
         *             It can include up to 127 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getAppConfigResource}
         * @param appConfigResource Use this parameter if the project will use <em>client-side evaluation powered by AWS AppConfig</em> .
         *                          Client-side evaluation allows your application to assign variations to user sessions locally instead of by calling the <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature</a> operation. This mitigates the latency and availability risks that come with an API call. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html">Use client-side evaluation - powered by AWS AppConfig .</a>
         *                          <p>
         *                          This parameter is a structure that contains information about the AWS AppConfig application that will be used as for client-side evaluation.
         *                          <p>
         *                          To create a project that uses client-side evaluation, you must have the <code>evidently:ExportProjectAsConfiguration</code> permission.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appConfigResource(software.amazon.awscdk.IResolvable appConfigResource) {
            this.appConfigResource = appConfigResource;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getAppConfigResource}
         * @param appConfigResource Use this parameter if the project will use <em>client-side evaluation powered by AWS AppConfig</em> .
         *                          Client-side evaluation allows your application to assign variations to user sessions locally instead of by calling the <a href="https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html">EvaluateFeature</a> operation. This mitigates the latency and availability risks that come with an API call. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html">Use client-side evaluation - powered by AWS AppConfig .</a>
         *                          <p>
         *                          This parameter is a structure that contains information about the AWS AppConfig application that will be used as for client-side evaluation.
         *                          <p>
         *                          To create a project that uses client-side evaluation, you must have the <code>evidently:ExportProjectAsConfiguration</code> permission.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appConfigResource(software.amazon.awscdk.services.evidently.CfnProject.AppConfigResourceObjectProperty appConfigResource) {
            this.appConfigResource = appConfigResource;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getDataDelivery}
         * @param dataDelivery A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so.
         *                     If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.
         *                     <p>
         *                     You can't specify both <code>CloudWatchLogs</code> and <code>S3Destination</code> in the same operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDelivery(software.amazon.awscdk.IResolvable dataDelivery) {
            this.dataDelivery = dataDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getDataDelivery}
         * @param dataDelivery A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so.
         *                     If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.
         *                     <p>
         *                     You can't specify both <code>CloudWatchLogs</code> and <code>S3Destination</code> in the same operation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDelivery(software.amazon.awscdk.services.evidently.CfnProject.DataDeliveryObjectProperty dataDelivery) {
            this.dataDelivery = dataDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getDescription}
         * @param description An optional description of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnProjectProps#getTags}
         * @param tags Assigns one or more tags (key-value pairs) to the project.
         *             Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         *             <p>
         *             Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         *             <p>
         *             You can associate as many as 50 tags with a project.
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnProjectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnProjectProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnProjectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnProjectProps {
        private final java.lang.String name;
        private final java.lang.Object appConfigResource;
        private final java.lang.Object dataDelivery;
        private final java.lang.String description;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.appConfigResource = software.amazon.jsii.Kernel.get(this, "appConfigResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataDelivery = software.amazon.jsii.Kernel.get(this, "dataDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.appConfigResource = builder.appConfigResource;
            this.dataDelivery = builder.dataDelivery;
            this.description = builder.description;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getAppConfigResource() {
            return this.appConfigResource;
        }

        @Override
        public final java.lang.Object getDataDelivery() {
            return this.dataDelivery;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getAppConfigResource() != null) {
                data.set("appConfigResource", om.valueToTree(this.getAppConfigResource()));
            }
            if (this.getDataDelivery() != null) {
                data.set("dataDelivery", om.valueToTree(this.getDataDelivery()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnProjectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnProjectProps.Jsii$Proxy that = (CfnProjectProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (this.appConfigResource != null ? !this.appConfigResource.equals(that.appConfigResource) : that.appConfigResource != null) return false;
            if (this.dataDelivery != null ? !this.dataDelivery.equals(that.dataDelivery) : that.dataDelivery != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.appConfigResource != null ? this.appConfigResource.hashCode() : 0);
            result = 31 * result + (this.dataDelivery != null ? this.dataDelivery.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
