package software.amazon.awscdk.services.gamelift;

/**
 * Properties for defining a <code>CfnContainerFleet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnContainerFleetProps cfnContainerFleetProps = CfnContainerFleetProps.builder()
 *         .fleetRoleArn("fleetRoleArn")
 *         // the properties below are optional
 *         .billingType("billingType")
 *         .deploymentConfiguration(DeploymentConfigurationProperty.builder()
 *                 .impairmentStrategy("impairmentStrategy")
 *                 .minimumHealthyPercentage(123)
 *                 .protectionStrategy("protectionStrategy")
 *                 .build())
 *         .description("description")
 *         .gameServerContainerGroupDefinitionName("gameServerContainerGroupDefinitionName")
 *         .gameServerContainerGroupsPerInstance(123)
 *         .gameSessionCreationLimitPolicy(GameSessionCreationLimitPolicyProperty.builder()
 *                 .newGameSessionsPerCreator(123)
 *                 .policyPeriodInMinutes(123)
 *                 .build())
 *         .instanceConnectionPortRange(ConnectionPortRangeProperty.builder()
 *                 .fromPort(123)
 *                 .toPort(123)
 *                 .build())
 *         .instanceInboundPermissions(List.of(IpPermissionProperty.builder()
 *                 .fromPort(123)
 *                 .ipRange("ipRange")
 *                 .protocol("protocol")
 *                 .toPort(123)
 *                 .build()))
 *         .instanceType("instanceType")
 *         .locations(List.of(LocationConfigurationProperty.builder()
 *                 .location("location")
 *                 // the properties below are optional
 *                 .locationCapacity(LocationCapacityProperty.builder()
 *                         .desiredEc2Instances(123)
 *                         .maxSize(123)
 *                         .minSize(123)
 *                         .build())
 *                 .stoppedActions(List.of("stoppedActions"))
 *                 .build()))
 *         .logConfiguration(LogConfigurationProperty.builder()
 *                 .logDestination("logDestination")
 *                 .logGroupArn("logGroupArn")
 *                 .s3BucketName("s3BucketName")
 *                 .build())
 *         .metricGroups(List.of("metricGroups"))
 *         .newGameSessionProtectionPolicy("newGameSessionProtectionPolicy")
 *         .perInstanceContainerGroupDefinitionName("perInstanceContainerGroupDefinitionName")
 *         .scalingPolicies(List.of(ScalingPolicyProperty.builder()
 *                 .metricName("metricName")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .comparisonOperator("comparisonOperator")
 *                 .evaluationPeriods(123)
 *                 .policyType("policyType")
 *                 .scalingAdjustment(123)
 *                 .scalingAdjustmentType("scalingAdjustmentType")
 *                 .targetConfiguration(TargetConfigurationProperty.builder()
 *                         .targetValue(123)
 *                         .build())
 *                 .threshold(123)
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:32.270Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnContainerFleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnContainerFleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnContainerFleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier for an AWS Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers.
     * <p>
     * See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set up an IAM service role</a> . This fleet property can't be changed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-fleetrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-fleetrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFleetRoleArn();

    /**
     * Indicates whether the fleet uses On-Demand or Spot instances for this fleet.
     * <p>
     * Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot">On-Demand versus Spot Instances</a> . You can't update this fleet property.
     * <p>
     * By default, this property is set to <code>ON_DEMAND</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-billingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-billingtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBillingType() {
        return null;
    }

    /**
     * Set of rules for processing a deployment for a container fleet update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-deploymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-deploymentconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentConfiguration() {
        return null;
    }

    /**
     * A meaningful description of the container fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the fleet's game server container group definition, which describes how to deploy containers with your game server build and support software onto each fleet instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gameservercontainergroupdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gameservercontainergroupdefinitionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGameServerContainerGroupDefinitionName() {
        return null;
    }

    /**
     * The number of times to replicate the game server container group on each fleet instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gameservercontainergroupsperinstance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gameservercontainergroupsperinstance</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGameServerContainerGroupsPerInstance() {
        return null;
    }

    /**
     * A policy that limits the number of game sessions that each individual player can create on instances in this fleet.
     * <p>
     * The limit applies for a specified span of time.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-gamesessioncreationlimitpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGameSessionCreationLimitPolicy() {
        return null;
    }

    /**
     * The set of port numbers to open on each instance in a container fleet.
     * <p>
     * Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceconnectionportrange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceconnectionportrange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceConnectionPortRange() {
        return null;
    }

    /**
     * The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceinboundpermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instanceinboundpermissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceInboundPermissions() {
        return null;
    }

    /**
     * The Amazon EC2 instance type to use for all instances in the fleet.
     * <p>
     * Instance type determines the computing resources and processing power that's available to host your game servers. This includes including CPU, memory, storage, and networking capacity. You can't update this fleet property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-instancetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-locations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-locations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLocations() {
        return null;
    }

    /**
     * The method that is used to collect container logs for the fleet.
     * <p>
     * Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.
     * <p>
     * <ul>
     * <li><code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.</li>
     * <li><code>S3</code> -- Store logs in an Amazon S3 bucket that you define.</li>
     * <li><code>NONE</code> -- Don't collect container logs.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-logconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
        return null;
    }

    /**
     * The name of an AWS CloudWatch metric group to add this fleet to.
     * <p>
     * Metric groups aggregate metrics for multiple fleets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-metricgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-metricgroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMetricGroups() {
        return null;
    }

    /**
     * Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players.
     * <p>
     * Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet capacity or when retiring unhealthy instances. You can also set game session protection for individual game sessions using <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a> .
     * <p>
     * <ul>
     * <li><em>NoProtection</em> -- Game sessions can be shut down during active gameplay.</li>
     * <li><em>FullProtection</em> -- Game sessions in <code>ACTIVE</code> status can't be shut down.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-newgamesessionprotectionpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-newgamesessionprotectionpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNewGameSessionProtectionPolicy() {
        return null;
    }

    /**
     * The name of the fleet's per-instance container group definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-perinstancecontainergroupdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-perinstancecontainergroupdefinitionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPerInstanceContainerGroupDefinitionName() {
        return null;
    }

    /**
     * A list of rules that control how a fleet is scaled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-scalingpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-scalingpolicies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScalingPolicies() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gamelift-containerfleet.html#cfn-gamelift-containerfleet-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnContainerFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnContainerFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnContainerFleetProps> {
        java.lang.String fleetRoleArn;
        java.lang.String billingType;
        java.lang.Object deploymentConfiguration;
        java.lang.String description;
        java.lang.String gameServerContainerGroupDefinitionName;
        java.lang.Number gameServerContainerGroupsPerInstance;
        java.lang.Object gameSessionCreationLimitPolicy;
        java.lang.Object instanceConnectionPortRange;
        java.lang.Object instanceInboundPermissions;
        java.lang.String instanceType;
        java.lang.Object locations;
        java.lang.Object logConfiguration;
        java.util.List<java.lang.String> metricGroups;
        java.lang.String newGameSessionProtectionPolicy;
        java.lang.String perInstanceContainerGroupDefinitionName;
        java.lang.Object scalingPolicies;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnContainerFleetProps#getFleetRoleArn}
         * @param fleetRoleArn The unique identifier for an AWS Identity and Access Management (IAM) role with permissions to run your containers on resources that are managed by Amazon GameLift Servers. This parameter is required.
         *                     See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set up an IAM service role</a> . This fleet property can't be changed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetRoleArn(java.lang.String fleetRoleArn) {
            this.fleetRoleArn = fleetRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getBillingType}
         * @param billingType Indicates whether the fleet uses On-Demand or Spot instances for this fleet.
         *                    Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot">On-Demand versus Spot Instances</a> . You can't update this fleet property.
         *                    <p>
         *                    By default, this property is set to <code>ON_DEMAND</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingType(java.lang.String billingType) {
            this.billingType = billingType;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getDeploymentConfiguration}
         * @param deploymentConfiguration Set of rules for processing a deployment for a container fleet update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfiguration(software.amazon.awscdk.IResolvable deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getDeploymentConfiguration}
         * @param deploymentConfiguration Set of rules for processing a deployment for a container fleet update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfiguration(software.amazon.awscdk.services.gamelift.CfnContainerFleet.DeploymentConfigurationProperty deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getDescription}
         * @param description A meaningful description of the container fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getGameServerContainerGroupDefinitionName}
         * @param gameServerContainerGroupDefinitionName The name of the fleet's game server container group definition, which describes how to deploy containers with your game server build and support software onto each fleet instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerContainerGroupDefinitionName(java.lang.String gameServerContainerGroupDefinitionName) {
            this.gameServerContainerGroupDefinitionName = gameServerContainerGroupDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getGameServerContainerGroupsPerInstance}
         * @param gameServerContainerGroupsPerInstance The number of times to replicate the game server container group on each fleet instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameServerContainerGroupsPerInstance(java.lang.Number gameServerContainerGroupsPerInstance) {
            this.gameServerContainerGroupsPerInstance = gameServerContainerGroupsPerInstance;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getGameSessionCreationLimitPolicy}
         * @param gameSessionCreationLimitPolicy A policy that limits the number of game sessions that each individual player can create on instances in this fleet.
         *                                       The limit applies for a specified span of time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionCreationLimitPolicy(software.amazon.awscdk.IResolvable gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getGameSessionCreationLimitPolicy}
         * @param gameSessionCreationLimitPolicy A policy that limits the number of game sessions that each individual player can create on instances in this fleet.
         *                                       The limit applies for a specified span of time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionCreationLimitPolicy(software.amazon.awscdk.services.gamelift.CfnContainerFleet.GameSessionCreationLimitPolicyProperty gameSessionCreationLimitPolicy) {
            this.gameSessionCreationLimitPolicy = gameSessionCreationLimitPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getInstanceConnectionPortRange}
         * @param instanceConnectionPortRange The set of port numbers to open on each instance in a container fleet.
         *                                    Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConnectionPortRange(software.amazon.awscdk.IResolvable instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getInstanceConnectionPortRange}
         * @param instanceConnectionPortRange The set of port numbers to open on each instance in a container fleet.
         *                                    Connection ports are used by inbound traffic to connect with processes that are running in containers on the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceConnectionPortRange(software.amazon.awscdk.services.gamelift.CfnContainerFleet.ConnectionPortRangeProperty instanceConnectionPortRange) {
            this.instanceConnectionPortRange = instanceConnectionPortRange;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getInstanceInboundPermissions}
         * @param instanceInboundPermissions The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInboundPermissions(software.amazon.awscdk.IResolvable instanceInboundPermissions) {
            this.instanceInboundPermissions = instanceInboundPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getInstanceInboundPermissions}
         * @param instanceInboundPermissions The IP address ranges and port settings that allow inbound traffic to access game server processes and other processes on this fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInboundPermissions(java.util.List<? extends java.lang.Object> instanceInboundPermissions) {
            this.instanceInboundPermissions = instanceInboundPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getInstanceType}
         * @param instanceType The Amazon EC2 instance type to use for all instances in the fleet.
         *                     Instance type determines the computing resources and processing power that's available to host your game servers. This includes including CPU, memory, storage, and networking capacity. You can't update this fleet property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getLocations}
         * @param locations the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locations(software.amazon.awscdk.IResolvable locations) {
            this.locations = locations;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getLocations}
         * @param locations the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locations(java.util.List<? extends java.lang.Object> locations) {
            this.locations = locations;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getLogConfiguration}
         * @param logConfiguration The method that is used to collect container logs for the fleet.
         *                         Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.
         *                         <p>
         *                         <ul>
         *                         <li><code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.</li>
         *                         <li><code>S3</code> -- Store logs in an Amazon S3 bucket that you define.</li>
         *                         <li><code>NONE</code> -- Don't collect container logs.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(software.amazon.awscdk.IResolvable logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getLogConfiguration}
         * @param logConfiguration The method that is used to collect container logs for the fleet.
         *                         Amazon GameLift Servers saves all standard output for each container in logs, including game session logs.
         *                         <p>
         *                         <ul>
         *                         <li><code>CLOUDWATCH</code> -- Send logs to an Amazon CloudWatch log group that you define. Each container emits a log stream, which is organized in the log group.</li>
         *                         <li><code>S3</code> -- Store logs in an Amazon S3 bucket that you define.</li>
         *                         <li><code>NONE</code> -- Don't collect container logs.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(software.amazon.awscdk.services.gamelift.CfnContainerFleet.LogConfigurationProperty logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getMetricGroups}
         * @param metricGroups The name of an AWS CloudWatch metric group to add this fleet to.
         *                     Metric groups aggregate metrics for multiple fleets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricGroups(java.util.List<java.lang.String> metricGroups) {
            this.metricGroups = metricGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getNewGameSessionProtectionPolicy}
         * @param newGameSessionProtectionPolicy Determines whether Amazon GameLift Servers can shut down game sessions on the fleet that are actively running and hosting players.
         *                                       Amazon GameLift Servers might prompt an instance shutdown when scaling down fleet capacity or when retiring unhealthy instances. You can also set game session protection for individual game sessions using <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a> .
         *                                       <p>
         *                                       <ul>
         *                                       <li><em>NoProtection</em> -- Game sessions can be shut down during active gameplay.</li>
         *                                       <li><em>FullProtection</em> -- Game sessions in <code>ACTIVE</code> status can't be shut down.</li>
         *                                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newGameSessionProtectionPolicy(java.lang.String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getPerInstanceContainerGroupDefinitionName}
         * @param perInstanceContainerGroupDefinitionName The name of the fleet's per-instance container group definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder perInstanceContainerGroupDefinitionName(java.lang.String perInstanceContainerGroupDefinitionName) {
            this.perInstanceContainerGroupDefinitionName = perInstanceContainerGroupDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getScalingPolicies}
         * @param scalingPolicies A list of rules that control how a fleet is scaled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingPolicies(software.amazon.awscdk.IResolvable scalingPolicies) {
            this.scalingPolicies = scalingPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getScalingPolicies}
         * @param scalingPolicies A list of rules that control how a fleet is scaled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingPolicies(java.util.List<? extends java.lang.Object> scalingPolicies) {
            this.scalingPolicies = scalingPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerFleetProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnContainerFleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnContainerFleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnContainerFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnContainerFleetProps {
        private final java.lang.String fleetRoleArn;
        private final java.lang.String billingType;
        private final java.lang.Object deploymentConfiguration;
        private final java.lang.String description;
        private final java.lang.String gameServerContainerGroupDefinitionName;
        private final java.lang.Number gameServerContainerGroupsPerInstance;
        private final java.lang.Object gameSessionCreationLimitPolicy;
        private final java.lang.Object instanceConnectionPortRange;
        private final java.lang.Object instanceInboundPermissions;
        private final java.lang.String instanceType;
        private final java.lang.Object locations;
        private final java.lang.Object logConfiguration;
        private final java.util.List<java.lang.String> metricGroups;
        private final java.lang.String newGameSessionProtectionPolicy;
        private final java.lang.String perInstanceContainerGroupDefinitionName;
        private final java.lang.Object scalingPolicies;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fleetRoleArn = software.amazon.jsii.Kernel.get(this, "fleetRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.billingType = software.amazon.jsii.Kernel.get(this, "billingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deploymentConfiguration = software.amazon.jsii.Kernel.get(this, "deploymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gameServerContainerGroupDefinitionName = software.amazon.jsii.Kernel.get(this, "gameServerContainerGroupDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gameServerContainerGroupsPerInstance = software.amazon.jsii.Kernel.get(this, "gameServerContainerGroupsPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.gameSessionCreationLimitPolicy = software.amazon.jsii.Kernel.get(this, "gameSessionCreationLimitPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceConnectionPortRange = software.amazon.jsii.Kernel.get(this, "instanceConnectionPortRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceInboundPermissions = software.amazon.jsii.Kernel.get(this, "instanceInboundPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.locations = software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.metricGroups = software.amazon.jsii.Kernel.get(this, "metricGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.newGameSessionProtectionPolicy = software.amazon.jsii.Kernel.get(this, "newGameSessionProtectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.perInstanceContainerGroupDefinitionName = software.amazon.jsii.Kernel.get(this, "perInstanceContainerGroupDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalingPolicies = software.amazon.jsii.Kernel.get(this, "scalingPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fleetRoleArn = java.util.Objects.requireNonNull(builder.fleetRoleArn, "fleetRoleArn is required");
            this.billingType = builder.billingType;
            this.deploymentConfiguration = builder.deploymentConfiguration;
            this.description = builder.description;
            this.gameServerContainerGroupDefinitionName = builder.gameServerContainerGroupDefinitionName;
            this.gameServerContainerGroupsPerInstance = builder.gameServerContainerGroupsPerInstance;
            this.gameSessionCreationLimitPolicy = builder.gameSessionCreationLimitPolicy;
            this.instanceConnectionPortRange = builder.instanceConnectionPortRange;
            this.instanceInboundPermissions = builder.instanceInboundPermissions;
            this.instanceType = builder.instanceType;
            this.locations = builder.locations;
            this.logConfiguration = builder.logConfiguration;
            this.metricGroups = builder.metricGroups;
            this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
            this.perInstanceContainerGroupDefinitionName = builder.perInstanceContainerGroupDefinitionName;
            this.scalingPolicies = builder.scalingPolicies;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getFleetRoleArn() {
            return this.fleetRoleArn;
        }

        @Override
        public final java.lang.String getBillingType() {
            return this.billingType;
        }

        @Override
        public final java.lang.Object getDeploymentConfiguration() {
            return this.deploymentConfiguration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getGameServerContainerGroupDefinitionName() {
            return this.gameServerContainerGroupDefinitionName;
        }

        @Override
        public final java.lang.Number getGameServerContainerGroupsPerInstance() {
            return this.gameServerContainerGroupsPerInstance;
        }

        @Override
        public final java.lang.Object getGameSessionCreationLimitPolicy() {
            return this.gameSessionCreationLimitPolicy;
        }

        @Override
        public final java.lang.Object getInstanceConnectionPortRange() {
            return this.instanceConnectionPortRange;
        }

        @Override
        public final java.lang.Object getInstanceInboundPermissions() {
            return this.instanceInboundPermissions;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.Object getLocations() {
            return this.locations;
        }

        @Override
        public final java.lang.Object getLogConfiguration() {
            return this.logConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getMetricGroups() {
            return this.metricGroups;
        }

        @Override
        public final java.lang.String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        @Override
        public final java.lang.String getPerInstanceContainerGroupDefinitionName() {
            return this.perInstanceContainerGroupDefinitionName;
        }

        @Override
        public final java.lang.Object getScalingPolicies() {
            return this.scalingPolicies;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fleetRoleArn", om.valueToTree(this.getFleetRoleArn()));
            if (this.getBillingType() != null) {
                data.set("billingType", om.valueToTree(this.getBillingType()));
            }
            if (this.getDeploymentConfiguration() != null) {
                data.set("deploymentConfiguration", om.valueToTree(this.getDeploymentConfiguration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGameServerContainerGroupDefinitionName() != null) {
                data.set("gameServerContainerGroupDefinitionName", om.valueToTree(this.getGameServerContainerGroupDefinitionName()));
            }
            if (this.getGameServerContainerGroupsPerInstance() != null) {
                data.set("gameServerContainerGroupsPerInstance", om.valueToTree(this.getGameServerContainerGroupsPerInstance()));
            }
            if (this.getGameSessionCreationLimitPolicy() != null) {
                data.set("gameSessionCreationLimitPolicy", om.valueToTree(this.getGameSessionCreationLimitPolicy()));
            }
            if (this.getInstanceConnectionPortRange() != null) {
                data.set("instanceConnectionPortRange", om.valueToTree(this.getInstanceConnectionPortRange()));
            }
            if (this.getInstanceInboundPermissions() != null) {
                data.set("instanceInboundPermissions", om.valueToTree(this.getInstanceInboundPermissions()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getLocations() != null) {
                data.set("locations", om.valueToTree(this.getLocations()));
            }
            if (this.getLogConfiguration() != null) {
                data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
            }
            if (this.getMetricGroups() != null) {
                data.set("metricGroups", om.valueToTree(this.getMetricGroups()));
            }
            if (this.getNewGameSessionProtectionPolicy() != null) {
                data.set("newGameSessionProtectionPolicy", om.valueToTree(this.getNewGameSessionProtectionPolicy()));
            }
            if (this.getPerInstanceContainerGroupDefinitionName() != null) {
                data.set("perInstanceContainerGroupDefinitionName", om.valueToTree(this.getPerInstanceContainerGroupDefinitionName()));
            }
            if (this.getScalingPolicies() != null) {
                data.set("scalingPolicies", om.valueToTree(this.getScalingPolicies()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnContainerFleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnContainerFleetProps.Jsii$Proxy that = (CfnContainerFleetProps.Jsii$Proxy) o;

            if (!fleetRoleArn.equals(that.fleetRoleArn)) return false;
            if (this.billingType != null ? !this.billingType.equals(that.billingType) : that.billingType != null) return false;
            if (this.deploymentConfiguration != null ? !this.deploymentConfiguration.equals(that.deploymentConfiguration) : that.deploymentConfiguration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.gameServerContainerGroupDefinitionName != null ? !this.gameServerContainerGroupDefinitionName.equals(that.gameServerContainerGroupDefinitionName) : that.gameServerContainerGroupDefinitionName != null) return false;
            if (this.gameServerContainerGroupsPerInstance != null ? !this.gameServerContainerGroupsPerInstance.equals(that.gameServerContainerGroupsPerInstance) : that.gameServerContainerGroupsPerInstance != null) return false;
            if (this.gameSessionCreationLimitPolicy != null ? !this.gameSessionCreationLimitPolicy.equals(that.gameSessionCreationLimitPolicy) : that.gameSessionCreationLimitPolicy != null) return false;
            if (this.instanceConnectionPortRange != null ? !this.instanceConnectionPortRange.equals(that.instanceConnectionPortRange) : that.instanceConnectionPortRange != null) return false;
            if (this.instanceInboundPermissions != null ? !this.instanceInboundPermissions.equals(that.instanceInboundPermissions) : that.instanceInboundPermissions != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.locations != null ? !this.locations.equals(that.locations) : that.locations != null) return false;
            if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
            if (this.metricGroups != null ? !this.metricGroups.equals(that.metricGroups) : that.metricGroups != null) return false;
            if (this.newGameSessionProtectionPolicy != null ? !this.newGameSessionProtectionPolicy.equals(that.newGameSessionProtectionPolicy) : that.newGameSessionProtectionPolicy != null) return false;
            if (this.perInstanceContainerGroupDefinitionName != null ? !this.perInstanceContainerGroupDefinitionName.equals(that.perInstanceContainerGroupDefinitionName) : that.perInstanceContainerGroupDefinitionName != null) return false;
            if (this.scalingPolicies != null ? !this.scalingPolicies.equals(that.scalingPolicies) : that.scalingPolicies != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fleetRoleArn.hashCode();
            result = 31 * result + (this.billingType != null ? this.billingType.hashCode() : 0);
            result = 31 * result + (this.deploymentConfiguration != null ? this.deploymentConfiguration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.gameServerContainerGroupDefinitionName != null ? this.gameServerContainerGroupDefinitionName.hashCode() : 0);
            result = 31 * result + (this.gameServerContainerGroupsPerInstance != null ? this.gameServerContainerGroupsPerInstance.hashCode() : 0);
            result = 31 * result + (this.gameSessionCreationLimitPolicy != null ? this.gameSessionCreationLimitPolicy.hashCode() : 0);
            result = 31 * result + (this.instanceConnectionPortRange != null ? this.instanceConnectionPortRange.hashCode() : 0);
            result = 31 * result + (this.instanceInboundPermissions != null ? this.instanceInboundPermissions.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.locations != null ? this.locations.hashCode() : 0);
            result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
            result = 31 * result + (this.metricGroups != null ? this.metricGroups.hashCode() : 0);
            result = 31 * result + (this.newGameSessionProtectionPolicy != null ? this.newGameSessionProtectionPolicy.hashCode() : 0);
            result = 31 * result + (this.perInstanceContainerGroupDefinitionName != null ? this.perInstanceContainerGroupDefinitionName.hashCode() : 0);
            result = 31 * result + (this.scalingPolicies != null ? this.scalingPolicies.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
