package software.amazon.awscdk.services.iam;

/**
 * Properties for defining a <code>CfnSAMLProvider</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * CfnSAMLProviderProps cfnSAMLProviderProps = CfnSAMLProviderProps.builder()
 *         .addPrivateKey("addPrivateKey")
 *         .assertionEncryptionMode("assertionEncryptionMode")
 *         .name("name")
 *         .privateKeyList(List.of(SAMLPrivateKeyProperty.builder()
 *                 .keyId("keyId")
 *                 .timestamp("timestamp")
 *                 .build()))
 *         .removePrivateKey("removePrivateKey")
 *         .samlMetadataDocument("samlMetadataDocument")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:32.761Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.CfnSAMLProviderProps")
@software.amazon.jsii.Jsii.Proxy(CfnSAMLProviderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSAMLProviderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the new private key from your external identity provider.
     * <p>
     * The private key must be a .pem file that uses AES-GCM or AES-CBC encryption algorithm to decrypt SAML assertions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-addprivatekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-addprivatekey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAddPrivateKey() {
        return null;
    }

    /**
     * Specifies the encryption setting for the SAML provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-assertionencryptionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-assertionencryptionmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssertionEncryptionMode() {
        return null;
    }

    /**
     * The name of the provider to create.
     * <p>
     * This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The private key metadata for the SAML provider.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-privatekeylist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-privatekeylist</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateKeyList() {
        return null;
    }

    /**
     * The Key ID of the private key to remove.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-removeprivatekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-removeprivatekey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRemovePrivateKey() {
        return null;
    }

    /**
     * An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based federation</a> in the <em>IAM User Guide</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-samlmetadatadocument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-samlmetadatadocument</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSamlMetadataDocument() {
        return null;
    }

    /**
     * A list of tags that you want to attach to the new IAM SAML provider.
     * <p>
     * Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <em>IAM User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSAMLProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSAMLProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSAMLProviderProps> {
        java.lang.String addPrivateKey;
        java.lang.String assertionEncryptionMode;
        java.lang.String name;
        java.lang.Object privateKeyList;
        java.lang.String removePrivateKey;
        java.lang.String samlMetadataDocument;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSAMLProviderProps#getAddPrivateKey}
         * @param addPrivateKey Specifies the new private key from your external identity provider.
         *                      The private key must be a .pem file that uses AES-GCM or AES-CBC encryption algorithm to decrypt SAML assertions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addPrivateKey(java.lang.String addPrivateKey) {
            this.addPrivateKey = addPrivateKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnSAMLProviderProps#getAssertionEncryptionMode}
         * @param assertionEncryptionMode Specifies the encryption setting for the SAML provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assertionEncryptionMode(java.lang.String assertionEncryptionMode) {
            this.assertionEncryptionMode = assertionEncryptionMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnSAMLProviderProps#getName}
         * @param name The name of the provider to create.
         *             This parameter allows (through its <a href="https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex">regex pattern</a> ) a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.&#64;-
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSAMLProviderProps#getPrivateKeyList}
         * @param privateKeyList The private key metadata for the SAML provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateKeyList(software.amazon.awscdk.IResolvable privateKeyList) {
            this.privateKeyList = privateKeyList;
            return this;
        }

        /**
         * Sets the value of {@link CfnSAMLProviderProps#getPrivateKeyList}
         * @param privateKeyList The private key metadata for the SAML provider.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateKeyList(java.util.List<? extends java.lang.Object> privateKeyList) {
            this.privateKeyList = privateKeyList;
            return this;
        }

        /**
         * Sets the value of {@link CfnSAMLProviderProps#getRemovePrivateKey}
         * @param removePrivateKey The Key ID of the private key to remove.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removePrivateKey(java.lang.String removePrivateKey) {
            this.removePrivateKey = removePrivateKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnSAMLProviderProps#getSamlMetadataDocument}
         * @param samlMetadataDocument An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.
         *                             For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based federation</a> in the <em>IAM User Guide</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlMetadataDocument(java.lang.String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        /**
         * Sets the value of {@link CfnSAMLProviderProps#getTags}
         * @param tags A list of tags that you want to attach to the new IAM SAML provider.
         *             Each tag consists of a key name and an associated value. For more information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM resources</a> in the <em>IAM User Guide</em> .
         *             <p>
         *             <blockquote>
         *             <p>
         *             If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the entire request fails and the resource is not created.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSAMLProviderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSAMLProviderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSAMLProviderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSAMLProviderProps {
        private final java.lang.String addPrivateKey;
        private final java.lang.String assertionEncryptionMode;
        private final java.lang.String name;
        private final java.lang.Object privateKeyList;
        private final java.lang.String removePrivateKey;
        private final java.lang.String samlMetadataDocument;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addPrivateKey = software.amazon.jsii.Kernel.get(this, "addPrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assertionEncryptionMode = software.amazon.jsii.Kernel.get(this, "assertionEncryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privateKeyList = software.amazon.jsii.Kernel.get(this, "privateKeyList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.removePrivateKey = software.amazon.jsii.Kernel.get(this, "removePrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.samlMetadataDocument = software.amazon.jsii.Kernel.get(this, "samlMetadataDocument", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addPrivateKey = builder.addPrivateKey;
            this.assertionEncryptionMode = builder.assertionEncryptionMode;
            this.name = builder.name;
            this.privateKeyList = builder.privateKeyList;
            this.removePrivateKey = builder.removePrivateKey;
            this.samlMetadataDocument = builder.samlMetadataDocument;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAddPrivateKey() {
            return this.addPrivateKey;
        }

        @Override
        public final java.lang.String getAssertionEncryptionMode() {
            return this.assertionEncryptionMode;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getPrivateKeyList() {
            return this.privateKeyList;
        }

        @Override
        public final java.lang.String getRemovePrivateKey() {
            return this.removePrivateKey;
        }

        @Override
        public final java.lang.String getSamlMetadataDocument() {
            return this.samlMetadataDocument;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddPrivateKey() != null) {
                data.set("addPrivateKey", om.valueToTree(this.getAddPrivateKey()));
            }
            if (this.getAssertionEncryptionMode() != null) {
                data.set("assertionEncryptionMode", om.valueToTree(this.getAssertionEncryptionMode()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPrivateKeyList() != null) {
                data.set("privateKeyList", om.valueToTree(this.getPrivateKeyList()));
            }
            if (this.getRemovePrivateKey() != null) {
                data.set("removePrivateKey", om.valueToTree(this.getRemovePrivateKey()));
            }
            if (this.getSamlMetadataDocument() != null) {
                data.set("samlMetadataDocument", om.valueToTree(this.getSamlMetadataDocument()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.CfnSAMLProviderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSAMLProviderProps.Jsii$Proxy that = (CfnSAMLProviderProps.Jsii$Proxy) o;

            if (this.addPrivateKey != null ? !this.addPrivateKey.equals(that.addPrivateKey) : that.addPrivateKey != null) return false;
            if (this.assertionEncryptionMode != null ? !this.assertionEncryptionMode.equals(that.assertionEncryptionMode) : that.assertionEncryptionMode != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.privateKeyList != null ? !this.privateKeyList.equals(that.privateKeyList) : that.privateKeyList != null) return false;
            if (this.removePrivateKey != null ? !this.removePrivateKey.equals(that.removePrivateKey) : that.removePrivateKey != null) return false;
            if (this.samlMetadataDocument != null ? !this.samlMetadataDocument.equals(that.samlMetadataDocument) : that.samlMetadataDocument != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addPrivateKey != null ? this.addPrivateKey.hashCode() : 0;
            result = 31 * result + (this.assertionEncryptionMode != null ? this.assertionEncryptionMode.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.privateKeyList != null ? this.privateKeyList.hashCode() : 0);
            result = 31 * result + (this.removePrivateKey != null ? this.removePrivateKey.hashCode() : 0);
            result = 31 * result + (this.samlMetadataDocument != null ? this.samlMetadataDocument.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
