package software.amazon.awscdk.services.iotfleetwise;

/**
 * Properties for defining a <code>CfnDecoderManifest</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotfleetwise.*;
 * CfnDecoderManifestProps cfnDecoderManifestProps = CfnDecoderManifestProps.builder()
 *         .modelManifestArn("modelManifestArn")
 *         .name("name")
 *         // the properties below are optional
 *         .defaultForUnmappedSignals("defaultForUnmappedSignals")
 *         .description("description")
 *         .networkInterfaces(List.of(NetworkInterfacesItemsProperty.builder()
 *                 .interfaceId("interfaceId")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .canInterface(CanInterfaceProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .protocolName("protocolName")
 *                         .protocolVersion("protocolVersion")
 *                         .build())
 *                 .obdInterface(ObdInterfaceProperty.builder()
 *                         .name("name")
 *                         .requestMessageId("requestMessageId")
 *                         // the properties below are optional
 *                         .dtcRequestIntervalSeconds("dtcRequestIntervalSeconds")
 *                         .hasTransmissionEcu("hasTransmissionEcu")
 *                         .obdStandard("obdStandard")
 *                         .pidRequestIntervalSeconds("pidRequestIntervalSeconds")
 *                         .useExtendedIds("useExtendedIds")
 *                         .build())
 *                 .build()))
 *         .signalDecoders(List.of(SignalDecodersItemsProperty.builder()
 *                 .fullyQualifiedName("fullyQualifiedName")
 *                 .interfaceId("interfaceId")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .canSignal(CanSignalProperty.builder()
 *                         .factor("factor")
 *                         .isBigEndian("isBigEndian")
 *                         .isSigned("isSigned")
 *                         .length("length")
 *                         .messageId("messageId")
 *                         .offset("offset")
 *                         .startBit("startBit")
 *                         // the properties below are optional
 *                         .name("name")
 *                         .signalValueType("signalValueType")
 *                         .build())
 *                 .obdSignal(ObdSignalProperty.builder()
 *                         .byteLength("byteLength")
 *                         .offset("offset")
 *                         .pid("pid")
 *                         .pidResponseLength("pidResponseLength")
 *                         .scaling("scaling")
 *                         .serviceMode("serviceMode")
 *                         .startByte("startByte")
 *                         // the properties below are optional
 *                         .bitMaskLength("bitMaskLength")
 *                         .bitRightShift("bitRightShift")
 *                         .isSigned("isSigned")
 *                         .signalValueType("signalValueType")
 *                         .build())
 *                 .build()))
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:33.258Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifestProps")
@software.amazon.jsii.Jsii.Proxy(CfnDecoderManifestProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDecoderManifestProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-modelmanifestarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-modelmanifestarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelManifestArn();

    /**
     * The name of the decoder manifest.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Use default decoders for all unmapped signals in the model.
     * <p>
     * You don't need to provide any detailed decoding information.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-defaultforunmappedsignals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-defaultforunmappedsignals</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultForUnmappedSignals() {
        return null;
    }

    /**
     * A brief description of the decoder manifest.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A list of information about available network interfaces.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-networkinterfaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-networkinterfaces</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
        return null;
    }

    /**
     * A list of information about signal decoders.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-signaldecoders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-signaldecoders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSignalDecoders() {
        return null;
    }

    /**
     * The state of the decoder manifest.
     * <p>
     * If the status is <code>ACTIVE</code> , the decoder manifest can't be edited. If the status is marked <code>DRAFT</code> , you can edit the decoder manifest.
     * <p>
     * Default: - "DRAFT"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * Metadata that can be used to manage the decoder manifest.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotfleetwise-decodermanifest.html#cfn-iotfleetwise-decodermanifest-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDecoderManifestProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDecoderManifestProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDecoderManifestProps> {
        java.lang.String modelManifestArn;
        java.lang.String name;
        java.lang.String defaultForUnmappedSignals;
        java.lang.String description;
        java.lang.Object networkInterfaces;
        java.lang.Object signalDecoders;
        java.lang.String status;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getModelManifestArn}
         * @param modelManifestArn The Amazon Resource Name (ARN) of a vehicle model (model manifest) associated with the decoder manifest. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelManifestArn(java.lang.String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getName}
         * @param name The name of the decoder manifest. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getDefaultForUnmappedSignals}
         * @param defaultForUnmappedSignals Use default decoders for all unmapped signals in the model.
         *                                  You don't need to provide any detailed decoding information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultForUnmappedSignals(java.lang.String defaultForUnmappedSignals) {
            this.defaultForUnmappedSignals = defaultForUnmappedSignals;
            return this;
        }

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getDescription}
         * @param description A brief description of the decoder manifest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getNetworkInterfaces}
         * @param networkInterfaces A list of information about available network interfaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(software.amazon.awscdk.IResolvable networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
            return this;
        }

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getNetworkInterfaces}
         * @param networkInterfaces A list of information about available network interfaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkInterfaces(java.util.List<? extends java.lang.Object> networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
            return this;
        }

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getSignalDecoders}
         * @param signalDecoders A list of information about signal decoders.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalDecoders(software.amazon.awscdk.IResolvable signalDecoders) {
            this.signalDecoders = signalDecoders;
            return this;
        }

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getSignalDecoders}
         * @param signalDecoders A list of information about signal decoders.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalDecoders(java.util.List<? extends java.lang.Object> signalDecoders) {
            this.signalDecoders = signalDecoders;
            return this;
        }

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getStatus}
         * @param status The state of the decoder manifest.
         *               If the status is <code>ACTIVE</code> , the decoder manifest can't be edited. If the status is marked <code>DRAFT</code> , you can edit the decoder manifest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnDecoderManifestProps#getTags}
         * @param tags Metadata that can be used to manage the decoder manifest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDecoderManifestProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDecoderManifestProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDecoderManifestProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDecoderManifestProps {
        private final java.lang.String modelManifestArn;
        private final java.lang.String name;
        private final java.lang.String defaultForUnmappedSignals;
        private final java.lang.String description;
        private final java.lang.Object networkInterfaces;
        private final java.lang.Object signalDecoders;
        private final java.lang.String status;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.modelManifestArn = software.amazon.jsii.Kernel.get(this, "modelManifestArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultForUnmappedSignals = software.amazon.jsii.Kernel.get(this, "defaultForUnmappedSignals", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkInterfaces = software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.signalDecoders = software.amazon.jsii.Kernel.get(this, "signalDecoders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.modelManifestArn = java.util.Objects.requireNonNull(builder.modelManifestArn, "modelManifestArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.defaultForUnmappedSignals = builder.defaultForUnmappedSignals;
            this.description = builder.description;
            this.networkInterfaces = builder.networkInterfaces;
            this.signalDecoders = builder.signalDecoders;
            this.status = builder.status;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getModelManifestArn() {
            return this.modelManifestArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDefaultForUnmappedSignals() {
            return this.defaultForUnmappedSignals;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getNetworkInterfaces() {
            return this.networkInterfaces;
        }

        @Override
        public final java.lang.Object getSignalDecoders() {
            return this.signalDecoders;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("modelManifestArn", om.valueToTree(this.getModelManifestArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDefaultForUnmappedSignals() != null) {
                data.set("defaultForUnmappedSignals", om.valueToTree(this.getDefaultForUnmappedSignals()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getNetworkInterfaces() != null) {
                data.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
            }
            if (this.getSignalDecoders() != null) {
                data.set("signalDecoders", om.valueToTree(this.getSignalDecoders()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotfleetwise.CfnDecoderManifestProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDecoderManifestProps.Jsii$Proxy that = (CfnDecoderManifestProps.Jsii$Proxy) o;

            if (!modelManifestArn.equals(that.modelManifestArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.defaultForUnmappedSignals != null ? !this.defaultForUnmappedSignals.equals(that.defaultForUnmappedSignals) : that.defaultForUnmappedSignals != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.networkInterfaces != null ? !this.networkInterfaces.equals(that.networkInterfaces) : that.networkInterfaces != null) return false;
            if (this.signalDecoders != null ? !this.signalDecoders.equals(that.signalDecoders) : that.signalDecoders != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.modelManifestArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.defaultForUnmappedSignals != null ? this.defaultForUnmappedSignals.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.networkInterfaces != null ? this.networkInterfaces.hashCode() : 0);
            result = 31 * result + (this.signalDecoders != null ? this.signalDecoders.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
