package software.amazon.awscdk.services.iotsitewise;

/**
 * Properties for defining a <code>CfnAssetModel</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * CfnAssetModelProps cfnAssetModelProps = CfnAssetModelProps.builder()
 *         .assetModelName("assetModelName")
 *         // the properties below are optional
 *         .assetModelCompositeModels(List.of(AssetModelCompositeModelProperty.builder()
 *                 .name("name")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .composedAssetModelId("composedAssetModelId")
 *                 .compositeModelProperties(List.of(AssetModelPropertyProperty.builder()
 *                         .dataType("dataType")
 *                         .name("name")
 *                         .type(PropertyTypeProperty.builder()
 *                                 .typeName("typeName")
 *                                 // the properties below are optional
 *                                 .attribute(AttributeProperty.builder()
 *                                         .defaultValue("defaultValue")
 *                                         .build())
 *                                 .metric(MetricProperty.builder()
 *                                         .expression("expression")
 *                                         .variables(List.of(ExpressionVariableProperty.builder()
 *                                                 .name("name")
 *                                                 .value(VariableValueProperty.builder()
 *                                                         .hierarchyExternalId("hierarchyExternalId")
 *                                                         .hierarchyId("hierarchyId")
 *                                                         .hierarchyLogicalId("hierarchyLogicalId")
 *                                                         .propertyExternalId("propertyExternalId")
 *                                                         .propertyId("propertyId")
 *                                                         .propertyLogicalId("propertyLogicalId")
 *                                                         .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .build()))
 *                                         .window(MetricWindowProperty.builder()
 *                                                 .tumbling(TumblingWindowProperty.builder()
 *                                                         .interval("interval")
 *                                                         // the properties below are optional
 *                                                         .offset("offset")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .transform(TransformProperty.builder()
 *                                         .expression("expression")
 *                                         .variables(List.of(ExpressionVariableProperty.builder()
 *                                                 .name("name")
 *                                                 .value(VariableValueProperty.builder()
 *                                                         .hierarchyExternalId("hierarchyExternalId")
 *                                                         .hierarchyId("hierarchyId")
 *                                                         .hierarchyLogicalId("hierarchyLogicalId")
 *                                                         .propertyExternalId("propertyExternalId")
 *                                                         .propertyId("propertyId")
 *                                                         .propertyLogicalId("propertyLogicalId")
 *                                                         .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .build()))
 *                                         .build())
 *                                 .build())
 *                         // the properties below are optional
 *                         .dataTypeSpec("dataTypeSpec")
 *                         .externalId("externalId")
 *                         .id("id")
 *                         .logicalId("logicalId")
 *                         .unit("unit")
 *                         .build()))
 *                 .description("description")
 *                 .externalId("externalId")
 *                 .id("id")
 *                 .parentAssetModelCompositeModelExternalId("parentAssetModelCompositeModelExternalId")
 *                 .path(List.of("path"))
 *                 .build()))
 *         .assetModelDescription("assetModelDescription")
 *         .assetModelExternalId("assetModelExternalId")
 *         .assetModelHierarchies(List.of(AssetModelHierarchyProperty.builder()
 *                 .childAssetModelId("childAssetModelId")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .externalId("externalId")
 *                 .id("id")
 *                 .logicalId("logicalId")
 *                 .build()))
 *         .assetModelProperties(List.of(AssetModelPropertyProperty.builder()
 *                 .dataType("dataType")
 *                 .name("name")
 *                 .type(PropertyTypeProperty.builder()
 *                         .typeName("typeName")
 *                         // the properties below are optional
 *                         .attribute(AttributeProperty.builder()
 *                                 .defaultValue("defaultValue")
 *                                 .build())
 *                         .metric(MetricProperty.builder()
 *                                 .expression("expression")
 *                                 .variables(List.of(ExpressionVariableProperty.builder()
 *                                         .name("name")
 *                                         .value(VariableValueProperty.builder()
 *                                                 .hierarchyExternalId("hierarchyExternalId")
 *                                                 .hierarchyId("hierarchyId")
 *                                                 .hierarchyLogicalId("hierarchyLogicalId")
 *                                                 .propertyExternalId("propertyExternalId")
 *                                                 .propertyId("propertyId")
 *                                                 .propertyLogicalId("propertyLogicalId")
 *                                                 .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
 *                                                         .name("name")
 *                                                         .build()))
 *                                                 .build())
 *                                         .build()))
 *                                 .window(MetricWindowProperty.builder()
 *                                         .tumbling(TumblingWindowProperty.builder()
 *                                                 .interval("interval")
 *                                                 // the properties below are optional
 *                                                 .offset("offset")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .transform(TransformProperty.builder()
 *                                 .expression("expression")
 *                                 .variables(List.of(ExpressionVariableProperty.builder()
 *                                         .name("name")
 *                                         .value(VariableValueProperty.builder()
 *                                                 .hierarchyExternalId("hierarchyExternalId")
 *                                                 .hierarchyId("hierarchyId")
 *                                                 .hierarchyLogicalId("hierarchyLogicalId")
 *                                                 .propertyExternalId("propertyExternalId")
 *                                                 .propertyId("propertyId")
 *                                                 .propertyLogicalId("propertyLogicalId")
 *                                                 .propertyPath(List.of(PropertyPathDefinitionProperty.builder()
 *                                                         .name("name")
 *                                                         .build()))
 *                                                 .build())
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .dataTypeSpec("dataTypeSpec")
 *                 .externalId("externalId")
 *                 .id("id")
 *                 .logicalId("logicalId")
 *                 .unit("unit")
 *                 .build()))
 *         .assetModelType("assetModelType")
 *         .enforcedAssetModelInterfaceRelationships(List.of(EnforcedAssetModelInterfaceRelationshipProperty.builder()
 *                 .interfaceAssetModelId("interfaceAssetModelId")
 *                 .propertyMappings(List.of(EnforcedAssetModelInterfacePropertyMappingProperty.builder()
 *                         .interfaceAssetModelPropertyExternalId("interfaceAssetModelPropertyExternalId")
 *                         // the properties below are optional
 *                         .assetModelPropertyExternalId("assetModelPropertyExternalId")
 *                         .assetModelPropertyLogicalId("assetModelPropertyLogicalId")
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:33.306Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnAssetModelProps")
@software.amazon.jsii.Jsii.Proxy(CfnAssetModelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAssetModelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A unique name for the asset model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssetModelName();

    /**
     * The composite models that are part of this asset model.
     * <p>
     * It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.
     * <p>
     * <blockquote>
     * <p>
     * When creating custom composite models, you need to use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">CreateAssetModelCompositeModel</a> . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html">Creating custom composite models (Components)</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelcompositemodels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssetModelCompositeModels() {
        return null;
    }

    /**
     * A description for the asset model.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeldescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeldescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetModelDescription() {
        return null;
    }

    /**
     * The external ID of the asset model.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelexternalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelexternalid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetModelExternalId() {
        return null;
    }

    /**
     * The hierarchy definitions of the asset model.
     * <p>
     * Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelhierarchies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelhierarchies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssetModelHierarchies() {
        return null;
    }

    /**
     * The property definitions of the asset model.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodelproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssetModelProperties() {
        return null;
    }

    /**
     * The type of asset model.
     * <p>
     * <ul>
     * <li><em>ASSET_MODEL</em> – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.</li>
     * <li><em>COMPONENT_MODEL</em> – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.</li>
     * <li><em>INTERFACE</em> – An interface is a type of model that defines a standard structure that can be applied to different asset models.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-assetmodeltype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssetModelType() {
        return null;
    }

    /**
     * a list of asset model and interface relationships.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-enforcedassetmodelinterfacerelationships">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-enforcedassetmodelinterfacerelationships</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnforcedAssetModelInterfaceRelationships() {
        return null;
    }

    /**
     * A list of key-value pairs that contain metadata for the asset.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotsitewise-assetmodel.html#cfn-iotsitewise-assetmodel-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAssetModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAssetModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAssetModelProps> {
        java.lang.String assetModelName;
        java.lang.Object assetModelCompositeModels;
        java.lang.String assetModelDescription;
        java.lang.String assetModelExternalId;
        java.lang.Object assetModelHierarchies;
        java.lang.Object assetModelProperties;
        java.lang.String assetModelType;
        java.lang.Object enforcedAssetModelInterfaceRelationships;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelName}
         * @param assetModelName A unique name for the asset model. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelName(java.lang.String assetModelName) {
            this.assetModelName = assetModelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelCompositeModels}
         * @param assetModelCompositeModels The composite models that are part of this asset model.
         *                                  It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.
         *                                  <p>
         *                                  <blockquote>
         *                                  <p>
         *                                  When creating custom composite models, you need to use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">CreateAssetModelCompositeModel</a> . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html">Creating custom composite models (Components)</a> in the <em>AWS IoT SiteWise User Guide</em> .
         *                                  <p>
         *                                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelCompositeModels(software.amazon.awscdk.IResolvable assetModelCompositeModels) {
            this.assetModelCompositeModels = assetModelCompositeModels;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelCompositeModels}
         * @param assetModelCompositeModels The composite models that are part of this asset model.
         *                                  It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.
         *                                  <p>
         *                                  <blockquote>
         *                                  <p>
         *                                  When creating custom composite models, you need to use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">CreateAssetModelCompositeModel</a> . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html">Creating custom composite models (Components)</a> in the <em>AWS IoT SiteWise User Guide</em> .
         *                                  <p>
         *                                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelCompositeModels(java.util.List<? extends java.lang.Object> assetModelCompositeModels) {
            this.assetModelCompositeModels = assetModelCompositeModels;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelDescription}
         * @param assetModelDescription A description for the asset model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelDescription(java.lang.String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelExternalId}
         * @param assetModelExternalId The external ID of the asset model.
         *                             For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external IDs</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelExternalId(java.lang.String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelHierarchies}
         * @param assetModelHierarchies The hierarchy definitions of the asset model.
         *                              Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <em>AWS IoT SiteWise User Guide</em> .
         *                              <p>
         *                              You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelHierarchies(software.amazon.awscdk.IResolvable assetModelHierarchies) {
            this.assetModelHierarchies = assetModelHierarchies;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelHierarchies}
         * @param assetModelHierarchies The hierarchy definitions of the asset model.
         *                              Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in the <em>AWS IoT SiteWise User Guide</em> .
         *                              <p>
         *                              You can specify up to 10 hierarchies per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelHierarchies(java.util.List<? extends java.lang.Object> assetModelHierarchies) {
            this.assetModelHierarchies = assetModelHierarchies;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelProperties}
         * @param assetModelProperties The property definitions of the asset model.
         *                             For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <em>AWS IoT SiteWise User Guide</em> .
         *                             <p>
         *                             You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelProperties(software.amazon.awscdk.IResolvable assetModelProperties) {
            this.assetModelProperties = assetModelProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelProperties}
         * @param assetModelProperties The property definitions of the asset model.
         *                             For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in the <em>AWS IoT SiteWise User Guide</em> .
         *                             <p>
         *                             You can specify up to 200 properties per asset model. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelProperties(java.util.List<? extends java.lang.Object> assetModelProperties) {
            this.assetModelProperties = assetModelProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getAssetModelType}
         * @param assetModelType The type of asset model.
         *                       <ul>
         *                       <li><em>ASSET_MODEL</em> – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.</li>
         *                       <li><em>COMPONENT_MODEL</em> – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.</li>
         *                       <li><em>INTERFACE</em> – An interface is a type of model that defines a standard structure that can be applied to different asset models.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetModelType(java.lang.String assetModelType) {
            this.assetModelType = assetModelType;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getEnforcedAssetModelInterfaceRelationships}
         * @param enforcedAssetModelInterfaceRelationships a list of asset model and interface relationships.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforcedAssetModelInterfaceRelationships(software.amazon.awscdk.IResolvable enforcedAssetModelInterfaceRelationships) {
            this.enforcedAssetModelInterfaceRelationships = enforcedAssetModelInterfaceRelationships;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getEnforcedAssetModelInterfaceRelationships}
         * @param enforcedAssetModelInterfaceRelationships a list of asset model and interface relationships.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enforcedAssetModelInterfaceRelationships(java.util.List<? extends java.lang.Object> enforcedAssetModelInterfaceRelationships) {
            this.enforcedAssetModelInterfaceRelationships = enforcedAssetModelInterfaceRelationships;
            return this;
        }

        /**
         * Sets the value of {@link CfnAssetModelProps#getTags}
         * @param tags A list of key-value pairs that contain metadata for the asset.
         *             For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAssetModelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAssetModelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAssetModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAssetModelProps {
        private final java.lang.String assetModelName;
        private final java.lang.Object assetModelCompositeModels;
        private final java.lang.String assetModelDescription;
        private final java.lang.String assetModelExternalId;
        private final java.lang.Object assetModelHierarchies;
        private final java.lang.Object assetModelProperties;
        private final java.lang.String assetModelType;
        private final java.lang.Object enforcedAssetModelInterfaceRelationships;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assetModelName = software.amazon.jsii.Kernel.get(this, "assetModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetModelCompositeModels = software.amazon.jsii.Kernel.get(this, "assetModelCompositeModels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.assetModelDescription = software.amazon.jsii.Kernel.get(this, "assetModelDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetModelExternalId = software.amazon.jsii.Kernel.get(this, "assetModelExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetModelHierarchies = software.amazon.jsii.Kernel.get(this, "assetModelHierarchies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.assetModelProperties = software.amazon.jsii.Kernel.get(this, "assetModelProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.assetModelType = software.amazon.jsii.Kernel.get(this, "assetModelType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enforcedAssetModelInterfaceRelationships = software.amazon.jsii.Kernel.get(this, "enforcedAssetModelInterfaceRelationships", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assetModelName = java.util.Objects.requireNonNull(builder.assetModelName, "assetModelName is required");
            this.assetModelCompositeModels = builder.assetModelCompositeModels;
            this.assetModelDescription = builder.assetModelDescription;
            this.assetModelExternalId = builder.assetModelExternalId;
            this.assetModelHierarchies = builder.assetModelHierarchies;
            this.assetModelProperties = builder.assetModelProperties;
            this.assetModelType = builder.assetModelType;
            this.enforcedAssetModelInterfaceRelationships = builder.enforcedAssetModelInterfaceRelationships;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAssetModelName() {
            return this.assetModelName;
        }

        @Override
        public final java.lang.Object getAssetModelCompositeModels() {
            return this.assetModelCompositeModels;
        }

        @Override
        public final java.lang.String getAssetModelDescription() {
            return this.assetModelDescription;
        }

        @Override
        public final java.lang.String getAssetModelExternalId() {
            return this.assetModelExternalId;
        }

        @Override
        public final java.lang.Object getAssetModelHierarchies() {
            return this.assetModelHierarchies;
        }

        @Override
        public final java.lang.Object getAssetModelProperties() {
            return this.assetModelProperties;
        }

        @Override
        public final java.lang.String getAssetModelType() {
            return this.assetModelType;
        }

        @Override
        public final java.lang.Object getEnforcedAssetModelInterfaceRelationships() {
            return this.enforcedAssetModelInterfaceRelationships;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("assetModelName", om.valueToTree(this.getAssetModelName()));
            if (this.getAssetModelCompositeModels() != null) {
                data.set("assetModelCompositeModels", om.valueToTree(this.getAssetModelCompositeModels()));
            }
            if (this.getAssetModelDescription() != null) {
                data.set("assetModelDescription", om.valueToTree(this.getAssetModelDescription()));
            }
            if (this.getAssetModelExternalId() != null) {
                data.set("assetModelExternalId", om.valueToTree(this.getAssetModelExternalId()));
            }
            if (this.getAssetModelHierarchies() != null) {
                data.set("assetModelHierarchies", om.valueToTree(this.getAssetModelHierarchies()));
            }
            if (this.getAssetModelProperties() != null) {
                data.set("assetModelProperties", om.valueToTree(this.getAssetModelProperties()));
            }
            if (this.getAssetModelType() != null) {
                data.set("assetModelType", om.valueToTree(this.getAssetModelType()));
            }
            if (this.getEnforcedAssetModelInterfaceRelationships() != null) {
                data.set("enforcedAssetModelInterfaceRelationships", om.valueToTree(this.getEnforcedAssetModelInterfaceRelationships()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnAssetModelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAssetModelProps.Jsii$Proxy that = (CfnAssetModelProps.Jsii$Proxy) o;

            if (!assetModelName.equals(that.assetModelName)) return false;
            if (this.assetModelCompositeModels != null ? !this.assetModelCompositeModels.equals(that.assetModelCompositeModels) : that.assetModelCompositeModels != null) return false;
            if (this.assetModelDescription != null ? !this.assetModelDescription.equals(that.assetModelDescription) : that.assetModelDescription != null) return false;
            if (this.assetModelExternalId != null ? !this.assetModelExternalId.equals(that.assetModelExternalId) : that.assetModelExternalId != null) return false;
            if (this.assetModelHierarchies != null ? !this.assetModelHierarchies.equals(that.assetModelHierarchies) : that.assetModelHierarchies != null) return false;
            if (this.assetModelProperties != null ? !this.assetModelProperties.equals(that.assetModelProperties) : that.assetModelProperties != null) return false;
            if (this.assetModelType != null ? !this.assetModelType.equals(that.assetModelType) : that.assetModelType != null) return false;
            if (this.enforcedAssetModelInterfaceRelationships != null ? !this.enforcedAssetModelInterfaceRelationships.equals(that.enforcedAssetModelInterfaceRelationships) : that.enforcedAssetModelInterfaceRelationships != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assetModelName.hashCode();
            result = 31 * result + (this.assetModelCompositeModels != null ? this.assetModelCompositeModels.hashCode() : 0);
            result = 31 * result + (this.assetModelDescription != null ? this.assetModelDescription.hashCode() : 0);
            result = 31 * result + (this.assetModelExternalId != null ? this.assetModelExternalId.hashCode() : 0);
            result = 31 * result + (this.assetModelHierarchies != null ? this.assetModelHierarchies.hashCode() : 0);
            result = 31 * result + (this.assetModelProperties != null ? this.assetModelProperties.hashCode() : 0);
            result = 31 * result + (this.assetModelType != null ? this.assetModelType.hashCode() : 0);
            result = 31 * result + (this.enforcedAssetModelInterfaceRelationships != null ? this.enforcedAssetModelInterfaceRelationships.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
