package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Props for defining an S3 destination of an Amazon Data Firehose delivery stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * // Provide a Lambda function that will transform records before delivery, with custom
 * // buffering and retry configuration
 * Function lambdaFunction = Function.Builder.create(this, "Processor")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "process-records")))
 *         .build();
 * LambdaFunctionProcessor lambdaProcessor = LambdaFunctionProcessor.Builder.create(lambdaFunction)
 *         .bufferInterval(Duration.minutes(5))
 *         .bufferSize(Size.mebibytes(5))
 *         .retries(5)
 *         .build();
 * S3Bucket s3Destination = S3Bucket.Builder.create(bucket)
 *         .processor(lambdaProcessor)
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:33.805Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.S3BucketProps")
@software.amazon.jsii.Jsii.Proxy(S3BucketProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3BucketProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.kinesisfirehose.CommonDestinationS3Props, software.amazon.awscdk.services.kinesisfirehose.CommonDestinationProps {

    /**
     * Specify a file extension.
     * <p>
     * It will override the default file extension appended by Data Format Conversion or S3 compression features such as <code>.parquet</code> or <code>.gz</code>.
     * <p>
     * File extension must start with a period (<code>.</code>) and can contain allowed characters: <code>0-9a-z!-_.*'()</code>.
     * <p>
     * Default: - The default file extension appended by Data Format Conversion or S3 compression features
     * <p>
     * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/create-destination.html#create-destination-s3">https://docs.aws.amazon.com/firehose/latest/dev/create-destination.html#create-destination-s3</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFileExtension() {
        return null;
    }

    /**
     * The time zone you prefer.
     * <p>
     * Default: - UTC
     * <p>
     * @see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html#timestamp-namespace">https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html#timestamp-namespace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.TimeZone getTimeZone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3BucketProps> {
        java.lang.String fileExtension;
        software.amazon.awscdk.TimeZone timeZone;
        software.amazon.awscdk.Duration bufferingInterval;
        software.amazon.awscdk.Size bufferingSize;
        software.amazon.awscdk.services.kinesisfirehose.Compression compression;
        java.lang.String dataOutputPrefix;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.String errorOutputPrefix;
        software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig loggingConfig;
        software.amazon.awscdk.services.kinesisfirehose.IDataProcessor processor;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.kinesisfirehose.DestinationS3BackupProps s3Backup;

        /**
         * Sets the value of {@link S3BucketProps#getFileExtension}
         * @param fileExtension Specify a file extension.
         *                      It will override the default file extension appended by Data Format Conversion or S3 compression features such as <code>.parquet</code> or <code>.gz</code>.
         *                      <p>
         *                      File extension must start with a period (<code>.</code>) and can contain allowed characters: <code>0-9a-z!-_.*'()</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileExtension(java.lang.String fileExtension) {
            this.fileExtension = fileExtension;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getTimeZone}
         * @param timeZone The time zone you prefer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(software.amazon.awscdk.TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getBufferingInterval}
         * @param bufferingInterval The length of time that Firehose buffers incoming data before delivering it to the S3 bucket.
         *                          Minimum: Duration.seconds(0)
         *                          Maximum: Duration.seconds(900)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferingInterval(software.amazon.awscdk.Duration bufferingInterval) {
            this.bufferingInterval = bufferingInterval;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getBufferingSize}
         * @param bufferingSize The size of the buffer that Amazon Data Firehose uses for incoming data before delivering it to the S3 bucket.
         *                      Minimum: Size.mebibytes(1)
         *                      Maximum: Size.mebibytes(128)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferingSize(software.amazon.awscdk.Size bufferingSize) {
            this.bufferingSize = bufferingSize;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getCompression}
         * @param compression The type of compression that Amazon Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
         *                    The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
         *                    destinations because they are not supported by the Amazon Redshift COPY operation
         *                    that reads from the S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(software.amazon.awscdk.services.kinesisfirehose.Compression compression) {
            this.compression = compression;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getDataOutputPrefix}
         * @param dataOutputPrefix A prefix that Amazon Data Firehose evaluates and adds to records before writing them to S3.
         *                         This prefix appears immediately following the bucket name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataOutputPrefix(java.lang.String dataOutputPrefix) {
            this.dataOutputPrefix = dataOutputPrefix;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getEncryptionKey}
         * @param encryptionKey The AWS KMS key used to encrypt the data that it delivers to your Amazon S3 bucket.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getErrorOutputPrefix}
         * @param errorOutputPrefix A prefix that Amazon Data Firehose evaluates and adds to failed records before writing them to S3.
         *                          This prefix appears immediately following the bucket name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder errorOutputPrefix(java.lang.String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getLoggingConfig}
         * @param loggingConfig Configuration that determines whether to log errors during data transformation or delivery failures, and specifies the CloudWatch log group for storing error logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfig(software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getProcessor}
         * @param processor The data transformation that should be performed on the data before writing to the destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder processor(software.amazon.awscdk.services.kinesisfirehose.IDataProcessor processor) {
            this.processor = processor;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getRole}
         * @param role The IAM role associated with this destination.
         *             Assumed by Amazon Data Firehose to invoke processors and write to destinations
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketProps#getS3Backup}
         * @param s3Backup The configuration for backing up source records to S3.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Backup(software.amazon.awscdk.services.kinesisfirehose.DestinationS3BackupProps s3Backup) {
            this.s3Backup = s3Backup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3BucketProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3BucketProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3BucketProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3BucketProps {
        private final java.lang.String fileExtension;
        private final software.amazon.awscdk.TimeZone timeZone;
        private final software.amazon.awscdk.Duration bufferingInterval;
        private final software.amazon.awscdk.Size bufferingSize;
        private final software.amazon.awscdk.services.kinesisfirehose.Compression compression;
        private final java.lang.String dataOutputPrefix;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String errorOutputPrefix;
        private final software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig loggingConfig;
        private final software.amazon.awscdk.services.kinesisfirehose.IDataProcessor processor;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.kinesisfirehose.DestinationS3BackupProps s3Backup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileExtension = software.amazon.jsii.Kernel.get(this, "fileExtension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TimeZone.class));
            this.bufferingInterval = software.amazon.jsii.Kernel.get(this, "bufferingInterval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.bufferingSize = software.amazon.jsii.Kernel.get(this, "bufferingSize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.Compression.class));
            this.dataOutputPrefix = software.amazon.jsii.Kernel.get(this, "dataOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.errorOutputPrefix = software.amazon.jsii.Kernel.get(this, "errorOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingConfig = software.amazon.jsii.Kernel.get(this, "loggingConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig.class));
            this.processor = software.amazon.jsii.Kernel.get(this, "processor", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.IDataProcessor.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.s3Backup = software.amazon.jsii.Kernel.get(this, "s3Backup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.DestinationS3BackupProps.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileExtension = builder.fileExtension;
            this.timeZone = builder.timeZone;
            this.bufferingInterval = builder.bufferingInterval;
            this.bufferingSize = builder.bufferingSize;
            this.compression = builder.compression;
            this.dataOutputPrefix = builder.dataOutputPrefix;
            this.encryptionKey = builder.encryptionKey;
            this.errorOutputPrefix = builder.errorOutputPrefix;
            this.loggingConfig = builder.loggingConfig;
            this.processor = builder.processor;
            this.role = builder.role;
            this.s3Backup = builder.s3Backup;
        }

        @Override
        public final java.lang.String getFileExtension() {
            return this.fileExtension;
        }

        @Override
        public final software.amazon.awscdk.TimeZone getTimeZone() {
            return this.timeZone;
        }

        @Override
        public final software.amazon.awscdk.Duration getBufferingInterval() {
            return this.bufferingInterval;
        }

        @Override
        public final software.amazon.awscdk.Size getBufferingSize() {
            return this.bufferingSize;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.Compression getCompression() {
            return this.compression;
        }

        @Override
        public final java.lang.String getDataOutputPrefix() {
            return this.dataOutputPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getErrorOutputPrefix() {
            return this.errorOutputPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig getLoggingConfig() {
            return this.loggingConfig;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.IDataProcessor getProcessor() {
            return this.processor;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.DestinationS3BackupProps getS3Backup() {
            return this.s3Backup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFileExtension() != null) {
                data.set("fileExtension", om.valueToTree(this.getFileExtension()));
            }
            if (this.getTimeZone() != null) {
                data.set("timeZone", om.valueToTree(this.getTimeZone()));
            }
            if (this.getBufferingInterval() != null) {
                data.set("bufferingInterval", om.valueToTree(this.getBufferingInterval()));
            }
            if (this.getBufferingSize() != null) {
                data.set("bufferingSize", om.valueToTree(this.getBufferingSize()));
            }
            if (this.getCompression() != null) {
                data.set("compression", om.valueToTree(this.getCompression()));
            }
            if (this.getDataOutputPrefix() != null) {
                data.set("dataOutputPrefix", om.valueToTree(this.getDataOutputPrefix()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getErrorOutputPrefix() != null) {
                data.set("errorOutputPrefix", om.valueToTree(this.getErrorOutputPrefix()));
            }
            if (this.getLoggingConfig() != null) {
                data.set("loggingConfig", om.valueToTree(this.getLoggingConfig()));
            }
            if (this.getProcessor() != null) {
                data.set("processor", om.valueToTree(this.getProcessor()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getS3Backup() != null) {
                data.set("s3Backup", om.valueToTree(this.getS3Backup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.S3BucketProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3BucketProps.Jsii$Proxy that = (S3BucketProps.Jsii$Proxy) o;

            if (this.fileExtension != null ? !this.fileExtension.equals(that.fileExtension) : that.fileExtension != null) return false;
            if (this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null) return false;
            if (this.bufferingInterval != null ? !this.bufferingInterval.equals(that.bufferingInterval) : that.bufferingInterval != null) return false;
            if (this.bufferingSize != null ? !this.bufferingSize.equals(that.bufferingSize) : that.bufferingSize != null) return false;
            if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
            if (this.dataOutputPrefix != null ? !this.dataOutputPrefix.equals(that.dataOutputPrefix) : that.dataOutputPrefix != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.errorOutputPrefix != null ? !this.errorOutputPrefix.equals(that.errorOutputPrefix) : that.errorOutputPrefix != null) return false;
            if (this.loggingConfig != null ? !this.loggingConfig.equals(that.loggingConfig) : that.loggingConfig != null) return false;
            if (this.processor != null ? !this.processor.equals(that.processor) : that.processor != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.s3Backup != null ? this.s3Backup.equals(that.s3Backup) : that.s3Backup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fileExtension != null ? this.fileExtension.hashCode() : 0;
            result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
            result = 31 * result + (this.bufferingInterval != null ? this.bufferingInterval.hashCode() : 0);
            result = 31 * result + (this.bufferingSize != null ? this.bufferingSize.hashCode() : 0);
            result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
            result = 31 * result + (this.dataOutputPrefix != null ? this.dataOutputPrefix.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.errorOutputPrefix != null ? this.errorOutputPrefix.hashCode() : 0);
            result = 31 * result + (this.loggingConfig != null ? this.loggingConfig.hashCode() : 0);
            result = 31 * result + (this.processor != null ? this.processor.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.s3Backup != null ? this.s3Backup.hashCode() : 0);
            return result;
        }
    }
}
