package software.amazon.awscdk.services.lambda;

/**
 * Optional parameters for creating code using bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kms.Key;
 * import software.amazon.awscdk.services.s3.*;
 * Key key;
 * Bucket bucket = new Bucket(this, "Bucket");
 * Map&lt;String, Key&gt; options = Map.of(
 *         "sourceKMSKey", key);
 * Function fnBucket = Function.Builder.create(this, "myFunction2")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .handler("index.handler")
 *         .code(Code.fromBucketV2(bucket, "python-lambda-handler.zip", options))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:34.067Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.BucketOptions")
@software.amazon.jsii.Jsii.Proxy(BucketOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BucketOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Optional S3 object version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getObjectVersion() {
        return null;
    }

    /**
     * The ARN of the KMS key used to encrypt the handler code.
     * <p>
     * Default: - the default server-side encryption with Amazon S3 managed keys(SSE-S3) key will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getSourceKMSKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BucketOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BucketOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BucketOptions> {
        java.lang.String objectVersion;
        software.amazon.awscdk.services.kms.IKey sourceKmsKey;

        /**
         * Sets the value of {@link BucketOptions#getObjectVersion}
         * @param objectVersion Optional S3 object version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectVersion(java.lang.String objectVersion) {
            this.objectVersion = objectVersion;
            return this;
        }

        /**
         * Sets the value of {@link BucketOptions#getSourceKmsKey}
         * @param sourceKmsKey The ARN of the KMS key used to encrypt the handler code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceKmsKey(software.amazon.awscdk.services.kms.IKey sourceKmsKey) {
            this.sourceKmsKey = sourceKmsKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BucketOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BucketOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BucketOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BucketOptions {
        private final java.lang.String objectVersion;
        private final software.amazon.awscdk.services.kms.IKey sourceKmsKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.objectVersion = software.amazon.jsii.Kernel.get(this, "objectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceKmsKey = software.amazon.jsii.Kernel.get(this, "sourceKMSKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.objectVersion = builder.objectVersion;
            this.sourceKmsKey = builder.sourceKmsKey;
        }

        @Override
        public final java.lang.String getObjectVersion() {
            return this.objectVersion;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getSourceKMSKey() {
            return this.sourceKmsKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getObjectVersion() != null) {
                data.set("objectVersion", om.valueToTree(this.getObjectVersion()));
            }
            if (this.getSourceKMSKey() != null) {
                data.set("sourceKMSKey", om.valueToTree(this.getSourceKMSKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.BucketOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BucketOptions.Jsii$Proxy that = (BucketOptions.Jsii$Proxy) o;

            if (this.objectVersion != null ? !this.objectVersion.equals(that.objectVersion) : that.objectVersion != null) return false;
            return this.sourceKmsKey != null ? this.sourceKmsKey.equals(that.sourceKmsKey) : that.sourceKmsKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.objectVersion != null ? this.objectVersion.hashCode() : 0;
            result = 31 * result + (this.sourceKmsKey != null ? this.sourceKmsKey.hashCode() : 0);
            return result;
        }
    }
}
