package software.amazon.awscdk.services.lambda;

/**
 * (Amazon MSK and self-managed Apache Kafka only) Specific configuration settings for a Kafka schema registry.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * EventRecordFormat eventRecordFormat;
 * KafkaSchemaRegistryAccessConfigType kafkaSchemaRegistryAccessConfigType;
 * KafkaSchemaValidationAttribute kafkaSchemaValidationAttribute;
 * KafkaSchemaRegistryConfig kafkaSchemaRegistryConfig = KafkaSchemaRegistryConfig.builder()
 *         .eventRecordFormat(eventRecordFormat)
 *         .schemaRegistryUri("schemaRegistryUri")
 *         .schemaValidationConfigs(List.of(KafkaSchemaValidationConfig.builder()
 *                 .attribute(kafkaSchemaValidationAttribute)
 *                 .build()))
 *         // the properties below are optional
 *         .accessConfigs(List.of(KafkaSchemaRegistryAccessConfig.builder()
 *                 .type(kafkaSchemaRegistryAccessConfigType)
 *                 .uri("uri")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:34.438Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.KafkaSchemaRegistryConfig")
@software.amazon.jsii.Jsii.Proxy(KafkaSchemaRegistryConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KafkaSchemaRegistryConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The record format that Lambda delivers to your function after schema validation.
     * <p>
     * <ul>
     * <li>Choose JSON to have Lambda deliver the record to your function as a standard JSON object.</li>
     * <li>Choose SOURCE to have Lambda deliver the record to your function in its original source format. Lambda removes all schema metadata, such as the schema ID, before sending the record to your function.</li>
     * </ul>
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventRecordFormat getEventRecordFormat();

    /**
     * The URI for your schema registry.
     * <p>
     * The correct URI format depends on the type of schema registry you're using.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSchemaRegistryUri();

    /**
     * An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> getSchemaValidationConfigs();

    /**
     * An array of access configuration objects that tell Lambda how to authenticate with your schema registry.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfig> getAccessConfigs() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KafkaSchemaRegistryConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KafkaSchemaRegistryConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KafkaSchemaRegistryConfig> {
        software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat;
        java.lang.String schemaRegistryUri;
        java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs;
        java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfig> accessConfigs;

        /**
         * Sets the value of {@link KafkaSchemaRegistryConfig#getEventRecordFormat}
         * @param eventRecordFormat The record format that Lambda delivers to your function after schema validation. This parameter is required.
         *                          <ul>
         *                          <li>Choose JSON to have Lambda deliver the record to your function as a standard JSON object.</li>
         *                          <li>Choose SOURCE to have Lambda deliver the record to your function in its original source format. Lambda removes all schema metadata, such as the schema ID, before sending the record to your function.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRecordFormat(software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat) {
            this.eventRecordFormat = eventRecordFormat;
            return this;
        }

        /**
         * Sets the value of {@link KafkaSchemaRegistryConfig#getSchemaRegistryUri}
         * @param schemaRegistryUri The URI for your schema registry. This parameter is required.
         *                          The correct URI format depends on the type of schema registry you're using.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaRegistryUri(java.lang.String schemaRegistryUri) {
            this.schemaRegistryUri = schemaRegistryUri;
            return this;
        }

        /**
         * Sets the value of {@link KafkaSchemaRegistryConfig#getSchemaValidationConfigs}
         * @param schemaValidationConfigs An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder schemaValidationConfigs(java.util.List<? extends software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs) {
            this.schemaValidationConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig>)schemaValidationConfigs;
            return this;
        }

        /**
         * Sets the value of {@link KafkaSchemaRegistryConfig#getAccessConfigs}
         * @param accessConfigs An array of access configuration objects that tell Lambda how to authenticate with your schema registry.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder accessConfigs(java.util.List<? extends software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfig> accessConfigs) {
            this.accessConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfig>)accessConfigs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KafkaSchemaRegistryConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KafkaSchemaRegistryConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KafkaSchemaRegistryConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaSchemaRegistryConfig {
        private final software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat;
        private final java.lang.String schemaRegistryUri;
        private final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs;
        private final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfig> accessConfigs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventRecordFormat = software.amazon.jsii.Kernel.get(this, "eventRecordFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventRecordFormat.class));
            this.schemaRegistryUri = software.amazon.jsii.Kernel.get(this, "schemaRegistryUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schemaValidationConfigs = software.amazon.jsii.Kernel.get(this, "schemaValidationConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig.class)));
            this.accessConfigs = software.amazon.jsii.Kernel.get(this, "accessConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfig.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventRecordFormat = java.util.Objects.requireNonNull(builder.eventRecordFormat, "eventRecordFormat is required");
            this.schemaRegistryUri = java.util.Objects.requireNonNull(builder.schemaRegistryUri, "schemaRegistryUri is required");
            this.schemaValidationConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig>)java.util.Objects.requireNonNull(builder.schemaValidationConfigs, "schemaValidationConfigs is required");
            this.accessConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfig>)builder.accessConfigs;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.EventRecordFormat getEventRecordFormat() {
            return this.eventRecordFormat;
        }

        @Override
        public final java.lang.String getSchemaRegistryUri() {
            return this.schemaRegistryUri;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> getSchemaValidationConfigs() {
            return this.schemaValidationConfigs;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaRegistryAccessConfig> getAccessConfigs() {
            return this.accessConfigs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventRecordFormat", om.valueToTree(this.getEventRecordFormat()));
            data.set("schemaRegistryUri", om.valueToTree(this.getSchemaRegistryUri()));
            data.set("schemaValidationConfigs", om.valueToTree(this.getSchemaValidationConfigs()));
            if (this.getAccessConfigs() != null) {
                data.set("accessConfigs", om.valueToTree(this.getAccessConfigs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.KafkaSchemaRegistryConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KafkaSchemaRegistryConfig.Jsii$Proxy that = (KafkaSchemaRegistryConfig.Jsii$Proxy) o;

            if (!eventRecordFormat.equals(that.eventRecordFormat)) return false;
            if (!schemaRegistryUri.equals(that.schemaRegistryUri)) return false;
            if (!schemaValidationConfigs.equals(that.schemaValidationConfigs)) return false;
            return this.accessConfigs != null ? this.accessConfigs.equals(that.accessConfigs) : that.accessConfigs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eventRecordFormat.hashCode();
            result = 31 * result + (this.schemaRegistryUri.hashCode());
            result = 31 * result + (this.schemaValidationConfigs.hashCode());
            result = 31 * result + (this.accessConfigs != null ? this.accessConfigs.hashCode() : 0);
            return result;
        }
    }
}
