package software.amazon.awscdk.services.lambda;

/**
 * Properties for schema registry configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * EventRecordFormat eventRecordFormat;
 * KafkaSchemaValidationAttribute kafkaSchemaValidationAttribute;
 * SchemaRegistryProps schemaRegistryProps = SchemaRegistryProps.builder()
 *         .eventRecordFormat(eventRecordFormat)
 *         .schemaValidationConfigs(List.of(KafkaSchemaValidationConfig.builder()
 *                 .attribute(kafkaSchemaValidationAttribute)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:34.497Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.SchemaRegistryProps")
@software.amazon.jsii.Jsii.Proxy(SchemaRegistryProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SchemaRegistryProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The record format that Lambda delivers to your function after schema validation.
     * <p>
     * <ul>
     * <li>Choose JSON to have Lambda deliver the record to your function as a standard JSON object.</li>
     * <li>Choose SOURCE to have Lambda deliver the record to your function in its original source format. Lambda removes all schema metadata, such as the schema ID, before sending the record to your function.</li>
     * </ul>
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventRecordFormat getEventRecordFormat();

    /**
     * An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> getSchemaValidationConfigs();

    /**
     * @return a {@link Builder} of {@link SchemaRegistryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SchemaRegistryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SchemaRegistryProps> {
        software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat;
        java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs;

        /**
         * Sets the value of {@link SchemaRegistryProps#getEventRecordFormat}
         * @param eventRecordFormat The record format that Lambda delivers to your function after schema validation. This parameter is required.
         *                          <ul>
         *                          <li>Choose JSON to have Lambda deliver the record to your function as a standard JSON object.</li>
         *                          <li>Choose SOURCE to have Lambda deliver the record to your function in its original source format. Lambda removes all schema metadata, such as the schema ID, before sending the record to your function.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRecordFormat(software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat) {
            this.eventRecordFormat = eventRecordFormat;
            return this;
        }

        /**
         * Sets the value of {@link SchemaRegistryProps#getSchemaValidationConfigs}
         * @param schemaValidationConfigs An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder schemaValidationConfigs(java.util.List<? extends software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs) {
            this.schemaValidationConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig>)schemaValidationConfigs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SchemaRegistryProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SchemaRegistryProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SchemaRegistryProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaRegistryProps {
        private final software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat;
        private final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eventRecordFormat = software.amazon.jsii.Kernel.get(this, "eventRecordFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventRecordFormat.class));
            this.schemaValidationConfigs = software.amazon.jsii.Kernel.get(this, "schemaValidationConfigs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eventRecordFormat = java.util.Objects.requireNonNull(builder.eventRecordFormat, "eventRecordFormat is required");
            this.schemaValidationConfigs = (java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig>)java.util.Objects.requireNonNull(builder.schemaValidationConfigs, "schemaValidationConfigs is required");
        }

        @Override
        public final software.amazon.awscdk.services.lambda.EventRecordFormat getEventRecordFormat() {
            return this.eventRecordFormat;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> getSchemaValidationConfigs() {
            return this.schemaValidationConfigs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eventRecordFormat", om.valueToTree(this.getEventRecordFormat()));
            data.set("schemaValidationConfigs", om.valueToTree(this.getSchemaValidationConfigs()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.SchemaRegistryProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SchemaRegistryProps.Jsii$Proxy that = (SchemaRegistryProps.Jsii$Proxy) o;

            if (!eventRecordFormat.equals(that.eventRecordFormat)) return false;
            return this.schemaValidationConfigs.equals(that.schemaValidationConfigs);
        }

        @Override
        public final int hashCode() {
            int result = this.eventRecordFormat.hashCode();
            result = 31 * result + (this.schemaValidationConfigs.hashCode());
            return result;
        }
    }
}
