package software.amazon.awscdk.services.lambda;

/**
 * Tag the current state of a Function with a Version number.
 * <p>
 * Avoid using this resource directly. If you need a Version object, use
 * <code>function.currentVersion</code> instead. That will add a Version object to your
 * template, and make sure the Version is invalidated whenever the Function
 * object changes. If you use the <code>Version</code> resource directly, you are
 * responsible for making sure it is invalidated (by changing its
 * logical ID) whenever necessary.
 * <p>
 * Version resources can then be used in <code>Alias</code> resources to refer to a
 * particular deployment of a Lambda.
 * <p>
 * If you want to ensure that you're associating the right version with
 * the right deployment, specify the <code>codeSha256</code> property while
 * creating the `Version.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CfnParametersCode lambdaCode = Code.fromCfnParameters();
 * Function func = Function.Builder.create(this, "Lambda")
 *         .code(lambdaCode)
 *         .handler("index.handler")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .build();
 * // used to make sure each CDK synthesis produces a different Version
 * Version version = func.getCurrentVersion();
 * Alias alias = Alias.Builder.create(this, "LambdaAlias")
 *         .aliasName("Prod")
 *         .version(version)
 *         .build();
 * LambdaDeploymentGroup.Builder.create(this, "DeploymentGroup")
 *         .alias(alias)
 *         .deploymentConfig(LambdaDeploymentConfig.LINEAR_10PERCENT_EVERY_1MINUTE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:34.525Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.Version")
public class Version extends software.amazon.awscdk.services.lambda.QualifiedFunctionBase implements software.amazon.awscdk.services.lambda.IVersion {

    protected Version(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Version(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.Version.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Version(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.VersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Construct a Version object from a Version ARN.
     * <p>
     * @param scope The cdk scope creating this resource. This parameter is required.
     * @param id The cdk id of this resource. This parameter is required.
     * @param versionArn The version ARN to create this version from. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion fromVersionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String versionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Version.class, "fromVersionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(versionArn, "versionArn is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion fromVersionAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.VersionAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.lambda.Version.class, "fromVersionAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (deprecated) Defines an alias for this version.
     * <p>
     * @deprecated Calling <code>addAlias</code> on a <code>Version</code> object will cause the Alias to be replaced on every function update. Call <code>function.addAlias()</code> or <code>new Alias()</code> instead.
     * @param aliasName The name of the alias (e.g. "live"). This parameter is required.
     * @param options Alias options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Alias addAlias(final @org.jetbrains.annotations.NotNull java.lang.String aliasName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.AliasOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Alias.class), new Object[] { java.util.Objects.requireNonNull(aliasName, "aliasName is required"), options });
    }

    /**
     * (deprecated) Defines an alias for this version.
     * <p>
     * @deprecated Calling <code>addAlias</code> on a <code>Version</code> object will cause the Alias to be replaced on every function update. Call <code>function.addAlias()</code> or <code>new Alias()</code> instead.
     * @param aliasName The name of the alias (e.g. "live"). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Alias addAlias(final @org.jetbrains.annotations.NotNull java.lang.String aliasName) {
        return software.amazon.jsii.Kernel.call(this, "addAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Alias.class), new Object[] { java.util.Objects.requireNonNull(aliasName, "aliasName is required") });
    }

    /**
     * Return the given named metric for this Function.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Function.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The architecture of this Lambda Function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Architecture getArchitecture() {
        return software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Architecture.class));
    }

    /**
     * Whether the addPermission() call adds any permissions.
     * <p>
     * True for new Lambdas, false for version $LATEST and imported Lambdas
     * from different accounts.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getCanCreatePermissions() {
        return software.amazon.jsii.Kernel.get(this, "canCreatePermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The ARN of the version for Lambda&#64;Edge.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEdgeArn() {
        return software.amazon.jsii.Kernel.get(this, "edgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN fo the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The principal this Lambda Function is running as.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The underlying <code>IFunction</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getLambda() {
        return software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
    }

    /**
     * The qualifier of the version or alias of this function.
     * <p>
     * A qualifier is the identifier that's appended to a version or alias ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getQualifier() {
        return software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The most recently deployed version of this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role associated with this function.
     * <p>
     * Undefined if the function was imported without a role.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.Version}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.Version> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.VersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.VersionProps.Builder();
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum: 60 seconds
         * Maximum: 6 hours
         * <p>
         * Default: Duration.hours(6)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The destination for failed invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onFailure The destination for failed invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * The destination for successful invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onSuccess The destination for successful invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onSuccess(final software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.props.onSuccess(onSuccess);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum: 0
         * Maximum: 2
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * SHA256 of the version of the Lambda source code.
         * <p>
         * Specify to validate that you're deploying the right version.
         * <p>
         * Default: No validation is performed
         * <p>
         * @return {@code this}
         * @param codeSha256 SHA256 of the version of the Lambda source code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeSha256(final java.lang.String codeSha256) {
            this.props.codeSha256(codeSha256);
            return this;
        }

        /**
         * Description of the version.
         * <p>
         * Default: Description of the Lambda
         * <p>
         * @return {@code this}
         * @param description Description of the version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies a provisioned concurrency configuration for a function's version.
         * <p>
         * Default: No provisioned concurrency
         * <p>
         * @return {@code this}
         * @param provisionedConcurrentExecutions Specifies a provisioned concurrency configuration for a function's version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisionedConcurrentExecutions(final java.lang.Number provisionedConcurrentExecutions) {
            this.props.provisionedConcurrentExecutions(provisionedConcurrentExecutions);
            return this;
        }

        /**
         * Whether to retain old versions of this function when a new version is created.
         * <p>
         * Default: RemovalPolicy.DESTROY
         * <p>
         * @return {@code this}
         * @param removalPolicy Whether to retain old versions of this function when a new version is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Function to get the value of.
         * <p>
         * @return {@code this}
         * @param lambda Function to get the value of. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lambda(final software.amazon.awscdk.services.lambda.IFunction lambda) {
            this.props.lambda(lambda);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.Version}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.Version build() {
            return new software.amazon.awscdk.services.lambda.Version(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
