package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.sns.*;
 * import software.amazon.awscdk.services.lambda.eventsources.SnsEventSource;
 * Topic topic;
 * Function fn;
 * Queue deadLetterQueue = new Queue(this, "deadLetterQueue");
 * fn.addEventSource(SnsEventSource.Builder.create(topic)
 *         .filterPolicy(Map.of())
 *         .deadLetterQueue(deadLetterQueue)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:34.628Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.SnsEventSource")
public class SnsEventSource extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IEventSource {

    protected SnsEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SnsEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param topic This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SnsEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.eventsources.SnsEventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required"), props });
    }

    /**
     * @param topic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SnsEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic topic) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(topic, "topic is required") });
    }

    /**
     * Called by <code>lambda.addEventSource</code> to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic getTopic() {
        return software.amazon.jsii.Kernel.get(this, "topic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.SnsEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.SnsEventSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param topic This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.sns.ITopic topic) {
            return new Builder(topic);
        }

        private final software.amazon.awscdk.services.sns.ITopic topic;
        private software.amazon.awscdk.services.lambda.eventsources.SnsEventSourceProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sns.ITopic topic) {
            this.topic = topic;
        }

        /**
         * Queue to be used as dead letter queue.
         * <p>
         * If not passed no dead letter queue is enabled.
         * <p>
         * Default: - No dead letter queue enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueue Queue to be used as dead letter queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The filter policy.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicy The filter policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicy(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        /**
         * The filter policy that is applied on the message body.
         * <p>
         * To apply a filter policy to the message attributes, use <code>filterPolicy</code>. A maximum of one of <code>filterPolicyWithMessageBody</code> and <code>filterPolicy</code> may be used.
         * <p>
         * Default: - all messages are delivered
         * <p>
         * @return {@code this}
         * @param filterPolicyWithMessageBody The filter policy that is applied on the message body. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPolicyWithMessageBody(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.FilterOrPolicy> filterPolicyWithMessageBody) {
            this.props().filterPolicyWithMessageBody(filterPolicyWithMessageBody);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.SnsEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.SnsEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.SnsEventSource(
                this.topic,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.lambda.eventsources.SnsEventSourceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.lambda.eventsources.SnsEventSourceProps.Builder();
            }
            return this.props;
        }
    }
}
