package software.amazon.awscdk.services.lightsail;

/**
 * Properties for defining a <code>CfnLoadBalancer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnLoadBalancerProps cfnLoadBalancerProps = CfnLoadBalancerProps.builder()
 *         .instancePort(123)
 *         .loadBalancerName("loadBalancerName")
 *         // the properties below are optional
 *         .attachedInstances(List.of("attachedInstances"))
 *         .healthCheckPath("healthCheckPath")
 *         .ipAddressType("ipAddressType")
 *         .sessionStickinessEnabled(false)
 *         .sessionStickinessLbCookieDurationSeconds("sessionStickinessLbCookieDurationSeconds")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tlsPolicyName("tlsPolicyName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:35.174Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnLoadBalancerProps")
@software.amazon.jsii.Jsii.Proxy(CfnLoadBalancerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLoadBalancerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The port that the load balancer uses to direct traffic to your Lightsail instances.
     * <p>
     * For HTTP traffic, specify port <code>80</code> . For HTTPS traffic, specify port <code>443</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-instanceport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-instanceport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getInstancePort();

    /**
     * The name of the load balancer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-loadbalancername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-loadbalancername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLoadBalancerName();

    /**
     * The Lightsail instances to attach to the load balancer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-attachedinstances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-attachedinstances</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAttachedInstances() {
        return null;
    }

    /**
     * The path on the attached instance where the health check will be performed.
     * <p>
     * If no path is specified, the load balancer tries to make a request to the default (root) page ( <code>/index.html</code> ).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-healthcheckpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-healthcheckpath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckPath() {
        return null;
    }

    /**
     * The IP address type of the load balancer.
     * <p>
     * The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for both IPv4 and IPv6.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-ipaddresstype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return null;
    }

    /**
     * A Boolean value indicating whether session stickiness is enabled.
     * <p>
     * Enable session stickiness (also known as <em>session affinity</em> ) to bind a user's session to a specific instance. This ensures that all requests from the user during the session are sent to the same instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-sessionstickinessenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-sessionstickinessenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSessionStickinessEnabled() {
        return null;
    }

    /**
     * The time period, in seconds, after which the load balancer session stickiness cookie should be considered stale.
     * <p>
     * If you do not specify this parameter, the default value is 0, which indicates that the sticky session should last for the duration of the browser session.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-sessionstickinesslbcookiedurationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-sessionstickinesslbcookiedurationseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSessionStickinessLbCookieDurationSeconds() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name of the TLS security policy for the load balancer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-tlspolicyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-loadbalancer.html#cfn-lightsail-loadbalancer-tlspolicyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTlsPolicyName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLoadBalancerProps> {
        java.lang.Number instancePort;
        java.lang.String loadBalancerName;
        java.util.List<java.lang.String> attachedInstances;
        java.lang.String healthCheckPath;
        java.lang.String ipAddressType;
        java.lang.Object sessionStickinessEnabled;
        java.lang.String sessionStickinessLbCookieDurationSeconds;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String tlsPolicyName;

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getInstancePort}
         * @param instancePort The port that the load balancer uses to direct traffic to your Lightsail instances. This parameter is required.
         *                     For HTTP traffic, specify port <code>80</code> . For HTTPS traffic, specify port <code>443</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instancePort(java.lang.Number instancePort) {
            this.instancePort = instancePort;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getLoadBalancerName}
         * @param loadBalancerName The name of the load balancer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(java.lang.String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getAttachedInstances}
         * @param attachedInstances The Lightsail instances to attach to the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attachedInstances(java.util.List<java.lang.String> attachedInstances) {
            this.attachedInstances = attachedInstances;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getHealthCheckPath}
         * @param healthCheckPath The path on the attached instance where the health check will be performed.
         *                        If no path is specified, the load balancer tries to make a request to the default (root) page ( <code>/index.html</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckPath(java.lang.String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getIpAddressType}
         * @param ipAddressType The IP address type of the load balancer.
         *                      The possible values are <code>ipv4</code> for IPv4 only, and <code>dualstack</code> for both IPv4 and IPv6.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(java.lang.String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getSessionStickinessEnabled}
         * @param sessionStickinessEnabled A Boolean value indicating whether session stickiness is enabled.
         *                                 Enable session stickiness (also known as <em>session affinity</em> ) to bind a user's session to a specific instance. This ensures that all requests from the user during the session are sent to the same instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionStickinessEnabled(java.lang.Boolean sessionStickinessEnabled) {
            this.sessionStickinessEnabled = sessionStickinessEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getSessionStickinessEnabled}
         * @param sessionStickinessEnabled A Boolean value indicating whether session stickiness is enabled.
         *                                 Enable session stickiness (also known as <em>session affinity</em> ) to bind a user's session to a specific instance. This ensures that all requests from the user during the session are sent to the same instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionStickinessEnabled(software.amazon.awscdk.IResolvable sessionStickinessEnabled) {
            this.sessionStickinessEnabled = sessionStickinessEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getSessionStickinessLbCookieDurationSeconds}
         * @param sessionStickinessLbCookieDurationSeconds The time period, in seconds, after which the load balancer session stickiness cookie should be considered stale.
         *                                                 If you do not specify this parameter, the default value is 0, which indicates that the sticky session should last for the duration of the browser session.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionStickinessLbCookieDurationSeconds(java.lang.String sessionStickinessLbCookieDurationSeconds) {
            this.sessionStickinessLbCookieDurationSeconds = sessionStickinessLbCookieDurationSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         *             <p>
         *             <blockquote>
         *             <p>
         *             The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getTlsPolicyName}
         * @param tlsPolicyName The name of the TLS security policy for the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsPolicyName(java.lang.String tlsPolicyName) {
            this.tlsPolicyName = tlsPolicyName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLoadBalancerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLoadBalancerProps {
        private final java.lang.Number instancePort;
        private final java.lang.String loadBalancerName;
        private final java.util.List<java.lang.String> attachedInstances;
        private final java.lang.String healthCheckPath;
        private final java.lang.String ipAddressType;
        private final java.lang.Object sessionStickinessEnabled;
        private final java.lang.String sessionStickinessLbCookieDurationSeconds;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String tlsPolicyName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instancePort = software.amazon.jsii.Kernel.get(this, "instancePort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.loadBalancerName = software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.attachedInstances = software.amazon.jsii.Kernel.get(this, "attachedInstances", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.healthCheckPath = software.amazon.jsii.Kernel.get(this, "healthCheckPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipAddressType = software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sessionStickinessEnabled = software.amazon.jsii.Kernel.get(this, "sessionStickinessEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sessionStickinessLbCookieDurationSeconds = software.amazon.jsii.Kernel.get(this, "sessionStickinessLbCookieDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.tlsPolicyName = software.amazon.jsii.Kernel.get(this, "tlsPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instancePort = java.util.Objects.requireNonNull(builder.instancePort, "instancePort is required");
            this.loadBalancerName = java.util.Objects.requireNonNull(builder.loadBalancerName, "loadBalancerName is required");
            this.attachedInstances = builder.attachedInstances;
            this.healthCheckPath = builder.healthCheckPath;
            this.ipAddressType = builder.ipAddressType;
            this.sessionStickinessEnabled = builder.sessionStickinessEnabled;
            this.sessionStickinessLbCookieDurationSeconds = builder.sessionStickinessLbCookieDurationSeconds;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.tlsPolicyName = builder.tlsPolicyName;
        }

        @Override
        public final java.lang.Number getInstancePort() {
            return this.instancePort;
        }

        @Override
        public final java.lang.String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final java.util.List<java.lang.String> getAttachedInstances() {
            return this.attachedInstances;
        }

        @Override
        public final java.lang.String getHealthCheckPath() {
            return this.healthCheckPath;
        }

        @Override
        public final java.lang.String getIpAddressType() {
            return this.ipAddressType;
        }

        @Override
        public final java.lang.Object getSessionStickinessEnabled() {
            return this.sessionStickinessEnabled;
        }

        @Override
        public final java.lang.String getSessionStickinessLbCookieDurationSeconds() {
            return this.sessionStickinessLbCookieDurationSeconds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTlsPolicyName() {
            return this.tlsPolicyName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instancePort", om.valueToTree(this.getInstancePort()));
            data.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
            if (this.getAttachedInstances() != null) {
                data.set("attachedInstances", om.valueToTree(this.getAttachedInstances()));
            }
            if (this.getHealthCheckPath() != null) {
                data.set("healthCheckPath", om.valueToTree(this.getHealthCheckPath()));
            }
            if (this.getIpAddressType() != null) {
                data.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
            }
            if (this.getSessionStickinessEnabled() != null) {
                data.set("sessionStickinessEnabled", om.valueToTree(this.getSessionStickinessEnabled()));
            }
            if (this.getSessionStickinessLbCookieDurationSeconds() != null) {
                data.set("sessionStickinessLbCookieDurationSeconds", om.valueToTree(this.getSessionStickinessLbCookieDurationSeconds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTlsPolicyName() != null) {
                data.set("tlsPolicyName", om.valueToTree(this.getTlsPolicyName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnLoadBalancerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLoadBalancerProps.Jsii$Proxy that = (CfnLoadBalancerProps.Jsii$Proxy) o;

            if (!instancePort.equals(that.instancePort)) return false;
            if (!loadBalancerName.equals(that.loadBalancerName)) return false;
            if (this.attachedInstances != null ? !this.attachedInstances.equals(that.attachedInstances) : that.attachedInstances != null) return false;
            if (this.healthCheckPath != null ? !this.healthCheckPath.equals(that.healthCheckPath) : that.healthCheckPath != null) return false;
            if (this.ipAddressType != null ? !this.ipAddressType.equals(that.ipAddressType) : that.ipAddressType != null) return false;
            if (this.sessionStickinessEnabled != null ? !this.sessionStickinessEnabled.equals(that.sessionStickinessEnabled) : that.sessionStickinessEnabled != null) return false;
            if (this.sessionStickinessLbCookieDurationSeconds != null ? !this.sessionStickinessLbCookieDurationSeconds.equals(that.sessionStickinessLbCookieDurationSeconds) : that.sessionStickinessLbCookieDurationSeconds != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.tlsPolicyName != null ? this.tlsPolicyName.equals(that.tlsPolicyName) : that.tlsPolicyName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instancePort.hashCode();
            result = 31 * result + (this.loadBalancerName.hashCode());
            result = 31 * result + (this.attachedInstances != null ? this.attachedInstances.hashCode() : 0);
            result = 31 * result + (this.healthCheckPath != null ? this.healthCheckPath.hashCode() : 0);
            result = 31 * result + (this.ipAddressType != null ? this.ipAddressType.hashCode() : 0);
            result = 31 * result + (this.sessionStickinessEnabled != null ? this.sessionStickinessEnabled.hashCode() : 0);
            result = 31 * result + (this.sessionStickinessLbCookieDurationSeconds != null ? this.sessionStickinessLbCookieDurationSeconds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tlsPolicyName != null ? this.tlsPolicyName.hashCode() : 0);
            return result;
        }
    }
}
