package software.amazon.awscdk.services.logs;

/**
 * This object defines one value to be copied with the copyValue processor.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CopyValueEntryProperty copyValueEntryProperty = CopyValueEntryProperty.builder()
 *         .source("source")
 *         .target("target")
 *         // the properties below are optional
 *         .overwriteIfExists(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:35.423Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CopyValueEntryProperty")
@software.amazon.jsii.Jsii.Proxy(CopyValueEntryProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CopyValueEntryProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key to copy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSource();

    /**
     * The key of the field to copy the value to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTarget();

    /**
     * Specifies whether to overwrite the value if the target key already exists.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOverwriteIfExists() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CopyValueEntryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CopyValueEntryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CopyValueEntryProperty> {
        java.lang.String source;
        java.lang.String target;
        java.lang.Boolean overwriteIfExists;

        /**
         * Sets the value of {@link CopyValueEntryProperty#getSource}
         * @param source The key to copy. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(java.lang.String source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link CopyValueEntryProperty#getTarget}
         * @param target The key of the field to copy the value to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(java.lang.String target) {
            this.target = target;
            return this;
        }

        /**
         * Sets the value of {@link CopyValueEntryProperty#getOverwriteIfExists}
         * @param overwriteIfExists Specifies whether to overwrite the value if the target key already exists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overwriteIfExists(java.lang.Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CopyValueEntryProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CopyValueEntryProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CopyValueEntryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CopyValueEntryProperty {
        private final java.lang.String source;
        private final java.lang.String target;
        private final java.lang.Boolean overwriteIfExists;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.overwriteIfExists = software.amazon.jsii.Kernel.get(this, "overwriteIfExists", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
            this.overwriteIfExists = builder.overwriteIfExists;
        }

        @Override
        public final java.lang.String getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getTarget() {
            return this.target;
        }

        @Override
        public final java.lang.Boolean getOverwriteIfExists() {
            return this.overwriteIfExists;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("source", om.valueToTree(this.getSource()));
            data.set("target", om.valueToTree(this.getTarget()));
            if (this.getOverwriteIfExists() != null) {
                data.set("overwriteIfExists", om.valueToTree(this.getOverwriteIfExists()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CopyValueEntryProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CopyValueEntryProperty.Jsii$Proxy that = (CopyValueEntryProperty.Jsii$Proxy) o;

            if (!source.equals(that.source)) return false;
            if (!target.equals(that.target)) return false;
            return this.overwriteIfExists != null ? this.overwriteIfExists.equals(that.overwriteIfExists) : that.overwriteIfExists == null;
        }

        @Override
        public final int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + (this.target.hashCode());
            result = 31 * result + (this.overwriteIfExists != null ? this.overwriteIfExists.hashCode() : 0);
            return result;
        }
    }
}
