package software.amazon.awscdk.services.logs;

/**
 * Properties for creating data converter processors.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * DataConverterProps dataConverterProps = DataConverterProps.builder()
 *         .type(DataConverterType.TYPE_CONVERTER)
 *         // the properties below are optional
 *         .dateTimeConverterOptions(DateTimeConverterProperty.builder()
 *                 .locale("locale")
 *                 .matchPatterns(List.of("matchPatterns"))
 *                 .source("source")
 *                 .target("target")
 *                 // the properties below are optional
 *                 .sourceTimezone("sourceTimezone")
 *                 .targetFormat("targetFormat")
 *                 .targetTimezone("targetTimezone")
 *                 .build())
 *         .typeConverterOptions(TypeConverterProperty.builder()
 *                 .entries(List.of(TypeConverterEntryProperty.builder()
 *                         .key("key")
 *                         .type(TypeConverterType.BOOLEAN)
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:35.431Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.DataConverterProps")
@software.amazon.jsii.Jsii.Proxy(DataConverterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DataConverterProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.logs.BaseProcessorProps {

    /**
     * The type of data conversion operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.DataConverterType getType();

    /**
     * Options for datetime conversion.
     * <p>
     * Required when type is DATETIME_CONVERTER.
     * <p>
     * Default: - No date time converter processor is created if not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.DateTimeConverterProperty getDateTimeConverterOptions() {
        return null;
    }

    /**
     * Options for type conversion.
     * <p>
     * Required when type is TYPE_CONVERTER.
     * <p>
     * Default: - No type convertor processor is created if not set
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.TypeConverterProperty getTypeConverterOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataConverterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataConverterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DataConverterProps> {
        software.amazon.awscdk.services.logs.DataConverterType type;
        software.amazon.awscdk.services.logs.DateTimeConverterProperty dateTimeConverterOptions;
        software.amazon.awscdk.services.logs.TypeConverterProperty typeConverterOptions;

        /**
         * Sets the value of {@link DataConverterProps#getType}
         * @param type The type of data conversion operation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.logs.DataConverterType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link DataConverterProps#getDateTimeConverterOptions}
         * @param dateTimeConverterOptions Options for datetime conversion.
         *                                 Required when type is DATETIME_CONVERTER.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dateTimeConverterOptions(software.amazon.awscdk.services.logs.DateTimeConverterProperty dateTimeConverterOptions) {
            this.dateTimeConverterOptions = dateTimeConverterOptions;
            return this;
        }

        /**
         * Sets the value of {@link DataConverterProps#getTypeConverterOptions}
         * @param typeConverterOptions Options for type conversion.
         *                             Required when type is TYPE_CONVERTER.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeConverterOptions(software.amazon.awscdk.services.logs.TypeConverterProperty typeConverterOptions) {
            this.typeConverterOptions = typeConverterOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataConverterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DataConverterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataConverterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataConverterProps {
        private final software.amazon.awscdk.services.logs.DataConverterType type;
        private final software.amazon.awscdk.services.logs.DateTimeConverterProperty dateTimeConverterOptions;
        private final software.amazon.awscdk.services.logs.TypeConverterProperty typeConverterOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataConverterType.class));
            this.dateTimeConverterOptions = software.amazon.jsii.Kernel.get(this, "dateTimeConverterOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DateTimeConverterProperty.class));
            this.typeConverterOptions = software.amazon.jsii.Kernel.get(this, "typeConverterOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.TypeConverterProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.dateTimeConverterOptions = builder.dateTimeConverterOptions;
            this.typeConverterOptions = builder.typeConverterOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.DataConverterType getType() {
            return this.type;
        }

        @Override
        public final software.amazon.awscdk.services.logs.DateTimeConverterProperty getDateTimeConverterOptions() {
            return this.dateTimeConverterOptions;
        }

        @Override
        public final software.amazon.awscdk.services.logs.TypeConverterProperty getTypeConverterOptions() {
            return this.typeConverterOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getDateTimeConverterOptions() != null) {
                data.set("dateTimeConverterOptions", om.valueToTree(this.getDateTimeConverterOptions()));
            }
            if (this.getTypeConverterOptions() != null) {
                data.set("typeConverterOptions", om.valueToTree(this.getTypeConverterOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.DataConverterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataConverterProps.Jsii$Proxy that = (DataConverterProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.dateTimeConverterOptions != null ? !this.dateTimeConverterOptions.equals(that.dateTimeConverterOptions) : that.dateTimeConverterOptions != null) return false;
            return this.typeConverterOptions != null ? this.typeConverterOptions.equals(that.typeConverterOptions) : that.typeConverterOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.dateTimeConverterOptions != null ? this.dateTimeConverterOptions.hashCode() : 0);
            result = 31 * result + (this.typeConverterOptions != null ? this.typeConverterOptions.hashCode() : 0);
            return result;
        }
    }
}
