package software.amazon.awscdk.services.logs;

/**
 * A data protection identifier.
 * <p>
 * If an identifier is supported but not in this class, it can be passed in the constructor instead.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * LogGroup logGroupDestination = LogGroup.Builder.create(this, "LogGroupLambdaAudit")
 *         .logGroupName("auditDestinationForCDK")
 *         .build();
 * Bucket bucket = new Bucket(this, "audit-bucket");
 * S3Bucket s3Destination = new S3Bucket(bucket);
 * DeliveryStream deliveryStream = DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(s3Destination)
 *         .build();
 * DataProtectionPolicy dataProtectionPolicy = DataProtectionPolicy.Builder.create()
 *         .name("data protection policy")
 *         .description("policy description")
 *         .identifiers(List.of(DataIdentifier.DRIVERSLICENSE_US,  // managed data identifier
 *             new DataIdentifier("EmailAddress"),  // forward compatibility for new managed data identifiers
 *             new CustomDataIdentifier("EmployeeId", "EmployeeId-\\d{9}"))) // custom data identifier
 *         .logGroupAuditDestination(logGroupDestination)
 *         .s3BucketAuditDestination(bucket)
 *         .deliveryStreamNameAuditDestination(deliveryStream.getDeliveryStreamName())
 *         .build();
 * LogGroup.Builder.create(this, "LogGroupLambda")
 *         .logGroupName("cdkIntegLogGroup")
 *         .dataProtectionPolicy(dataProtectionPolicy)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:35.433Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.DataIdentifier")
public class DataIdentifier extends software.amazon.jsii.JsiiObject {

    protected DataIdentifier(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DataIdentifier(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        ADDRESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "ADDRESS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        AWSSECRETKEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "AWSSECRETKEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        BANKACCOUNTNUMBER_DE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "BANKACCOUNTNUMBER_DE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        BANKACCOUNTNUMBER_ES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "BANKACCOUNTNUMBER_ES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        BANKACCOUNTNUMBER_FR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "BANKACCOUNTNUMBER_FR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        BANKACCOUNTNUMBER_GB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "BANKACCOUNTNUMBER_GB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        BANKACCOUNTNUMBER_IT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "BANKACCOUNTNUMBER_IT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        BANKACCOUNTNUMBER_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "BANKACCOUNTNUMBER_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        CEPCODE_BR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "CEPCODE_BR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        CNPJ_BR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "CNPJ_BR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        CPFCODE_BR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "CPFCODE_BR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        CREDITCARDEXPIRATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "CREDITCARDEXPIRATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        CREDITCARDNUMBER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "CREDITCARDNUMBER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        CREDITCARDSECURITYCODE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "CREDITCARDSECURITYCODE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_AT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_AT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_AU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_AU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_BE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_BE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_BG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_BG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_CA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_CA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_CY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_CY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_CZ = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_CZ", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_DE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_DE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_DK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_DK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_EE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_EE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_ES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_ES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_FI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_FI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_FR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_FR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_GB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_GB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_GR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_GR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_HR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_HR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_HU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_HU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_IE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_IE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_IT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_IT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_LT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_LT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_LU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_LU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_LV = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_LV", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_MT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_MT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_NL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_NL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_PL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_PL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_PT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_PT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_RO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_RO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_SE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_SE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_SI = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_SI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_SK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_SK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRIVERSLICENSE_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRIVERSLICENSE_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        DRUGENFORCEMENTAGENCYNUMBER_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "DRUGENFORCEMENTAGENCYNUMBER_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        ELECTORALROLLNUMBER_GB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "ELECTORALROLLNUMBER_GB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        EMAILADDRESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "EMAILADDRESS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        HEALTHCAREPROCEDURECODE_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "HEALTHCAREPROCEDURECODE_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        HEALTHINSURANCECARDNUMBER_EU = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "HEALTHINSURANCECARDNUMBER_EU", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        HEALTHINSURANCECLAIMNUMBER_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "HEALTHINSURANCECLAIMNUMBER_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        HEALTHINSURANCENUMBER_FR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "HEALTHINSURANCENUMBER_FR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        INDIVIDUALTAXIDENTIFICATIONNUMBER_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "INDIVIDUALTAXIDENTIFICATIONNUMBER_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        INSEECODE_FR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "INSEECODE_FR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        IPADDRESS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "IPADDRESS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        LATLONG = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "LATLONG", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        MEDICAREBENEFICIARYNUMBER_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "MEDICAREBENEFICIARYNUMBER_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NAME", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NATIONALDRUGCODE_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NATIONALDRUGCODE_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NATIONALIDENTIFICATIONNUMBER_DE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NATIONALIDENTIFICATIONNUMBER_DE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NATIONALIDENTIFICATIONNUMBER_ES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NATIONALIDENTIFICATIONNUMBER_ES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NATIONALIDENTIFICATIONNUMBER_IT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NATIONALIDENTIFICATIONNUMBER_IT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NATIONALINSURANCENUMBER_GB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NATIONALINSURANCENUMBER_GB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NATIONALPROVIDERID_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NATIONALPROVIDERID_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NHSNUMBER_GB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NHSNUMBER_GB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NIENUMBER_ES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NIENUMBER_ES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        NIFNUMBER_ES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "NIFNUMBER_ES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        OPENSSHPRIVATEKEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "OPENSSHPRIVATEKEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PASSPORTNUMBER_CA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PASSPORTNUMBER_CA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PASSPORTNUMBER_DE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PASSPORTNUMBER_DE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PASSPORTNUMBER_ES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PASSPORTNUMBER_ES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PASSPORTNUMBER_FR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PASSPORTNUMBER_FR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PASSPORTNUMBER_GB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PASSPORTNUMBER_GB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PASSPORTNUMBER_IT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PASSPORTNUMBER_IT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PASSPORTNUMBER_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PASSPORTNUMBER_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PERMANENTRESIDENCENUMBER_CA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PERMANENTRESIDENCENUMBER_CA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PERSONALHEALTHNUMBER_CA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PERSONALHEALTHNUMBER_CA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PGPPRIVATEKEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PGPPRIVATEKEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PHONENUMBER_BR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PHONENUMBER_BR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PHONENUMBER_DE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PHONENUMBER_DE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PHONENUMBER_ES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PHONENUMBER_ES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PHONENUMBER_FR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PHONENUMBER_FR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PHONENUMBER_GB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PHONENUMBER_GB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PHONENUMBER_IT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PHONENUMBER_IT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PHONENUMBER_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PHONENUMBER_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PKCSPRIVATEKEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PKCSPRIVATEKEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        POSTALCODE_CA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "POSTALCODE_CA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        PUTTYPRIVATEKEY = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "PUTTYPRIVATEKEY", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        RGNUMBER_BR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "RGNUMBER_BR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        SOCIALINSURANCENUMBER_CA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "SOCIALINSURANCENUMBER_CA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        SSN_ES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "SSN_ES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        SSN_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "SSN_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        TAXID_DE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "TAXID_DE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        TAXID_ES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "TAXID_ES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        TAXID_FR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "TAXID_FR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        TAXID_GB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "TAXID_GB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        VEHICLEIDENTIFICATIONNUMBER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "VEHICLEIDENTIFICATIONNUMBER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
        ZIPCODE_US = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.DataIdentifier.class, "ZIPCODE_US", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.DataIdentifier.class));
    }

    /**
     * Create a managed data identifier not in the list of static members.
     * <p>
     * This is used to maintain forward compatibility, in case a new managed identifier is supported but not updated in CDK yet.
     * <p>
     * @param name <ul><li>name of the identifier.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DataIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier ADDRESS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier AWSSECRETKEY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier BANKACCOUNTNUMBER_DE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier BANKACCOUNTNUMBER_ES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier BANKACCOUNTNUMBER_FR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier BANKACCOUNTNUMBER_GB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier BANKACCOUNTNUMBER_IT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier BANKACCOUNTNUMBER_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier CEPCODE_BR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier CNPJ_BR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier CPFCODE_BR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier CREDITCARDEXPIRATION;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier CREDITCARDNUMBER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier CREDITCARDSECURITYCODE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_AT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_AU;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_BE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_BG;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_CA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_CY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_CZ;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_DE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_DK;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_EE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_ES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_FI;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_FR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_GB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_GR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_HR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_HU;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_IE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_IT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_LT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_LU;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_LV;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_MT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_NL;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_PL;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_PT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_RO;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_SE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_SI;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_SK;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRIVERSLICENSE_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier DRUGENFORCEMENTAGENCYNUMBER_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier ELECTORALROLLNUMBER_GB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier EMAILADDRESS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier HEALTHCAREPROCEDURECODE_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier HEALTHINSURANCECARDNUMBER_EU;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier HEALTHINSURANCECLAIMNUMBER_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier HEALTHINSURANCENUMBER_FR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier INDIVIDUALTAXIDENTIFICATIONNUMBER_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier INSEECODE_FR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier IPADDRESS;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier LATLONG;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier MEDICAREBENEFICIARYNUMBER_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NATIONALDRUGCODE_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NATIONALIDENTIFICATIONNUMBER_DE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NATIONALIDENTIFICATIONNUMBER_ES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NATIONALIDENTIFICATIONNUMBER_IT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NATIONALINSURANCENUMBER_GB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NATIONALPROVIDERID_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NHSNUMBER_GB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NIENUMBER_ES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier NIFNUMBER_ES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier OPENSSHPRIVATEKEY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PASSPORTNUMBER_CA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PASSPORTNUMBER_DE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PASSPORTNUMBER_ES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PASSPORTNUMBER_FR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PASSPORTNUMBER_GB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PASSPORTNUMBER_IT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PASSPORTNUMBER_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PERMANENTRESIDENCENUMBER_CA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PERSONALHEALTHNUMBER_CA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PGPPRIVATEKEY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PHONENUMBER_BR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PHONENUMBER_DE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PHONENUMBER_ES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PHONENUMBER_FR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PHONENUMBER_GB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PHONENUMBER_IT;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PHONENUMBER_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PKCSPRIVATEKEY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier POSTALCODE_CA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier PUTTYPRIVATEKEY;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier RGNUMBER_BR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier SOCIALINSURANCENUMBER_CA;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier SSN_ES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier SSN_US;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier TAXID_DE;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier TAXID_ES;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier TAXID_FR;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier TAXID_GB;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier VEHICLEIDENTIFICATIONNUMBER;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.logs.DataIdentifier ZIPCODE_US;

    /**
     * <ul><li>name of the identifier.</li></ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
