package software.amazon.awscdk.services.logs;

/**
 * Processor for JSON mutation operations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a log group
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * // Create a JSON parser processor
 * ParserProcessor jsonParser = ParserProcessor.Builder.create()
 *         .type(ParserProcessorType.JSON)
 *         .build();
 * // Create a processor to add keys
 * JsonMutatorProcessor addKeysProcessor = JsonMutatorProcessor.Builder.create()
 *         .type(JsonMutatorType.ADD_KEYS)
 *         .addKeysOptions(AddKeysProperty.builder()
 *                 .entries(List.of(AddKeyEntryProperty.builder()
 *                         .key("metadata.transformed_in")
 *                         .value("CloudWatchLogs")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Create a transformer with these processors
 * // Create a transformer with these processors
 * Transformer.Builder.create(this, "Transformer")
 *         .transformerName("MyTransformer")
 *         .logGroup(logGroup)
 *         .transformerConfig(List.of(jsonParser, addKeysProcessor))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:35.456Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.JsonMutatorProcessor")
public class JsonMutatorProcessor extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.logs.IProcessor {

    protected JsonMutatorProcessor(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JsonMutatorProcessor(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new JSON mutator processor.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public JsonMutatorProcessor(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonMutatorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The type of JSON mutation operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonMutatorType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.JsonMutatorType.class));
    }

    /**
     * The type of JSON mutation operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.JsonMutatorType value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.JsonMutatorProcessor}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.JsonMutatorProcessor> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.logs.JsonMutatorProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.logs.JsonMutatorProps.Builder();
        }

        /**
         * The type of JSON mutation operation.
         * <p>
         * @return {@code this}
         * @param type The type of JSON mutation operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final software.amazon.awscdk.services.logs.JsonMutatorType type) {
            this.props.type(type);
            return this;
        }

        /**
         * Options for adding keys.
         * <p>
         * Required when type is ADD_KEYS.
         * <p>
         * Default: - No adding keys processor is created if props not set
         * <p>
         * @return {@code this}
         * @param addKeysOptions Options for adding keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addKeysOptions(final software.amazon.awscdk.services.logs.AddKeysProperty addKeysOptions) {
            this.props.addKeysOptions(addKeysOptions);
            return this;
        }

        /**
         * Options for copying values.
         * <p>
         * Required when type is COPY_VALUE.
         * <p>
         * Default: - No copy value processor is created if props not set
         * <p>
         * @return {@code this}
         * @param copyValueOptions Options for copying values. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyValueOptions(final software.amazon.awscdk.services.logs.CopyValueProperty copyValueOptions) {
            this.props.copyValueOptions(copyValueOptions);
            return this;
        }

        /**
         * Keys to delete.
         * <p>
         * Required when type is DELETE_KEYS.
         * <p>
         * Default: - No delete key processor is created if props not set
         * <p>
         * @return {@code this}
         * @param deleteKeysOptions Keys to delete. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteKeysOptions(final software.amazon.awscdk.services.logs.ProcessorDeleteKeysProperty deleteKeysOptions) {
            this.props.deleteKeysOptions(deleteKeysOptions);
            return this;
        }

        /**
         * Options for converting lists to maps.
         * <p>
         * Required when type is LIST_TO_MAP.
         * <p>
         * Default: - No list-to-map processor is created if props not set
         * <p>
         * @return {@code this}
         * @param listToMapOptions Options for converting lists to maps. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listToMapOptions(final software.amazon.awscdk.services.logs.ListToMapProperty listToMapOptions) {
            this.props.listToMapOptions(listToMapOptions);
            return this;
        }

        /**
         * Options for moving keys.
         * <p>
         * Required when type is MOVE_KEYS.
         * <p>
         * Default: - No move key processor is created if props not set
         * <p>
         * @return {@code this}
         * @param moveKeysOptions Options for moving keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder moveKeysOptions(final software.amazon.awscdk.services.logs.MoveKeysProperty moveKeysOptions) {
            this.props.moveKeysOptions(moveKeysOptions);
            return this;
        }

        /**
         * Options for renaming keys.
         * <p>
         * Required when type is RENAME_KEYS.
         * <p>
         * Default: - No rename key processor is created if props not set
         * <p>
         * @return {@code this}
         * @param renameKeysOptions Options for renaming keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renameKeysOptions(final software.amazon.awscdk.services.logs.RenameKeysProperty renameKeysOptions) {
            this.props.renameKeysOptions(renameKeysOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.JsonMutatorProcessor}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.JsonMutatorProcessor build() {
            return new software.amazon.awscdk.services.logs.JsonMutatorProcessor(
                this.props.build()
            );
        }
    }
}
