package software.amazon.awscdk.services.logs;

/**
 * This object defines one key that will be renamed with the renameKey processor.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * RenameKeyEntryProperty renameKeyEntryProperty = RenameKeyEntryProperty.builder()
 *         .key("key")
 *         .renameTo("renameTo")
 *         // the properties below are optional
 *         .overwriteIfExists(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:35.521Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.RenameKeyEntryProperty")
@software.amazon.jsii.Jsii.Proxy(RenameKeyEntryProperty.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RenameKeyEntryProperty extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key to rename.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKey();

    /**
     * The string to use for the new key name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRenameTo();

    /**
     * Whether to overwrite the target key if it already exists.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getOverwriteIfExists() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RenameKeyEntryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RenameKeyEntryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RenameKeyEntryProperty> {
        java.lang.String key;
        java.lang.String renameTo;
        java.lang.Boolean overwriteIfExists;

        /**
         * Sets the value of {@link RenameKeyEntryProperty#getKey}
         * @param key The key to rename. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder key(java.lang.String key) {
            this.key = key;
            return this;
        }

        /**
         * Sets the value of {@link RenameKeyEntryProperty#getRenameTo}
         * @param renameTo The string to use for the new key name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renameTo(java.lang.String renameTo) {
            this.renameTo = renameTo;
            return this;
        }

        /**
         * Sets the value of {@link RenameKeyEntryProperty#getOverwriteIfExists}
         * @param overwriteIfExists Whether to overwrite the target key if it already exists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overwriteIfExists(java.lang.Boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RenameKeyEntryProperty}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RenameKeyEntryProperty build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RenameKeyEntryProperty}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenameKeyEntryProperty {
        private final java.lang.String key;
        private final java.lang.String renameTo;
        private final java.lang.Boolean overwriteIfExists;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.renameTo = software.amazon.jsii.Kernel.get(this, "renameTo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.overwriteIfExists = software.amazon.jsii.Kernel.get(this, "overwriteIfExists", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            this.renameTo = java.util.Objects.requireNonNull(builder.renameTo, "renameTo is required");
            this.overwriteIfExists = builder.overwriteIfExists;
        }

        @Override
        public final java.lang.String getKey() {
            return this.key;
        }

        @Override
        public final java.lang.String getRenameTo() {
            return this.renameTo;
        }

        @Override
        public final java.lang.Boolean getOverwriteIfExists() {
            return this.overwriteIfExists;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("key", om.valueToTree(this.getKey()));
            data.set("renameTo", om.valueToTree(this.getRenameTo()));
            if (this.getOverwriteIfExists() != null) {
                data.set("overwriteIfExists", om.valueToTree(this.getOverwriteIfExists()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.RenameKeyEntryProperty"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RenameKeyEntryProperty.Jsii$Proxy that = (RenameKeyEntryProperty.Jsii$Proxy) o;

            if (!key.equals(that.key)) return false;
            if (!renameTo.equals(that.renameTo)) return false;
            return this.overwriteIfExists != null ? this.overwriteIfExists.equals(that.overwriteIfExists) : that.overwriteIfExists == null;
        }

        @Override
        public final int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (this.renameTo.hashCode());
            result = 31 * result + (this.overwriteIfExists != null ? this.overwriteIfExists.hashCode() : 0);
            return result;
        }
    }
}
