package software.amazon.awscdk.services.logs;

/**
 * The Resource properties for AWS::Logs::Transformer resource.
 * <p>
 * This
 * interface defines all configuration options for the CfnTransformer construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a log group
 * LogGroup logGroup = new LogGroup(this, "MyLogGroup");
 * // Create a JSON parser processor
 * ParserProcessor jsonParser = ParserProcessor.Builder.create()
 *         .type(ParserProcessorType.JSON)
 *         .build();
 * // Create a processor to add keys
 * JsonMutatorProcessor addKeysProcessor = JsonMutatorProcessor.Builder.create()
 *         .type(JsonMutatorType.ADD_KEYS)
 *         .addKeysOptions(AddKeysProperty.builder()
 *                 .entries(List.of(AddKeyEntryProperty.builder()
 *                         .key("metadata.transformed_in")
 *                         .value("CloudWatchLogs")
 *                         .build()))
 *                 .build())
 *         .build();
 * // Create a transformer with these processors
 * // Create a transformer with these processors
 * Transformer.Builder.create(this, "Transformer")
 *         .transformerName("MyTransformer")
 *         .logGroup(logGroup)
 *         .transformerConfig(List.of(jsonParser, addKeysProcessor))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:35.538Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.TransformerProps")
@software.amazon.jsii.Jsii.Proxy(TransformerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TransformerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Existing log group that you want to associate with this transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.ILogGroup getLogGroup();

    /**
     * List of processors in a transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.logs.IProcessor> getTransformerConfig();

    /**
     * Name of the transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTransformerName();

    /**
     * @return a {@link Builder} of {@link TransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TransformerProps> {
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        java.util.List<software.amazon.awscdk.services.logs.IProcessor> transformerConfig;
        java.lang.String transformerName;

        /**
         * Sets the value of {@link TransformerProps#getLogGroup}
         * @param logGroup Existing log group that you want to associate with this transformer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link TransformerProps#getTransformerConfig}
         * @param transformerConfig List of processors in a transformer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder transformerConfig(java.util.List<? extends software.amazon.awscdk.services.logs.IProcessor> transformerConfig) {
            this.transformerConfig = (java.util.List<software.amazon.awscdk.services.logs.IProcessor>)transformerConfig;
            return this;
        }

        /**
         * Sets the value of {@link TransformerProps#getTransformerName}
         * @param transformerName Name of the transformer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformerName(java.lang.String transformerName) {
            this.transformerName = transformerName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TransformerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TransformerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TransformerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TransformerProps {
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final java.util.List<software.amazon.awscdk.services.logs.IProcessor> transformerConfig;
        private final java.lang.String transformerName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.transformerConfig = software.amazon.jsii.Kernel.get(this, "transformerConfig", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.IProcessor.class)));
            this.transformerName = software.amazon.jsii.Kernel.get(this, "transformerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.logGroup = java.util.Objects.requireNonNull(builder.logGroup, "logGroup is required");
            this.transformerConfig = (java.util.List<software.amazon.awscdk.services.logs.IProcessor>)java.util.Objects.requireNonNull(builder.transformerConfig, "transformerConfig is required");
            this.transformerName = java.util.Objects.requireNonNull(builder.transformerName, "transformerName is required");
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.logs.IProcessor> getTransformerConfig() {
            return this.transformerConfig;
        }

        @Override
        public final java.lang.String getTransformerName() {
            return this.transformerName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("logGroup", om.valueToTree(this.getLogGroup()));
            data.set("transformerConfig", om.valueToTree(this.getTransformerConfig()));
            data.set("transformerName", om.valueToTree(this.getTransformerName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.TransformerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TransformerProps.Jsii$Proxy that = (TransformerProps.Jsii$Proxy) o;

            if (!logGroup.equals(that.logGroup)) return false;
            if (!transformerConfig.equals(that.transformerConfig)) return false;
            return this.transformerName.equals(that.transformerName);
        }

        @Override
        public final int hashCode() {
            int result = this.logGroup.hashCode();
            result = 31 * result + (this.transformerConfig.hashCode());
            result = 31 * result + (this.transformerName.hashCode());
            return result;
        }
    }
}
