package software.amazon.awscdk.services.mpa;

/**
 * Creates a new identity source.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/mpa/latest/userguide/mpa-concepts.html">Identity Source</a> in the <em>Multi-party approval User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mpa.*;
 * CfnIdentitySource cfnIdentitySource = CfnIdentitySource.Builder.create(this, "MyCfnIdentitySource")
 *         .identitySourceParameters(IdentitySourceParametersProperty.builder()
 *                 .iamIdentityCenter(IamIdentityCenterProperty.builder()
 *                         .instanceArn("instanceArn")
 *                         .region("region")
 *                         // the properties below are optional
 *                         .approvalPortalUrl("approvalPortalUrl")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-identitysource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-identitysource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:36.259Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mpa.CfnIdentitySource")
public class CfnIdentitySource extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnIdentitySource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentitySource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mpa.CfnIdentitySource.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIdentitySource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mpa.CfnIdentitySourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Timestamp when the identity source was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Amazon Resource Name (ARN) for the identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentitySourceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentitySourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * URL for the approval portal associated with the IAM Identity Center instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentitySourceParametersIamIdentityCenterApprovalPortalUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentitySourceParametersIamIdentityCenterApprovalPortalUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of resource that provided identities to the identity source.
     * <p>
     * For example, an IAM Identity Center instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentitySourceType() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentitySourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Status for the identity source.
     * <p>
     * For example, if the identity source is <code>ACTIVE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Status code of the identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusCode() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Message describing the status for the identity source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A <code>IdentitySourceParameters</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getIdentitySourceParameters() {
        return software.amazon.jsii.Kernel.get(this, "identitySourceParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A <code>IdentitySourceParameters</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentitySourceParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "identitySourceParameters", java.util.Objects.requireNonNull(value, "identitySourceParameters is required"));
    }

    /**
     * A <code>IdentitySourceParameters</code> object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentitySourceParameters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mpa.CfnIdentitySource.IdentitySourceParametersProperty value) {
        software.amazon.jsii.Kernel.set(this, "identitySourceParameters", java.util.Objects.requireNonNull(value, "identitySourceParameters is required"));
    }

    /**
     * Tags that you have added to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags that you have added to the specified resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * AWS IAM Identity Center credentials.
     * <p>
     * For more information see, <a href="https://docs.aws.amazon.com/identity-center/">AWS IAM Identity Center</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mpa.*;
     * IamIdentityCenterProperty iamIdentityCenterProperty = IamIdentityCenterProperty.builder()
     *         .instanceArn("instanceArn")
     *         .region("region")
     *         // the properties below are optional
     *         .approvalPortalUrl("approvalPortalUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-iamidentitycenter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-iamidentitycenter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mpa.CfnIdentitySource.IamIdentityCenterProperty")
    @software.amazon.jsii.Jsii.Proxy(IamIdentityCenterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IamIdentityCenterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Amazon Resource Name (ARN) for the IAM Identity Center instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-iamidentitycenter.html#cfn-mpa-identitysource-iamidentitycenter-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-iamidentitycenter.html#cfn-mpa-identitysource-iamidentitycenter-instancearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

        /**
         * AWS Region where the IAM Identity Center instance is located.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-iamidentitycenter.html#cfn-mpa-identitysource-iamidentitycenter-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-iamidentitycenter.html#cfn-mpa-identitysource-iamidentitycenter-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * URL for the approval portal associated with the IAM Identity Center instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-iamidentitycenter.html#cfn-mpa-identitysource-iamidentitycenter-approvalportalurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-iamidentitycenter.html#cfn-mpa-identitysource-iamidentitycenter-approvalportalurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApprovalPortalUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IamIdentityCenterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IamIdentityCenterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IamIdentityCenterProperty> {
            java.lang.String instanceArn;
            java.lang.String region;
            java.lang.String approvalPortalUrl;

            /**
             * Sets the value of {@link IamIdentityCenterProperty#getInstanceArn}
             * @param instanceArn Amazon Resource Name (ARN) for the IAM Identity Center instance. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceArn(java.lang.String instanceArn) {
                this.instanceArn = instanceArn;
                return this;
            }

            /**
             * Sets the value of {@link IamIdentityCenterProperty#getRegion}
             * @param region AWS Region where the IAM Identity Center instance is located. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link IamIdentityCenterProperty#getApprovalPortalUrl}
             * @param approvalPortalUrl URL for the approval portal associated with the IAM Identity Center instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder approvalPortalUrl(java.lang.String approvalPortalUrl) {
                this.approvalPortalUrl = approvalPortalUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamIdentityCenterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IamIdentityCenterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IamIdentityCenterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamIdentityCenterProperty {
            private final java.lang.String instanceArn;
            private final java.lang.String region;
            private final java.lang.String approvalPortalUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.approvalPortalUrl = software.amazon.jsii.Kernel.get(this, "approvalPortalUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
                this.approvalPortalUrl = builder.approvalPortalUrl;
            }

            @Override
            public final java.lang.String getInstanceArn() {
                return this.instanceArn;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getApprovalPortalUrl() {
                return this.approvalPortalUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
                data.set("region", om.valueToTree(this.getRegion()));
                if (this.getApprovalPortalUrl() != null) {
                    data.set("approvalPortalUrl", om.valueToTree(this.getApprovalPortalUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mpa.CfnIdentitySource.IamIdentityCenterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IamIdentityCenterProperty.Jsii$Proxy that = (IamIdentityCenterProperty.Jsii$Proxy) o;

                if (!instanceArn.equals(that.instanceArn)) return false;
                if (!region.equals(that.region)) return false;
                return this.approvalPortalUrl != null ? this.approvalPortalUrl.equals(that.approvalPortalUrl) : that.approvalPortalUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceArn.hashCode();
                result = 31 * result + (this.region.hashCode());
                result = 31 * result + (this.approvalPortalUrl != null ? this.approvalPortalUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details for the resource that provides identities to the identity source.
     * <p>
     * For example, an IAM Identity Center instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mpa.*;
     * IdentitySourceParametersProperty identitySourceParametersProperty = IdentitySourceParametersProperty.builder()
     *         .iamIdentityCenter(IamIdentityCenterProperty.builder()
     *                 .instanceArn("instanceArn")
     *                 .region("region")
     *                 // the properties below are optional
     *                 .approvalPortalUrl("approvalPortalUrl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-identitysourceparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-identitysourceparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mpa.CfnIdentitySource.IdentitySourceParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentitySourceParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentitySourceParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * AWS IAM Identity Center credentials.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-identitysourceparameters.html#cfn-mpa-identitysource-identitysourceparameters-iamidentitycenter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mpa-identitysource-identitysourceparameters.html#cfn-mpa-identitysource-identitysourceparameters-iamidentitycenter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIamIdentityCenter();

        /**
         * @return a {@link Builder} of {@link IdentitySourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentitySourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentitySourceParametersProperty> {
            java.lang.Object iamIdentityCenter;

            /**
             * Sets the value of {@link IdentitySourceParametersProperty#getIamIdentityCenter}
             * @param iamIdentityCenter AWS IAM Identity Center credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamIdentityCenter(software.amazon.awscdk.IResolvable iamIdentityCenter) {
                this.iamIdentityCenter = iamIdentityCenter;
                return this;
            }

            /**
             * Sets the value of {@link IdentitySourceParametersProperty#getIamIdentityCenter}
             * @param iamIdentityCenter AWS IAM Identity Center credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamIdentityCenter(software.amazon.awscdk.services.mpa.CfnIdentitySource.IamIdentityCenterProperty iamIdentityCenter) {
                this.iamIdentityCenter = iamIdentityCenter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentitySourceParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentitySourceParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentitySourceParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentitySourceParametersProperty {
            private final java.lang.Object iamIdentityCenter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iamIdentityCenter = software.amazon.jsii.Kernel.get(this, "iamIdentityCenter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iamIdentityCenter = java.util.Objects.requireNonNull(builder.iamIdentityCenter, "iamIdentityCenter is required");
            }

            @Override
            public final java.lang.Object getIamIdentityCenter() {
                return this.iamIdentityCenter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("iamIdentityCenter", om.valueToTree(this.getIamIdentityCenter()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mpa.CfnIdentitySource.IdentitySourceParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentitySourceParametersProperty.Jsii$Proxy that = (IdentitySourceParametersProperty.Jsii$Proxy) o;

                return this.iamIdentityCenter.equals(that.iamIdentityCenter);
            }

            @Override
            public final int hashCode() {
                int result = this.iamIdentityCenter.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mpa.CfnIdentitySource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mpa.CfnIdentitySource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mpa.CfnIdentitySourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mpa.CfnIdentitySourceProps.Builder();
        }

        /**
         * A <code>IdentitySourceParameters</code> object.
         * <p>
         * Contains details for the resource that provides identities to the identity source. For example, an IAM Identity Center instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-identitysource.html#cfn-mpa-identitysource-identitysourceparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-identitysource.html#cfn-mpa-identitysource-identitysourceparameters</a>
         * @param identitySourceParameters A <code>IdentitySourceParameters</code> object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySourceParameters(final software.amazon.awscdk.IResolvable identitySourceParameters) {
            this.props.identitySourceParameters(identitySourceParameters);
            return this;
        }
        /**
         * A <code>IdentitySourceParameters</code> object.
         * <p>
         * Contains details for the resource that provides identities to the identity source. For example, an IAM Identity Center instance.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-identitysource.html#cfn-mpa-identitysource-identitysourceparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-identitysource.html#cfn-mpa-identitysource-identitysourceparameters</a>
         * @param identitySourceParameters A <code>IdentitySourceParameters</code> object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySourceParameters(final software.amazon.awscdk.services.mpa.CfnIdentitySource.IdentitySourceParametersProperty identitySourceParameters) {
            this.props.identitySourceParameters(identitySourceParameters);
            return this;
        }

        /**
         * Tags that you have added to the specified resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-identitysource.html#cfn-mpa-identitysource-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mpa-identitysource.html#cfn-mpa-identitysource-tags</a>
         * @param tags Tags that you have added to the specified resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mpa.CfnIdentitySource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mpa.CfnIdentitySource build() {
            return new software.amazon.awscdk.services.mpa.CfnIdentitySource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
