package software.amazon.awscdk.services.odb;

/**
 * Properties for defining a <code>CfnCloudVmCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.odb.*;
 * CfnCloudVmClusterProps cfnCloudVmClusterProps = CfnCloudVmClusterProps.builder()
 *         .cloudExadataInfrastructureId("cloudExadataInfrastructureId")
 *         .clusterName("clusterName")
 *         .cpuCoreCount(123)
 *         .dataCollectionOptions(DataCollectionOptionsProperty.builder()
 *                 .isDiagnosticsEventsEnabled(false)
 *                 .isHealthMonitoringEnabled(false)
 *                 .isIncidentLogsEnabled(false)
 *                 .build())
 *         .dataStorageSizeInTBs(123)
 *         .dbNodeStorageSizeInGBs(123)
 *         .dbServers(List.of("dbServers"))
 *         .displayName("displayName")
 *         .giVersion("giVersion")
 *         .hostname("hostname")
 *         .isLocalBackupEnabled(false)
 *         .isSparseDiskgroupEnabled(false)
 *         .licenseModel("licenseModel")
 *         .memorySizeInGBs(123)
 *         .odbNetworkId("odbNetworkId")
 *         .scanListenerPortTcp(123)
 *         .sshPublicKeys(List.of("sshPublicKeys"))
 *         .systemVersion("systemVersion")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeZone("timeZone")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:36.558Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_odb.CfnCloudVmClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnCloudVmClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCloudVmClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier of the Exadata infrastructure that this VM cluster belongs to.
     * <p>
     * Required when creating a VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-cloudexadatainfrastructureid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-cloudexadatainfrastructureid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudExadataInfrastructureId() {
        return null;
    }

    /**
     * The name of the Grid Infrastructure (GI) cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-clustername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return null;
    }

    /**
     * The number of CPU cores enabled on the VM cluster.
     * <p>
     * Required when creating a VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-cpucorecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-cpucorecount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpuCoreCount() {
        return null;
    }

    /**
     * The set of diagnostic collection options enabled for the VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datacollectionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datacollectionoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataCollectionOptions() {
        return null;
    }

    /**
     * The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datastoragesizeintbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-datastoragesizeintbs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDataStorageSizeInTBs() {
        return null;
    }

    /**
     * The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbnodestoragesizeingbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbnodestoragesizeingbs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDbNodeStorageSizeInGBs() {
        return null;
    }

    /**
     * The list of database servers for the VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-dbservers</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDbServers() {
        return null;
    }

    /**
     * The user-friendly name for the VM cluster.
     * <p>
     * Required when creating a VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
     * <p>
     * Required when creating a VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-giversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-giversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGiVersion() {
        return null;
    }

    /**
     * The host name for the VM cluster.
     * <p>
     * Required when creating a VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-hostname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostname() {
        return null;
    }

    /**
     * Specifies whether database backups to local Exadata storage are enabled for the VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-islocalbackupenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-islocalbackupenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsLocalBackupEnabled() {
        return null;
    }

    /**
     * Specifies whether the VM cluster is configured with a sparse disk group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-issparsediskgroupenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-issparsediskgroupenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsSparseDiskgroupEnabled() {
        return null;
    }

    /**
     * The Oracle license model applied to the VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-licensemodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-licensemodel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLicenseModel() {
        return null;
    }

    /**
     * The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-memorysizeingbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-memorysizeingbs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemorySizeInGBs() {
        return null;
    }

    /**
     * The unique identifier of the ODB network for the VM cluster.
     * <p>
     * Required when creating a VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-odbnetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-odbnetworkid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOdbNetworkId() {
        return null;
    }

    /**
     * The port number for TCP connections to the single client access name (SCAN) listener.
     * <p>
     * Valid values: <code>1024–8999</code> with the following exceptions: <code>2484</code> , <code>6100</code> , <code>6200</code> , <code>7060</code> , <code>7070</code> , <code>7085</code> , and <code>7879</code>
     * <p>
     * Default: <code>1521</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-scanlistenerporttcp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-scanlistenerporttcp</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getScanListenerPortTcp() {
        return null;
    }

    /**
     * The public key portion of one or more key pairs used for SSH access to the VM cluster.
     * <p>
     * Required when creating a VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-sshpublickeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-sshpublickeys</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSshPublicKeys() {
        return null;
    }

    /**
     * The operating system version of the image chosen for the VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-systemversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-systemversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSystemVersion() {
        return null;
    }

    /**
     * Tags to assign to the Vm Cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The time zone of the VM cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-odb-cloudvmcluster.html#cfn-odb-cloudvmcluster-timezone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCloudVmClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCloudVmClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCloudVmClusterProps> {
        java.lang.String cloudExadataInfrastructureId;
        java.lang.String clusterName;
        java.lang.Number cpuCoreCount;
        java.lang.Object dataCollectionOptions;
        java.lang.Number dataStorageSizeInTBs;
        java.lang.Number dbNodeStorageSizeInGBs;
        java.util.List<java.lang.String> dbServers;
        java.lang.String displayName;
        java.lang.String giVersion;
        java.lang.String hostname;
        java.lang.Object isLocalBackupEnabled;
        java.lang.Object isSparseDiskgroupEnabled;
        java.lang.String licenseModel;
        java.lang.Number memorySizeInGBs;
        java.lang.String odbNetworkId;
        java.lang.Number scanListenerPortTcp;
        java.util.List<java.lang.String> sshPublicKeys;
        java.lang.String systemVersion;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String timeZone;

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getCloudExadataInfrastructureId}
         * @param cloudExadataInfrastructureId The unique identifier of the Exadata infrastructure that this VM cluster belongs to.
         *                                     Required when creating a VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudExadataInfrastructureId(java.lang.String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getClusterName}
         * @param clusterName The name of the Grid Infrastructure (GI) cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getCpuCoreCount}
         * @param cpuCoreCount The number of CPU cores enabled on the VM cluster.
         *                     Required when creating a VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuCoreCount(java.lang.Number cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getDataCollectionOptions}
         * @param dataCollectionOptions The set of diagnostic collection options enabled for the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCollectionOptions(software.amazon.awscdk.IResolvable dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getDataCollectionOptions}
         * @param dataCollectionOptions The set of diagnostic collection options enabled for the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCollectionOptions(software.amazon.awscdk.services.odb.CfnCloudVmCluster.DataCollectionOptionsProperty dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getDataStorageSizeInTBs}
         * @param dataStorageSizeInTBs The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataStorageSizeInTBs(java.lang.Number dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getDbNodeStorageSizeInGBs}
         * @param dbNodeStorageSizeInGBs The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbNodeStorageSizeInGBs(java.lang.Number dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getDbServers}
         * @param dbServers The list of database servers for the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbServers(java.util.List<java.lang.String> dbServers) {
            this.dbServers = dbServers;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getDisplayName}
         * @param displayName The user-friendly name for the VM cluster.
         *                    Required when creating a VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getGiVersion}
         * @param giVersion The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
         *                  Required when creating a VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder giVersion(java.lang.String giVersion) {
            this.giVersion = giVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getHostname}
         * @param hostname The host name for the VM cluster.
         *                 Required when creating a VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getIsLocalBackupEnabled}
         * @param isLocalBackupEnabled Specifies whether database backups to local Exadata storage are enabled for the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLocalBackupEnabled(java.lang.Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getIsLocalBackupEnabled}
         * @param isLocalBackupEnabled Specifies whether database backups to local Exadata storage are enabled for the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLocalBackupEnabled(software.amazon.awscdk.IResolvable isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getIsSparseDiskgroupEnabled}
         * @param isSparseDiskgroupEnabled Specifies whether the VM cluster is configured with a sparse disk group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isSparseDiskgroupEnabled(java.lang.Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getIsSparseDiskgroupEnabled}
         * @param isSparseDiskgroupEnabled Specifies whether the VM cluster is configured with a sparse disk group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isSparseDiskgroupEnabled(software.amazon.awscdk.IResolvable isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getLicenseModel}
         * @param licenseModel The Oracle license model applied to the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder licenseModel(java.lang.String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getMemorySizeInGBs}
         * @param memorySizeInGBs The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySizeInGBs(java.lang.Number memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getOdbNetworkId}
         * @param odbNetworkId The unique identifier of the ODB network for the VM cluster.
         *                     Required when creating a VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder odbNetworkId(java.lang.String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getScanListenerPortTcp}
         * @param scanListenerPortTcp The port number for TCP connections to the single client access name (SCAN) listener.
         *                            Valid values: <code>1024–8999</code> with the following exceptions: <code>2484</code> , <code>6100</code> , <code>6200</code> , <code>7060</code> , <code>7070</code> , <code>7085</code> , and <code>7879</code>
         *                            <p>
         *                            Default: <code>1521</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanListenerPortTcp(java.lang.Number scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getSshPublicKeys}
         * @param sshPublicKeys The public key portion of one or more key pairs used for SSH access to the VM cluster.
         *                      Required when creating a VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sshPublicKeys(java.util.List<java.lang.String> sshPublicKeys) {
            this.sshPublicKeys = sshPublicKeys;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getSystemVersion}
         * @param systemVersion The operating system version of the image chosen for the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder systemVersion(java.lang.String systemVersion) {
            this.systemVersion = systemVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getTags}
         * @param tags Tags to assign to the Vm Cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnCloudVmClusterProps#getTimeZone}
         * @param timeZone The time zone of the VM cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(java.lang.String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCloudVmClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCloudVmClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCloudVmClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCloudVmClusterProps {
        private final java.lang.String cloudExadataInfrastructureId;
        private final java.lang.String clusterName;
        private final java.lang.Number cpuCoreCount;
        private final java.lang.Object dataCollectionOptions;
        private final java.lang.Number dataStorageSizeInTBs;
        private final java.lang.Number dbNodeStorageSizeInGBs;
        private final java.util.List<java.lang.String> dbServers;
        private final java.lang.String displayName;
        private final java.lang.String giVersion;
        private final java.lang.String hostname;
        private final java.lang.Object isLocalBackupEnabled;
        private final java.lang.Object isSparseDiskgroupEnabled;
        private final java.lang.String licenseModel;
        private final java.lang.Number memorySizeInGBs;
        private final java.lang.String odbNetworkId;
        private final java.lang.Number scanListenerPortTcp;
        private final java.util.List<java.lang.String> sshPublicKeys;
        private final java.lang.String systemVersion;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String timeZone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudExadataInfrastructureId = software.amazon.jsii.Kernel.get(this, "cloudExadataInfrastructureId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cpuCoreCount = software.amazon.jsii.Kernel.get(this, "cpuCoreCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dataCollectionOptions = software.amazon.jsii.Kernel.get(this, "dataCollectionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataStorageSizeInTBs = software.amazon.jsii.Kernel.get(this, "dataStorageSizeInTBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dbNodeStorageSizeInGBs = software.amazon.jsii.Kernel.get(this, "dbNodeStorageSizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.dbServers = software.amazon.jsii.Kernel.get(this, "dbServers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.giVersion = software.amazon.jsii.Kernel.get(this, "giVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.isLocalBackupEnabled = software.amazon.jsii.Kernel.get(this, "isLocalBackupEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.isSparseDiskgroupEnabled = software.amazon.jsii.Kernel.get(this, "isSparseDiskgroupEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.licenseModel = software.amazon.jsii.Kernel.get(this, "licenseModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memorySizeInGBs = software.amazon.jsii.Kernel.get(this, "memorySizeInGBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.odbNetworkId = software.amazon.jsii.Kernel.get(this, "odbNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scanListenerPortTcp = software.amazon.jsii.Kernel.get(this, "scanListenerPortTcp", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.sshPublicKeys = software.amazon.jsii.Kernel.get(this, "sshPublicKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.systemVersion = software.amazon.jsii.Kernel.get(this, "systemVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
            this.clusterName = builder.clusterName;
            this.cpuCoreCount = builder.cpuCoreCount;
            this.dataCollectionOptions = builder.dataCollectionOptions;
            this.dataStorageSizeInTBs = builder.dataStorageSizeInTBs;
            this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
            this.dbServers = builder.dbServers;
            this.displayName = builder.displayName;
            this.giVersion = builder.giVersion;
            this.hostname = builder.hostname;
            this.isLocalBackupEnabled = builder.isLocalBackupEnabled;
            this.isSparseDiskgroupEnabled = builder.isSparseDiskgroupEnabled;
            this.licenseModel = builder.licenseModel;
            this.memorySizeInGBs = builder.memorySizeInGBs;
            this.odbNetworkId = builder.odbNetworkId;
            this.scanListenerPortTcp = builder.scanListenerPortTcp;
            this.sshPublicKeys = builder.sshPublicKeys;
            this.systemVersion = builder.systemVersion;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.timeZone = builder.timeZone;
        }

        @Override
        public final java.lang.String getCloudExadataInfrastructureId() {
            return this.cloudExadataInfrastructureId;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.Number getCpuCoreCount() {
            return this.cpuCoreCount;
        }

        @Override
        public final java.lang.Object getDataCollectionOptions() {
            return this.dataCollectionOptions;
        }

        @Override
        public final java.lang.Number getDataStorageSizeInTBs() {
            return this.dataStorageSizeInTBs;
        }

        @Override
        public final java.lang.Number getDbNodeStorageSizeInGBs() {
            return this.dbNodeStorageSizeInGBs;
        }

        @Override
        public final java.util.List<java.lang.String> getDbServers() {
            return this.dbServers;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.lang.String getGiVersion() {
            return this.giVersion;
        }

        @Override
        public final java.lang.String getHostname() {
            return this.hostname;
        }

        @Override
        public final java.lang.Object getIsLocalBackupEnabled() {
            return this.isLocalBackupEnabled;
        }

        @Override
        public final java.lang.Object getIsSparseDiskgroupEnabled() {
            return this.isSparseDiskgroupEnabled;
        }

        @Override
        public final java.lang.String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final java.lang.Number getMemorySizeInGBs() {
            return this.memorySizeInGBs;
        }

        @Override
        public final java.lang.String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        @Override
        public final java.lang.Number getScanListenerPortTcp() {
            return this.scanListenerPortTcp;
        }

        @Override
        public final java.util.List<java.lang.String> getSshPublicKeys() {
            return this.sshPublicKeys;
        }

        @Override
        public final java.lang.String getSystemVersion() {
            return this.systemVersion;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTimeZone() {
            return this.timeZone;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCloudExadataInfrastructureId() != null) {
                data.set("cloudExadataInfrastructureId", om.valueToTree(this.getCloudExadataInfrastructureId()));
            }
            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getCpuCoreCount() != null) {
                data.set("cpuCoreCount", om.valueToTree(this.getCpuCoreCount()));
            }
            if (this.getDataCollectionOptions() != null) {
                data.set("dataCollectionOptions", om.valueToTree(this.getDataCollectionOptions()));
            }
            if (this.getDataStorageSizeInTBs() != null) {
                data.set("dataStorageSizeInTBs", om.valueToTree(this.getDataStorageSizeInTBs()));
            }
            if (this.getDbNodeStorageSizeInGBs() != null) {
                data.set("dbNodeStorageSizeInGBs", om.valueToTree(this.getDbNodeStorageSizeInGBs()));
            }
            if (this.getDbServers() != null) {
                data.set("dbServers", om.valueToTree(this.getDbServers()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getGiVersion() != null) {
                data.set("giVersion", om.valueToTree(this.getGiVersion()));
            }
            if (this.getHostname() != null) {
                data.set("hostname", om.valueToTree(this.getHostname()));
            }
            if (this.getIsLocalBackupEnabled() != null) {
                data.set("isLocalBackupEnabled", om.valueToTree(this.getIsLocalBackupEnabled()));
            }
            if (this.getIsSparseDiskgroupEnabled() != null) {
                data.set("isSparseDiskgroupEnabled", om.valueToTree(this.getIsSparseDiskgroupEnabled()));
            }
            if (this.getLicenseModel() != null) {
                data.set("licenseModel", om.valueToTree(this.getLicenseModel()));
            }
            if (this.getMemorySizeInGBs() != null) {
                data.set("memorySizeInGBs", om.valueToTree(this.getMemorySizeInGBs()));
            }
            if (this.getOdbNetworkId() != null) {
                data.set("odbNetworkId", om.valueToTree(this.getOdbNetworkId()));
            }
            if (this.getScanListenerPortTcp() != null) {
                data.set("scanListenerPortTcp", om.valueToTree(this.getScanListenerPortTcp()));
            }
            if (this.getSshPublicKeys() != null) {
                data.set("sshPublicKeys", om.valueToTree(this.getSshPublicKeys()));
            }
            if (this.getSystemVersion() != null) {
                data.set("systemVersion", om.valueToTree(this.getSystemVersion()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeZone() != null) {
                data.set("timeZone", om.valueToTree(this.getTimeZone()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_odb.CfnCloudVmClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCloudVmClusterProps.Jsii$Proxy that = (CfnCloudVmClusterProps.Jsii$Proxy) o;

            if (this.cloudExadataInfrastructureId != null ? !this.cloudExadataInfrastructureId.equals(that.cloudExadataInfrastructureId) : that.cloudExadataInfrastructureId != null) return false;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.cpuCoreCount != null ? !this.cpuCoreCount.equals(that.cpuCoreCount) : that.cpuCoreCount != null) return false;
            if (this.dataCollectionOptions != null ? !this.dataCollectionOptions.equals(that.dataCollectionOptions) : that.dataCollectionOptions != null) return false;
            if (this.dataStorageSizeInTBs != null ? !this.dataStorageSizeInTBs.equals(that.dataStorageSizeInTBs) : that.dataStorageSizeInTBs != null) return false;
            if (this.dbNodeStorageSizeInGBs != null ? !this.dbNodeStorageSizeInGBs.equals(that.dbNodeStorageSizeInGBs) : that.dbNodeStorageSizeInGBs != null) return false;
            if (this.dbServers != null ? !this.dbServers.equals(that.dbServers) : that.dbServers != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.giVersion != null ? !this.giVersion.equals(that.giVersion) : that.giVersion != null) return false;
            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
            if (this.isLocalBackupEnabled != null ? !this.isLocalBackupEnabled.equals(that.isLocalBackupEnabled) : that.isLocalBackupEnabled != null) return false;
            if (this.isSparseDiskgroupEnabled != null ? !this.isSparseDiskgroupEnabled.equals(that.isSparseDiskgroupEnabled) : that.isSparseDiskgroupEnabled != null) return false;
            if (this.licenseModel != null ? !this.licenseModel.equals(that.licenseModel) : that.licenseModel != null) return false;
            if (this.memorySizeInGBs != null ? !this.memorySizeInGBs.equals(that.memorySizeInGBs) : that.memorySizeInGBs != null) return false;
            if (this.odbNetworkId != null ? !this.odbNetworkId.equals(that.odbNetworkId) : that.odbNetworkId != null) return false;
            if (this.scanListenerPortTcp != null ? !this.scanListenerPortTcp.equals(that.scanListenerPortTcp) : that.scanListenerPortTcp != null) return false;
            if (this.sshPublicKeys != null ? !this.sshPublicKeys.equals(that.sshPublicKeys) : that.sshPublicKeys != null) return false;
            if (this.systemVersion != null ? !this.systemVersion.equals(that.systemVersion) : that.systemVersion != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.timeZone != null ? this.timeZone.equals(that.timeZone) : that.timeZone == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudExadataInfrastructureId != null ? this.cloudExadataInfrastructureId.hashCode() : 0;
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            result = 31 * result + (this.cpuCoreCount != null ? this.cpuCoreCount.hashCode() : 0);
            result = 31 * result + (this.dataCollectionOptions != null ? this.dataCollectionOptions.hashCode() : 0);
            result = 31 * result + (this.dataStorageSizeInTBs != null ? this.dataStorageSizeInTBs.hashCode() : 0);
            result = 31 * result + (this.dbNodeStorageSizeInGBs != null ? this.dbNodeStorageSizeInGBs.hashCode() : 0);
            result = 31 * result + (this.dbServers != null ? this.dbServers.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.giVersion != null ? this.giVersion.hashCode() : 0);
            result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
            result = 31 * result + (this.isLocalBackupEnabled != null ? this.isLocalBackupEnabled.hashCode() : 0);
            result = 31 * result + (this.isSparseDiskgroupEnabled != null ? this.isSparseDiskgroupEnabled.hashCode() : 0);
            result = 31 * result + (this.licenseModel != null ? this.licenseModel.hashCode() : 0);
            result = 31 * result + (this.memorySizeInGBs != null ? this.memorySizeInGBs.hashCode() : 0);
            result = 31 * result + (this.odbNetworkId != null ? this.odbNetworkId.hashCode() : 0);
            result = 31 * result + (this.scanListenerPortTcp != null ? this.scanListenerPortTcp.hashCode() : 0);
            result = 31 * result + (this.sshPublicKeys != null ? this.sshPublicKeys.hashCode() : 0);
            result = 31 * result + (this.systemVersion != null ? this.systemVersion.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
            return result;
        }
    }
}
