package software.amazon.awscdk.services.osis;

/**
 * The AWS::OSIS::Pipeline resource creates an Amazon OpenSearch Ingestion pipeline.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.osis.*;
 * CfnPipeline cfnPipeline = CfnPipeline.Builder.create(this, "MyCfnPipeline")
 *         .maxUnits(123)
 *         .minUnits(123)
 *         .pipelineConfigurationBody("pipelineConfigurationBody")
 *         .pipelineName("pipelineName")
 *         // the properties below are optional
 *         .bufferOptions(BufferOptionsProperty.builder()
 *                 .persistentBufferEnabled(false)
 *                 .build())
 *         .encryptionAtRestOptions(EncryptionAtRestOptionsProperty.builder()
 *                 .kmsKeyArn("kmsKeyArn")
 *                 .build())
 *         .logPublishingOptions(LogPublishingOptionsProperty.builder()
 *                 .cloudWatchLogDestination(CloudWatchLogDestinationProperty.builder()
 *                         .logGroup("logGroup")
 *                         .build())
 *                 .isLoggingEnabled(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcOptions(VpcOptionsProperty.builder()
 *                 .subnetIds(List.of("subnetIds"))
 *                 // the properties below are optional
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .vpcAttachmentOptions(VpcAttachmentOptionsProperty.builder()
 *                         .attachToVpc(false)
 *                         .cidrBlock("cidrBlock")
 *                         .build())
 *                 .vpcEndpointManagement("vpcEndpointManagement")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:36.750Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_osis.CfnPipeline")
public class CfnPipeline extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnPipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.osis.CfnPipeline.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.osis.CfnPipelineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A list of the ingestion endpoints for the pipeline that you can send data to.
     * <p>
     * Currently, only a single ingestion endpoint is supported for a pipeline. For example, <code>my-pipeline-123456789012.us-east-1.osis.amazonaws.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrIngestEndpointUrls() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrIngestEndpointUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPipelineArn() {
        return software.amazon.jsii.Kernel.get(this, "attrPipelineArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The VPC interface endpoints that have access to the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrVpcEndpoints() {
        return software.amazon.jsii.Kernel.get(this, "attrVpcEndpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The VPC endpoint service name for the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVpcEndpointService() {
        return software.amazon.jsii.Kernel.get(this, "attrVpcEndpointService", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxUnits() {
        return software.amazon.jsii.Kernel.get(this, "maxUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxUnits(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxUnits", java.util.Objects.requireNonNull(value, "maxUnits is required"));
    }

    /**
     * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMinUnits() {
        return software.amazon.jsii.Kernel.get(this, "minUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinUnits(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minUnits", java.util.Objects.requireNonNull(value, "minUnits is required"));
    }

    /**
     * The Data Prepper pipeline configuration in YAML format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPipelineConfigurationBody() {
        return software.amazon.jsii.Kernel.get(this, "pipelineConfigurationBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Data Prepper pipeline configuration in YAML format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPipelineConfigurationBody(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pipelineConfigurationBody", java.util.Objects.requireNonNull(value, "pipelineConfigurationBody is required"));
    }

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPipelineName() {
        return software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPipelineName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pipelineName", java.util.Objects.requireNonNull(value, "pipelineName is required"));
    }

    /**
     * Options that specify the configuration of a persistent buffer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBufferOptions() {
        return software.amazon.jsii.Kernel.get(this, "bufferOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Options that specify the configuration of a persistent buffer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBufferOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bufferOptions", value);
    }

    /**
     * Options that specify the configuration of a persistent buffer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBufferOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.osis.CfnPipeline.BufferOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "bufferOptions", value);
    }

    /**
     * Options to control how OpenSearch encrypts buffer data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionAtRestOptions() {
        return software.amazon.jsii.Kernel.get(this, "encryptionAtRestOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Options to control how OpenSearch encrypts buffer data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionAtRestOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionAtRestOptions", value);
    }

    /**
     * Options to control how OpenSearch encrypts buffer data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionAtRestOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.osis.CfnPipeline.EncryptionAtRestOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionAtRestOptions", value);
    }

    /**
     * Key-value pairs that represent log publishing settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogPublishingOptions() {
        return software.amazon.jsii.Kernel.get(this, "logPublishingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Key-value pairs that represent log publishing settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPublishingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logPublishingOptions", value);
    }

    /**
     * Key-value pairs that represent log publishing settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPublishingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.osis.CfnPipeline.LogPublishingOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "logPublishingOptions", value);
    }

    /**
     * List of tags to add to the pipeline upon creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * List of tags to add to the pipeline upon creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcOptions() {
        return software.amazon.jsii.Kernel.get(this, "vpcOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcOptions", value);
    }

    /**
     * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.osis.CfnPipeline.VpcOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcOptions", value);
    }
    /**
     * Options that specify the configuration of a persistent buffer.
     * <p>
     * To configure how OpenSearch Ingestion encrypts this data, set the <code>EncryptionAtRestOptions</code> . For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering">Persistent buffering</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.osis.*;
     * BufferOptionsProperty bufferOptionsProperty = BufferOptionsProperty.builder()
     *         .persistentBufferEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-bufferoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-bufferoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_osis.CfnPipeline.BufferOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BufferOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BufferOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether persistent buffering should be enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-bufferoptions.html#cfn-osis-pipeline-bufferoptions-persistentbufferenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-bufferoptions.html#cfn-osis-pipeline-bufferoptions-persistentbufferenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPersistentBufferEnabled();

        /**
         * @return a {@link Builder} of {@link BufferOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BufferOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BufferOptionsProperty> {
            java.lang.Object persistentBufferEnabled;

            /**
             * Sets the value of {@link BufferOptionsProperty#getPersistentBufferEnabled}
             * @param persistentBufferEnabled Whether persistent buffering should be enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder persistentBufferEnabled(java.lang.Boolean persistentBufferEnabled) {
                this.persistentBufferEnabled = persistentBufferEnabled;
                return this;
            }

            /**
             * Sets the value of {@link BufferOptionsProperty#getPersistentBufferEnabled}
             * @param persistentBufferEnabled Whether persistent buffering should be enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder persistentBufferEnabled(software.amazon.awscdk.IResolvable persistentBufferEnabled) {
                this.persistentBufferEnabled = persistentBufferEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BufferOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BufferOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BufferOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BufferOptionsProperty {
            private final java.lang.Object persistentBufferEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.persistentBufferEnabled = software.amazon.jsii.Kernel.get(this, "persistentBufferEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.persistentBufferEnabled = java.util.Objects.requireNonNull(builder.persistentBufferEnabled, "persistentBufferEnabled is required");
            }

            @Override
            public final java.lang.Object getPersistentBufferEnabled() {
                return this.persistentBufferEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("persistentBufferEnabled", om.valueToTree(this.getPersistentBufferEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_osis.CfnPipeline.BufferOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BufferOptionsProperty.Jsii$Proxy that = (BufferOptionsProperty.Jsii$Proxy) o;

                return this.persistentBufferEnabled.equals(that.persistentBufferEnabled);
            }

            @Override
            public final int hashCode() {
                int result = this.persistentBufferEnabled.hashCode();
                return result;
            }
        }
    }
    /**
     * The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.osis.*;
     * CloudWatchLogDestinationProperty cloudWatchLogDestinationProperty = CloudWatchLogDestinationProperty.builder()
     *         .logGroup("logGroup")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-cloudwatchlogdestination.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-cloudwatchlogdestination.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_osis.CfnPipeline.CloudWatchLogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the CloudWatch Logs group to send pipeline logs to.
         * <p>
         * You can specify an existing log group or create a new one. For example, <code>/aws/vendedlogs/OpenSearchService/pipelines</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-cloudwatchlogdestination.html#cfn-osis-pipeline-cloudwatchlogdestination-loggroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-cloudwatchlogdestination.html#cfn-osis-pipeline-cloudwatchlogdestination-loggroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroup();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogDestinationProperty> {
            java.lang.String logGroup;

            /**
             * Sets the value of {@link CloudWatchLogDestinationProperty#getLogGroup}
             * @param logGroup The name of the CloudWatch Logs group to send pipeline logs to. This parameter is required.
             *                 You can specify an existing log group or create a new one. For example, <code>/aws/vendedlogs/OpenSearchService/pipelines</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroup(java.lang.String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogDestinationProperty {
            private final java.lang.String logGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroup = java.util.Objects.requireNonNull(builder.logGroup, "logGroup is required");
            }

            @Override
            public final java.lang.String getLogGroup() {
                return this.logGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroup", om.valueToTree(this.getLogGroup()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_osis.CfnPipeline.CloudWatchLogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogDestinationProperty.Jsii$Proxy that = (CloudWatchLogDestinationProperty.Jsii$Proxy) o;

                return this.logGroup.equals(that.logGroup);
            }

            @Override
            public final int hashCode() {
                int result = this.logGroup.hashCode();
                return result;
            }
        }
    }
    /**
     * Options to control how OpenSearch encrypts buffer data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.osis.*;
     * EncryptionAtRestOptionsProperty encryptionAtRestOptionsProperty = EncryptionAtRestOptionsProperty.builder()
     *         .kmsKeyArn("kmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-encryptionatrestoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-encryptionatrestoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_osis.CfnPipeline.EncryptionAtRestOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionAtRestOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionAtRestOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the KMS key used to encrypt buffer data.
         * <p>
         * By default, data is encrypted using an AWS owned key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-encryptionatrestoptions.html#cfn-osis-pipeline-encryptionatrestoptions-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-encryptionatrestoptions.html#cfn-osis-pipeline-encryptionatrestoptions-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKmsKeyArn();

        /**
         * @return a {@link Builder} of {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionAtRestOptionsProperty> {
            java.lang.String kmsKeyArn;

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getKmsKeyArn}
             * @param kmsKeyArn The ARN of the KMS key used to encrypt buffer data. This parameter is required.
             *                  By default, data is encrypted using an AWS owned key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionAtRestOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionAtRestOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionAtRestOptionsProperty {
            private final java.lang.String kmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyArn = java.util.Objects.requireNonNull(builder.kmsKeyArn, "kmsKeyArn is required");
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_osis.CfnPipeline.EncryptionAtRestOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionAtRestOptionsProperty.Jsii$Proxy that = (EncryptionAtRestOptionsProperty.Jsii$Proxy) o;

                return this.kmsKeyArn.equals(that.kmsKeyArn);
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Container for the values required to configure logging for the pipeline.
     * <p>
     * If you don't specify these values, OpenSearch Ingestion will not publish logs from your application to CloudWatch Logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.osis.*;
     * LogPublishingOptionsProperty logPublishingOptionsProperty = LogPublishingOptionsProperty.builder()
     *         .cloudWatchLogDestination(CloudWatchLogDestinationProperty.builder()
     *                 .logGroup("logGroup")
     *                 .build())
     *         .isLoggingEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-logpublishingoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-logpublishingoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_osis.CfnPipeline.LogPublishingOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(LogPublishingOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogPublishingOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs.
         * <p>
         * This parameter is required if <code>IsLoggingEnabled</code> is set to <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-logpublishingoptions.html#cfn-osis-pipeline-logpublishingoptions-cloudwatchlogdestination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-logpublishingoptions.html#cfn-osis-pipeline-logpublishingoptions-cloudwatchlogdestination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogDestination() {
            return null;
        }

        /**
         * Whether logs should be published.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-logpublishingoptions.html#cfn-osis-pipeline-logpublishingoptions-isloggingenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-logpublishingoptions.html#cfn-osis-pipeline-logpublishingoptions-isloggingenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsLoggingEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogPublishingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogPublishingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogPublishingOptionsProperty> {
            java.lang.Object cloudWatchLogDestination;
            java.lang.Object isLoggingEnabled;

            /**
             * Sets the value of {@link LogPublishingOptionsProperty#getCloudWatchLogDestination}
             * @param cloudWatchLogDestination The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs.
             *                                 This parameter is required if <code>IsLoggingEnabled</code> is set to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogDestination(software.amazon.awscdk.IResolvable cloudWatchLogDestination) {
                this.cloudWatchLogDestination = cloudWatchLogDestination;
                return this;
            }

            /**
             * Sets the value of {@link LogPublishingOptionsProperty#getCloudWatchLogDestination}
             * @param cloudWatchLogDestination The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs.
             *                                 This parameter is required if <code>IsLoggingEnabled</code> is set to <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogDestination(software.amazon.awscdk.services.osis.CfnPipeline.CloudWatchLogDestinationProperty cloudWatchLogDestination) {
                this.cloudWatchLogDestination = cloudWatchLogDestination;
                return this;
            }

            /**
             * Sets the value of {@link LogPublishingOptionsProperty#getIsLoggingEnabled}
             * @param isLoggingEnabled Whether logs should be published.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isLoggingEnabled(java.lang.Boolean isLoggingEnabled) {
                this.isLoggingEnabled = isLoggingEnabled;
                return this;
            }

            /**
             * Sets the value of {@link LogPublishingOptionsProperty#getIsLoggingEnabled}
             * @param isLoggingEnabled Whether logs should be published.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isLoggingEnabled(software.amazon.awscdk.IResolvable isLoggingEnabled) {
                this.isLoggingEnabled = isLoggingEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogPublishingOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogPublishingOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogPublishingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogPublishingOptionsProperty {
            private final java.lang.Object cloudWatchLogDestination;
            private final java.lang.Object isLoggingEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogDestination = software.amazon.jsii.Kernel.get(this, "cloudWatchLogDestination", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isLoggingEnabled = software.amazon.jsii.Kernel.get(this, "isLoggingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogDestination = builder.cloudWatchLogDestination;
                this.isLoggingEnabled = builder.isLoggingEnabled;
            }

            @Override
            public final java.lang.Object getCloudWatchLogDestination() {
                return this.cloudWatchLogDestination;
            }

            @Override
            public final java.lang.Object getIsLoggingEnabled() {
                return this.isLoggingEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogDestination() != null) {
                    data.set("cloudWatchLogDestination", om.valueToTree(this.getCloudWatchLogDestination()));
                }
                if (this.getIsLoggingEnabled() != null) {
                    data.set("isLoggingEnabled", om.valueToTree(this.getIsLoggingEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_osis.CfnPipeline.LogPublishingOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogPublishingOptionsProperty.Jsii$Proxy that = (LogPublishingOptionsProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogDestination != null ? !this.cloudWatchLogDestination.equals(that.cloudWatchLogDestination) : that.cloudWatchLogDestination != null) return false;
                return this.isLoggingEnabled != null ? this.isLoggingEnabled.equals(that.isLoggingEnabled) : that.isLoggingEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogDestination != null ? this.cloudWatchLogDestination.hashCode() : 0;
                result = 31 * result + (this.isLoggingEnabled != null ? this.isLoggingEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Options for attaching a VPC to pipeline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.osis.*;
     * VpcAttachmentOptionsProperty vpcAttachmentOptionsProperty = VpcAttachmentOptionsProperty.builder()
     *         .attachToVpc(false)
     *         .cidrBlock("cidrBlock")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcattachmentoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcattachmentoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_osis.CfnPipeline.VpcAttachmentOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcAttachmentOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcAttachmentOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether a VPC is attached to the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcattachmentoptions.html#cfn-osis-pipeline-vpcattachmentoptions-attachtovpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcattachmentoptions.html#cfn-osis-pipeline-vpcattachmentoptions-attachtovpc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAttachToVpc();

        /**
         * The CIDR block to be reserved for OpenSearch Ingestion to create elastic network interfaces (ENIs).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcattachmentoptions.html#cfn-osis-pipeline-vpcattachmentoptions-cidrblock">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcattachmentoptions.html#cfn-osis-pipeline-vpcattachmentoptions-cidrblock</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCidrBlock();

        /**
         * @return a {@link Builder} of {@link VpcAttachmentOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcAttachmentOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcAttachmentOptionsProperty> {
            java.lang.Object attachToVpc;
            java.lang.String cidrBlock;

            /**
             * Sets the value of {@link VpcAttachmentOptionsProperty#getAttachToVpc}
             * @param attachToVpc Whether a VPC is attached to the pipeline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachToVpc(java.lang.Boolean attachToVpc) {
                this.attachToVpc = attachToVpc;
                return this;
            }

            /**
             * Sets the value of {@link VpcAttachmentOptionsProperty#getAttachToVpc}
             * @param attachToVpc Whether a VPC is attached to the pipeline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attachToVpc(software.amazon.awscdk.IResolvable attachToVpc) {
                this.attachToVpc = attachToVpc;
                return this;
            }

            /**
             * Sets the value of {@link VpcAttachmentOptionsProperty#getCidrBlock}
             * @param cidrBlock The CIDR block to be reserved for OpenSearch Ingestion to create elastic network interfaces (ENIs). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrBlock(java.lang.String cidrBlock) {
                this.cidrBlock = cidrBlock;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcAttachmentOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcAttachmentOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcAttachmentOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcAttachmentOptionsProperty {
            private final java.lang.Object attachToVpc;
            private final java.lang.String cidrBlock;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attachToVpc = software.amazon.jsii.Kernel.get(this, "attachToVpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cidrBlock = software.amazon.jsii.Kernel.get(this, "cidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attachToVpc = java.util.Objects.requireNonNull(builder.attachToVpc, "attachToVpc is required");
                this.cidrBlock = java.util.Objects.requireNonNull(builder.cidrBlock, "cidrBlock is required");
            }

            @Override
            public final java.lang.Object getAttachToVpc() {
                return this.attachToVpc;
            }

            @Override
            public final java.lang.String getCidrBlock() {
                return this.cidrBlock;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attachToVpc", om.valueToTree(this.getAttachToVpc()));
                data.set("cidrBlock", om.valueToTree(this.getCidrBlock()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_osis.CfnPipeline.VpcAttachmentOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcAttachmentOptionsProperty.Jsii$Proxy that = (VpcAttachmentOptionsProperty.Jsii$Proxy) o;

                if (!attachToVpc.equals(that.attachToVpc)) return false;
                return this.cidrBlock.equals(that.cidrBlock);
            }

            @Override
            public final int hashCode() {
                int result = this.attachToVpc.hashCode();
                result = 31 * result + (this.cidrBlock.hashCode());
                return result;
            }
        }
    }
    /**
     * An OpenSearch Ingestion-managed VPC endpoint that will access one or more pipelines.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.osis.*;
     * VpcEndpointProperty vpcEndpointProperty = VpcEndpointProperty.builder()
     *         .vpcEndpointId("vpcEndpointId")
     *         .vpcId("vpcId")
     *         .vpcOptions(VpcOptionsProperty.builder()
     *                 .subnetIds(List.of("subnetIds"))
     *                 // the properties below are optional
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .vpcAttachmentOptions(VpcAttachmentOptionsProperty.builder()
     *                         .attachToVpc(false)
     *                         .cidrBlock("cidrBlock")
     *                         .build())
     *                 .vpcEndpointManagement("vpcEndpointManagement")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_osis.CfnPipeline.VpcEndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcEndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcEndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html#cfn-osis-pipeline-vpcendpoint-vpcendpointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html#cfn-osis-pipeline-vpcendpoint-vpcendpointid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointId() {
            return null;
        }

        /**
         * The ID for your VPC.
         * <p>
         * AWS PrivateLink generates this value when you create a VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html#cfn-osis-pipeline-vpcendpoint-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html#cfn-osis-pipeline-vpcendpoint-vpcid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * Information about the VPC, including associated subnets and security groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html#cfn-osis-pipeline-vpcendpoint-vpcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html#cfn-osis-pipeline-vpcendpoint-vpcoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcEndpointProperty> {
            java.lang.String vpcEndpointId;
            java.lang.String vpcId;
            java.lang.Object vpcOptions;

            /**
             * Sets the value of {@link VpcEndpointProperty#getVpcEndpointId}
             * @param vpcEndpointId The unique identifier of the endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointId(java.lang.String vpcEndpointId) {
                this.vpcEndpointId = vpcEndpointId;
                return this;
            }

            /**
             * Sets the value of {@link VpcEndpointProperty#getVpcId}
             * @param vpcId The ID for your VPC.
             *              AWS PrivateLink generates this value when you create a VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Sets the value of {@link VpcEndpointProperty#getVpcOptions}
             * @param vpcOptions Information about the VPC, including associated subnets and security groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcOptions(software.amazon.awscdk.IResolvable vpcOptions) {
                this.vpcOptions = vpcOptions;
                return this;
            }

            /**
             * Sets the value of {@link VpcEndpointProperty#getVpcOptions}
             * @param vpcOptions Information about the VPC, including associated subnets and security groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcOptions(software.amazon.awscdk.services.osis.CfnPipeline.VpcOptionsProperty vpcOptions) {
                this.vpcOptions = vpcOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcEndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcEndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcEndpointProperty {
            private final java.lang.String vpcEndpointId;
            private final java.lang.String vpcId;
            private final java.lang.Object vpcOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcEndpointId = software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcOptions = software.amazon.jsii.Kernel.get(this, "vpcOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcEndpointId = builder.vpcEndpointId;
                this.vpcId = builder.vpcId;
                this.vpcOptions = builder.vpcOptions;
            }

            @Override
            public final java.lang.String getVpcEndpointId() {
                return this.vpcEndpointId;
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            public final java.lang.Object getVpcOptions() {
                return this.vpcOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVpcEndpointId() != null) {
                    data.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
                }
                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }
                if (this.getVpcOptions() != null) {
                    data.set("vpcOptions", om.valueToTree(this.getVpcOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_osis.CfnPipeline.VpcEndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcEndpointProperty.Jsii$Proxy that = (VpcEndpointProperty.Jsii$Proxy) o;

                if (this.vpcEndpointId != null ? !this.vpcEndpointId.equals(that.vpcEndpointId) : that.vpcEndpointId != null) return false;
                if (this.vpcId != null ? !this.vpcId.equals(that.vpcId) : that.vpcId != null) return false;
                return this.vpcOptions != null ? this.vpcOptions.equals(that.vpcOptions) : that.vpcOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.vpcEndpointId != null ? this.vpcEndpointId.hashCode() : 0;
                result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
                result = 31 * result + (this.vpcOptions != null ? this.vpcOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.osis.*;
     * VpcOptionsProperty vpcOptionsProperty = VpcOptionsProperty.builder()
     *         .subnetIds(List.of("subnetIds"))
     *         // the properties below are optional
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .vpcAttachmentOptions(VpcAttachmentOptionsProperty.builder()
     *                 .attachToVpc(false)
     *                 .cidrBlock("cidrBlock")
     *                 .build())
     *         .vpcEndpointManagement("vpcEndpointManagement")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_osis.CfnPipeline.VpcOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of subnet IDs associated with the VPC endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * A list of security groups associated with the VPC endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * Options for attaching a VPC to a pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-vpcattachmentoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-vpcattachmentoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcAttachmentOptions() {
            return null;
        }

        /**
         * Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured for the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-vpcendpointmanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-vpcendpointmanagement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointManagement() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcOptionsProperty> {
            java.util.List<java.lang.String> subnetIds;
            java.util.List<java.lang.String> securityGroupIds;
            java.lang.Object vpcAttachmentOptions;
            java.lang.String vpcEndpointManagement;

            /**
             * Sets the value of {@link VpcOptionsProperty#getSubnetIds}
             * @param subnetIds A list of subnet IDs associated with the VPC endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getSecurityGroupIds}
             * @param securityGroupIds A list of security groups associated with the VPC endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getVpcAttachmentOptions}
             * @param vpcAttachmentOptions Options for attaching a VPC to a pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcAttachmentOptions(software.amazon.awscdk.IResolvable vpcAttachmentOptions) {
                this.vpcAttachmentOptions = vpcAttachmentOptions;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getVpcAttachmentOptions}
             * @param vpcAttachmentOptions Options for attaching a VPC to a pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcAttachmentOptions(software.amazon.awscdk.services.osis.CfnPipeline.VpcAttachmentOptionsProperty vpcAttachmentOptions) {
                this.vpcAttachmentOptions = vpcAttachmentOptions;
                return this;
            }

            /**
             * Sets the value of {@link VpcOptionsProperty#getVpcEndpointManagement}
             * @param vpcEndpointManagement Defines whether you or Amazon OpenSearch Ingestion service create and manage the VPC endpoint configured for the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointManagement(java.lang.String vpcEndpointManagement) {
                this.vpcEndpointManagement = vpcEndpointManagement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcOptionsProperty {
            private final java.util.List<java.lang.String> subnetIds;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.lang.Object vpcAttachmentOptions;
            private final java.lang.String vpcEndpointManagement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpcAttachmentOptions = software.amazon.jsii.Kernel.get(this, "vpcAttachmentOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcEndpointManagement = software.amazon.jsii.Kernel.get(this, "vpcEndpointManagement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
                this.securityGroupIds = builder.securityGroupIds;
                this.vpcAttachmentOptions = builder.vpcAttachmentOptions;
                this.vpcEndpointManagement = builder.vpcEndpointManagement;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.lang.Object getVpcAttachmentOptions() {
                return this.vpcAttachmentOptions;
            }

            @Override
            public final java.lang.String getVpcEndpointManagement() {
                return this.vpcEndpointManagement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getVpcAttachmentOptions() != null) {
                    data.set("vpcAttachmentOptions", om.valueToTree(this.getVpcAttachmentOptions()));
                }
                if (this.getVpcEndpointManagement() != null) {
                    data.set("vpcEndpointManagement", om.valueToTree(this.getVpcEndpointManagement()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_osis.CfnPipeline.VpcOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcOptionsProperty.Jsii$Proxy that = (VpcOptionsProperty.Jsii$Proxy) o;

                if (!subnetIds.equals(that.subnetIds)) return false;
                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.vpcAttachmentOptions != null ? !this.vpcAttachmentOptions.equals(that.vpcAttachmentOptions) : that.vpcAttachmentOptions != null) return false;
                return this.vpcEndpointManagement != null ? this.vpcEndpointManagement.equals(that.vpcEndpointManagement) : that.vpcEndpointManagement == null;
            }

            @Override
            public final int hashCode() {
                int result = this.subnetIds.hashCode();
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                result = 31 * result + (this.vpcAttachmentOptions != null ? this.vpcAttachmentOptions.hashCode() : 0);
                result = 31 * result + (this.vpcEndpointManagement != null ? this.vpcEndpointManagement.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.osis.CfnPipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.osis.CfnPipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.osis.CfnPipelineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.osis.CfnPipelineProps.Builder();
        }

        /**
         * The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-maxunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-maxunits</a>
         * @param maxUnits The maximum pipeline capacity, in Ingestion Compute Units (ICUs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxUnits(final java.lang.Number maxUnits) {
            this.props.maxUnits(maxUnits);
            return this;
        }

        /**
         * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-minunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-minunits</a>
         * @param minUnits The minimum pipeline capacity, in Ingestion Compute Units (ICUs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minUnits(final java.lang.Number minUnits) {
            this.props.minUnits(minUnits);
            return this;
        }

        /**
         * The Data Prepper pipeline configuration in YAML format.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelineconfigurationbody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelineconfigurationbody</a>
         * @param pipelineConfigurationBody The Data Prepper pipeline configuration in YAML format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineConfigurationBody(final java.lang.String pipelineConfigurationBody) {
            this.props.pipelineConfigurationBody(pipelineConfigurationBody);
            return this;
        }

        /**
         * The name of the pipeline.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelinename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelinename</a>
         * @param pipelineName The name of the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(final java.lang.String pipelineName) {
            this.props.pipelineName(pipelineName);
            return this;
        }

        /**
         * Options that specify the configuration of a persistent buffer.
         * <p>
         * To configure how OpenSearch Ingestion encrypts this data, set the <code>EncryptionAtRestOptions</code> . For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering">Persistent buffering</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-bufferoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-bufferoptions</a>
         * @param bufferOptions Options that specify the configuration of a persistent buffer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferOptions(final software.amazon.awscdk.IResolvable bufferOptions) {
            this.props.bufferOptions(bufferOptions);
            return this;
        }
        /**
         * Options that specify the configuration of a persistent buffer.
         * <p>
         * To configure how OpenSearch Ingestion encrypts this data, set the <code>EncryptionAtRestOptions</code> . For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/osis-features-overview.html#persistent-buffering">Persistent buffering</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-bufferoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-bufferoptions</a>
         * @param bufferOptions Options that specify the configuration of a persistent buffer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bufferOptions(final software.amazon.awscdk.services.osis.CfnPipeline.BufferOptionsProperty bufferOptions) {
            this.props.bufferOptions(bufferOptions);
            return this;
        }

        /**
         * Options to control how OpenSearch encrypts buffer data.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-encryptionatrestoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-encryptionatrestoptions</a>
         * @param encryptionAtRestOptions Options to control how OpenSearch encrypts buffer data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(final software.amazon.awscdk.IResolvable encryptionAtRestOptions) {
            this.props.encryptionAtRestOptions(encryptionAtRestOptions);
            return this;
        }
        /**
         * Options to control how OpenSearch encrypts buffer data.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-encryptionatrestoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-encryptionatrestoptions</a>
         * @param encryptionAtRestOptions Options to control how OpenSearch encrypts buffer data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(final software.amazon.awscdk.services.osis.CfnPipeline.EncryptionAtRestOptionsProperty encryptionAtRestOptions) {
            this.props.encryptionAtRestOptions(encryptionAtRestOptions);
            return this;
        }

        /**
         * Key-value pairs that represent log publishing settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-logpublishingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-logpublishingoptions</a>
         * @param logPublishingOptions Key-value pairs that represent log publishing settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(final software.amazon.awscdk.IResolvable logPublishingOptions) {
            this.props.logPublishingOptions(logPublishingOptions);
            return this;
        }
        /**
         * Key-value pairs that represent log publishing settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-logpublishingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-logpublishingoptions</a>
         * @param logPublishingOptions Key-value pairs that represent log publishing settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(final software.amazon.awscdk.services.osis.CfnPipeline.LogPublishingOptionsProperty logPublishingOptions) {
            this.props.logPublishingOptions(logPublishingOptions);
            return this;
        }

        /**
         * List of tags to add to the pipeline upon creation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-tags</a>
         * @param tags List of tags to add to the pipeline upon creation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-vpcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-vpcoptions</a>
         * @param vpcOptions Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(final software.amazon.awscdk.IResolvable vpcOptions) {
            this.props.vpcOptions(vpcOptions);
            return this;
        }
        /**
         * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-vpcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-vpcoptions</a>
         * @param vpcOptions Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(final software.amazon.awscdk.services.osis.CfnPipeline.VpcOptionsProperty vpcOptions) {
            this.props.vpcOptions(vpcOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.osis.CfnPipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.osis.CfnPipeline build() {
            return new software.amazon.awscdk.services.osis.CfnPipeline(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
