package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnDBCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBClusterProps cfnDBClusterProps = CfnDBClusterProps.builder()
 *         .allocatedStorage(123)
 *         .associatedRoles(List.of(DBClusterRoleProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .featureName("featureName")
 *                 .build()))
 *         .autoMinorVersionUpgrade(false)
 *         .availabilityZones(List.of("availabilityZones"))
 *         .backtrackWindow(123)
 *         .backupRetentionPeriod(123)
 *         .clusterScalabilityType("clusterScalabilityType")
 *         .copyTagsToSnapshot(false)
 *         .databaseInsightsMode("databaseInsightsMode")
 *         .databaseName("databaseName")
 *         .dbClusterIdentifier("dbClusterIdentifier")
 *         .dbClusterInstanceClass("dbClusterInstanceClass")
 *         .dbClusterParameterGroupName("dbClusterParameterGroupName")
 *         .dbInstanceParameterGroupName("dbInstanceParameterGroupName")
 *         .dbSubnetGroupName("dbSubnetGroupName")
 *         .dbSystemId("dbSystemId")
 *         .deleteAutomatedBackups(false)
 *         .deletionProtection(false)
 *         .domain("domain")
 *         .domainIamRoleName("domainIamRoleName")
 *         .enableCloudwatchLogsExports(List.of("enableCloudwatchLogsExports"))
 *         .enableGlobalWriteForwarding(false)
 *         .enableHttpEndpoint(false)
 *         .enableIamDatabaseAuthentication(false)
 *         .enableLocalWriteForwarding(false)
 *         .engine("engine")
 *         .engineLifecycleSupport("engineLifecycleSupport")
 *         .engineMode("engineMode")
 *         .engineVersion("engineVersion")
 *         .globalClusterIdentifier("globalClusterIdentifier")
 *         .iops(123)
 *         .kmsKeyId("kmsKeyId")
 *         .manageMasterUserPassword(false)
 *         .masterUsername("masterUsername")
 *         .masterUserPassword("masterUserPassword")
 *         .masterUserSecret(MasterUserSecretProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .secretArn("secretArn")
 *                 .build())
 *         .monitoringInterval(123)
 *         .monitoringRoleArn("monitoringRoleArn")
 *         .networkType("networkType")
 *         .performanceInsightsEnabled(false)
 *         .performanceInsightsKmsKeyId("performanceInsightsKmsKeyId")
 *         .performanceInsightsRetentionPeriod(123)
 *         .port(123)
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .publiclyAccessible(false)
 *         .replicationSourceIdentifier("replicationSourceIdentifier")
 *         .restoreToTime("restoreToTime")
 *         .restoreType("restoreType")
 *         .scalingConfiguration(ScalingConfigurationProperty.builder()
 *                 .autoPause(false)
 *                 .maxCapacity(123)
 *                 .minCapacity(123)
 *                 .secondsBeforeTimeout(123)
 *                 .secondsUntilAutoPause(123)
 *                 .timeoutAction("timeoutAction")
 *                 .build())
 *         .serverlessV2ScalingConfiguration(ServerlessV2ScalingConfigurationProperty.builder()
 *                 .maxCapacity(123)
 *                 .minCapacity(123)
 *                 .secondsUntilAutoPause(123)
 *                 .build())
 *         .snapshotIdentifier("snapshotIdentifier")
 *         .sourceDbClusterIdentifier("sourceDbClusterIdentifier")
 *         .sourceDbClusterResourceId("sourceDbClusterResourceId")
 *         .sourceRegion("sourceRegion")
 *         .storageEncrypted(false)
 *         .storageType("storageType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useLatestRestorableTime(false)
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:38.854Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-allocatedstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-allocatedstorage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAllocatedStorage() {
        return null;
    }

    /**
     * Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
     * <p>
     * IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-associatedroles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-associatedroles</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatedRoles() {
        return null;
    }

    /**
     * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
     * <p>
     * By default, minor engine upgrades are applied automatically.
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB cluster.
     * <p>
     * For more information about automatic minor version upgrades, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades">Automatically upgrading the minor engine version</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-autominorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-autominorversionupgrade</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return null;
    }

    /**
     * A list of Availability Zones (AZs) where instances in the DB cluster can be created.
     * <p>
     * For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-availabilityzones">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-availabilityzones</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return null;
    }

    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code> .
     * <p>
     * Valid for Cluster Type: Aurora MySQL DB clusters only
     * <p>
     * Default: <code>0</code>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backtrackwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backtrackwindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBacktrackWindow() {
        return null;
    }

    /**
     * The number of days for which automated backups are retained.
     * <p>
     * Default: 1
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a value from 1 to 35</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * Default: - 1
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backupretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-backupretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionPeriod() {
        return null;
    }

    /**
     * Specifies the scalability mode of the Aurora DB cluster.
     * <p>
     * When set to <code>limitless</code> , the cluster operates as an Aurora Limitless Database, allowing you to create a DB shard group for horizontal scaling (sharding) capabilities. When set to <code>standard</code> (the default), the cluster uses normal DB instance creation.
     * <p>
     * <em>Important:</em> Automated backup retention isn't supported with Aurora Limitless Database clusters. If you set this property to <code>limitless</code> , you cannot set <code>DeleteAutomatedBackups</code> to <code>false</code> . To create a backup, use manual snapshots instead.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-clusterscalabilitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-clusterscalabilitytype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterScalabilityType() {
        return null;
    }

    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
     * <p>
     * The default is not to copy them.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-copytagstosnapshot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-copytagstosnapshot</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCopyTagsToSnapshot() {
        return null;
    }

    /**
     * The mode of Database Insights to enable for the DB cluster.
     * <p>
     * If you set this value to <code>advanced</code> , you must also set the <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databaseinsightsmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databaseinsightsmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseInsightsMode() {
        return null;
    }

    /**
     * The name of your database.
     * <p>
     * If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-databasename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
        return null;
    }

    /**
     * The DB cluster identifier. This parameter is stored as a lowercase string.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
     * <li>First character must be a letter.</li>
     * <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
     * </ul>
     * <p>
     * Example: <code>my-cluster1</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterIdentifier() {
        return null;
    }

    /**
     * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example <code>db.m6gd.xlarge</code> . Not all DB instance classes are available in all AWS Regions , or for all database engines.
     * <p>
     * For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterinstanceclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterinstanceclass</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterInstanceClass() {
        return null;
    }

    /**
     * The name of the DB cluster parameter group to associate with this DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
     * <p>
     * If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
     * <p>
     * </blockquote>
     * <p>
     * To list all of the available DB cluster parameter group names, use the following command:
     * <p>
     * <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbclusterparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbClusterParameterGroupName() {
        return null;
    }

    /**
     * The name of the DB parameter group to apply to all instances of the DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
     * <p>
     * </blockquote>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * <p>
     * Default: The existing name setting
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>The DB parameter group must be in the same DB parameter group family as this DB cluster.</li>
     * <li>The <code>DBInstanceParameterGroupName</code> parameter is valid in combination with the <code>AllowMajorVersionUpgrade</code> parameter for a major version upgrade only.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbinstanceparametergroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbinstanceparametergroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbInstanceParameterGroupName() {
        return null;
    }

    /**
     * A DB subnet group that you want to associate with this DB cluster.
     * <p>
     * If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsubnetgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsubnetgroupname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbSubnetGroupName() {
        return null;
    }

    /**
     * Reserved for future use.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-dbsystemid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDbSystemId() {
        return null;
    }

    /**
     * Specifies whether to remove automated backups immediately after the DB cluster is deleted.
     * <p>
     * This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB cluster is deleted, unless the AWS Backup policy specifies a point-in-time restore rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deleteautomatedbackups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deleteautomatedbackups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteAutomatedBackups() {
        return null;
    }

    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * <p>
     * The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deletionprotection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-deletionprotection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeletionProtection() {
        return null;
    }

    /**
     * Indicates the directory ID of the Active Directory to create the DB cluster.
     * <p>
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-domain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-domain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * Specifies the name of the IAM role to use when making API calls to the Directory Service.
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-domainiamrolename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-domainiamrolename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainIamRoleName() {
        return null;
    }

    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     * <p>
     * The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <em>Aurora MySQL</em>
     * <p>
     * Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
     * <p>
     * <em>Aurora PostgreSQL</em>
     * <p>
     * Valid values: <code>postgresql</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablecloudwatchlogsexports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablecloudwatchlogsexports</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
        return null;
    }

    /**
     * Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database).
     * <p>
     * By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
     * <p>
     * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableglobalwriteforwarding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableglobalwriteforwarding</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableGlobalWriteForwarding() {
        return null;
    }

    /**
     * Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
     * <p>
     * When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablehttpendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablehttpendpoint</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableHttpEndpoint() {
        return null;
    }

    /**
     * A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
     * <p>
     * By default, mapping is disabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableiamdatabaseauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enableiamdatabaseauthentication</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableIamDatabaseAuthentication() {
        return null;
    }

    /**
     * Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster.
     * <p>
     * By default, write operations aren't allowed on reader DB instances.
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablelocalwriteforwarding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enablelocalwriteforwarding</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableLocalWriteForwarding() {
        return null;
    }

    /**
     * The name of the database engine to be used for this DB cluster.
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>aurora-mysql</code></li>
     * <li><code>aurora-postgresql</code></li>
     * <li><code>mysql</code></li>
     * <li><code>postgres</code></li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return null;
    }

    /**
     * The life cycle type for this DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * By default, this value is set to <code>open-source-rds-extended-support</code> , which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code> . In this case, creating the DB cluster will fail if the DB major version is past its end of standard support date.
     * <p>
     * </blockquote>
     * <p>
     * You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:
     * <p>
     * <ul>
     * <li>Amazon Aurora - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS Extended Support with Amazon Aurora</a> in the <em>Amazon Aurora User Guide</em></li>
     * <li>Amazon RDS - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended Support with Amazon RDS</a> in the <em>Amazon RDS User Guide</em></li>
     * </ul>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
     * <p>
     * Default: <code>open-source-rds-extended-support</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginelifecyclesupport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginelifecyclesupport</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineLifecycleSupport() {
        return null;
    }

    /**
     * The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code> .
     * <p>
     * The <code>serverless</code> engine mode only applies for Aurora Serverless v1 DB clusters. Aurora Serverless v2 DB clusters use the <code>provisioned</code> engine mode.
     * <p>
     * For information about limitations and requirements for Serverless DB clusters, see the following sections in the <em>Amazon Aurora User Guide</em> :
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless v1</a></li>
     * <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html">Requirements for Aurora Serverless v2</a></li>
     * </ul>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-enginemode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineMode() {
        return null;
    }

    /**
     * The version number of the database engine to use.
     * <p>
     * To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (8.0-compatible), use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * You can supply either <code>5.7</code> or <code>8.0</code> to use the default engine version for Aurora MySQL version 2 or version 3, respectively.
     * <p>
     * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for RDS for MySQL, use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     * <p>
     * <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
     * <p>
     * <em>Aurora MySQL</em>
     * <p>
     * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database engine updates for Amazon Aurora MySQL</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <em>Aurora PostgreSQL</em>
     * <p>
     * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * <em>MySQL</em>
     * <p>
     * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">Amazon RDS for MySQL</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * <em>PostgreSQL</em>
     * <p>
     * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
     * <p>
     * To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
     * <p>
     * If you aren't configuring a global database cluster, don't specify this property.
     * <p>
     * <blockquote>
     * <p>
     * To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
     * <p>
     * </blockquote>
     * <p>
     * For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-globalclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-globalclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGlobalClusterIdentifier() {
        return null;
    }

    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
     * <p>
     * For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Provisioned IOPS storage</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-iops</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> .
     * <p>
     * If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you create a read replica of an encrypted DB cluster in another AWS Region, make sure to set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination AWS Region. This KMS key is used to encrypt the read replica in that AWS Region.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Specifies whether to manage the master user password with AWS Secrets Manager.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Can't manage the master user password with AWS Secrets Manager if <code>MasterUserPassword</code> is specified.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-managemasteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-managemasteruserpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getManageMasterUserPassword() {
        return null;
    }

    /**
     * The name of the master user for the DB cluster.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUsername() {
        return null;
    }

    /**
     * The master password for the DB instance.
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masteruserpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
        return null;
    }

    /**
     * The secret managed by RDS in AWS Secrets Manager for the master user password.
     * <p>
     * <blockquote>
     * <p>
     * When you restore a DB cluster from a snapshot, Amazon RDS generates a new secret instead of reusing the secret specified in the <code>SecretArn</code> property. This ensures that the restored DB cluster is securely managed with a dedicated secret. To maintain consistent integration with your application, you might need to update resource configurations to reference the newly created secret.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusersecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-masterusersecret</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMasterUserSecret() {
        return null;
    }

    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
     * <p>
     * To turn off collecting Enhanced Monitoring metrics, specify <code>0</code> .
     * <p>
     * If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than <code>0</code> .
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
     * <p>
     * Default: <code>0</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-monitoringinterval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-monitoringinterval</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMonitoringInterval() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
     * <p>
     * An example is <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * If <code>MonitoringInterval</code> is set to a value other than <code>0</code> , supply a <code>MonitoringRoleArn</code> value.
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-monitoringrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-monitoringrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMonitoringRoleArn() {
        return null;
    }

    /**
     * The network type of the DB cluster.
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li><code>IPV4</code></li>
     * <li><code>DUAL</code></li>
     * </ul>
     * <p>
     * The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and IPv6 protocols ( <code>DUAL</code> ).
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">Working with a DB instance in a VPC</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-networktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-networktype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkType() {
        return null;
    }

    /**
     * Specifies whether to turn on Performance Insights for the DB cluster.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-performanceinsightsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-performanceinsightsenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPerformanceInsightsEnabled() {
        return null;
    }

    /**
     * The AWS KMS key identifier for encryption of Performance Insights data.
     * <p>
     * The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * <p>
     * If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account . Your AWS account has a different default KMS key for each AWS Region .
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-performanceinsightskmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-performanceinsightskmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPerformanceInsightsKmsKeyId() {
        return null;
    }

    /**
     * The number of days to retain Performance Insights data.
     * <p>
     * When creating a DB cluster without enabling Performance Insights, you can't specify the parameter <code>PerformanceInsightsRetentionPeriod</code> .
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li><code>7</code></li>
     * <li><em>month</em> * 31, where <em>month</em> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</li>
     * <li><code>731</code></li>
     * </ul>
     * <p>
     * Default: <code>7</code> days
     * <p>
     * If you specify a retention period that isn't valid, such as <code>94</code> , Amazon RDS issues an error.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-performanceinsightsretentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-performanceinsightsretentionperiod</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPerformanceInsightsRetentionPeriod() {
        return null;
    }

    /**
     * The port number on which the DB instances in the DB cluster accept connections.
     * <p>
     * Default:
     * <p>
     * <ul>
     * <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
     * <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
     * <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
     * <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-port</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * The daily time range during which automated backups are created.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
     * <li>Must be in Universal Coordinated Time (UTC).</li>
     * <li>Must not conflict with the preferred maintenance window.</li>
     * <li>Must be at least 30 minutes.</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredbackupwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredbackupwindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return null;
    }

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * <p>
     * Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
     * <p>
     * The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Maintaining an Amazon Aurora DB cluster</a> in the <em>Amazon Aurora User Guide.</em>
     * <p>
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * <p>
     * Constraints: Minimum 30-minute window.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-preferredmaintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * Specifies whether the DB cluster is publicly accessible.
     * <p>
     * When the DB cluster is publicly accessible and you connect from outside of the DB cluster's virtual private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from within the same VPC as the DB cluster, the endpoint resolves to the private IP address. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     * <p>
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     * <p>
     * Valid for Cluster Type: Multi-AZ DB clusters only
     * <p>
     * Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
     * <p>
     * If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
     * <li>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</li>
     * </ul>
     * <p>
     * If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
     * <p>
     * <ul>
     * <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
     * <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-publiclyaccessible</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-replicationsourceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-replicationsourceidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplicationSourceIdentifier() {
        return null;
    }

    /**
     * The date and time to restore the DB cluster to.
     * <p>
     * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must be before the latest restorable time for the DB instance</li>
     * <li>Must be specified if <code>UseLatestRestorableTime</code> parameter isn't provided</li>
     * <li>Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled</li>
     * <li>Can't be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code></li>
     * </ul>
     * <p>
     * This property must be used with <code>SourceDBClusterIdentifier</code> property. The resulting cluster will have the identifier that matches the value of the <code>DBclusterIdentifier</code> property.
     * <p>
     * Example: <code>2015-03-07T23:45:00Z</code>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretotime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretotime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRestoreToTime() {
        return null;
    }

    /**
     * The type of restore to be performed. You can specify one of the following values:.
     * <p>
     * <ul>
     * <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
     * <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
     * </ul>
     * <p>
     * If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-restoretype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRestoreType() {
        return null;
    }

    /**
     * The scaling configuration of an Aurora Serverless v1 DB cluster.
     * <p>
     * This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the <code>ServerlessV2ScalingConfiguration</code> property.
     * <p>
     * Valid for: Aurora Serverless v1 DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-scalingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-scalingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfiguration() {
        return null;
    }

    /**
     * The scaling configuration of an Aurora Serverless V2 DB cluster.
     * <p>
     * This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, Use the <code>ScalingConfiguration</code> property.
     * <p>
     * Valid for: Aurora Serverless v2 DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-serverlessv2scalingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-serverlessv2scalingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getServerlessV2ScalingConfiguration() {
        return null;
    }

    /**
     * The identifier for the DB snapshot or DB cluster snapshot to restore from.
     * <p>
     * You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
     * <p>
     * After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
     * <p>
     * <ul>
     * <li><code>GlobalClusterIdentifier</code></li>
     * <li><code>MasterUsername</code></li>
     * <li><code>MasterUserPassword</code></li>
     * <li><code>ReplicationSourceIdentifier</code></li>
     * <li><code>RestoreType</code></li>
     * <li><code>SourceDBClusterIdentifier</code></li>
     * <li><code>SourceRegion</code></li>
     * <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
     * <li><code>UseLatestRestorableTime</code></li>
     * </ul>
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing Snapshot.</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-snapshotidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-snapshotidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotIdentifier() {
        return null;
    }

    /**
     * When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>Must match the identifier of an existing DBCluster.</li>
     * <li>Cannot be specified if <code>SourceDbClusterResourceId</code> is specified. You must specify either <code>SourceDBClusterIdentifier</code> or <code>SourceDbClusterResourceId</code> , but not both.</li>
     * </ul>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusteridentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterIdentifier() {
        return null;
    }

    /**
     * The resource ID of the source DB cluster from which to restore.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusterresourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourcedbclusterresourceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceDbClusterResourceId() {
        return null;
    }

    /**
     * The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, <code>us-east-1</code> .
     * <p>
     * Valid for: Aurora DB clusters only
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourceregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-sourceregion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSourceRegion() {
        return null;
    }

    /**
     * Indicates whether the DB cluster is encrypted.
     * <p>
     * If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
     * <p>
     * If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
     * <p>
     * If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify both the <code>StorageEncrypted</code> and <code>SnapshotIdentifier</code> properties without specifying the <code>KmsKeyId</code> property, then the restored DB cluster inherits the encryption settings from the DB snapshot that provide.
     * <p>
     * </blockquote>
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storageencrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storageencrypted</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStorageEncrypted() {
        return null;
    }

    /**
     * The storage type to associate with the DB cluster.
     * <p>
     * For information on storage types for Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type">Storage configurations for Amazon Aurora DB clusters</a> . For information on storage types for Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings">Settings for creating Multi-AZ DB clusters</a> .
     * <p>
     * This setting is required to create a Multi-AZ DB cluster.
     * <p>
     * When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * Valid Values:
     * <p>
     * <ul>
     * <li>Aurora DB clusters - <code>aurora | aurora-iopt1</code></li>
     * <li>Multi-AZ DB clusters - <code>io1 | io2 | gp3</code></li>
     * </ul>
     * <p>
     * Default:
     * <p>
     * <ul>
     * <li>Aurora DB clusters - <code>aurora</code></li>
     * <li>Multi-AZ DB clusters - <code>io1</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * When you create an Aurora DB cluster with the storage type set to <code>aurora-iopt1</code> , the storage type is returned in the response. The storage type isn't returned when you set it to <code>aurora</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-storagetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return null;
    }

    /**
     * Tags to assign to the DB cluster.
     * <p>
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A value that indicates whether to restore the DB cluster to the latest restorable backup time.
     * <p>
     * By default, the DB cluster is not restored to the latest restorable backup time.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-uselatestrestorabletime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-uselatestrestorabletime</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUseLatestRestorableTime() {
        return null;
    }

    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     * <p>
     * If you plan to update the resource, don't specify VPC security groups in a shared VPC.
     * <p>
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-vpcsecuritygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html#cfn-rds-dbcluster-vpcsecuritygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBClusterProps> {
        java.lang.Number allocatedStorage;
        java.lang.Object associatedRoles;
        java.lang.Object autoMinorVersionUpgrade;
        java.util.List<java.lang.String> availabilityZones;
        java.lang.Number backtrackWindow;
        java.lang.Number backupRetentionPeriod;
        java.lang.String clusterScalabilityType;
        java.lang.Object copyTagsToSnapshot;
        java.lang.String databaseInsightsMode;
        java.lang.String databaseName;
        java.lang.String dbClusterIdentifier;
        java.lang.String dbClusterInstanceClass;
        java.lang.String dbClusterParameterGroupName;
        java.lang.String dbInstanceParameterGroupName;
        java.lang.String dbSubnetGroupName;
        java.lang.String dbSystemId;
        java.lang.Object deleteAutomatedBackups;
        java.lang.Object deletionProtection;
        java.lang.String domain;
        java.lang.String domainIamRoleName;
        java.util.List<java.lang.String> enableCloudwatchLogsExports;
        java.lang.Object enableGlobalWriteForwarding;
        java.lang.Object enableHttpEndpoint;
        java.lang.Object enableIamDatabaseAuthentication;
        java.lang.Object enableLocalWriteForwarding;
        java.lang.String engine;
        java.lang.String engineLifecycleSupport;
        java.lang.String engineMode;
        java.lang.String engineVersion;
        java.lang.String globalClusterIdentifier;
        java.lang.Number iops;
        java.lang.String kmsKeyId;
        java.lang.Object manageMasterUserPassword;
        java.lang.String masterUsername;
        java.lang.String masterUserPassword;
        java.lang.Object masterUserSecret;
        java.lang.Number monitoringInterval;
        java.lang.String monitoringRoleArn;
        java.lang.String networkType;
        java.lang.Object performanceInsightsEnabled;
        java.lang.String performanceInsightsKmsKeyId;
        java.lang.Number performanceInsightsRetentionPeriod;
        java.lang.Number port;
        java.lang.String preferredBackupWindow;
        java.lang.String preferredMaintenanceWindow;
        java.lang.Object publiclyAccessible;
        java.lang.String replicationSourceIdentifier;
        java.lang.String restoreToTime;
        java.lang.String restoreType;
        java.lang.Object scalingConfiguration;
        java.lang.Object serverlessV2ScalingConfiguration;
        java.lang.String snapshotIdentifier;
        java.lang.String sourceDbClusterIdentifier;
        java.lang.String sourceDbClusterResourceId;
        java.lang.String sourceRegion;
        java.lang.Object storageEncrypted;
        java.lang.String storageType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object useLatestRestorableTime;
        java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Sets the value of {@link CfnDBClusterProps#getAllocatedStorage}
         * @param allocatedStorage The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         *                         Valid for Cluster Type: Multi-AZ DB clusters only
         *                         <p>
         *                         This setting is required to create a Multi-AZ DB cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocatedStorage(java.lang.Number allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAssociatedRoles}
         * @param associatedRoles Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
         *                        IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         *                        <p>
         *                        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(software.amazon.awscdk.IResolvable associatedRoles) {
            this.associatedRoles = associatedRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAssociatedRoles}
         * @param associatedRoles Provides a list of the AWS Identity and Access Management (IAM) roles that are associated with the DB cluster.
         *                        IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         *                        <p>
         *                        Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatedRoles(java.util.List<? extends java.lang.Object> associatedRoles) {
            this.associatedRoles = associatedRoles;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
         *                                By default, minor engine upgrades are applied automatically.
         *                                <p>
         *                                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB cluster.
         *                                <p>
         *                                For more information about automatic minor version upgrades, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades">Automatically upgrading the minor engine version</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(java.lang.Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAutoMinorVersionUpgrade}
         * @param autoMinorVersionUpgrade Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
         *                                By default, minor engine upgrades are applied automatically.
         *                                <p>
         *                                Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB cluster.
         *                                <p>
         *                                For more information about automatic minor version upgrades, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Upgrading.html#USER_UpgradeDBInstance.Upgrading.AutoMinorVersionUpgrades">Automatically upgrading the minor engine version</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getAvailabilityZones}
         * @param availabilityZones A list of Availability Zones (AZs) where instances in the DB cluster can be created.
         *                          For information on AWS Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <em>Amazon Aurora User Guide</em> .
         *                          <p>
         *                          Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getBacktrackWindow}
         * @param backtrackWindow The target backtrack window, in seconds. To disable backtracking, set this value to <code>0</code> .
         *                        Valid for Cluster Type: Aurora MySQL DB clusters only
         *                        <p>
         *                        Default: <code>0</code>
         *                        <p>
         *                        Constraints:
         *                        <p>
         *                        <ul>
         *                        <li>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</li>
         *                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backtrackWindow(java.lang.Number backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getBackupRetentionPeriod}
         * @param backupRetentionPeriod The number of days for which automated backups are retained.
         *                              Default: 1
         *                              <p>
         *                              Constraints:
         *                              <p>
         *                              <ul>
         *                              <li>Must be a value from 1 to 35</li>
         *                              </ul>
         *                              <p>
         *                              Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionPeriod(java.lang.Number backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getClusterScalabilityType}
         * @param clusterScalabilityType Specifies the scalability mode of the Aurora DB cluster.
         *                               When set to <code>limitless</code> , the cluster operates as an Aurora Limitless Database, allowing you to create a DB shard group for horizontal scaling (sharding) capabilities. When set to <code>standard</code> (the default), the cluster uses normal DB instance creation.
         *                               <p>
         *                               <em>Important:</em> Automated backup retention isn't supported with Aurora Limitless Database clusters. If you set this property to <code>limitless</code> , you cannot set <code>DeleteAutomatedBackups</code> to <code>false</code> . To create a backup, use manual snapshots instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterScalabilityType(java.lang.String clusterScalabilityType) {
            this.clusterScalabilityType = clusterScalabilityType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         *                           The default is not to copy them.
         *                           <p>
         *                           Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(java.lang.Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getCopyTagsToSnapshot}
         * @param copyTagsToSnapshot A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         *                           The default is not to copy them.
         *                           <p>
         *                           Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder copyTagsToSnapshot(software.amazon.awscdk.IResolvable copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDatabaseInsightsMode}
         * @param databaseInsightsMode The mode of Database Insights to enable for the DB cluster.
         *                             If you set this value to <code>advanced</code> , you must also set the <code>PerformanceInsightsEnabled</code> parameter to <code>true</code> and the <code>PerformanceInsightsRetentionPeriod</code> parameter to 465.
         *                             <p>
         *                             Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInsightsMode(java.lang.String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDatabaseName}
         * @param databaseName The name of your database.
         *                     If you don't provide a name, then Amazon RDS won't create a database in this DB cluster. For naming constraints, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html#RDS_Limits.Constraints">Naming Constraints</a> in the <em>Amazon Aurora User Guide</em> .
         *                     <p>
         *                     Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(java.lang.String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbClusterIdentifier}
         * @param dbClusterIdentifier The DB cluster identifier. This parameter is stored as a lowercase string.
         *                            Constraints:
         *                            <p>
         *                            <ul>
         *                            <li>Must contain from 1 to 63 letters, numbers, or hyphens.</li>
         *                            <li>First character must be a letter.</li>
         *                            <li>Can't end with a hyphen or contain two consecutive hyphens.</li>
         *                            </ul>
         *                            <p>
         *                            Example: <code>my-cluster1</code>
         *                            <p>
         *                            Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterIdentifier(java.lang.String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbClusterInstanceClass}
         * @param dbClusterInstanceClass The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example <code>db.m6gd.xlarge</code> . Not all DB instance classes are available in all AWS Regions , or for all database engines.
         *                               For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <em>Amazon RDS User Guide</em> .
         *                               <p>
         *                               This setting is required to create a Multi-AZ DB cluster.
         *                               <p>
         *                               Valid for Cluster Type: Multi-AZ DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterInstanceClass(java.lang.String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbClusterParameterGroupName}
         * @param dbClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB cluster.
         *                                    <blockquote>
         *                                    <p>
         *                                    If you apply a parameter group to an existing DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
         *                                    <p>
         *                                    If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
         *                                    <p>
         *                                    </blockquote>
         *                                    <p>
         *                                    To list all of the available DB cluster parameter group names, use the following command:
         *                                    <p>
         *                                    <code>aws rds describe-db-cluster-parameter-groups --query "DBClusterParameterGroups[].DBClusterParameterGroupName" --output text</code>
         *                                    <p>
         *                                    Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterParameterGroupName(java.lang.String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbInstanceParameterGroupName}
         * @param dbInstanceParameterGroupName The name of the DB parameter group to apply to all instances of the DB cluster.
         *                                     <blockquote>
         *                                     <p>
         *                                     When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.
         *                                     <p>
         *                                     </blockquote>
         *                                     <p>
         *                                     Valid for Cluster Type: Aurora DB clusters only
         *                                     <p>
         *                                     Default: The existing name setting
         *                                     <p>
         *                                     Constraints:
         *                                     <p>
         *                                     <ul>
         *                                     <li>The DB parameter group must be in the same DB parameter group family as this DB cluster.</li>
         *                                     <li>The <code>DBInstanceParameterGroupName</code> parameter is valid in combination with the <code>AllowMajorVersionUpgrade</code> parameter for a major version upgrade only.</li>
         *                                     </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbInstanceParameterGroupName(java.lang.String dbInstanceParameterGroupName) {
            this.dbInstanceParameterGroupName = dbInstanceParameterGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbSubnetGroupName}
         * @param dbSubnetGroupName A DB subnet group that you want to associate with this DB cluster.
         *                          If you are restoring a DB cluster to a point in time with <code>RestoreType</code> set to <code>copy-on-write</code> , and don't specify a DB subnet group name, then the DB cluster is restored with a default DB subnet group.
         *                          <p>
         *                          Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSubnetGroupName(java.lang.String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDbSystemId}
         * @param dbSystemId Reserved for future use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSystemId(java.lang.String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDeleteAutomatedBackups}
         * @param deleteAutomatedBackups Specifies whether to remove automated backups immediately after the DB cluster is deleted.
         *                               This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB cluster is deleted, unless the AWS Backup policy specifies a point-in-time restore rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(java.lang.Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDeleteAutomatedBackups}
         * @param deleteAutomatedBackups Specifies whether to remove automated backups immediately after the DB cluster is deleted.
         *                               This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB cluster is deleted, unless the AWS Backup policy specifies a point-in-time restore rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteAutomatedBackups(software.amazon.awscdk.IResolvable deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDeletionProtection}
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled.
         *                           The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         *                           <p>
         *                           Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(java.lang.Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDeletionProtection}
         * @param deletionProtection A value that indicates whether the DB cluster has deletion protection enabled.
         *                           The database can't be deleted when deletion protection is enabled. By default, deletion protection is disabled.
         *                           <p>
         *                           Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(software.amazon.awscdk.IResolvable deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDomain}
         * @param domain Indicates the directory ID of the Active Directory to create the DB cluster.
         *               For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
         *               <p>
         *               For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <em>Amazon Aurora User Guide</em> .
         *               <p>
         *               Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getDomainIamRoleName}
         * @param domainIamRoleName Specifies the name of the IAM role to use when making API calls to the Directory Service.
         *                          Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainIamRoleName(java.lang.String domainIamRoleName) {
            this.domainIamRoleName = domainIamRoleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableCloudwatchLogsExports}
         * @param enableCloudwatchLogsExports The list of log types that need to be enabled for exporting to CloudWatch Logs.
         *                                    The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <em>Amazon Aurora User Guide</em> .
         *                                    <p>
         *                                    <em>Aurora MySQL</em>
         *                                    <p>
         *                                    Valid values: <code>audit</code> , <code>error</code> , <code>general</code> , <code>slowquery</code>
         *                                    <p>
         *                                    <em>Aurora PostgreSQL</em>
         *                                    <p>
         *                                    Valid values: <code>postgresql</code>
         *                                    <p>
         *                                    Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableCloudwatchLogsExports(java.util.List<java.lang.String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = enableCloudwatchLogsExports;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableGlobalWriteForwarding}
         * @param enableGlobalWriteForwarding Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database).
         *                                    By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
         *                                    <p>
         *                                    You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
         *                                    <p>
         *                                    Valid for Cluster Type: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableGlobalWriteForwarding(java.lang.Boolean enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableGlobalWriteForwarding}
         * @param enableGlobalWriteForwarding Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database).
         *                                    By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
         *                                    <p>
         *                                    You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
         *                                    <p>
         *                                    Valid for Cluster Type: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableGlobalWriteForwarding(software.amazon.awscdk.IResolvable enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableHttpEndpoint}
         * @param enableHttpEndpoint Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
         *                           When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
         *                           <p>
         *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the <em>Amazon Aurora User Guide</em> .
         *                           <p>
         *                           Valid for Cluster Type: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(java.lang.Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableHttpEndpoint}
         * @param enableHttpEndpoint Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
         *                           When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
         *                           <p>
         *                           For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using RDS Data API</a> in the <em>Amazon Aurora User Guide</em> .
         *                           <p>
         *                           Valid for Cluster Type: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableHttpEndpoint(software.amazon.awscdk.IResolvable enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableIamDatabaseAuthentication}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         *                                        By default, mapping is disabled.
         *                                        <p>
         *                                        For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
         *                                        <p>
         *                                        Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(java.lang.Boolean enableIamDatabaseAuthentication) {
            this.enableIamDatabaseAuthentication = enableIamDatabaseAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableIamDatabaseAuthentication}
         * @param enableIamDatabaseAuthentication A value that indicates whether to enable mapping of AWS Identity and Access Management (IAM) accounts to database accounts.
         *                                        By default, mapping is disabled.
         *                                        <p>
         *                                        For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">IAM Database Authentication</a> in the <em>Amazon Aurora User Guide.</em>
         *                                        <p>
         *                                        Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableIamDatabaseAuthentication(software.amazon.awscdk.IResolvable enableIamDatabaseAuthentication) {
            this.enableIamDatabaseAuthentication = enableIamDatabaseAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableLocalWriteForwarding}
         * @param enableLocalWriteForwarding Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster.
         *                                   By default, write operations aren't allowed on reader DB instances.
         *                                   <p>
         *                                   Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLocalWriteForwarding(java.lang.Boolean enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEnableLocalWriteForwarding}
         * @param enableLocalWriteForwarding Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster.
         *                                   By default, write operations aren't allowed on reader DB instances.
         *                                   <p>
         *                                   Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLocalWriteForwarding(software.amazon.awscdk.IResolvable enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEngine}
         * @param engine The name of the database engine to be used for this DB cluster.
         *               Valid Values:
         *               <p>
         *               <ul>
         *               <li><code>aurora-mysql</code></li>
         *               <li><code>aurora-postgresql</code></li>
         *               <li><code>mysql</code></li>
         *               <li><code>postgres</code></li>
         *               </ul>
         *               <p>
         *               Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEngineLifecycleSupport}
         * @param engineLifecycleSupport The life cycle type for this DB cluster.
         *                               <blockquote>
         *                               <p>
         *                               By default, this value is set to <code>open-source-rds-extended-support</code> , which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to <code>open-source-rds-extended-support-disabled</code> . In this case, creating the DB cluster will fail if the DB major version is past its end of standard support date.
         *                               <p>
         *                               </blockquote>
         *                               <p>
         *                               You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:
         *                               <p>
         *                               <ul>
         *                               <li>Amazon Aurora - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html">Amazon RDS Extended Support with Amazon Aurora</a> in the <em>Amazon Aurora User Guide</em></li>
         *                               <li>Amazon RDS - <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html">Amazon RDS Extended Support with Amazon RDS</a> in the <em>Amazon RDS User Guide</em></li>
         *                               </ul>
         *                               <p>
         *                               Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *                               <p>
         *                               Valid Values: <code>open-source-rds-extended-support | open-source-rds-extended-support-disabled</code>
         *                               <p>
         *                               Default: <code>open-source-rds-extended-support</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineLifecycleSupport(java.lang.String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEngineMode}
         * @param engineMode The DB engine mode of the DB cluster, either <code>provisioned</code> or <code>serverless</code> .
         *                   The <code>serverless</code> engine mode only applies for Aurora Serverless v1 DB clusters. Aurora Serverless v2 DB clusters use the <code>provisioned</code> engine mode.
         *                   <p>
         *                   For information about limitations and requirements for Serverless DB clusters, see the following sections in the <em>Amazon Aurora User Guide</em> :
         *                   <p>
         *                   <ul>
         *                   <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">Limitations of Aurora Serverless v1</a></li>
         *                   <li><a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html">Requirements for Aurora Serverless v2</a></li>
         *                   </ul>
         *                   <p>
         *                   Valid for Cluster Type: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineMode(java.lang.String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getEngineVersion}
         * @param engineVersion The version number of the database engine to use.
         *                      To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (8.0-compatible), use the following command:
         *                      <p>
         *                      <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code>
         *                      <p>
         *                      You can supply either <code>5.7</code> or <code>8.0</code> to use the default engine version for Aurora MySQL version 2 or version 3, respectively.
         *                      <p>
         *                      To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         *                      <p>
         *                      <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code>
         *                      <p>
         *                      To list all of the available engine versions for RDS for MySQL, use the following command:
         *                      <p>
         *                      <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code>
         *                      <p>
         *                      To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         *                      <p>
         *                      <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code>
         *                      <p>
         *                      <em>Aurora MySQL</em>
         *                      <p>
         *                      For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">Database engine updates for Amazon Aurora MySQL</a> in the <em>Amazon Aurora User Guide</em> .
         *                      <p>
         *                      <em>Aurora PostgreSQL</em>
         *                      <p>
         *                      For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <em>Amazon Aurora User Guide</em> .
         *                      <p>
         *                      <em>MySQL</em>
         *                      <p>
         *                      For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">Amazon RDS for MySQL</a> in the <em>Amazon RDS User Guide</em> .
         *                      <p>
         *                      <em>PostgreSQL</em>
         *                      <p>
         *                      For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL</a> in the <em>Amazon RDS User Guide</em> .
         *                      <p>
         *                      Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getGlobalClusterIdentifier}
         * @param globalClusterIdentifier If you are configuring an Aurora global database cluster and want your Aurora DB cluster to be a secondary member in the global database cluster, specify the global cluster ID of the global database cluster.
         *                                To define the primary database cluster of the global cluster, use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html">AWS::RDS::GlobalCluster</a> resource.
         *                                <p>
         *                                If you aren't configuring a global database cluster, don't specify this property.
         *                                <p>
         *                                <blockquote>
         *                                <p>
         *                                To remove the DB cluster from a global database cluster, specify an empty value for the <code>GlobalClusterIdentifier</code> property.
         *                                <p>
         *                                </blockquote>
         *                                <p>
         *                                For information about Aurora global databases, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html">Working with Amazon Aurora Global Databases</a> in the <em>Amazon Aurora User Guide</em> .
         *                                <p>
         *                                Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalClusterIdentifier(java.lang.String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getIops}
         * @param iops The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
         *             For information about valid IOPS values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Provisioned IOPS storage</a> in the <em>Amazon RDS User Guide</em> .
         *             <p>
         *             This setting is required to create a Multi-AZ DB cluster.
         *             <p>
         *             Valid for Cluster Type: Multi-AZ DB clusters only
         *             <p>
         *             Constraints:
         *             <p>
         *             <ul>
         *             <li>Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(java.lang.Number iops) {
            this.iops = iops;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getKmsKeyId}
         * @param kmsKeyId The Amazon Resource Name (ARN) of the AWS KMS key that is used to encrypt the database instances in the DB cluster, such as <code>arn:aws:kms:us-east-1:012345678910:key/abcd1234-a123-456a-a12b-a123b4cd56ef</code> .
         *                 If you enable the <code>StorageEncrypted</code> property but don't specify this property, the default KMS key is used. If you specify this property, you must set the <code>StorageEncrypted</code> property to <code>true</code> .
         *                 <p>
         *                 If you specify the <code>SnapshotIdentifier</code> property, the <code>StorageEncrypted</code> property value is inherited from the snapshot, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         *                 <p>
         *                 If you create a read replica of an encrypted DB cluster in another AWS Region, make sure to set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination AWS Region. This KMS key is used to encrypt the read replica in that AWS Region.
         *                 <p>
         *                 Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getManageMasterUserPassword}
         * @param manageMasterUserPassword Specifies whether to manage the master user password with AWS Secrets Manager.
         *                                 For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon Aurora User Guide.</em>
         *                                 <p>
         *                                 Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *                                 <p>
         *                                 Constraints:
         *                                 <p>
         *                                 <ul>
         *                                 <li>Can't manage the master user password with AWS Secrets Manager if <code>MasterUserPassword</code> is specified.</li>
         *                                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageMasterUserPassword(java.lang.Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getManageMasterUserPassword}
         * @param manageMasterUserPassword Specifies whether to manage the master user password with AWS Secrets Manager.
         *                                 For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon Aurora User Guide.</em>
         *                                 <p>
         *                                 Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *                                 <p>
         *                                 Constraints:
         *                                 <p>
         *                                 <ul>
         *                                 <li>Can't manage the master user password with AWS Secrets Manager if <code>MasterUserPassword</code> is specified.</li>
         *                                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manageMasterUserPassword(software.amazon.awscdk.IResolvable manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getMasterUsername}
         * @param masterUsername The name of the master user for the DB cluster.
         *                       <blockquote>
         *                       <p>
         *                       If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
         *                       <p>
         *                       </blockquote>
         *                       <p>
         *                       Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUsername(java.lang.String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getMasterUserPassword}
         * @param masterUserPassword The master password for the DB instance.
         *                           <blockquote>
         *                           <p>
         *                           If you specify the <code>SourceDBClusterIdentifier</code> , <code>SnapshotIdentifier</code> , or <code>GlobalClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, the snapshot, or the primary DB cluster for the global database cluster, respectively.
         *                           <p>
         *                           </blockquote>
         *                           <p>
         *                           Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserPassword(java.lang.String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getMasterUserSecret}
         * @param masterUserSecret The secret managed by RDS in AWS Secrets Manager for the master user password.
         *                         <blockquote>
         *                         <p>
         *                         When you restore a DB cluster from a snapshot, Amazon RDS generates a new secret instead of reusing the secret specified in the <code>SecretArn</code> property. This ensures that the restored DB cluster is securely managed with a dedicated secret. To maintain consistent integration with your application, you might need to update resource configurations to reference the newly created secret.
         *                         <p>
         *                         </blockquote>
         *                         <p>
         *                         For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon Aurora User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserSecret(software.amazon.awscdk.IResolvable masterUserSecret) {
            this.masterUserSecret = masterUserSecret;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getMasterUserSecret}
         * @param masterUserSecret The secret managed by RDS in AWS Secrets Manager for the master user password.
         *                         <blockquote>
         *                         <p>
         *                         When you restore a DB cluster from a snapshot, Amazon RDS generates a new secret instead of reusing the secret specified in the <code>SecretArn</code> property. This ensures that the restored DB cluster is securely managed with a dedicated secret. To maintain consistent integration with your application, you might need to update resource configurations to reference the newly created secret.
         *                         <p>
         *                         </blockquote>
         *                         <p>
         *                         For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon RDS User Guide</em> and <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html">Password management with AWS Secrets Manager</a> in the <em>Amazon Aurora User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUserSecret(software.amazon.awscdk.services.rds.CfnDBCluster.MasterUserSecretProperty masterUserSecret) {
            this.masterUserSecret = masterUserSecret;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getMonitoringInterval}
         * @param monitoringInterval The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
         *                           To turn off collecting Enhanced Monitoring metrics, specify <code>0</code> .
         *                           <p>
         *                           If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than <code>0</code> .
         *                           <p>
         *                           Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *                           <p>
         *                           Valid Values: <code>0 | 1 | 5 | 10 | 15 | 30 | 60</code>
         *                           <p>
         *                           Default: <code>0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringInterval(java.lang.Number monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getMonitoringRoleArn}
         * @param monitoringRoleArn The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
         *                          An example is <code>arn:aws:iam:123456789012:role/emaccess</code> . For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <em>Amazon RDS User Guide</em> .
         *                          <p>
         *                          If <code>MonitoringInterval</code> is set to a value other than <code>0</code> , supply a <code>MonitoringRoleArn</code> value.
         *                          <p>
         *                          Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringRoleArn(java.lang.String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getNetworkType}
         * @param networkType The network type of the DB cluster.
         *                    Valid values:
         *                    <p>
         *                    <ul>
         *                    <li><code>IPV4</code></li>
         *                    <li><code>DUAL</code></li>
         *                    </ul>
         *                    <p>
         *                    The network type is determined by the <code>DBSubnetGroup</code> specified for the DB cluster. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and IPv6 protocols ( <code>DUAL</code> ).
         *                    <p>
         *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html">Working with a DB instance in a VPC</a> in the <em>Amazon Aurora User Guide.</em>
         *                    <p>
         *                    Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkType(java.lang.String networkType) {
            this.networkType = networkType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPerformanceInsightsEnabled}
         * @param performanceInsightsEnabled Specifies whether to turn on Performance Insights for the DB cluster.
         *                                   For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         *                                   <p>
         *                                   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsEnabled(java.lang.Boolean performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPerformanceInsightsEnabled}
         * @param performanceInsightsEnabled Specifies whether to turn on Performance Insights for the DB cluster.
         *                                   For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <em>Amazon RDS User Guide</em> .
         *                                   <p>
         *                                   Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsEnabled(software.amazon.awscdk.IResolvable performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPerformanceInsightsKmsKeyId}
         * @param performanceInsightsKmsKeyId The AWS KMS key identifier for encryption of Performance Insights data.
         *                                    The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *                                    <p>
         *                                    If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code> , then Amazon RDS uses your default KMS key. There is a default KMS key for your AWS account . Your AWS account has a different default KMS key for each AWS Region .
         *                                    <p>
         *                                    Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsKmsKeyId(java.lang.String performanceInsightsKmsKeyId) {
            this.performanceInsightsKmsKeyId = performanceInsightsKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPerformanceInsightsRetentionPeriod}
         * @param performanceInsightsRetentionPeriod The number of days to retain Performance Insights data.
         *                                           When creating a DB cluster without enabling Performance Insights, you can't specify the parameter <code>PerformanceInsightsRetentionPeriod</code> .
         *                                           <p>
         *                                           Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *                                           <p>
         *                                           Valid Values:
         *                                           <p>
         *                                           <ul>
         *                                           <li><code>7</code></li>
         *                                           <li><em>month</em> * 31, where <em>month</em> is a number of months from 1-23. Examples: <code>93</code> (3 months * 31), <code>341</code> (11 months * 31), <code>589</code> (19 months * 31)</li>
         *                                           <li><code>731</code></li>
         *                                           </ul>
         *                                           <p>
         *                                           Default: <code>7</code> days
         *                                           <p>
         *                                           If you specify a retention period that isn't valid, such as <code>94</code> , Amazon RDS issues an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder performanceInsightsRetentionPeriod(java.lang.Number performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPort}
         * @param port The port number on which the DB instances in the DB cluster accept connections.
         *             Default:
         *             <p>
         *             <ul>
         *             <li>When <code>EngineMode</code> is <code>provisioned</code> , <code>3306</code> (for both Aurora MySQL and Aurora PostgreSQL)</li>
         *             <li>When <code>EngineMode</code> is <code>serverless</code> :</li>
         *             <li><code>3306</code> when <code>Engine</code> is <code>aurora</code> or <code>aurora-mysql</code></li>
         *             <li><code>5432</code> when <code>Engine</code> is <code>aurora-postgresql</code></li>
         *             </ul>
         *             <p>
         *             <blockquote>
         *             <p>
         *             The <code>No interruption</code> on update behavior only applies to DB clusters. If you are updating a DB instance, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html#cfn-rds-dbinstance-port">Port</a> for the AWS::RDS::DBInstance resource.
         *             <p>
         *             </blockquote>
         *             <p>
         *             Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPreferredBackupWindow}
         * @param preferredBackupWindow The daily time range during which automated backups are created.
         *                              For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">Backup Window</a> in the <em>Amazon Aurora User Guide.</em>
         *                              <p>
         *                              Constraints:
         *                              <p>
         *                              <ul>
         *                              <li>Must be in the format <code>hh24:mi-hh24:mi</code> .</li>
         *                              <li>Must be in Universal Coordinated Time (UTC).</li>
         *                              <li>Must not conflict with the preferred maintenance window.</li>
         *                              <li>Must be at least 30 minutes.</li>
         *                              </ul>
         *                              <p>
         *                              Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(java.lang.String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         *                                   Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
         *                                   <p>
         *                                   The default is a 30-minute window selected at random from an 8-hour block of time for each AWS Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">Maintaining an Amazon Aurora DB cluster</a> in the <em>Amazon Aurora User Guide.</em>
         *                                   <p>
         *                                   Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         *                                   <p>
         *                                   Constraints: Minimum 30-minute window.
         *                                   <p>
         *                                   Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPubliclyAccessible}
         * @param publiclyAccessible Specifies whether the DB cluster is publicly accessible.
         *                           When the DB cluster is publicly accessible and you connect from outside of the DB cluster's virtual private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from within the same VPC as the DB cluster, the endpoint resolves to the private IP address. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         *                           <p>
         *                           When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         *                           <p>
         *                           Valid for Cluster Type: Multi-AZ DB clusters only
         *                           <p>
         *                           Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *                           <p>
         *                           If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         *                           <p>
         *                           <ul>
         *                           <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
         *                           <li>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</li>
         *                           </ul>
         *                           <p>
         *                           If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         *                           <p>
         *                           <ul>
         *                           <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
         *                           <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getPubliclyAccessible}
         * @param publiclyAccessible Specifies whether the DB cluster is publicly accessible.
         *                           When the DB cluster is publicly accessible and you connect from outside of the DB cluster's virtual private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from within the same VPC as the DB cluster, the endpoint resolves to the private IP address. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         *                           <p>
         *                           When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         *                           <p>
         *                           Valid for Cluster Type: Multi-AZ DB clusters only
         *                           <p>
         *                           Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.
         *                           <p>
         *                           If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         *                           <p>
         *                           <ul>
         *                           <li>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
         *                           <li>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</li>
         *                           </ul>
         *                           <p>
         *                           If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:
         *                           <p>
         *                           <ul>
         *                           <li>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</li>
         *                           <li>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getReplicationSourceIdentifier}
         * @param replicationSourceIdentifier The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
         *                                    Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationSourceIdentifier(java.lang.String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getRestoreToTime}
         * @param restoreToTime The date and time to restore the DB cluster to.
         *                      Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         *                      <p>
         *                      Constraints:
         *                      <p>
         *                      <ul>
         *                      <li>Must be before the latest restorable time for the DB instance</li>
         *                      <li>Must be specified if <code>UseLatestRestorableTime</code> parameter isn't provided</li>
         *                      <li>Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled</li>
         *                      <li>Can't be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code></li>
         *                      </ul>
         *                      <p>
         *                      This property must be used with <code>SourceDBClusterIdentifier</code> property. The resulting cluster will have the identifier that matches the value of the <code>DBclusterIdentifier</code> property.
         *                      <p>
         *                      Example: <code>2015-03-07T23:45:00Z</code>
         *                      <p>
         *                      Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreToTime(java.lang.String restoreToTime) {
            this.restoreToTime = restoreToTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getRestoreType}
         * @param restoreType The type of restore to be performed. You can specify one of the following values:.
         *                    <ul>
         *                    <li><code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</li>
         *                    <li><code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</li>
         *                    </ul>
         *                    <p>
         *                    If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.
         *                    <p>
         *                    Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreType(java.lang.String restoreType) {
            this.restoreType = restoreType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getScalingConfiguration}
         * @param scalingConfiguration The scaling configuration of an Aurora Serverless v1 DB cluster.
         *                             This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the <code>ServerlessV2ScalingConfiguration</code> property.
         *                             <p>
         *                             Valid for: Aurora Serverless v1 DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(software.amazon.awscdk.IResolvable scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getScalingConfiguration}
         * @param scalingConfiguration The scaling configuration of an Aurora Serverless v1 DB cluster.
         *                             This property is only supported for Aurora Serverless v1. For Aurora Serverless v2, Use the <code>ServerlessV2ScalingConfiguration</code> property.
         *                             <p>
         *                             Valid for: Aurora Serverless v1 DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfiguration(software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getServerlessV2ScalingConfiguration}
         * @param serverlessV2ScalingConfiguration The scaling configuration of an Aurora Serverless V2 DB cluster.
         *                                         This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, Use the <code>ScalingConfiguration</code> property.
         *                                         <p>
         *                                         Valid for: Aurora Serverless v2 DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessV2ScalingConfiguration(software.amazon.awscdk.IResolvable serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getServerlessV2ScalingConfiguration}
         * @param serverlessV2ScalingConfiguration The scaling configuration of an Aurora Serverless V2 DB cluster.
         *                                         This property is only supported for Aurora Serverless v2. For Aurora Serverless v1, Use the <code>ScalingConfiguration</code> property.
         *                                         <p>
         *                                         Valid for: Aurora Serverless v2 DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverlessV2ScalingConfiguration(software.amazon.awscdk.services.rds.CfnDBCluster.ServerlessV2ScalingConfigurationProperty serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getSnapshotIdentifier}
         * @param snapshotIdentifier The identifier for the DB snapshot or DB cluster snapshot to restore from.
         *                           You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.
         *                           <p>
         *                           After you restore a DB cluster with a <code>SnapshotIdentifier</code> property, you must specify the same <code>SnapshotIdentifier</code> property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the snapshot again, and the data in the database is not changed. However, if you don't specify the <code>SnapshotIdentifier</code> property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified <code>SnapshotIdentifier</code> property, and the original DB cluster is deleted.
         *                           <p>
         *                           If you specify the <code>SnapshotIdentifier</code> property to restore a DB cluster (as opposed to specifying it for DB cluster updates), then don't specify the following properties:
         *                           <p>
         *                           <ul>
         *                           <li><code>GlobalClusterIdentifier</code></li>
         *                           <li><code>MasterUsername</code></li>
         *                           <li><code>MasterUserPassword</code></li>
         *                           <li><code>ReplicationSourceIdentifier</code></li>
         *                           <li><code>RestoreType</code></li>
         *                           <li><code>SourceDBClusterIdentifier</code></li>
         *                           <li><code>SourceRegion</code></li>
         *                           <li><code>StorageEncrypted</code> (for an encrypted snapshot)</li>
         *                           <li><code>UseLatestRestorableTime</code></li>
         *                           </ul>
         *                           <p>
         *                           Constraints:
         *                           <p>
         *                           <ul>
         *                           <li>Must match the identifier of an existing Snapshot.</li>
         *                           </ul>
         *                           <p>
         *                           Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotIdentifier(java.lang.String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getSourceDbClusterIdentifier}
         * @param sourceDbClusterIdentifier When restoring a DB cluster to a point in time, the identifier of the source DB cluster from which to restore.
         *                                  Constraints:
         *                                  <p>
         *                                  <ul>
         *                                  <li>Must match the identifier of an existing DBCluster.</li>
         *                                  <li>Cannot be specified if <code>SourceDbClusterResourceId</code> is specified. You must specify either <code>SourceDBClusterIdentifier</code> or <code>SourceDbClusterResourceId</code> , but not both.</li>
         *                                  </ul>
         *                                  <p>
         *                                  Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterIdentifier(java.lang.String sourceDbClusterIdentifier) {
            this.sourceDbClusterIdentifier = sourceDbClusterIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getSourceDbClusterResourceId}
         * @param sourceDbClusterResourceId The resource ID of the source DB cluster from which to restore.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDbClusterResourceId(java.lang.String sourceDbClusterResourceId) {
            this.sourceDbClusterResourceId = sourceDbClusterResourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getSourceRegion}
         * @param sourceRegion The AWS Region which contains the source DB cluster when replicating a DB cluster. For example, <code>us-east-1</code> .
         *                     Valid for: Aurora DB clusters only
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceRegion(java.lang.String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getStorageEncrypted}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted.
         *                         If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         *                         <p>
         *                         If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         If you specify both the <code>StorageEncrypted</code> and <code>SnapshotIdentifier</code> properties without specifying the <code>KmsKeyId</code> property, then the restored DB cluster inherits the encryption settings from the DB snapshot that provide.
         *                         <p>
         *                         </blockquote>
         *                         <p>
         *                         Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(java.lang.Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getStorageEncrypted}
         * @param storageEncrypted Indicates whether the DB cluster is encrypted.
         *                         If you specify the <code>KmsKeyId</code> property, then you must enable encryption.
         *                         <p>
         *                         If you specify the <code>SourceDBClusterIdentifier</code> property, don't specify this property. The value is inherited from the source DB cluster, and if the DB cluster is encrypted, the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SnapshotIdentifier</code> and the specified snapshot is encrypted, don't specify this property. The value is inherited from the snapshot, and the specified <code>KmsKeyId</code> property is used.
         *                         <p>
         *                         If you specify the <code>SnapshotIdentifier</code> and the specified snapshot isn't encrypted, you can use this property to specify that the restored DB cluster is encrypted. Specify the <code>KmsKeyId</code> property for the KMS key to use for encryption. If you don't want the restored DB cluster to be encrypted, then don't set this property or set it to <code>false</code> .
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         If you specify both the <code>StorageEncrypted</code> and <code>SnapshotIdentifier</code> properties without specifying the <code>KmsKeyId</code> property, then the restored DB cluster inherits the encryption settings from the DB snapshot that provide.
         *                         <p>
         *                         </blockquote>
         *                         <p>
         *                         Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(software.amazon.awscdk.IResolvable storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getStorageType}
         * @param storageType The storage type to associate with the DB cluster.
         *                    For information on storage types for Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type">Storage configurations for Amazon Aurora DB clusters</a> . For information on storage types for Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings">Settings for creating Multi-AZ DB clusters</a> .
         *                    <p>
         *                    This setting is required to create a Multi-AZ DB cluster.
         *                    <p>
         *                    When specified for a Multi-AZ DB cluster, a value for the <code>Iops</code> parameter is required.
         *                    <p>
         *                    Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *                    <p>
         *                    Valid Values:
         *                    <p>
         *                    <ul>
         *                    <li>Aurora DB clusters - <code>aurora | aurora-iopt1</code></li>
         *                    <li>Multi-AZ DB clusters - <code>io1 | io2 | gp3</code></li>
         *                    </ul>
         *                    <p>
         *                    Default:
         *                    <p>
         *                    <ul>
         *                    <li>Aurora DB clusters - <code>aurora</code></li>
         *                    <li>Multi-AZ DB clusters - <code>io1</code></li>
         *                    </ul>
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    When you create an Aurora DB cluster with the storage type set to <code>aurora-iopt1</code> , the storage type is returned in the response. The storage type isn't returned when you set it to <code>aurora</code> .
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(java.lang.String storageType) {
            this.storageType = storageType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getTags}
         * @param tags Tags to assign to the DB cluster.
         *             Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getUseLatestRestorableTime}
         * @param useLatestRestorableTime A value that indicates whether to restore the DB cluster to the latest restorable backup time.
         *                                By default, the DB cluster is not restored to the latest restorable backup time.
         *                                <p>
         *                                Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(java.lang.Boolean useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getUseLatestRestorableTime}
         * @param useLatestRestorableTime A value that indicates whether to restore the DB cluster to the latest restorable backup time.
         *                                By default, the DB cluster is not restored to the latest restorable backup time.
         *                                <p>
         *                                Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useLatestRestorableTime(software.amazon.awscdk.IResolvable useLatestRestorableTime) {
            this.useLatestRestorableTime = useLatestRestorableTime;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBClusterProps#getVpcSecurityGroupIds}
         * @param vpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster.
         *                            If you plan to update the resource, don't specify VPC security groups in a shared VPC.
         *                            <p>
         *                            Valid for: Aurora DB clusters and Multi-AZ DB clusters
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = vpcSecurityGroupIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBClusterProps {
        private final java.lang.Number allocatedStorage;
        private final java.lang.Object associatedRoles;
        private final java.lang.Object autoMinorVersionUpgrade;
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Number backtrackWindow;
        private final java.lang.Number backupRetentionPeriod;
        private final java.lang.String clusterScalabilityType;
        private final java.lang.Object copyTagsToSnapshot;
        private final java.lang.String databaseInsightsMode;
        private final java.lang.String databaseName;
        private final java.lang.String dbClusterIdentifier;
        private final java.lang.String dbClusterInstanceClass;
        private final java.lang.String dbClusterParameterGroupName;
        private final java.lang.String dbInstanceParameterGroupName;
        private final java.lang.String dbSubnetGroupName;
        private final java.lang.String dbSystemId;
        private final java.lang.Object deleteAutomatedBackups;
        private final java.lang.Object deletionProtection;
        private final java.lang.String domain;
        private final java.lang.String domainIamRoleName;
        private final java.util.List<java.lang.String> enableCloudwatchLogsExports;
        private final java.lang.Object enableGlobalWriteForwarding;
        private final java.lang.Object enableHttpEndpoint;
        private final java.lang.Object enableIamDatabaseAuthentication;
        private final java.lang.Object enableLocalWriteForwarding;
        private final java.lang.String engine;
        private final java.lang.String engineLifecycleSupport;
        private final java.lang.String engineMode;
        private final java.lang.String engineVersion;
        private final java.lang.String globalClusterIdentifier;
        private final java.lang.Number iops;
        private final java.lang.String kmsKeyId;
        private final java.lang.Object manageMasterUserPassword;
        private final java.lang.String masterUsername;
        private final java.lang.String masterUserPassword;
        private final java.lang.Object masterUserSecret;
        private final java.lang.Number monitoringInterval;
        private final java.lang.String monitoringRoleArn;
        private final java.lang.String networkType;
        private final java.lang.Object performanceInsightsEnabled;
        private final java.lang.String performanceInsightsKmsKeyId;
        private final java.lang.Number performanceInsightsRetentionPeriod;
        private final java.lang.Number port;
        private final java.lang.String preferredBackupWindow;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.lang.Object publiclyAccessible;
        private final java.lang.String replicationSourceIdentifier;
        private final java.lang.String restoreToTime;
        private final java.lang.String restoreType;
        private final java.lang.Object scalingConfiguration;
        private final java.lang.Object serverlessV2ScalingConfiguration;
        private final java.lang.String snapshotIdentifier;
        private final java.lang.String sourceDbClusterIdentifier;
        private final java.lang.String sourceDbClusterResourceId;
        private final java.lang.String sourceRegion;
        private final java.lang.Object storageEncrypted;
        private final java.lang.String storageType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object useLatestRestorableTime;
        private final java.util.List<java.lang.String> vpcSecurityGroupIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allocatedStorage = software.amazon.jsii.Kernel.get(this, "allocatedStorage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.associatedRoles = software.amazon.jsii.Kernel.get(this, "associatedRoles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoMinorVersionUpgrade = software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.backtrackWindow = software.amazon.jsii.Kernel.get(this, "backtrackWindow", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.backupRetentionPeriod = software.amazon.jsii.Kernel.get(this, "backupRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.clusterScalabilityType = software.amazon.jsii.Kernel.get(this, "clusterScalabilityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.copyTagsToSnapshot = software.amazon.jsii.Kernel.get(this, "copyTagsToSnapshot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.databaseInsightsMode = software.amazon.jsii.Kernel.get(this, "databaseInsightsMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "dbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusterInstanceClass = software.amazon.jsii.Kernel.get(this, "dbClusterInstanceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbClusterParameterGroupName = software.amazon.jsii.Kernel.get(this, "dbClusterParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbInstanceParameterGroupName = software.amazon.jsii.Kernel.get(this, "dbInstanceParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbSubnetGroupName = software.amazon.jsii.Kernel.get(this, "dbSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dbSystemId = software.amazon.jsii.Kernel.get(this, "dbSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deleteAutomatedBackups = software.amazon.jsii.Kernel.get(this, "deleteAutomatedBackups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deletionProtection = software.amazon.jsii.Kernel.get(this, "deletionProtection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainIamRoleName = software.amazon.jsii.Kernel.get(this, "domainIamRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableCloudwatchLogsExports = software.amazon.jsii.Kernel.get(this, "enableCloudwatchLogsExports", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.enableGlobalWriteForwarding = software.amazon.jsii.Kernel.get(this, "enableGlobalWriteForwarding", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableHttpEndpoint = software.amazon.jsii.Kernel.get(this, "enableHttpEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableIamDatabaseAuthentication = software.amazon.jsii.Kernel.get(this, "enableIamDatabaseAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableLocalWriteForwarding = software.amazon.jsii.Kernel.get(this, "enableLocalWriteForwarding", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineLifecycleSupport = software.amazon.jsii.Kernel.get(this, "engineLifecycleSupport", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineMode = software.amazon.jsii.Kernel.get(this, "engineMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalClusterIdentifier = software.amazon.jsii.Kernel.get(this, "globalClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.manageMasterUserPassword = software.amazon.jsii.Kernel.get(this, "manageMasterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.masterUsername = software.amazon.jsii.Kernel.get(this, "masterUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserPassword = software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.masterUserSecret = software.amazon.jsii.Kernel.get(this, "masterUserSecret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.monitoringInterval = software.amazon.jsii.Kernel.get(this, "monitoringInterval", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.monitoringRoleArn = software.amazon.jsii.Kernel.get(this, "monitoringRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkType = software.amazon.jsii.Kernel.get(this, "networkType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.performanceInsightsEnabled = software.amazon.jsii.Kernel.get(this, "performanceInsightsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.performanceInsightsKmsKeyId = software.amazon.jsii.Kernel.get(this, "performanceInsightsKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.performanceInsightsRetentionPeriod = software.amazon.jsii.Kernel.get(this, "performanceInsightsRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.preferredBackupWindow = software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replicationSourceIdentifier = software.amazon.jsii.Kernel.get(this, "replicationSourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreToTime = software.amazon.jsii.Kernel.get(this, "restoreToTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreType = software.amazon.jsii.Kernel.get(this, "restoreType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scalingConfiguration = software.amazon.jsii.Kernel.get(this, "scalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serverlessV2ScalingConfiguration = software.amazon.jsii.Kernel.get(this, "serverlessV2ScalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotIdentifier = software.amazon.jsii.Kernel.get(this, "snapshotIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceDbClusterIdentifier = software.amazon.jsii.Kernel.get(this, "sourceDbClusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceDbClusterResourceId = software.amazon.jsii.Kernel.get(this, "sourceDbClusterResourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceRegion = software.amazon.jsii.Kernel.get(this, "sourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.storageEncrypted = software.amazon.jsii.Kernel.get(this, "storageEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.useLatestRestorableTime = software.amazon.jsii.Kernel.get(this, "useLatestRestorableTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcSecurityGroupIds = software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allocatedStorage = builder.allocatedStorage;
            this.associatedRoles = builder.associatedRoles;
            this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
            this.availabilityZones = builder.availabilityZones;
            this.backtrackWindow = builder.backtrackWindow;
            this.backupRetentionPeriod = builder.backupRetentionPeriod;
            this.clusterScalabilityType = builder.clusterScalabilityType;
            this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
            this.databaseInsightsMode = builder.databaseInsightsMode;
            this.databaseName = builder.databaseName;
            this.dbClusterIdentifier = builder.dbClusterIdentifier;
            this.dbClusterInstanceClass = builder.dbClusterInstanceClass;
            this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
            this.dbInstanceParameterGroupName = builder.dbInstanceParameterGroupName;
            this.dbSubnetGroupName = builder.dbSubnetGroupName;
            this.dbSystemId = builder.dbSystemId;
            this.deleteAutomatedBackups = builder.deleteAutomatedBackups;
            this.deletionProtection = builder.deletionProtection;
            this.domain = builder.domain;
            this.domainIamRoleName = builder.domainIamRoleName;
            this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
            this.enableGlobalWriteForwarding = builder.enableGlobalWriteForwarding;
            this.enableHttpEndpoint = builder.enableHttpEndpoint;
            this.enableIamDatabaseAuthentication = builder.enableIamDatabaseAuthentication;
            this.enableLocalWriteForwarding = builder.enableLocalWriteForwarding;
            this.engine = builder.engine;
            this.engineLifecycleSupport = builder.engineLifecycleSupport;
            this.engineMode = builder.engineMode;
            this.engineVersion = builder.engineVersion;
            this.globalClusterIdentifier = builder.globalClusterIdentifier;
            this.iops = builder.iops;
            this.kmsKeyId = builder.kmsKeyId;
            this.manageMasterUserPassword = builder.manageMasterUserPassword;
            this.masterUsername = builder.masterUsername;
            this.masterUserPassword = builder.masterUserPassword;
            this.masterUserSecret = builder.masterUserSecret;
            this.monitoringInterval = builder.monitoringInterval;
            this.monitoringRoleArn = builder.monitoringRoleArn;
            this.networkType = builder.networkType;
            this.performanceInsightsEnabled = builder.performanceInsightsEnabled;
            this.performanceInsightsKmsKeyId = builder.performanceInsightsKmsKeyId;
            this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
            this.port = builder.port;
            this.preferredBackupWindow = builder.preferredBackupWindow;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.publiclyAccessible = builder.publiclyAccessible;
            this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
            this.restoreToTime = builder.restoreToTime;
            this.restoreType = builder.restoreType;
            this.scalingConfiguration = builder.scalingConfiguration;
            this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
            this.snapshotIdentifier = builder.snapshotIdentifier;
            this.sourceDbClusterIdentifier = builder.sourceDbClusterIdentifier;
            this.sourceDbClusterResourceId = builder.sourceDbClusterResourceId;
            this.sourceRegion = builder.sourceRegion;
            this.storageEncrypted = builder.storageEncrypted;
            this.storageType = builder.storageType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.useLatestRestorableTime = builder.useLatestRestorableTime;
            this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        }

        @Override
        public final java.lang.Number getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final java.lang.Object getAssociatedRoles() {
            return this.associatedRoles;
        }

        @Override
        public final java.lang.Object getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final java.lang.Number getBacktrackWindow() {
            return this.backtrackWindow;
        }

        @Override
        public final java.lang.Number getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final java.lang.String getClusterScalabilityType() {
            return this.clusterScalabilityType;
        }

        @Override
        public final java.lang.Object getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        @Override
        public final java.lang.String getDatabaseInsightsMode() {
            return this.databaseInsightsMode;
        }

        @Override
        public final java.lang.String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final java.lang.String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final java.lang.String getDbClusterInstanceClass() {
            return this.dbClusterInstanceClass;
        }

        @Override
        public final java.lang.String getDbClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final java.lang.String getDbInstanceParameterGroupName() {
            return this.dbInstanceParameterGroupName;
        }

        @Override
        public final java.lang.String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        @Override
        public final java.lang.String getDbSystemId() {
            return this.dbSystemId;
        }

        @Override
        public final java.lang.Object getDeleteAutomatedBackups() {
            return this.deleteAutomatedBackups;
        }

        @Override
        public final java.lang.Object getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.String getDomainIamRoleName() {
            return this.domainIamRoleName;
        }

        @Override
        public final java.util.List<java.lang.String> getEnableCloudwatchLogsExports() {
            return this.enableCloudwatchLogsExports;
        }

        @Override
        public final java.lang.Object getEnableGlobalWriteForwarding() {
            return this.enableGlobalWriteForwarding;
        }

        @Override
        public final java.lang.Object getEnableHttpEndpoint() {
            return this.enableHttpEndpoint;
        }

        @Override
        public final java.lang.Object getEnableIamDatabaseAuthentication() {
            return this.enableIamDatabaseAuthentication;
        }

        @Override
        public final java.lang.Object getEnableLocalWriteForwarding() {
            return this.enableLocalWriteForwarding;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getEngineLifecycleSupport() {
            return this.engineLifecycleSupport;
        }

        @Override
        public final java.lang.String getEngineMode() {
            return this.engineMode;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        @Override
        public final java.lang.Number getIops() {
            return this.iops;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.Object getManageMasterUserPassword() {
            return this.manageMasterUserPassword;
        }

        @Override
        public final java.lang.String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final java.lang.String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        @Override
        public final java.lang.Object getMasterUserSecret() {
            return this.masterUserSecret;
        }

        @Override
        public final java.lang.Number getMonitoringInterval() {
            return this.monitoringInterval;
        }

        @Override
        public final java.lang.String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        @Override
        public final java.lang.String getNetworkType() {
            return this.networkType;
        }

        @Override
        public final java.lang.Object getPerformanceInsightsEnabled() {
            return this.performanceInsightsEnabled;
        }

        @Override
        public final java.lang.String getPerformanceInsightsKmsKeyId() {
            return this.performanceInsightsKmsKeyId;
        }

        @Override
        public final java.lang.Number getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final java.lang.String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.lang.Object getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final java.lang.String getReplicationSourceIdentifier() {
            return this.replicationSourceIdentifier;
        }

        @Override
        public final java.lang.String getRestoreToTime() {
            return this.restoreToTime;
        }

        @Override
        public final java.lang.String getRestoreType() {
            return this.restoreType;
        }

        @Override
        public final java.lang.Object getScalingConfiguration() {
            return this.scalingConfiguration;
        }

        @Override
        public final java.lang.Object getServerlessV2ScalingConfiguration() {
            return this.serverlessV2ScalingConfiguration;
        }

        @Override
        public final java.lang.String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final java.lang.String getSourceDbClusterIdentifier() {
            return this.sourceDbClusterIdentifier;
        }

        @Override
        public final java.lang.String getSourceDbClusterResourceId() {
            return this.sourceDbClusterResourceId;
        }

        @Override
        public final java.lang.String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final java.lang.Object getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final java.lang.String getStorageType() {
            return this.storageType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getUseLatestRestorableTime() {
            return this.useLatestRestorableTime;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllocatedStorage() != null) {
                data.set("allocatedStorage", om.valueToTree(this.getAllocatedStorage()));
            }
            if (this.getAssociatedRoles() != null) {
                data.set("associatedRoles", om.valueToTree(this.getAssociatedRoles()));
            }
            if (this.getAutoMinorVersionUpgrade() != null) {
                data.set("autoMinorVersionUpgrade", om.valueToTree(this.getAutoMinorVersionUpgrade()));
            }
            if (this.getAvailabilityZones() != null) {
                data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            }
            if (this.getBacktrackWindow() != null) {
                data.set("backtrackWindow", om.valueToTree(this.getBacktrackWindow()));
            }
            if (this.getBackupRetentionPeriod() != null) {
                data.set("backupRetentionPeriod", om.valueToTree(this.getBackupRetentionPeriod()));
            }
            if (this.getClusterScalabilityType() != null) {
                data.set("clusterScalabilityType", om.valueToTree(this.getClusterScalabilityType()));
            }
            if (this.getCopyTagsToSnapshot() != null) {
                data.set("copyTagsToSnapshot", om.valueToTree(this.getCopyTagsToSnapshot()));
            }
            if (this.getDatabaseInsightsMode() != null) {
                data.set("databaseInsightsMode", om.valueToTree(this.getDatabaseInsightsMode()));
            }
            if (this.getDatabaseName() != null) {
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
            }
            if (this.getDbClusterIdentifier() != null) {
                data.set("dbClusterIdentifier", om.valueToTree(this.getDbClusterIdentifier()));
            }
            if (this.getDbClusterInstanceClass() != null) {
                data.set("dbClusterInstanceClass", om.valueToTree(this.getDbClusterInstanceClass()));
            }
            if (this.getDbClusterParameterGroupName() != null) {
                data.set("dbClusterParameterGroupName", om.valueToTree(this.getDbClusterParameterGroupName()));
            }
            if (this.getDbInstanceParameterGroupName() != null) {
                data.set("dbInstanceParameterGroupName", om.valueToTree(this.getDbInstanceParameterGroupName()));
            }
            if (this.getDbSubnetGroupName() != null) {
                data.set("dbSubnetGroupName", om.valueToTree(this.getDbSubnetGroupName()));
            }
            if (this.getDbSystemId() != null) {
                data.set("dbSystemId", om.valueToTree(this.getDbSystemId()));
            }
            if (this.getDeleteAutomatedBackups() != null) {
                data.set("deleteAutomatedBackups", om.valueToTree(this.getDeleteAutomatedBackups()));
            }
            if (this.getDeletionProtection() != null) {
                data.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
            }
            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getDomainIamRoleName() != null) {
                data.set("domainIamRoleName", om.valueToTree(this.getDomainIamRoleName()));
            }
            if (this.getEnableCloudwatchLogsExports() != null) {
                data.set("enableCloudwatchLogsExports", om.valueToTree(this.getEnableCloudwatchLogsExports()));
            }
            if (this.getEnableGlobalWriteForwarding() != null) {
                data.set("enableGlobalWriteForwarding", om.valueToTree(this.getEnableGlobalWriteForwarding()));
            }
            if (this.getEnableHttpEndpoint() != null) {
                data.set("enableHttpEndpoint", om.valueToTree(this.getEnableHttpEndpoint()));
            }
            if (this.getEnableIamDatabaseAuthentication() != null) {
                data.set("enableIamDatabaseAuthentication", om.valueToTree(this.getEnableIamDatabaseAuthentication()));
            }
            if (this.getEnableLocalWriteForwarding() != null) {
                data.set("enableLocalWriteForwarding", om.valueToTree(this.getEnableLocalWriteForwarding()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getEngineLifecycleSupport() != null) {
                data.set("engineLifecycleSupport", om.valueToTree(this.getEngineLifecycleSupport()));
            }
            if (this.getEngineMode() != null) {
                data.set("engineMode", om.valueToTree(this.getEngineMode()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getGlobalClusterIdentifier() != null) {
                data.set("globalClusterIdentifier", om.valueToTree(this.getGlobalClusterIdentifier()));
            }
            if (this.getIops() != null) {
                data.set("iops", om.valueToTree(this.getIops()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getManageMasterUserPassword() != null) {
                data.set("manageMasterUserPassword", om.valueToTree(this.getManageMasterUserPassword()));
            }
            if (this.getMasterUsername() != null) {
                data.set("masterUsername", om.valueToTree(this.getMasterUsername()));
            }
            if (this.getMasterUserPassword() != null) {
                data.set("masterUserPassword", om.valueToTree(this.getMasterUserPassword()));
            }
            if (this.getMasterUserSecret() != null) {
                data.set("masterUserSecret", om.valueToTree(this.getMasterUserSecret()));
            }
            if (this.getMonitoringInterval() != null) {
                data.set("monitoringInterval", om.valueToTree(this.getMonitoringInterval()));
            }
            if (this.getMonitoringRoleArn() != null) {
                data.set("monitoringRoleArn", om.valueToTree(this.getMonitoringRoleArn()));
            }
            if (this.getNetworkType() != null) {
                data.set("networkType", om.valueToTree(this.getNetworkType()));
            }
            if (this.getPerformanceInsightsEnabled() != null) {
                data.set("performanceInsightsEnabled", om.valueToTree(this.getPerformanceInsightsEnabled()));
            }
            if (this.getPerformanceInsightsKmsKeyId() != null) {
                data.set("performanceInsightsKmsKeyId", om.valueToTree(this.getPerformanceInsightsKmsKeyId()));
            }
            if (this.getPerformanceInsightsRetentionPeriod() != null) {
                data.set("performanceInsightsRetentionPeriod", om.valueToTree(this.getPerformanceInsightsRetentionPeriod()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getPreferredBackupWindow() != null) {
                data.set("preferredBackupWindow", om.valueToTree(this.getPreferredBackupWindow()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getPubliclyAccessible() != null) {
                data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
            }
            if (this.getReplicationSourceIdentifier() != null) {
                data.set("replicationSourceIdentifier", om.valueToTree(this.getReplicationSourceIdentifier()));
            }
            if (this.getRestoreToTime() != null) {
                data.set("restoreToTime", om.valueToTree(this.getRestoreToTime()));
            }
            if (this.getRestoreType() != null) {
                data.set("restoreType", om.valueToTree(this.getRestoreType()));
            }
            if (this.getScalingConfiguration() != null) {
                data.set("scalingConfiguration", om.valueToTree(this.getScalingConfiguration()));
            }
            if (this.getServerlessV2ScalingConfiguration() != null) {
                data.set("serverlessV2ScalingConfiguration", om.valueToTree(this.getServerlessV2ScalingConfiguration()));
            }
            if (this.getSnapshotIdentifier() != null) {
                data.set("snapshotIdentifier", om.valueToTree(this.getSnapshotIdentifier()));
            }
            if (this.getSourceDbClusterIdentifier() != null) {
                data.set("sourceDbClusterIdentifier", om.valueToTree(this.getSourceDbClusterIdentifier()));
            }
            if (this.getSourceDbClusterResourceId() != null) {
                data.set("sourceDbClusterResourceId", om.valueToTree(this.getSourceDbClusterResourceId()));
            }
            if (this.getSourceRegion() != null) {
                data.set("sourceRegion", om.valueToTree(this.getSourceRegion()));
            }
            if (this.getStorageEncrypted() != null) {
                data.set("storageEncrypted", om.valueToTree(this.getStorageEncrypted()));
            }
            if (this.getStorageType() != null) {
                data.set("storageType", om.valueToTree(this.getStorageType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUseLatestRestorableTime() != null) {
                data.set("useLatestRestorableTime", om.valueToTree(this.getUseLatestRestorableTime()));
            }
            if (this.getVpcSecurityGroupIds() != null) {
                data.set("vpcSecurityGroupIds", om.valueToTree(this.getVpcSecurityGroupIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBClusterProps.Jsii$Proxy that = (CfnDBClusterProps.Jsii$Proxy) o;

            if (this.allocatedStorage != null ? !this.allocatedStorage.equals(that.allocatedStorage) : that.allocatedStorage != null) return false;
            if (this.associatedRoles != null ? !this.associatedRoles.equals(that.associatedRoles) : that.associatedRoles != null) return false;
            if (this.autoMinorVersionUpgrade != null ? !this.autoMinorVersionUpgrade.equals(that.autoMinorVersionUpgrade) : that.autoMinorVersionUpgrade != null) return false;
            if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
            if (this.backtrackWindow != null ? !this.backtrackWindow.equals(that.backtrackWindow) : that.backtrackWindow != null) return false;
            if (this.backupRetentionPeriod != null ? !this.backupRetentionPeriod.equals(that.backupRetentionPeriod) : that.backupRetentionPeriod != null) return false;
            if (this.clusterScalabilityType != null ? !this.clusterScalabilityType.equals(that.clusterScalabilityType) : that.clusterScalabilityType != null) return false;
            if (this.copyTagsToSnapshot != null ? !this.copyTagsToSnapshot.equals(that.copyTagsToSnapshot) : that.copyTagsToSnapshot != null) return false;
            if (this.databaseInsightsMode != null ? !this.databaseInsightsMode.equals(that.databaseInsightsMode) : that.databaseInsightsMode != null) return false;
            if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
            if (this.dbClusterIdentifier != null ? !this.dbClusterIdentifier.equals(that.dbClusterIdentifier) : that.dbClusterIdentifier != null) return false;
            if (this.dbClusterInstanceClass != null ? !this.dbClusterInstanceClass.equals(that.dbClusterInstanceClass) : that.dbClusterInstanceClass != null) return false;
            if (this.dbClusterParameterGroupName != null ? !this.dbClusterParameterGroupName.equals(that.dbClusterParameterGroupName) : that.dbClusterParameterGroupName != null) return false;
            if (this.dbInstanceParameterGroupName != null ? !this.dbInstanceParameterGroupName.equals(that.dbInstanceParameterGroupName) : that.dbInstanceParameterGroupName != null) return false;
            if (this.dbSubnetGroupName != null ? !this.dbSubnetGroupName.equals(that.dbSubnetGroupName) : that.dbSubnetGroupName != null) return false;
            if (this.dbSystemId != null ? !this.dbSystemId.equals(that.dbSystemId) : that.dbSystemId != null) return false;
            if (this.deleteAutomatedBackups != null ? !this.deleteAutomatedBackups.equals(that.deleteAutomatedBackups) : that.deleteAutomatedBackups != null) return false;
            if (this.deletionProtection != null ? !this.deletionProtection.equals(that.deletionProtection) : that.deletionProtection != null) return false;
            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.domainIamRoleName != null ? !this.domainIamRoleName.equals(that.domainIamRoleName) : that.domainIamRoleName != null) return false;
            if (this.enableCloudwatchLogsExports != null ? !this.enableCloudwatchLogsExports.equals(that.enableCloudwatchLogsExports) : that.enableCloudwatchLogsExports != null) return false;
            if (this.enableGlobalWriteForwarding != null ? !this.enableGlobalWriteForwarding.equals(that.enableGlobalWriteForwarding) : that.enableGlobalWriteForwarding != null) return false;
            if (this.enableHttpEndpoint != null ? !this.enableHttpEndpoint.equals(that.enableHttpEndpoint) : that.enableHttpEndpoint != null) return false;
            if (this.enableIamDatabaseAuthentication != null ? !this.enableIamDatabaseAuthentication.equals(that.enableIamDatabaseAuthentication) : that.enableIamDatabaseAuthentication != null) return false;
            if (this.enableLocalWriteForwarding != null ? !this.enableLocalWriteForwarding.equals(that.enableLocalWriteForwarding) : that.enableLocalWriteForwarding != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.engineLifecycleSupport != null ? !this.engineLifecycleSupport.equals(that.engineLifecycleSupport) : that.engineLifecycleSupport != null) return false;
            if (this.engineMode != null ? !this.engineMode.equals(that.engineMode) : that.engineMode != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.globalClusterIdentifier != null ? !this.globalClusterIdentifier.equals(that.globalClusterIdentifier) : that.globalClusterIdentifier != null) return false;
            if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.manageMasterUserPassword != null ? !this.manageMasterUserPassword.equals(that.manageMasterUserPassword) : that.manageMasterUserPassword != null) return false;
            if (this.masterUsername != null ? !this.masterUsername.equals(that.masterUsername) : that.masterUsername != null) return false;
            if (this.masterUserPassword != null ? !this.masterUserPassword.equals(that.masterUserPassword) : that.masterUserPassword != null) return false;
            if (this.masterUserSecret != null ? !this.masterUserSecret.equals(that.masterUserSecret) : that.masterUserSecret != null) return false;
            if (this.monitoringInterval != null ? !this.monitoringInterval.equals(that.monitoringInterval) : that.monitoringInterval != null) return false;
            if (this.monitoringRoleArn != null ? !this.monitoringRoleArn.equals(that.monitoringRoleArn) : that.monitoringRoleArn != null) return false;
            if (this.networkType != null ? !this.networkType.equals(that.networkType) : that.networkType != null) return false;
            if (this.performanceInsightsEnabled != null ? !this.performanceInsightsEnabled.equals(that.performanceInsightsEnabled) : that.performanceInsightsEnabled != null) return false;
            if (this.performanceInsightsKmsKeyId != null ? !this.performanceInsightsKmsKeyId.equals(that.performanceInsightsKmsKeyId) : that.performanceInsightsKmsKeyId != null) return false;
            if (this.performanceInsightsRetentionPeriod != null ? !this.performanceInsightsRetentionPeriod.equals(that.performanceInsightsRetentionPeriod) : that.performanceInsightsRetentionPeriod != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.preferredBackupWindow != null ? !this.preferredBackupWindow.equals(that.preferredBackupWindow) : that.preferredBackupWindow != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
            if (this.replicationSourceIdentifier != null ? !this.replicationSourceIdentifier.equals(that.replicationSourceIdentifier) : that.replicationSourceIdentifier != null) return false;
            if (this.restoreToTime != null ? !this.restoreToTime.equals(that.restoreToTime) : that.restoreToTime != null) return false;
            if (this.restoreType != null ? !this.restoreType.equals(that.restoreType) : that.restoreType != null) return false;
            if (this.scalingConfiguration != null ? !this.scalingConfiguration.equals(that.scalingConfiguration) : that.scalingConfiguration != null) return false;
            if (this.serverlessV2ScalingConfiguration != null ? !this.serverlessV2ScalingConfiguration.equals(that.serverlessV2ScalingConfiguration) : that.serverlessV2ScalingConfiguration != null) return false;
            if (this.snapshotIdentifier != null ? !this.snapshotIdentifier.equals(that.snapshotIdentifier) : that.snapshotIdentifier != null) return false;
            if (this.sourceDbClusterIdentifier != null ? !this.sourceDbClusterIdentifier.equals(that.sourceDbClusterIdentifier) : that.sourceDbClusterIdentifier != null) return false;
            if (this.sourceDbClusterResourceId != null ? !this.sourceDbClusterResourceId.equals(that.sourceDbClusterResourceId) : that.sourceDbClusterResourceId != null) return false;
            if (this.sourceRegion != null ? !this.sourceRegion.equals(that.sourceRegion) : that.sourceRegion != null) return false;
            if (this.storageEncrypted != null ? !this.storageEncrypted.equals(that.storageEncrypted) : that.storageEncrypted != null) return false;
            if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.useLatestRestorableTime != null ? !this.useLatestRestorableTime.equals(that.useLatestRestorableTime) : that.useLatestRestorableTime != null) return false;
            return this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.equals(that.vpcSecurityGroupIds) : that.vpcSecurityGroupIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allocatedStorage != null ? this.allocatedStorage.hashCode() : 0;
            result = 31 * result + (this.associatedRoles != null ? this.associatedRoles.hashCode() : 0);
            result = 31 * result + (this.autoMinorVersionUpgrade != null ? this.autoMinorVersionUpgrade.hashCode() : 0);
            result = 31 * result + (this.availabilityZones != null ? this.availabilityZones.hashCode() : 0);
            result = 31 * result + (this.backtrackWindow != null ? this.backtrackWindow.hashCode() : 0);
            result = 31 * result + (this.backupRetentionPeriod != null ? this.backupRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.clusterScalabilityType != null ? this.clusterScalabilityType.hashCode() : 0);
            result = 31 * result + (this.copyTagsToSnapshot != null ? this.copyTagsToSnapshot.hashCode() : 0);
            result = 31 * result + (this.databaseInsightsMode != null ? this.databaseInsightsMode.hashCode() : 0);
            result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
            result = 31 * result + (this.dbClusterIdentifier != null ? this.dbClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.dbClusterInstanceClass != null ? this.dbClusterInstanceClass.hashCode() : 0);
            result = 31 * result + (this.dbClusterParameterGroupName != null ? this.dbClusterParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.dbInstanceParameterGroupName != null ? this.dbInstanceParameterGroupName.hashCode() : 0);
            result = 31 * result + (this.dbSubnetGroupName != null ? this.dbSubnetGroupName.hashCode() : 0);
            result = 31 * result + (this.dbSystemId != null ? this.dbSystemId.hashCode() : 0);
            result = 31 * result + (this.deleteAutomatedBackups != null ? this.deleteAutomatedBackups.hashCode() : 0);
            result = 31 * result + (this.deletionProtection != null ? this.deletionProtection.hashCode() : 0);
            result = 31 * result + (this.domain != null ? this.domain.hashCode() : 0);
            result = 31 * result + (this.domainIamRoleName != null ? this.domainIamRoleName.hashCode() : 0);
            result = 31 * result + (this.enableCloudwatchLogsExports != null ? this.enableCloudwatchLogsExports.hashCode() : 0);
            result = 31 * result + (this.enableGlobalWriteForwarding != null ? this.enableGlobalWriteForwarding.hashCode() : 0);
            result = 31 * result + (this.enableHttpEndpoint != null ? this.enableHttpEndpoint.hashCode() : 0);
            result = 31 * result + (this.enableIamDatabaseAuthentication != null ? this.enableIamDatabaseAuthentication.hashCode() : 0);
            result = 31 * result + (this.enableLocalWriteForwarding != null ? this.enableLocalWriteForwarding.hashCode() : 0);
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.engineLifecycleSupport != null ? this.engineLifecycleSupport.hashCode() : 0);
            result = 31 * result + (this.engineMode != null ? this.engineMode.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.globalClusterIdentifier != null ? this.globalClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.manageMasterUserPassword != null ? this.manageMasterUserPassword.hashCode() : 0);
            result = 31 * result + (this.masterUsername != null ? this.masterUsername.hashCode() : 0);
            result = 31 * result + (this.masterUserPassword != null ? this.masterUserPassword.hashCode() : 0);
            result = 31 * result + (this.masterUserSecret != null ? this.masterUserSecret.hashCode() : 0);
            result = 31 * result + (this.monitoringInterval != null ? this.monitoringInterval.hashCode() : 0);
            result = 31 * result + (this.monitoringRoleArn != null ? this.monitoringRoleArn.hashCode() : 0);
            result = 31 * result + (this.networkType != null ? this.networkType.hashCode() : 0);
            result = 31 * result + (this.performanceInsightsEnabled != null ? this.performanceInsightsEnabled.hashCode() : 0);
            result = 31 * result + (this.performanceInsightsKmsKeyId != null ? this.performanceInsightsKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.performanceInsightsRetentionPeriod != null ? this.performanceInsightsRetentionPeriod.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.preferredBackupWindow != null ? this.preferredBackupWindow.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
            result = 31 * result + (this.replicationSourceIdentifier != null ? this.replicationSourceIdentifier.hashCode() : 0);
            result = 31 * result + (this.restoreToTime != null ? this.restoreToTime.hashCode() : 0);
            result = 31 * result + (this.restoreType != null ? this.restoreType.hashCode() : 0);
            result = 31 * result + (this.scalingConfiguration != null ? this.scalingConfiguration.hashCode() : 0);
            result = 31 * result + (this.serverlessV2ScalingConfiguration != null ? this.serverlessV2ScalingConfiguration.hashCode() : 0);
            result = 31 * result + (this.snapshotIdentifier != null ? this.snapshotIdentifier.hashCode() : 0);
            result = 31 * result + (this.sourceDbClusterIdentifier != null ? this.sourceDbClusterIdentifier.hashCode() : 0);
            result = 31 * result + (this.sourceDbClusterResourceId != null ? this.sourceDbClusterResourceId.hashCode() : 0);
            result = 31 * result + (this.sourceRegion != null ? this.sourceRegion.hashCode() : 0);
            result = 31 * result + (this.storageEncrypted != null ? this.storageEncrypted.hashCode() : 0);
            result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.useLatestRestorableTime != null ? this.useLatestRestorableTime.hashCode() : 0);
            result = 31 * result + (this.vpcSecurityGroupIds != null ? this.vpcSecurityGroupIds.hashCode() : 0);
            return result;
        }
    }
}
