package software.amazon.awscdk.services.redshift;

/**
 * Creates a scheduled action.
 * <p>
 * A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the <code>ResizeCluster</code> API operation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshift.*;
 * CfnScheduledAction cfnScheduledAction = CfnScheduledAction.Builder.create(this, "MyCfnScheduledAction")
 *         .scheduledActionName("scheduledActionName")
 *         // the properties below are optional
 *         .enable(false)
 *         .endTime("endTime")
 *         .iamRole("iamRole")
 *         .schedule("schedule")
 *         .scheduledActionDescription("scheduledActionDescription")
 *         .startTime("startTime")
 *         .targetAction(ScheduledActionTypeProperty.builder()
 *                 .pauseCluster(PauseClusterMessageProperty.builder()
 *                         .clusterIdentifier("clusterIdentifier")
 *                         .build())
 *                 .resizeCluster(ResizeClusterMessageProperty.builder()
 *                         .clusterIdentifier("clusterIdentifier")
 *                         // the properties below are optional
 *                         .classic(false)
 *                         .clusterType("clusterType")
 *                         .nodeType("nodeType")
 *                         .numberOfNodes(123)
 *                         .build())
 *                 .resumeCluster(ResumeClusterMessageProperty.builder()
 *                         .clusterIdentifier("clusterIdentifier")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:39.166Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnScheduledAction")
public class CfnScheduledAction extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnScheduledAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScheduledAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshift.CfnScheduledAction.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScheduledAction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshift.CfnScheduledActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * List of times when the scheduled action will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrNextInvocations() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrNextInvocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The state of the scheduled action.
     * <p>
     * For example, <code>DISABLED</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrState() {
        return software.amazon.jsii.Kernel.get(this, "attrState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScheduledActionName() {
        return software.amazon.jsii.Kernel.get(this, "scheduledActionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledActionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduledActionName", java.util.Objects.requireNonNull(value, "scheduledActionName is required"));
    }

    /**
     * If true, the schedule is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnable() {
        return software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If true, the schedule is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnable(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enable", value);
    }

    /**
     * If true, the schedule is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnable(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enable", value);
    }

    /**
     * The end time in UTC when the schedule is no longer active.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndTime() {
        return software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The end time in UTC when the schedule is no longer active.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endTime", value);
    }

    /**
     * The IAM role to assume to run the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIamRole() {
        return software.amazon.jsii.Kernel.get(this, "iamRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role to assume to run the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIamRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "iamRole", value);
    }

    /**
     * The schedule for a one-time (at format) or recurring (cron format) scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The schedule for a one-time (at format) or recurring (cron format) scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The description of the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScheduledActionDescription() {
        return software.amazon.jsii.Kernel.get(this, "scheduledActionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScheduledActionDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scheduledActionDescription", value);
    }

    /**
     * The start time in UTC when the schedule is active.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
        return software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The start time in UTC when the schedule is active.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "startTime", value);
    }

    /**
     * A JSON format string of the Amazon Redshift API operation with input parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargetAction() {
        return software.amazon.jsii.Kernel.get(this, "targetAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A JSON format string of the Amazon Redshift API operation with input parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetAction(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targetAction", value);
    }

    /**
     * A JSON format string of the Amazon Redshift API operation with input parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetAction(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshift.CfnScheduledAction.ScheduledActionTypeProperty value) {
        software.amazon.jsii.Kernel.set(this, "targetAction", value);
    }
    /**
     * Describes a pause cluster operation.
     * <p>
     * For example, a scheduled action to run the <code>PauseCluster</code> API operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshift.*;
     * PauseClusterMessageProperty pauseClusterMessageProperty = PauseClusterMessageProperty.builder()
     *         .clusterIdentifier("clusterIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-pauseclustermessage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-pauseclustermessage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnScheduledAction.PauseClusterMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(PauseClusterMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PauseClusterMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the cluster to be paused.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-pauseclustermessage.html#cfn-redshift-scheduledaction-pauseclustermessage-clusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-pauseclustermessage.html#cfn-redshift-scheduledaction-pauseclustermessage-clusteridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

        /**
         * @return a {@link Builder} of {@link PauseClusterMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PauseClusterMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PauseClusterMessageProperty> {
            java.lang.String clusterIdentifier;

            /**
             * Sets the value of {@link PauseClusterMessageProperty#getClusterIdentifier}
             * @param clusterIdentifier The identifier of the cluster to be paused. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
                this.clusterIdentifier = clusterIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PauseClusterMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PauseClusterMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PauseClusterMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PauseClusterMessageProperty {
            private final java.lang.String clusterIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterIdentifier = java.util.Objects.requireNonNull(builder.clusterIdentifier, "clusterIdentifier is required");
            }

            @Override
            public final java.lang.String getClusterIdentifier() {
                return this.clusterIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshift.CfnScheduledAction.PauseClusterMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PauseClusterMessageProperty.Jsii$Proxy that = (PauseClusterMessageProperty.Jsii$Proxy) o;

                return this.clusterIdentifier.equals(that.clusterIdentifier);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterIdentifier.hashCode();
                return result;
            }
        }
    }
    /**
     * Describes a resize cluster operation.
     * <p>
     * For example, a scheduled action to run the <code>ResizeCluster</code> API operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshift.*;
     * ResizeClusterMessageProperty resizeClusterMessageProperty = ResizeClusterMessageProperty.builder()
     *         .clusterIdentifier("clusterIdentifier")
     *         // the properties below are optional
     *         .classic(false)
     *         .clusterType("clusterType")
     *         .nodeType("nodeType")
     *         .numberOfNodes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnScheduledAction.ResizeClusterMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(ResizeClusterMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResizeClusterMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier for the cluster to resize.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-clusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-clusteridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

        /**
         * A boolean value indicating whether the resize operation is using the classic resize process.
         * <p>
         * If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-classic">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-classic</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClassic() {
            return null;
        }

        /**
         * The new cluster type for the specified cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-clustertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-clustertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterType() {
            return null;
        }

        /**
         * The new node type for the nodes you are adding.
         * <p>
         * If not specified, the cluster's current node type is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-nodetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-nodetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNodeType() {
            return null;
        }

        /**
         * The new number of nodes for the cluster.
         * <p>
         * If not specified, the cluster's current number of nodes is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-numberofnodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resizeclustermessage.html#cfn-redshift-scheduledaction-resizeclustermessage-numberofnodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfNodes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResizeClusterMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResizeClusterMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResizeClusterMessageProperty> {
            java.lang.String clusterIdentifier;
            java.lang.Object classic;
            java.lang.String clusterType;
            java.lang.String nodeType;
            java.lang.Number numberOfNodes;

            /**
             * Sets the value of {@link ResizeClusterMessageProperty#getClusterIdentifier}
             * @param clusterIdentifier The unique identifier for the cluster to resize. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
                this.clusterIdentifier = clusterIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link ResizeClusterMessageProperty#getClassic}
             * @param classic A boolean value indicating whether the resize operation is using the classic resize process.
             *                If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classic(java.lang.Boolean classic) {
                this.classic = classic;
                return this;
            }

            /**
             * Sets the value of {@link ResizeClusterMessageProperty#getClassic}
             * @param classic A boolean value indicating whether the resize operation is using the classic resize process.
             *                If you don't provide this parameter or set the value to <code>false</code> , the resize type is elastic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classic(software.amazon.awscdk.IResolvable classic) {
                this.classic = classic;
                return this;
            }

            /**
             * Sets the value of {@link ResizeClusterMessageProperty#getClusterType}
             * @param clusterType The new cluster type for the specified cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterType(java.lang.String clusterType) {
                this.clusterType = clusterType;
                return this;
            }

            /**
             * Sets the value of {@link ResizeClusterMessageProperty#getNodeType}
             * @param nodeType The new node type for the nodes you are adding.
             *                 If not specified, the cluster's current node type is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeType(java.lang.String nodeType) {
                this.nodeType = nodeType;
                return this;
            }

            /**
             * Sets the value of {@link ResizeClusterMessageProperty#getNumberOfNodes}
             * @param numberOfNodes The new number of nodes for the cluster.
             *                      If not specified, the cluster's current number of nodes is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfNodes(java.lang.Number numberOfNodes) {
                this.numberOfNodes = numberOfNodes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResizeClusterMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResizeClusterMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResizeClusterMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResizeClusterMessageProperty {
            private final java.lang.String clusterIdentifier;
            private final java.lang.Object classic;
            private final java.lang.String clusterType;
            private final java.lang.String nodeType;
            private final java.lang.Number numberOfNodes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.classic = software.amazon.jsii.Kernel.get(this, "classic", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clusterType = software.amazon.jsii.Kernel.get(this, "clusterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nodeType = software.amazon.jsii.Kernel.get(this, "nodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numberOfNodes = software.amazon.jsii.Kernel.get(this, "numberOfNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterIdentifier = java.util.Objects.requireNonNull(builder.clusterIdentifier, "clusterIdentifier is required");
                this.classic = builder.classic;
                this.clusterType = builder.clusterType;
                this.nodeType = builder.nodeType;
                this.numberOfNodes = builder.numberOfNodes;
            }

            @Override
            public final java.lang.String getClusterIdentifier() {
                return this.clusterIdentifier;
            }

            @Override
            public final java.lang.Object getClassic() {
                return this.classic;
            }

            @Override
            public final java.lang.String getClusterType() {
                return this.clusterType;
            }

            @Override
            public final java.lang.String getNodeType() {
                return this.nodeType;
            }

            @Override
            public final java.lang.Number getNumberOfNodes() {
                return this.numberOfNodes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));
                if (this.getClassic() != null) {
                    data.set("classic", om.valueToTree(this.getClassic()));
                }
                if (this.getClusterType() != null) {
                    data.set("clusterType", om.valueToTree(this.getClusterType()));
                }
                if (this.getNodeType() != null) {
                    data.set("nodeType", om.valueToTree(this.getNodeType()));
                }
                if (this.getNumberOfNodes() != null) {
                    data.set("numberOfNodes", om.valueToTree(this.getNumberOfNodes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshift.CfnScheduledAction.ResizeClusterMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResizeClusterMessageProperty.Jsii$Proxy that = (ResizeClusterMessageProperty.Jsii$Proxy) o;

                if (!clusterIdentifier.equals(that.clusterIdentifier)) return false;
                if (this.classic != null ? !this.classic.equals(that.classic) : that.classic != null) return false;
                if (this.clusterType != null ? !this.clusterType.equals(that.clusterType) : that.clusterType != null) return false;
                if (this.nodeType != null ? !this.nodeType.equals(that.nodeType) : that.nodeType != null) return false;
                return this.numberOfNodes != null ? this.numberOfNodes.equals(that.numberOfNodes) : that.numberOfNodes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clusterIdentifier.hashCode();
                result = 31 * result + (this.classic != null ? this.classic.hashCode() : 0);
                result = 31 * result + (this.clusterType != null ? this.clusterType.hashCode() : 0);
                result = 31 * result + (this.nodeType != null ? this.nodeType.hashCode() : 0);
                result = 31 * result + (this.numberOfNodes != null ? this.numberOfNodes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes a resume cluster operation.
     * <p>
     * For example, a scheduled action to run the <code>ResumeCluster</code> API operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshift.*;
     * ResumeClusterMessageProperty resumeClusterMessageProperty = ResumeClusterMessageProperty.builder()
     *         .clusterIdentifier("clusterIdentifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resumeclustermessage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resumeclustermessage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnScheduledAction.ResumeClusterMessageProperty")
    @software.amazon.jsii.Jsii.Proxy(ResumeClusterMessageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResumeClusterMessageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of the cluster to be resumed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resumeclustermessage.html#cfn-redshift-scheduledaction-resumeclustermessage-clusteridentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-resumeclustermessage.html#cfn-redshift-scheduledaction-resumeclustermessage-clusteridentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier();

        /**
         * @return a {@link Builder} of {@link ResumeClusterMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResumeClusterMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResumeClusterMessageProperty> {
            java.lang.String clusterIdentifier;

            /**
             * Sets the value of {@link ResumeClusterMessageProperty#getClusterIdentifier}
             * @param clusterIdentifier The identifier of the cluster to be resumed. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterIdentifier(java.lang.String clusterIdentifier) {
                this.clusterIdentifier = clusterIdentifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResumeClusterMessageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResumeClusterMessageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResumeClusterMessageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResumeClusterMessageProperty {
            private final java.lang.String clusterIdentifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterIdentifier = software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterIdentifier = java.util.Objects.requireNonNull(builder.clusterIdentifier, "clusterIdentifier is required");
            }

            @Override
            public final java.lang.String getClusterIdentifier() {
                return this.clusterIdentifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterIdentifier", om.valueToTree(this.getClusterIdentifier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshift.CfnScheduledAction.ResumeClusterMessageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResumeClusterMessageProperty.Jsii$Proxy that = (ResumeClusterMessageProperty.Jsii$Proxy) o;

                return this.clusterIdentifier.equals(that.clusterIdentifier);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterIdentifier.hashCode();
                return result;
            }
        }
    }
    /**
     * The action type that specifies an Amazon Redshift API operation that is supported by the Amazon Redshift scheduler.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshift.*;
     * ScheduledActionTypeProperty scheduledActionTypeProperty = ScheduledActionTypeProperty.builder()
     *         .pauseCluster(PauseClusterMessageProperty.builder()
     *                 .clusterIdentifier("clusterIdentifier")
     *                 .build())
     *         .resizeCluster(ResizeClusterMessageProperty.builder()
     *                 .clusterIdentifier("clusterIdentifier")
     *                 // the properties below are optional
     *                 .classic(false)
     *                 .clusterType("clusterType")
     *                 .nodeType("nodeType")
     *                 .numberOfNodes(123)
     *                 .build())
     *         .resumeCluster(ResumeClusterMessageProperty.builder()
     *                 .clusterIdentifier("clusterIdentifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-scheduledactiontype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-scheduledactiontype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshift.CfnScheduledAction.ScheduledActionTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduledActionTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduledActionTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An action that runs a <code>PauseCluster</code> API operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-scheduledactiontype.html#cfn-redshift-scheduledaction-scheduledactiontype-pausecluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-scheduledactiontype.html#cfn-redshift-scheduledaction-scheduledactiontype-pausecluster</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPauseCluster() {
            return null;
        }

        /**
         * An action that runs a <code>ResizeCluster</code> API operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-scheduledactiontype.html#cfn-redshift-scheduledaction-scheduledactiontype-resizecluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-scheduledactiontype.html#cfn-redshift-scheduledaction-scheduledactiontype-resizecluster</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResizeCluster() {
            return null;
        }

        /**
         * An action that runs a <code>ResumeCluster</code> API operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-scheduledactiontype.html#cfn-redshift-scheduledaction-scheduledactiontype-resumecluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshift-scheduledaction-scheduledactiontype.html#cfn-redshift-scheduledaction-scheduledactiontype-resumecluster</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResumeCluster() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduledActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduledActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduledActionTypeProperty> {
            java.lang.Object pauseCluster;
            java.lang.Object resizeCluster;
            java.lang.Object resumeCluster;

            /**
             * Sets the value of {@link ScheduledActionTypeProperty#getPauseCluster}
             * @param pauseCluster An action that runs a <code>PauseCluster</code> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pauseCluster(software.amazon.awscdk.IResolvable pauseCluster) {
                this.pauseCluster = pauseCluster;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionTypeProperty#getPauseCluster}
             * @param pauseCluster An action that runs a <code>PauseCluster</code> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pauseCluster(software.amazon.awscdk.services.redshift.CfnScheduledAction.PauseClusterMessageProperty pauseCluster) {
                this.pauseCluster = pauseCluster;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionTypeProperty#getResizeCluster}
             * @param resizeCluster An action that runs a <code>ResizeCluster</code> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resizeCluster(software.amazon.awscdk.IResolvable resizeCluster) {
                this.resizeCluster = resizeCluster;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionTypeProperty#getResizeCluster}
             * @param resizeCluster An action that runs a <code>ResizeCluster</code> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resizeCluster(software.amazon.awscdk.services.redshift.CfnScheduledAction.ResizeClusterMessageProperty resizeCluster) {
                this.resizeCluster = resizeCluster;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionTypeProperty#getResumeCluster}
             * @param resumeCluster An action that runs a <code>ResumeCluster</code> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resumeCluster(software.amazon.awscdk.IResolvable resumeCluster) {
                this.resumeCluster = resumeCluster;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledActionTypeProperty#getResumeCluster}
             * @param resumeCluster An action that runs a <code>ResumeCluster</code> API operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resumeCluster(software.amazon.awscdk.services.redshift.CfnScheduledAction.ResumeClusterMessageProperty resumeCluster) {
                this.resumeCluster = resumeCluster;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduledActionTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduledActionTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduledActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledActionTypeProperty {
            private final java.lang.Object pauseCluster;
            private final java.lang.Object resizeCluster;
            private final java.lang.Object resumeCluster;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pauseCluster = software.amazon.jsii.Kernel.get(this, "pauseCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resizeCluster = software.amazon.jsii.Kernel.get(this, "resizeCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resumeCluster = software.amazon.jsii.Kernel.get(this, "resumeCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pauseCluster = builder.pauseCluster;
                this.resizeCluster = builder.resizeCluster;
                this.resumeCluster = builder.resumeCluster;
            }

            @Override
            public final java.lang.Object getPauseCluster() {
                return this.pauseCluster;
            }

            @Override
            public final java.lang.Object getResizeCluster() {
                return this.resizeCluster;
            }

            @Override
            public final java.lang.Object getResumeCluster() {
                return this.resumeCluster;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPauseCluster() != null) {
                    data.set("pauseCluster", om.valueToTree(this.getPauseCluster()));
                }
                if (this.getResizeCluster() != null) {
                    data.set("resizeCluster", om.valueToTree(this.getResizeCluster()));
                }
                if (this.getResumeCluster() != null) {
                    data.set("resumeCluster", om.valueToTree(this.getResumeCluster()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshift.CfnScheduledAction.ScheduledActionTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduledActionTypeProperty.Jsii$Proxy that = (ScheduledActionTypeProperty.Jsii$Proxy) o;

                if (this.pauseCluster != null ? !this.pauseCluster.equals(that.pauseCluster) : that.pauseCluster != null) return false;
                if (this.resizeCluster != null ? !this.resizeCluster.equals(that.resizeCluster) : that.resizeCluster != null) return false;
                return this.resumeCluster != null ? this.resumeCluster.equals(that.resumeCluster) : that.resumeCluster == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pauseCluster != null ? this.pauseCluster.hashCode() : 0;
                result = 31 * result + (this.resizeCluster != null ? this.resizeCluster.hashCode() : 0);
                result = 31 * result + (this.resumeCluster != null ? this.resumeCluster.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.redshift.CfnScheduledAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.redshift.CfnScheduledAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.redshift.CfnScheduledActionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.redshift.CfnScheduledActionProps.Builder();
        }

        /**
         * The name of the scheduled action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-scheduledactionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-scheduledactionname</a>
         * @param scheduledActionName The name of the scheduled action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActionName(final java.lang.String scheduledActionName) {
            this.props.scheduledActionName(scheduledActionName);
            return this;
        }

        /**
         * If true, the schedule is enabled.
         * <p>
         * If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-enable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-enable</a>
         * @param enable If true, the schedule is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enable(final java.lang.Boolean enable) {
            this.props.enable(enable);
            return this;
        }
        /**
         * If true, the schedule is enabled.
         * <p>
         * If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-enable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-enable</a>
         * @param enable If true, the schedule is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enable(final software.amazon.awscdk.IResolvable enable) {
            this.props.enable(enable);
            return this;
        }

        /**
         * The end time in UTC when the schedule is no longer active.
         * <p>
         * After this time, the scheduled action does not trigger.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-endtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-endtime</a>
         * @param endTime The end time in UTC when the schedule is no longer active. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endTime(final java.lang.String endTime) {
            this.props.endTime(endTime);
            return this;
        }

        /**
         * The IAM role to assume to run the scheduled action.
         * <p>
         * This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <em>Amazon Redshift Cluster Management Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-iamrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-iamrole</a>
         * @param iamRole The IAM role to assume to run the scheduled action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRole(final java.lang.String iamRole) {
            this.props.iamRole(iamRole);
            return this;
        }

        /**
         * The schedule for a one-time (at format) or recurring (cron format) scheduled action.
         * <p>
         * Schedule invocations must be separated by at least one hour.
         * <p>
         * Format of at expressions is " <code>at(yyyy-mm-ddThh:mm:ss)</code> ". For example, " <code>at(2016-03-04T17:27:00)</code> ".
         * <p>
         * Format of cron expressions is " <code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code> ". For example, " <code>cron(0 10 ? * MON *)</code> ". For more information, see <a href="https://docs.aws.amazon.com//AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <em>Amazon CloudWatch Events User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-schedule</a>
         * @param schedule The schedule for a one-time (at format) or recurring (cron format) scheduled action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final java.lang.String schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * The description of the scheduled action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-scheduledactiondescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-scheduledactiondescription</a>
         * @param scheduledActionDescription The description of the scheduled action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledActionDescription(final java.lang.String scheduledActionDescription) {
            this.props.scheduledActionDescription(scheduledActionDescription);
            return this;
        }

        /**
         * The start time in UTC when the schedule is active.
         * <p>
         * Before this time, the scheduled action does not trigger.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-starttime</a>
         * @param startTime The start time in UTC when the schedule is active. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(final java.lang.String startTime) {
            this.props.startTime(startTime);
            return this;
        }

        /**
         * A JSON format string of the Amazon Redshift API operation with input parameters.
         * <p>
         * " <code>{\"ResizeCluster\":{\"NodeType\":\"ra3.4xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code> ".
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-targetaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-targetaction</a>
         * @param targetAction A JSON format string of the Amazon Redshift API operation with input parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetAction(final software.amazon.awscdk.IResolvable targetAction) {
            this.props.targetAction(targetAction);
            return this;
        }
        /**
         * A JSON format string of the Amazon Redshift API operation with input parameters.
         * <p>
         * " <code>{\"ResizeCluster\":{\"NodeType\":\"ra3.4xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code> ".
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-targetaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshift-scheduledaction.html#cfn-redshift-scheduledaction-targetaction</a>
         * @param targetAction A JSON format string of the Amazon Redshift API operation with input parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetAction(final software.amazon.awscdk.services.redshift.CfnScheduledAction.ScheduledActionTypeProperty targetAction) {
            this.props.targetAction(targetAction);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.redshift.CfnScheduledAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.redshift.CfnScheduledAction build() {
            return new software.amazon.awscdk.services.redshift.CfnScheduledAction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
