package software.amazon.awscdk.services.redshiftserverless;

/**
 * A snapshot object that contains databases.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshiftserverless.*;
 * CfnSnapshot cfnSnapshot = CfnSnapshot.Builder.create(this, "MyCfnSnapshot")
 *         .snapshotName("snapshotName")
 *         // the properties below are optional
 *         .namespaceName("namespaceName")
 *         .retentionPeriod(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:39.175Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnSnapshot")
public class CfnSnapshot extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnSnapshot(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSnapshot(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshiftserverless.CfnSnapshot.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSnapshot(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshiftserverless.CfnSnapshotProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The owner AWS ;
     * <p>
     * account of the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrOwnerAccount() {
        return software.amazon.jsii.Kernel.get(this, "attrOwnerAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrSnapshot() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshot", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The username of the database within a snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnapshotAdminUsername() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotAdminUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the KMS key used to encrypt the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnapshotKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnapshotNamespaceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotNamespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the namepsace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnapshotNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotNamespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The owner AWS ;
     * <p>
     * account of the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnapshotOwnerAccount() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotOwnerAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The retention period of the snapshot created by the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrSnapshotRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotRetentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnapshotSnapshotArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotSnapshotArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp of when the snapshot was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnapshotSnapshotCreateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotSnapshotCreateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnapshotSnapshotName() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotSnapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnapshotStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrSnapshotStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSnapshotName() {
        return software.amazon.jsii.Kernel.get(this, "snapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotName", java.util.Objects.requireNonNull(value, "snapshotName is required"));
    }

    /**
     * The name of the namepsace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the namepsace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNamespaceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "namespaceName", value);
    }

    /**
     * The retention period of the snapshot created by the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The retention period of the snapshot created by the scheduled action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "retentionPeriod", value);
    }

    /**
     * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag objects</a> to associate with the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag objects</a> to associate with the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * A snapshot object that contains databases.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * SnapshotProperty snapshotProperty = SnapshotProperty.builder()
     *         .adminUsername("adminUsername")
     *         .kmsKeyId("kmsKeyId")
     *         .namespaceArn("namespaceArn")
     *         .namespaceName("namespaceName")
     *         .ownerAccount("ownerAccount")
     *         .retentionPeriod(123)
     *         .snapshotArn("snapshotArn")
     *         .snapshotCreateTime("snapshotCreateTime")
     *         .snapshotName("snapshotName")
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnSnapshot.SnapshotProperty")
    @software.amazon.jsii.Jsii.Proxy(SnapshotProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnapshotProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The username of the database within a snapshot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-adminusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-adminusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdminUsername() {
            return null;
        }

        /**
         * The unique identifier of the KMS key used to encrypt the snapshot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-namespacearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-namespacearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceArn() {
            return null;
        }

        /**
         * The name of the namepsace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-namespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-namespacename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceName() {
            return null;
        }

        /**
         * The owner AWS ;
         * <p>
         * account of the snapshot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-owneraccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-owneraccount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOwnerAccount() {
            return null;
        }

        /**
         * The retention period of the snapshot created by the scheduled action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-retentionperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionPeriod() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the snapshot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-snapshotarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-snapshotarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotArn() {
            return null;
        }

        /**
         * The timestamp of when the snapshot was created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-snapshotcreatetime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-snapshotcreatetime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotCreateTime() {
            return null;
        }

        /**
         * The name of the snapshot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-snapshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-snapshotname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotName() {
            return null;
        }

        /**
         * The status of the snapshot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-snapshot-snapshot.html#cfn-redshiftserverless-snapshot-snapshot-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnapshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnapshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnapshotProperty> {
            java.lang.String adminUsername;
            java.lang.String kmsKeyId;
            java.lang.String namespaceArn;
            java.lang.String namespaceName;
            java.lang.String ownerAccount;
            java.lang.Number retentionPeriod;
            java.lang.String snapshotArn;
            java.lang.String snapshotCreateTime;
            java.lang.String snapshotName;
            java.lang.String status;

            /**
             * Sets the value of {@link SnapshotProperty#getAdminUsername}
             * @param adminUsername The username of the database within a snapshot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adminUsername(java.lang.String adminUsername) {
                this.adminUsername = adminUsername;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotProperty#getKmsKeyId}
             * @param kmsKeyId The unique identifier of the KMS key used to encrypt the snapshot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotProperty#getNamespaceArn}
             * @param namespaceArn The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceArn(java.lang.String namespaceArn) {
                this.namespaceArn = namespaceArn;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotProperty#getNamespaceName}
             * @param namespaceName The name of the namepsace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceName(java.lang.String namespaceName) {
                this.namespaceName = namespaceName;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotProperty#getOwnerAccount}
             * @param ownerAccount The owner AWS ;.
             *                     account of the snapshot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ownerAccount(java.lang.String ownerAccount) {
                this.ownerAccount = ownerAccount;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotProperty#getRetentionPeriod}
             * @param retentionPeriod The retention period of the snapshot created by the scheduled action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionPeriod(java.lang.Number retentionPeriod) {
                this.retentionPeriod = retentionPeriod;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotProperty#getSnapshotArn}
             * @param snapshotArn The Amazon Resource Name (ARN) of the snapshot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotArn(java.lang.String snapshotArn) {
                this.snapshotArn = snapshotArn;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotProperty#getSnapshotCreateTime}
             * @param snapshotCreateTime The timestamp of when the snapshot was created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotCreateTime(java.lang.String snapshotCreateTime) {
                this.snapshotCreateTime = snapshotCreateTime;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotProperty#getSnapshotName}
             * @param snapshotName The name of the snapshot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotName(java.lang.String snapshotName) {
                this.snapshotName = snapshotName;
                return this;
            }

            /**
             * Sets the value of {@link SnapshotProperty#getStatus}
             * @param status The status of the snapshot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnapshotProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnapshotProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnapshotProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnapshotProperty {
            private final java.lang.String adminUsername;
            private final java.lang.String kmsKeyId;
            private final java.lang.String namespaceArn;
            private final java.lang.String namespaceName;
            private final java.lang.String ownerAccount;
            private final java.lang.Number retentionPeriod;
            private final java.lang.String snapshotArn;
            private final java.lang.String snapshotCreateTime;
            private final java.lang.String snapshotName;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adminUsername = software.amazon.jsii.Kernel.get(this, "adminUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespaceArn = software.amazon.jsii.Kernel.get(this, "namespaceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.namespaceName = software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ownerAccount = software.amazon.jsii.Kernel.get(this, "ownerAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.snapshotArn = software.amazon.jsii.Kernel.get(this, "snapshotArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotCreateTime = software.amazon.jsii.Kernel.get(this, "snapshotCreateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snapshotName = software.amazon.jsii.Kernel.get(this, "snapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adminUsername = builder.adminUsername;
                this.kmsKeyId = builder.kmsKeyId;
                this.namespaceArn = builder.namespaceArn;
                this.namespaceName = builder.namespaceName;
                this.ownerAccount = builder.ownerAccount;
                this.retentionPeriod = builder.retentionPeriod;
                this.snapshotArn = builder.snapshotArn;
                this.snapshotCreateTime = builder.snapshotCreateTime;
                this.snapshotName = builder.snapshotName;
                this.status = builder.status;
            }

            @Override
            public final java.lang.String getAdminUsername() {
                return this.adminUsername;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getNamespaceArn() {
                return this.namespaceArn;
            }

            @Override
            public final java.lang.String getNamespaceName() {
                return this.namespaceName;
            }

            @Override
            public final java.lang.String getOwnerAccount() {
                return this.ownerAccount;
            }

            @Override
            public final java.lang.Number getRetentionPeriod() {
                return this.retentionPeriod;
            }

            @Override
            public final java.lang.String getSnapshotArn() {
                return this.snapshotArn;
            }

            @Override
            public final java.lang.String getSnapshotCreateTime() {
                return this.snapshotCreateTime;
            }

            @Override
            public final java.lang.String getSnapshotName() {
                return this.snapshotName;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdminUsername() != null) {
                    data.set("adminUsername", om.valueToTree(this.getAdminUsername()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getNamespaceArn() != null) {
                    data.set("namespaceArn", om.valueToTree(this.getNamespaceArn()));
                }
                if (this.getNamespaceName() != null) {
                    data.set("namespaceName", om.valueToTree(this.getNamespaceName()));
                }
                if (this.getOwnerAccount() != null) {
                    data.set("ownerAccount", om.valueToTree(this.getOwnerAccount()));
                }
                if (this.getRetentionPeriod() != null) {
                    data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
                }
                if (this.getSnapshotArn() != null) {
                    data.set("snapshotArn", om.valueToTree(this.getSnapshotArn()));
                }
                if (this.getSnapshotCreateTime() != null) {
                    data.set("snapshotCreateTime", om.valueToTree(this.getSnapshotCreateTime()));
                }
                if (this.getSnapshotName() != null) {
                    data.set("snapshotName", om.valueToTree(this.getSnapshotName()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnSnapshot.SnapshotProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnapshotProperty.Jsii$Proxy that = (SnapshotProperty.Jsii$Proxy) o;

                if (this.adminUsername != null ? !this.adminUsername.equals(that.adminUsername) : that.adminUsername != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.namespaceArn != null ? !this.namespaceArn.equals(that.namespaceArn) : that.namespaceArn != null) return false;
                if (this.namespaceName != null ? !this.namespaceName.equals(that.namespaceName) : that.namespaceName != null) return false;
                if (this.ownerAccount != null ? !this.ownerAccount.equals(that.ownerAccount) : that.ownerAccount != null) return false;
                if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
                if (this.snapshotArn != null ? !this.snapshotArn.equals(that.snapshotArn) : that.snapshotArn != null) return false;
                if (this.snapshotCreateTime != null ? !this.snapshotCreateTime.equals(that.snapshotCreateTime) : that.snapshotCreateTime != null) return false;
                if (this.snapshotName != null ? !this.snapshotName.equals(that.snapshotName) : that.snapshotName != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adminUsername != null ? this.adminUsername.hashCode() : 0;
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.namespaceArn != null ? this.namespaceArn.hashCode() : 0);
                result = 31 * result + (this.namespaceName != null ? this.namespaceName.hashCode() : 0);
                result = 31 * result + (this.ownerAccount != null ? this.ownerAccount.hashCode() : 0);
                result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
                result = 31 * result + (this.snapshotArn != null ? this.snapshotArn.hashCode() : 0);
                result = 31 * result + (this.snapshotCreateTime != null ? this.snapshotCreateTime.hashCode() : 0);
                result = 31 * result + (this.snapshotName != null ? this.snapshotName.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.redshiftserverless.CfnSnapshot}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.redshiftserverless.CfnSnapshot> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.redshiftserverless.CfnSnapshotProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.redshiftserverless.CfnSnapshotProps.Builder();
        }

        /**
         * The name of the snapshot.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html#cfn-redshiftserverless-snapshot-snapshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html#cfn-redshiftserverless-snapshot-snapshotname</a>
         * @param snapshotName The name of the snapshot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotName(final java.lang.String snapshotName) {
            this.props.snapshotName(snapshotName);
            return this;
        }

        /**
         * The name of the namepsace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html#cfn-redshiftserverless-snapshot-namespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html#cfn-redshiftserverless-snapshot-namespacename</a>
         * @param namespaceName The name of the namepsace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceName(final java.lang.String namespaceName) {
            this.props.namespaceName(namespaceName);
            return this;
        }

        /**
         * The retention period of the snapshot created by the scheduled action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html#cfn-redshiftserverless-snapshot-retentionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html#cfn-redshiftserverless-snapshot-retentionperiod</a>
         * @param retentionPeriod The retention period of the snapshot created by the scheduled action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final java.lang.Number retentionPeriod) {
            this.props.retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag objects</a> to associate with the snapshot.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html#cfn-redshiftserverless-snapshot-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-snapshot.html#cfn-redshiftserverless-snapshot-tags</a>
         * @param tags An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag objects</a> to associate with the snapshot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.redshiftserverless.CfnSnapshot}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.redshiftserverless.CfnSnapshot build() {
            return new software.amazon.awscdk.services.redshiftserverless.CfnSnapshot(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
