package software.amazon.awscdk.services.resourcegroups;

/**
 * Creates a resource group with the specified name and description.
 * <p>
 * You can optionally include either a resource query or a service configuration. For more information about constructing a resource query, see <a href="https://docs.aws.amazon.com//ARG/latest/userguide/getting_started-query.html">Build queries and groups in AWS Resource Groups</a> in the <em>AWS Resource Groups User Guide</em> . For more information about service-linked groups and service configurations, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html">Service configurations for Resource Groups</a> .
 * <p>
 * <em>Minimum permissions</em>
 * <p>
 * To run this command, you must have the following permissions:
 * <p>
 * <ul>
 * <li><code>resource-groups:CreateGroup</code></li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.resourcegroups.*;
 * CfnGroup cfnGroup = CfnGroup.Builder.create(this, "MyCfnGroup")
 *         .name("name")
 *         // the properties below are optional
 *         .configuration(List.of(ConfigurationItemProperty.builder()
 *                 .parameters(List.of(ConfigurationParameterProperty.builder()
 *                         .name("name")
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .type("type")
 *                 .build()))
 *         .description("description")
 *         .resourceQuery(ResourceQueryProperty.builder()
 *                 .query(QueryProperty.builder()
 *                         .resourceTypeFilters(List.of("resourceTypeFilters"))
 *                         .stackIdentifier("stackIdentifier")
 *                         .tagFilters(List.of(TagFilterProperty.builder()
 *                                 .key("key")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .build())
 *                 .type("type")
 *                 .build())
 *         .resources(List.of("resources"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:39.243Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resourcegroups.CfnGroup")
public class CfnGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.resourcegroups.CfnGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.resourcegroups.CfnGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the new resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of a resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The service configuration currently associated with the resource group and in effect for the members of the resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The service configuration currently associated with the resource group and in effect for the members of the resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The service configuration currently associated with the resource group and in effect for the members of the resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.resourcegroups.CfnGroup.ConfigurationItemProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.resourcegroups.CfnGroup.ConfigurationItemProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * The description of the resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResourceQuery() {
        return software.amazon.jsii.Kernel.get(this, "resourceQuery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceQuery(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceQuery", value);
    }

    /**
     * The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceQuery(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.resourcegroups.CfnGroup.ResourceQueryProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourceQuery", value);
    }

    /**
     * A list of the Amazon Resource Names (ARNs) of AWS resources that you want to add to the specified group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResources() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of the Amazon Resource Names (ARNs) of AWS resources that you want to add to the specified group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "resources", value);
    }

    /**
     * The tag key and value pairs that are attached to the resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tag key and value pairs that are attached to the resource group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * One of the items in the service configuration assigned to a resource group.
     * <p>
     * A service configuration can consist of one or more items. For details service configurations and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a> in the <em>AWS Resource Groups User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resourcegroups.*;
     * ConfigurationItemProperty configurationItemProperty = ConfigurationItemProperty.builder()
     *         .parameters(List.of(ConfigurationParameterProperty.builder()
     *                 .name("name")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resourcegroups.CfnGroup.ConfigurationItemProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A collection of parameters for this configuration item.
         * <p>
         * For the list of parameters that you can use with each configuration item <code>Type</code> , see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a> in the <em>AWS Resource Groups User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationitem.html#cfn-resourcegroups-group-configurationitem-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationitem.html#cfn-resourcegroups-group-configurationitem-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * Specifies the type of configuration item.
         * <p>
         * Each item must have a unique value for type. For the list of the types that you can specify for a configuration item, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a> in the <em>AWS Resource Groups User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationitem.html#cfn-resourcegroups-group-configurationitem-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationitem.html#cfn-resourcegroups-group-configurationitem-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationItemProperty> {
            java.lang.Object parameters;
            java.lang.String type;

            /**
             * Sets the value of {@link ConfigurationItemProperty#getParameters}
             * @param parameters A collection of parameters for this configuration item.
             *                   For the list of parameters that you can use with each configuration item <code>Type</code> , see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a> in the <em>AWS Resource Groups User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationItemProperty#getParameters}
             * @param parameters A collection of parameters for this configuration item.
             *                   For the list of parameters that you can use with each configuration item <code>Type</code> , see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a> in the <em>AWS Resource Groups User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.List<? extends java.lang.Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationItemProperty#getType}
             * @param type Specifies the type of configuration item.
             *             Each item must have a unique value for type. For the list of the types that you can specify for a configuration item, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a> in the <em>AWS Resource Groups User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationItemProperty {
            private final java.lang.Object parameters;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameters = builder.parameters;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resourcegroups.CfnGroup.ConfigurationItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationItemProperty.Jsii$Proxy that = (ConfigurationItemProperty.Jsii$Proxy) o;

                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parameters != null ? this.parameters.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * One parameter for a group configuration item.
     * <p>
     * For details about service configurations and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a> in the <em>AWS Resource Groups User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resourcegroups.*;
     * ConfigurationParameterProperty configurationParameterProperty = ConfigurationParameterProperty.builder()
     *         .name("name")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resourcegroups.CfnGroup.ConfigurationParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the group configuration parameter.
         * <p>
         * For the list of parameters that you can use with each configuration item type, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a> in the <em>AWS Resource Groups User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationparameter.html#cfn-resourcegroups-group-configurationparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationparameter.html#cfn-resourcegroups-group-configurationparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value or values to be used for the specified parameter.
         * <p>
         * For the list of values you can use with each parameter, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationparameter.html#cfn-resourcegroups-group-configurationparameter-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-configurationparameter.html#cfn-resourcegroups-group-configurationparameter-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationParameterProperty> {
            java.lang.String name;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link ConfigurationParameterProperty#getName}
             * @param name The name of the group configuration parameter.
             *             For the list of parameters that you can use with each configuration item type, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a> in the <em>AWS Resource Groups User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationParameterProperty#getValues}
             * @param values The value or values to be used for the specified parameter.
             *               For the list of values you can use with each parameter, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationParameterProperty {
            private final java.lang.String name;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resourcegroups.CfnGroup.ConfigurationParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationParameterProperty.Jsii$Proxy that = (ConfigurationParameterProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies details within a <code>ResourceQuery</code> structure that determines the membership of the resource group.
     * <p>
     * The contents required in the <code>Query</code> structure are determined by the <code>Type</code> property of the containing <code>ResourceQuery</code> structure.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resourcegroups.*;
     * QueryProperty queryProperty = QueryProperty.builder()
     *         .resourceTypeFilters(List.of("resourceTypeFilters"))
     *         .stackIdentifier("stackIdentifier")
     *         .tagFilters(List.of(TagFilterProperty.builder()
     *                 .key("key")
     *                 .values(List.of("values"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resourcegroups.CfnGroup.QueryProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies limits to the types of resources that can be included in the resource group.
         * <p>
         * For example, if <code>ResourceTypeFilters</code> is <code>["AWS::EC2::Instance", "AWS::DynamoDB::Table"]</code> , only EC2 instances or DynamoDB tables can be members of this resource group. The default value is <code>["AWS::AllSupported"]</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html#cfn-resourcegroups-group-query-resourcetypefilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html#cfn-resourcegroups-group-query-resourcetypefilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getResourceTypeFilters() {
            return null;
        }

        /**
         * Specifies the ARN of a CloudFormation stack.
         * <p>
         * All supported resources of the CloudFormation stack are members of the resource group. If you don't specify an ARN, this parameter defaults to the current stack that you are defining, which means that all the resources of the current stack are grouped.
         * <p>
         * You can specify a value for <code>StackIdentifier</code> only when the <code>ResourceQuery.Type</code> property is <code>CLOUDFORMATION_STACK_1_0.</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html#cfn-resourcegroups-group-query-stackidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html#cfn-resourcegroups-group-query-stackidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStackIdentifier() {
            return null;
        }

        /**
         * A list of key-value pair objects that limit which resources can be members of the resource group.
         * <p>
         * This property is required when the <code>ResourceQuery.Type</code> property is <code>TAG_FILTERS_1_0</code> .
         * <p>
         * A resource must have a tag that matches every filter that is provided in the <code>TagFilters</code> list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html#cfn-resourcegroups-group-query-tagfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-query.html#cfn-resourcegroups-group-query-tagfilters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagFilters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryProperty> {
            java.util.List<java.lang.String> resourceTypeFilters;
            java.lang.String stackIdentifier;
            java.lang.Object tagFilters;

            /**
             * Sets the value of {@link QueryProperty#getResourceTypeFilters}
             * @param resourceTypeFilters Specifies limits to the types of resources that can be included in the resource group.
             *                            For example, if <code>ResourceTypeFilters</code> is <code>["AWS::EC2::Instance", "AWS::DynamoDB::Table"]</code> , only EC2 instances or DynamoDB tables can be members of this resource group. The default value is <code>["AWS::AllSupported"]</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTypeFilters(java.util.List<java.lang.String> resourceTypeFilters) {
                this.resourceTypeFilters = resourceTypeFilters;
                return this;
            }

            /**
             * Sets the value of {@link QueryProperty#getStackIdentifier}
             * @param stackIdentifier Specifies the ARN of a CloudFormation stack.
             *                        All supported resources of the CloudFormation stack are members of the resource group. If you don't specify an ARN, this parameter defaults to the current stack that you are defining, which means that all the resources of the current stack are grouped.
             *                        <p>
             *                        You can specify a value for <code>StackIdentifier</code> only when the <code>ResourceQuery.Type</code> property is <code>CLOUDFORMATION_STACK_1_0.</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stackIdentifier(java.lang.String stackIdentifier) {
                this.stackIdentifier = stackIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link QueryProperty#getTagFilters}
             * @param tagFilters A list of key-value pair objects that limit which resources can be members of the resource group.
             *                   This property is required when the <code>ResourceQuery.Type</code> property is <code>TAG_FILTERS_1_0</code> .
             *                   <p>
             *                   A resource must have a tag that matches every filter that is provided in the <code>TagFilters</code> list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(software.amazon.awscdk.IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Sets the value of {@link QueryProperty#getTagFilters}
             * @param tagFilters A list of key-value pair objects that limit which resources can be members of the resource group.
             *                   This property is required when the <code>ResourceQuery.Type</code> property is <code>TAG_FILTERS_1_0</code> .
             *                   <p>
             *                   A resource must have a tag that matches every filter that is provided in the <code>TagFilters</code> list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagFilters(java.util.List<? extends java.lang.Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryProperty {
            private final java.util.List<java.lang.String> resourceTypeFilters;
            private final java.lang.String stackIdentifier;
            private final java.lang.Object tagFilters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceTypeFilters = software.amazon.jsii.Kernel.get(this, "resourceTypeFilters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.stackIdentifier = software.amazon.jsii.Kernel.get(this, "stackIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagFilters = software.amazon.jsii.Kernel.get(this, "tagFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceTypeFilters = builder.resourceTypeFilters;
                this.stackIdentifier = builder.stackIdentifier;
                this.tagFilters = builder.tagFilters;
            }

            @Override
            public final java.util.List<java.lang.String> getResourceTypeFilters() {
                return this.resourceTypeFilters;
            }

            @Override
            public final java.lang.String getStackIdentifier() {
                return this.stackIdentifier;
            }

            @Override
            public final java.lang.Object getTagFilters() {
                return this.tagFilters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResourceTypeFilters() != null) {
                    data.set("resourceTypeFilters", om.valueToTree(this.getResourceTypeFilters()));
                }
                if (this.getStackIdentifier() != null) {
                    data.set("stackIdentifier", om.valueToTree(this.getStackIdentifier()));
                }
                if (this.getTagFilters() != null) {
                    data.set("tagFilters", om.valueToTree(this.getTagFilters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resourcegroups.CfnGroup.QueryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryProperty.Jsii$Proxy that = (QueryProperty.Jsii$Proxy) o;

                if (this.resourceTypeFilters != null ? !this.resourceTypeFilters.equals(that.resourceTypeFilters) : that.resourceTypeFilters != null) return false;
                if (this.stackIdentifier != null ? !this.stackIdentifier.equals(that.stackIdentifier) : that.stackIdentifier != null) return false;
                return this.tagFilters != null ? this.tagFilters.equals(that.tagFilters) : that.tagFilters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceTypeFilters != null ? this.resourceTypeFilters.hashCode() : 0;
                result = 31 * result + (this.stackIdentifier != null ? this.stackIdentifier.hashCode() : 0);
                result = 31 * result + (this.tagFilters != null ? this.tagFilters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The query used to dynamically define the members of a group.
     * <p>
     * For more information about how to construct a query, see <a href="https://docs.aws.amazon.com//ARG/latest/userguide/gettingstarted-query.html">Build queries and groups in AWS Resource Groups</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resourcegroups.*;
     * ResourceQueryProperty resourceQueryProperty = ResourceQueryProperty.builder()
     *         .query(QueryProperty.builder()
     *                 .resourceTypeFilters(List.of("resourceTypeFilters"))
     *                 .stackIdentifier("stackIdentifier")
     *                 .tagFilters(List.of(TagFilterProperty.builder()
     *                         .key("key")
     *                         .values(List.of("values"))
     *                         .build()))
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-resourcequery.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-resourcequery.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resourcegroups.CfnGroup.ResourceQueryProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceQueryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceQueryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The query that defines the membership of the group.
         * <p>
         * This is a structure with properties that depend on the <code>Type</code> .
         * <p>
         * The <code>Query</code> structure must be included in the following scenarios:
         * <p>
         * <ul>
         * <li>When the <code>Type</code> is <code>TAG_FILTERS_1_0</code> , you must specify a <code>Query</code> structure that contains a <code>TagFilters</code> list of tags. Resources with tags that match those in the <code>TagFilter</code> list become members of the resource group.</li>
         * <li>When the <code>Type</code> is <code>CLOUDFORMATION_STACK_1_0</code> then this field is required only when you must specify a CloudFormation stack other than the one you are defining. To do this, the <code>Query</code> structure must contain the <code>StackIdentifier</code> property. If you don't specify either a <code>Query</code> structure or a <code>StackIdentifier</code> within that <code>Query</code> , then it defaults to the CloudFormation stack that you're currently constructing.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-resourcequery.html#cfn-resourcegroups-group-resourcequery-query">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-resourcequery.html#cfn-resourcegroups-group-resourcequery-query</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQuery() {
            return null;
        }

        /**
         * Specifies the type of resource query that determines this group's membership. There are two valid query types:.
         * <p>
         * <ul>
         * <li><code>TAG_FILTERS_1_0</code> indicates that the group is a tag-based group. To complete the group membership, you must include the <code>TagFilters</code> property to specify the tag filters to use in the query.</li>
         * <li><code>CLOUDFORMATION_STACK_1_0</code> , the default, indicates that the group is a CloudFormation stack-based group. Group membership is based on the CloudFormation stack. You must specify the <code>StackIdentifier</code> property in the query to define which stack to associate the group with, or leave it empty to default to the stack where the group is defined.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-resourcequery.html#cfn-resourcegroups-group-resourcequery-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-resourcequery.html#cfn-resourcegroups-group-resourcequery-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceQueryProperty> {
            java.lang.Object query;
            java.lang.String type;

            /**
             * Sets the value of {@link ResourceQueryProperty#getQuery}
             * @param query The query that defines the membership of the group.
             *              This is a structure with properties that depend on the <code>Type</code> .
             *              <p>
             *              The <code>Query</code> structure must be included in the following scenarios:
             *              <p>
             *              <ul>
             *              <li>When the <code>Type</code> is <code>TAG_FILTERS_1_0</code> , you must specify a <code>Query</code> structure that contains a <code>TagFilters</code> list of tags. Resources with tags that match those in the <code>TagFilter</code> list become members of the resource group.</li>
             *              <li>When the <code>Type</code> is <code>CLOUDFORMATION_STACK_1_0</code> then this field is required only when you must specify a CloudFormation stack other than the one you are defining. To do this, the <code>Query</code> structure must contain the <code>StackIdentifier</code> property. If you don't specify either a <code>Query</code> structure or a <code>StackIdentifier</code> within that <code>Query</code> , then it defaults to the CloudFormation stack that you're currently constructing.</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder query(software.amazon.awscdk.IResolvable query) {
                this.query = query;
                return this;
            }

            /**
             * Sets the value of {@link ResourceQueryProperty#getQuery}
             * @param query The query that defines the membership of the group.
             *              This is a structure with properties that depend on the <code>Type</code> .
             *              <p>
             *              The <code>Query</code> structure must be included in the following scenarios:
             *              <p>
             *              <ul>
             *              <li>When the <code>Type</code> is <code>TAG_FILTERS_1_0</code> , you must specify a <code>Query</code> structure that contains a <code>TagFilters</code> list of tags. Resources with tags that match those in the <code>TagFilter</code> list become members of the resource group.</li>
             *              <li>When the <code>Type</code> is <code>CLOUDFORMATION_STACK_1_0</code> then this field is required only when you must specify a CloudFormation stack other than the one you are defining. To do this, the <code>Query</code> structure must contain the <code>StackIdentifier</code> property. If you don't specify either a <code>Query</code> structure or a <code>StackIdentifier</code> within that <code>Query</code> , then it defaults to the CloudFormation stack that you're currently constructing.</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder query(software.amazon.awscdk.services.resourcegroups.CfnGroup.QueryProperty query) {
                this.query = query;
                return this;
            }

            /**
             * Sets the value of {@link ResourceQueryProperty#getType}
             * @param type Specifies the type of resource query that determines this group's membership. There are two valid query types:.
             *             <ul>
             *             <li><code>TAG_FILTERS_1_0</code> indicates that the group is a tag-based group. To complete the group membership, you must include the <code>TagFilters</code> property to specify the tag filters to use in the query.</li>
             *             <li><code>CLOUDFORMATION_STACK_1_0</code> , the default, indicates that the group is a CloudFormation stack-based group. Group membership is based on the CloudFormation stack. You must specify the <code>StackIdentifier</code> property in the query to define which stack to associate the group with, or leave it empty to default to the stack where the group is defined.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceQueryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceQueryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceQueryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceQueryProperty {
            private final java.lang.Object query;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.query = software.amazon.jsii.Kernel.get(this, "query", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.query = builder.query;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getQuery() {
                return this.query;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getQuery() != null) {
                    data.set("query", om.valueToTree(this.getQuery()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resourcegroups.CfnGroup.ResourceQueryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceQueryProperty.Jsii$Proxy that = (ResourceQueryProperty.Jsii$Proxy) o;

                if (this.query != null ? !this.query.equals(that.query) : that.query != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.query != null ? this.query.hashCode() : 0;
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a single tag key and optional values that you can use to specify membership in a tag-based group.
     * <p>
     * An AWS resource that doesn't have a matching tag key and value is rejected as a member of the group.
     * <p>
     * A <code>TagFilter</code> object includes two properties: <code>Key</code> (a string) and <code>Values</code> (a list of strings). Only resources in the account that are tagged with a matching key-value pair are members of the group. The <code>Values</code> property of <code>TagFilter</code> is optional, but specifying it narrows the query results.
     * <p>
     * As an example, suppose the <code>TagFilters</code> string is <code>[{"Key": "Stage", "Values": ["Test", "Beta"]}, {"Key": "Storage"}]</code> . In this case, only resources with all of the following tags are members of the group:
     * <p>
     * <ul>
     * <li><code>Stage</code> tag key with a value of either <code>Test</code> or <code>Beta</code></li>
     * <li><code>Storage</code> tag key with any value</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resourcegroups.*;
     * TagFilterProperty tagFilterProperty = TagFilterProperty.builder()
     *         .key("key")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-tagfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-tagfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resourcegroups.CfnGroup.TagFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TagFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string that defines a tag key.
         * <p>
         * Only resources in the account that are tagged with a specified tag key are members of the tag-based resource group.
         * <p>
         * This field is required when the <code>ResourceQuery</code> structure's <code>Type</code> property is <code>TAG_FILTERS_1_0</code> . You must specify at least one tag key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-tagfilter.html#cfn-resourcegroups-group-tagfilter-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-tagfilter.html#cfn-resourcegroups-group-tagfilter-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * A list of tag values that can be included in the tag-based resource group.
         * <p>
         * This is optional. If you don't specify a value or values for a key, then an AWS resource with any value for that key is a member.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-tagfilter.html#cfn-resourcegroups-group-tagfilter-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resourcegroups-group-tagfilter.html#cfn-resourcegroups-group-tagfilter-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagFilterProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link TagFilterProperty#getKey}
             * @param key A string that defines a tag key.
             *            Only resources in the account that are tagged with a specified tag key are members of the tag-based resource group.
             *            <p>
             *            This field is required when the <code>ResourceQuery</code> structure's <code>Type</code> property is <code>TAG_FILTERS_1_0</code> . You must specify at least one tag key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getValues}
             * @param values A list of tag values that can be included in the tag-based resource group.
             *               This is optional. If you don't specify a value or values for a key, then an AWS resource with any value for that key is a member.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFilterProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resourcegroups.CfnGroup.TagFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFilterProperty.Jsii$Proxy that = (TagFilterProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.resourcegroups.CfnGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.resourcegroups.CfnGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.resourcegroups.CfnGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.resourcegroups.CfnGroupProps.Builder();
        }

        /**
         * The name of a resource group.
         * <p>
         * The name must be unique within the AWS Region in which you create the resource. To create multiple resource groups based on the same CloudFormation stack, you must generate unique names for each.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-name</a>
         * @param name The name of a resource group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The service configuration currently associated with the resource group and in effect for the members of the resource group.
         * <p>
         * A <code>Configuration</code> consists of one or more <code>ConfigurationItem</code> entries. For information about service configurations for resource groups and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a> in the <em>AWS Resource Groups User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * You can include either a <code>Configuration</code> or a <code>ResourceQuery</code> , but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-configuration</a>
         * @param configuration The service configuration currently associated with the resource group and in effect for the members of the resource group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * The service configuration currently associated with the resource group and in effect for the members of the resource group.
         * <p>
         * A <code>Configuration</code> consists of one or more <code>ConfigurationItem</code> entries. For information about service configurations for resource groups and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a> in the <em>AWS Resource Groups User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * You can include either a <code>Configuration</code> or a <code>ResourceQuery</code> , but not both.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-configuration</a>
         * @param configuration The service configuration currently associated with the resource group and in effect for the members of the resource group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final java.util.List<? extends java.lang.Object> configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The description of the resource group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-description</a>
         * @param description The description of the resource group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group.
         * <p>
         * For more information about queries and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/userguide/gettingstarted-query.html">Build queries and groups in AWS Resource Groups</a> in the <em>AWS Resource Groups User Guide</em>
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>You can include either a <code>ResourceQuery</code> or a <code>Configuration</code> , but not both.</li>
         * <li>You can specify the group's membership either by using a <code>ResourceQuery</code> or by using a list of <code>Resources</code> , but not both.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resourcequery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resourcequery</a>
         * @param resourceQuery The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceQuery(final software.amazon.awscdk.IResolvable resourceQuery) {
            this.props.resourceQuery(resourceQuery);
            return this;
        }
        /**
         * The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group.
         * <p>
         * For more information about queries and how to construct them, see <a href="https://docs.aws.amazon.com//ARG/latest/userguide/gettingstarted-query.html">Build queries and groups in AWS Resource Groups</a> in the <em>AWS Resource Groups User Guide</em>
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>You can include either a <code>ResourceQuery</code> or a <code>Configuration</code> , but not both.</li>
         * <li>You can specify the group's membership either by using a <code>ResourceQuery</code> or by using a list of <code>Resources</code> , but not both.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resourcequery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resourcequery</a>
         * @param resourceQuery The resource query structure that is used to dynamically determine which AWS resources are members of the associated resource group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceQuery(final software.amazon.awscdk.services.resourcegroups.CfnGroup.ResourceQueryProperty resourceQuery) {
            this.props.resourceQuery(resourceQuery);
            return this;
        }

        /**
         * A list of the Amazon Resource Names (ARNs) of AWS resources that you want to add to the specified group.
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>You can specify the group membership either by using a list of <code>Resources</code> or by using a <code>ResourceQuery</code> , but not both.</li>
         * <li>You can include a <code>Resources</code> property only if you also specify a <code>Configuration</code> property.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-resources</a>
         * @param resources A list of the Amazon Resource Names (ARNs) of AWS resources that you want to add to the specified group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resources(final java.util.List<java.lang.String> resources) {
            this.props.resources(resources);
            return this;
        }

        /**
         * The tag key and value pairs that are attached to the resource group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resourcegroups-group.html#cfn-resourcegroups-group-tags</a>
         * @param tags The tag key and value pairs that are attached to the resource group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.resourcegroups.CfnGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.resourcegroups.CfnGroup build() {
            return new software.amazon.awscdk.services.resourcegroups.CfnGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
