package software.amazon.awscdk.services.route53;

/**
 * Configuration for CIDR routing in Route 53 resource record set objects.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone myZone;
 * CfnCidrCollection cidrCollection = CfnCidrCollection.Builder.create(this, "CidrCollection")
 *         .name("test-collection")
 *         .locations(List.of(LocationProperty.builder()
 *                 .cidrList(List.of("192.168.1.0/24"))
 *                 .locationName("my_location")
 *                 .build()))
 *         .build();
 * ARecord.Builder.create(this, "CidrRoutingConfig")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses("1.2.3.4"))
 *         .setIdentifier("test")
 *         .cidrRoutingConfig(CidrRoutingConfig.create(CidrRoutingConfigProps.builder()
 *                 .collectionId(cidrCollection.getAttrId())
 *                 .locationName("test_location")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-cidrroutingconfig">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordset.html#cfn-route53-recordset-cidrroutingconfig</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:39.370Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.CidrRoutingConfig")
public class CidrRoutingConfig extends software.amazon.jsii.JsiiObject {

    protected CidrRoutingConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CidrRoutingConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new instance of CidrRoutingConfig.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CidrRoutingConfig create(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CidrRoutingConfigProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.CidrRoutingConfig.class, "create", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.CidrRoutingConfig.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new instance of CidrRoutingConfig for default CIDR record.
     * <p>
     * This method defines the locationName as <code>*</code>.
     * <p>
     * @return A new instance of CidrRoutingConfig with the default location name as <code>*</code>.
     * @param collectionId The CIDR collection ID. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.CidrRoutingConfig withDefaultLocationName(final @org.jetbrains.annotations.NotNull java.lang.String collectionId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.route53.CidrRoutingConfig.class, "withDefaultLocationName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.CidrRoutingConfig.class), new Object[] { java.util.Objects.requireNonNull(collectionId, "collectionId is required") });
    }

    /**
     * The CIDR collection ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCollectionId() {
        return software.amazon.jsii.Kernel.get(this, "collectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CIDR collection location name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLocationName() {
        return software.amazon.jsii.Kernel.get(this, "locationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
