package software.amazon.awscdk.services.route53;

/**
 * Properties to configure a VPC Endpoint Service domain name.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.route53.PublicHostedZone;
 * import software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName;
 * PublicHostedZone zone;
 * VpcEndpointService vpces;
 * VpcEndpointServiceDomainName.Builder.create(this, "EndpointDomain")
 *         .endpointService(vpces)
 *         .domainName("my-stuff.aws-cdk.dev")
 *         .publicHostedZone(zone)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:39.413Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.VpcEndpointServiceDomainNameProps")
@software.amazon.jsii.Jsii.Proxy(VpcEndpointServiceDomainNameProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcEndpointServiceDomainNameProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain name to use.
     * <p>
     * This domain name must be owned by this account (registered through Route53),
     * or delegated to this account. Domain ownership will be verified by AWS before
     * private DNS can be used.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html">https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The VPC Endpoint Service to configure Private DNS for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpcEndpointService getEndpointService();

    /**
     * The public hosted zone to use for the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IPublicHostedZone getPublicHostedZone();

    /**
     * @return a {@link Builder} of {@link VpcEndpointServiceDomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcEndpointServiceDomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcEndpointServiceDomainNameProps> {
        java.lang.String domainName;
        software.amazon.awscdk.services.ec2.IVpcEndpointService endpointService;
        software.amazon.awscdk.services.route53.IPublicHostedZone publicHostedZone;

        /**
         * Sets the value of {@link VpcEndpointServiceDomainNameProps#getDomainName}
         * @param domainName The domain name to use. This parameter is required.
         *                   This domain name must be owned by this account (registered through Route53),
         *                   or delegated to this account. Domain ownership will be verified by AWS before
         *                   private DNS can be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link VpcEndpointServiceDomainNameProps#getEndpointService}
         * @param endpointService The VPC Endpoint Service to configure Private DNS for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointService(software.amazon.awscdk.services.ec2.IVpcEndpointService endpointService) {
            this.endpointService = endpointService;
            return this;
        }

        /**
         * Sets the value of {@link VpcEndpointServiceDomainNameProps#getPublicHostedZone}
         * @param publicHostedZone The public hosted zone to use for the domain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicHostedZone(software.amazon.awscdk.services.route53.IPublicHostedZone publicHostedZone) {
            this.publicHostedZone = publicHostedZone;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcEndpointServiceDomainNameProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcEndpointServiceDomainNameProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcEndpointServiceDomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcEndpointServiceDomainNameProps {
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.ec2.IVpcEndpointService endpointService;
        private final software.amazon.awscdk.services.route53.IPublicHostedZone publicHostedZone;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointService = software.amazon.jsii.Kernel.get(this, "endpointService", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpcEndpointService.class));
            this.publicHostedZone = software.amazon.jsii.Kernel.get(this, "publicHostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IPublicHostedZone.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.endpointService = java.util.Objects.requireNonNull(builder.endpointService, "endpointService is required");
            this.publicHostedZone = java.util.Objects.requireNonNull(builder.publicHostedZone, "publicHostedZone is required");
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpcEndpointService getEndpointService() {
            return this.endpointService;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IPublicHostedZone getPublicHostedZone() {
            return this.publicHostedZone;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("endpointService", om.valueToTree(this.getEndpointService()));
            data.set("publicHostedZone", om.valueToTree(this.getPublicHostedZone()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.VpcEndpointServiceDomainNameProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcEndpointServiceDomainNameProps.Jsii$Proxy that = (VpcEndpointServiceDomainNameProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (!endpointService.equals(that.endpointService)) return false;
            return this.publicHostedZone.equals(that.publicHostedZone);
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.endpointService.hashCode());
            result = 31 * result + (this.publicHostedZone.hashCode());
            return result;
        }
    }
}
