package software.amazon.awscdk.services.s3;

/**
 * The default retention settings for an S3 Object Lock configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Configure for governance mode with a duration of 7 years
 * // Configure for governance mode with a duration of 7 years
 * Bucket.Builder.create(this, "Bucket1")
 *         .objectLockDefaultRetention(ObjectLockRetention.governance(Duration.days(7 * 365)))
 *         .build();
 * // Configure for compliance mode with a duration of 1 year
 * // Configure for compliance mode with a duration of 1 year
 * Bucket.Builder.create(this, "Bucket2")
 *         .objectLockDefaultRetention(ObjectLockRetention.compliance(Duration.days(365)))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-overview.html">https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-overview.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:39.672Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.ObjectLockRetention")
public class ObjectLockRetention extends software.amazon.jsii.JsiiObject {

    protected ObjectLockRetention(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ObjectLockRetention(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Configure for Compliance retention for a specified duration.
     * <p>
     * When an object is locked in compliance mode, its retention mode can't be changed, and
     * its retention period can't be shortened. Compliance mode helps ensure that an object
     * version can't be overwritten or deleted for the duration of the retention period.
     * <p>
     * @return the ObjectLockRetention configuration
     * @param duration the length of time for which objects should be retained. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.ObjectLockRetention compliance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.ObjectLockRetention.class, "compliance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ObjectLockRetention.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Configure for Governance retention for a specified duration.
     * <p>
     * With governance mode, you protect objects against being deleted by most users, but you can
     * still grant some users permission to alter the retention settings or delete the object if
     * necessary. You can also use governance mode to test retention-period settings before
     * creating a compliance-mode retention period.
     * <p>
     * @return the ObjectLockRetention configuration
     * @param duration the length of time for which objects should retained. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.ObjectLockRetention governance(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.ObjectLockRetention.class, "governance", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ObjectLockRetention.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * The default period for which objects should be retained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getDuration() {
        return software.amazon.jsii.Kernel.get(this, "duration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * The retention mode to use for the object lock configuration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-overview.html#object-lock-retention-modes">https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock-overview.html#object-lock-retention-modes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.ObjectLockMode getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.ObjectLockMode.class));
    }
}
