package software.amazon.awscdk.services.sagemaker;

/**
 * Creates a SageMaker HyperPod cluster.
 * <p>
 * SageMaker HyperPod is a capability of SageMaker for creating and managing persistent clusters for developing large machine learning models, such as large language models (LLMs) and diffusion models. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html">Amazon SageMaker HyperPod</a> in the <em>Amazon SageMaker Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnCluster cfnCluster = CfnCluster.Builder.create(this, "MyCfnCluster")
 *         .clusterName("clusterName")
 *         .instanceGroups(List.of(ClusterInstanceGroupProperty.builder()
 *                 .executionRole("executionRole")
 *                 .instanceCount(123)
 *                 .instanceGroupName("instanceGroupName")
 *                 .instanceType("instanceType")
 *                 .lifeCycleConfig(ClusterLifeCycleConfigProperty.builder()
 *                         .onCreate("onCreate")
 *                         .sourceS3Uri("sourceS3Uri")
 *                         .build())
 *                 // the properties below are optional
 *                 .currentCount(123)
 *                 .imageId("imageId")
 *                 .instanceStorageConfigs(List.of(ClusterInstanceStorageConfigProperty.builder()
 *                         .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
 *                                 .volumeSizeInGb(123)
 *                                 .build())
 *                         .build()))
 *                 .onStartDeepHealthChecks(List.of("onStartDeepHealthChecks"))
 *                 .overrideVpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .scheduledUpdateConfig(ScheduledUpdateConfigProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         // the properties below are optional
 *                         .deploymentConfig(DeploymentConfigProperty.builder()
 *                                 .autoRollbackConfiguration(List.of(AlarmDetailsProperty.builder()
 *                                         .alarmName("alarmName")
 *                                         .build()))
 *                                 .rollingUpdatePolicy(RollingUpdatePolicyProperty.builder()
 *                                         .maximumBatchSize(CapacitySizeConfigProperty.builder()
 *                                                 .type("type")
 *                                                 .value(123)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .rollbackMaximumBatchSize(CapacitySizeConfigProperty.builder()
 *                                                 .type("type")
 *                                                 .value(123)
 *                                                 .build())
 *                                         .build())
 *                                 .waitIntervalInSeconds(123)
 *                                 .build())
 *                         .build())
 *                 .threadsPerCore(123)
 *                 .trainingPlanArn("trainingPlanArn")
 *                 .build()))
 *         .nodeProvisioningMode("nodeProvisioningMode")
 *         .nodeRecovery("nodeRecovery")
 *         .orchestrator(OrchestratorProperty.builder()
 *                 .eks(ClusterOrchestratorEksConfigProperty.builder()
 *                         .clusterArn("clusterArn")
 *                         .build())
 *                 .build())
 *         .restrictedInstanceGroups(List.of(ClusterRestrictedInstanceGroupProperty.builder()
 *                 .environmentConfig(EnvironmentConfigProperty.builder()
 *                         .fSxLustreConfig(FSxLustreConfigProperty.builder()
 *                                 .perUnitStorageThroughput(123)
 *                                 .sizeInGiB(123)
 *                                 .build())
 *                         .build())
 *                 .executionRole("executionRole")
 *                 .instanceCount(123)
 *                 .instanceGroupName("instanceGroupName")
 *                 .instanceType("instanceType")
 *                 // the properties below are optional
 *                 .currentCount(123)
 *                 .instanceStorageConfigs(List.of(ClusterInstanceStorageConfigProperty.builder()
 *                         .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
 *                                 .volumeSizeInGb(123)
 *                                 .build())
 *                         .build()))
 *                 .onStartDeepHealthChecks(List.of("onStartDeepHealthChecks"))
 *                 .overrideVpcConfig(VpcConfigProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .threadsPerCore(123)
 *                 .trainingPlanArn("trainingPlanArn")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:39.783Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster")
public class CfnCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "attrClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrClusterStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrClusterStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time when the SageMaker HyperPod cluster is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The failure message of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFailureMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrFailureMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", value);
    }

    /**
     * The instance groups of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceGroups() {
        return software.amazon.jsii.Kernel.get(this, "instanceGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The instance groups of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceGroups", value);
    }

    /**
     * The instance groups of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterInstanceGroupProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterInstanceGroupProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "instanceGroups", value);
    }

    /**
     * Determines the scaling strategy for the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNodeProvisioningMode() {
        return software.amazon.jsii.Kernel.get(this, "nodeProvisioningMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Determines the scaling strategy for the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeProvisioningMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "nodeProvisioningMode", value);
    }

    /**
     * Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNodeRecovery() {
        return software.amazon.jsii.Kernel.get(this, "nodeRecovery", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeRecovery(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "nodeRecovery", value);
    }

    /**
     * The orchestrator type for the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrchestrator() {
        return software.amazon.jsii.Kernel.get(this, "orchestrator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The orchestrator type for the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrchestrator(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "orchestrator", value);
    }

    /**
     * The orchestrator type for the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrchestrator(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnCluster.OrchestratorProperty value) {
        software.amazon.jsii.Kernel.set(this, "orchestrator", value);
    }

    /**
     * The restricted instance groups of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRestrictedInstanceGroups() {
        return software.amazon.jsii.Kernel.get(this, "restrictedInstanceGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The restricted instance groups of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestrictedInstanceGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "restrictedInstanceGroups", value);
    }

    /**
     * The restricted instance groups of the SageMaker HyperPod cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestrictedInstanceGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterRestrictedInstanceGroupProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterRestrictedInstanceGroupProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "restrictedInstanceGroups", value);
    }

    /**
     * A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }

    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnCluster.VpcConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfig", value);
    }
    /**
     * The details of the alarm to monitor during the AMI update.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AlarmDetailsProperty alarmDetailsProperty = AlarmDetailsProperty.builder()
     *         .alarmName("alarmName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-alarmdetails.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-alarmdetails.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.AlarmDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the alarm.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-alarmdetails.html#cfn-sagemaker-cluster-alarmdetails-alarmname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-alarmdetails.html#cfn-sagemaker-cluster-alarmdetails-alarmname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlarmName();

        /**
         * @return a {@link Builder} of {@link AlarmDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmDetailsProperty> {
            java.lang.String alarmName;

            /**
             * Sets the value of {@link AlarmDetailsProperty#getAlarmName}
             * @param alarmName The name of the alarm. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmName(java.lang.String alarmName) {
                this.alarmName = alarmName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmDetailsProperty {
            private final java.lang.String alarmName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmName = java.util.Objects.requireNonNull(builder.alarmName, "alarmName is required");
            }

            @Override
            public final java.lang.String getAlarmName() {
                return this.alarmName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmName", om.valueToTree(this.getAlarmName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.AlarmDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmDetailsProperty.Jsii$Proxy that = (AlarmDetailsProperty.Jsii$Proxy) o;

                return this.alarmName.equals(that.alarmName);
            }

            @Override
            public final int hashCode() {
                int result = this.alarmName.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration of the size measurements of the AMI update.
     * <p>
     * Using this configuration, you can specify whether SageMaker should update your instance group by an amount or percentage of instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CapacitySizeConfigProperty capacitySizeConfigProperty = CapacitySizeConfigProperty.builder()
     *         .type("type")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-capacitysizeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-capacitysizeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.CapacitySizeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacitySizeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacitySizeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether SageMaker should process the update by amount or percentage of instances.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-capacitysizeconfig.html#cfn-sagemaker-cluster-capacitysizeconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-capacitysizeconfig.html#cfn-sagemaker-cluster-capacitysizeconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Specifies the amount or percentage of instances SageMaker updates at a time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-capacitysizeconfig.html#cfn-sagemaker-cluster-capacitysizeconfig-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-capacitysizeconfig.html#cfn-sagemaker-cluster-capacitysizeconfig-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link CapacitySizeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacitySizeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacitySizeConfigProperty> {
            java.lang.String type;
            java.lang.Number value;

            /**
             * Sets the value of {@link CapacitySizeConfigProperty#getType}
             * @param type Specifies whether SageMaker should process the update by amount or percentage of instances. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link CapacitySizeConfigProperty#getValue}
             * @param value Specifies the amount or percentage of instances SageMaker updates at a time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacitySizeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacitySizeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacitySizeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacitySizeConfigProperty {
            private final java.lang.String type;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.CapacitySizeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacitySizeConfigProperty.Jsii$Proxy that = (CapacitySizeConfigProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines the configuration for attaching an additional Amazon Elastic Block Store (EBS) volume to each instance of the SageMaker HyperPod cluster instance group.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-release-notes.html#sagemaker-hyperpod-release-notes-20240620">SageMaker HyperPod release notes: June 20, 2024</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterEbsVolumeConfigProperty clusterEbsVolumeConfigProperty = ClusterEbsVolumeConfigProperty.builder()
     *         .volumeSizeInGb(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterEbsVolumeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterEbsVolumeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker HyperPod cluster instance group.
         * <p>
         * The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html#cfn-sagemaker-cluster-clusterebsvolumeconfig-volumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterebsvolumeconfig.html#cfn-sagemaker-cluster-clusterebsvolumeconfig-volumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSizeInGb() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterEbsVolumeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterEbsVolumeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterEbsVolumeConfigProperty> {
            java.lang.Number volumeSizeInGb;

            /**
             * Sets the value of {@link ClusterEbsVolumeConfigProperty#getVolumeSizeInGb}
             * @param volumeSizeInGb The size in gigabytes (GB) of the additional EBS volume to be attached to the instances in the SageMaker HyperPod cluster instance group.
             *                       The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterEbsVolumeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterEbsVolumeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterEbsVolumeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterEbsVolumeConfigProperty {
            private final java.lang.Number volumeSizeInGb;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.volumeSizeInGb = builder.volumeSizeInGb;
            }

            @Override
            public final java.lang.Number getVolumeSizeInGb() {
                return this.volumeSizeInGb;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getVolumeSizeInGb() != null) {
                    data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterEbsVolumeConfigProperty.Jsii$Proxy that = (ClusterEbsVolumeConfigProperty.Jsii$Proxy) o;

                return this.volumeSizeInGb != null ? this.volumeSizeInGb.equals(that.volumeSizeInGb) : that.volumeSizeInGb == null;
            }

            @Override
            public final int hashCode() {
                int result = this.volumeSizeInGb != null ? this.volumeSizeInGb.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration information of the instance group within the HyperPod cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterInstanceGroupProperty clusterInstanceGroupProperty = ClusterInstanceGroupProperty.builder()
     *         .executionRole("executionRole")
     *         .instanceCount(123)
     *         .instanceGroupName("instanceGroupName")
     *         .instanceType("instanceType")
     *         .lifeCycleConfig(ClusterLifeCycleConfigProperty.builder()
     *                 .onCreate("onCreate")
     *                 .sourceS3Uri("sourceS3Uri")
     *                 .build())
     *         // the properties below are optional
     *         .currentCount(123)
     *         .imageId("imageId")
     *         .instanceStorageConfigs(List.of(ClusterInstanceStorageConfigProperty.builder()
     *                 .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
     *                         .volumeSizeInGb(123)
     *                         .build())
     *                 .build()))
     *         .onStartDeepHealthChecks(List.of("onStartDeepHealthChecks"))
     *         .overrideVpcConfig(VpcConfigProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .scheduledUpdateConfig(ScheduledUpdateConfigProperty.builder()
     *                 .scheduleExpression("scheduleExpression")
     *                 // the properties below are optional
     *                 .deploymentConfig(DeploymentConfigProperty.builder()
     *                         .autoRollbackConfiguration(List.of(AlarmDetailsProperty.builder()
     *                                 .alarmName("alarmName")
     *                                 .build()))
     *                         .rollingUpdatePolicy(RollingUpdatePolicyProperty.builder()
     *                                 .maximumBatchSize(CapacitySizeConfigProperty.builder()
     *                                         .type("type")
     *                                         .value(123)
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .rollbackMaximumBatchSize(CapacitySizeConfigProperty.builder()
     *                                         .type("type")
     *                                         .value(123)
     *                                         .build())
     *                                 .build())
     *                         .waitIntervalInSeconds(123)
     *                         .build())
     *                 .build())
     *         .threadsPerCore(123)
     *         .trainingPlanArn("trainingPlanArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterInstanceGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterInstanceGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The execution role for the instance group to assume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

        /**
         * The number of instances in an instance group of the SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * The name of the instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancegroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancegroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceGroupName();

        /**
         * The instance type of the instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The lifecycle configuration for a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-lifecycleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-lifecycleconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getLifeCycleConfig();

        /**
         * The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-currentcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-currentcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCurrentCount() {
            return null;
        }

        /**
         * AMI Id to be used for launching EC2 instances - HyperPodPublicAmiId or CustomAmiId.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-imageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-imageid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageId() {
            return null;
        }

        /**
         * The configurations of additional storage specified to the instance group where the instance (node) is launched.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancestorageconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-instancestorageconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceStorageConfigs() {
            return null;
        }

        /**
         * A flag indicating whether deep health checks should be performed when the HyperPod cluster instance group is created or updated.
         * <p>
         * Deep health checks are comprehensive, invasive tests that validate the health of the underlying hardware and infrastructure components.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-onstartdeephealthchecks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-onstartdeephealthchecks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOnStartDeepHealthChecks() {
            return null;
        }

        /**
         * The customized Amazon VPC configuration at the instance group level that overrides the default Amazon VPC configuration of the SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-overridevpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-overridevpcconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrideVpcConfig() {
            return null;
        }

        /**
         * The configuration object of the schedule that SageMaker follows when updating the AMI.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-scheduledupdateconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-scheduledupdateconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScheduledUpdateConfig() {
            return null;
        }

        /**
         * The number of threads per CPU core you specified under <code>CreateCluster</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-threadspercore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-threadspercore</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreadsPerCore() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the training plan to use for this cluster instance group.
         * <p>
         * For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker Training Plan, see CreateTrainingPlan.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-trainingplanarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancegroup.html#cfn-sagemaker-cluster-clusterinstancegroup-trainingplanarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrainingPlanArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterInstanceGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterInstanceGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterInstanceGroupProperty> {
            java.lang.String executionRole;
            java.lang.Number instanceCount;
            java.lang.String instanceGroupName;
            java.lang.String instanceType;
            java.lang.Object lifeCycleConfig;
            java.lang.Number currentCount;
            java.lang.String imageId;
            java.lang.Object instanceStorageConfigs;
            java.util.List<java.lang.String> onStartDeepHealthChecks;
            java.lang.Object overrideVpcConfig;
            java.lang.Object scheduledUpdateConfig;
            java.lang.Number threadsPerCore;
            java.lang.String trainingPlanArn;

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getExecutionRole}
             * @param executionRole The execution role for the instance group to assume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceCount}
             * @param instanceCount The number of instances in an instance group of the SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceGroupName}
             * @param instanceGroupName The name of the instance group of a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceGroupName(java.lang.String instanceGroupName) {
                this.instanceGroupName = instanceGroupName;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceType}
             * @param instanceType The instance type of the instance group of a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getLifeCycleConfig}
             * @param lifeCycleConfig The lifecycle configuration for a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifeCycleConfig(software.amazon.awscdk.IResolvable lifeCycleConfig) {
                this.lifeCycleConfig = lifeCycleConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getLifeCycleConfig}
             * @param lifeCycleConfig The lifecycle configuration for a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lifeCycleConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterLifeCycleConfigProperty lifeCycleConfig) {
                this.lifeCycleConfig = lifeCycleConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getCurrentCount}
             * @param currentCount The number of instances that are currently in the instance group of a SageMaker HyperPod cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentCount(java.lang.Number currentCount) {
                this.currentCount = currentCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getImageId}
             * @param imageId AMI Id to be used for launching EC2 instances - HyperPodPublicAmiId or CustomAmiId.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageId(java.lang.String imageId) {
                this.imageId = imageId;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceStorageConfigs}
             * @param instanceStorageConfigs The configurations of additional storage specified to the instance group where the instance (node) is launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceStorageConfigs(software.amazon.awscdk.IResolvable instanceStorageConfigs) {
                this.instanceStorageConfigs = instanceStorageConfigs;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getInstanceStorageConfigs}
             * @param instanceStorageConfigs The configurations of additional storage specified to the instance group where the instance (node) is launched.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceStorageConfigs(java.util.List<? extends java.lang.Object> instanceStorageConfigs) {
                this.instanceStorageConfigs = instanceStorageConfigs;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getOnStartDeepHealthChecks}
             * @param onStartDeepHealthChecks A flag indicating whether deep health checks should be performed when the HyperPod cluster instance group is created or updated.
             *                                Deep health checks are comprehensive, invasive tests that validate the health of the underlying hardware and infrastructure components.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onStartDeepHealthChecks(java.util.List<java.lang.String> onStartDeepHealthChecks) {
                this.onStartDeepHealthChecks = onStartDeepHealthChecks;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getOverrideVpcConfig}
             * @param overrideVpcConfig The customized Amazon VPC configuration at the instance group level that overrides the default Amazon VPC configuration of the SageMaker HyperPod cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideVpcConfig(software.amazon.awscdk.IResolvable overrideVpcConfig) {
                this.overrideVpcConfig = overrideVpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getOverrideVpcConfig}
             * @param overrideVpcConfig The customized Amazon VPC configuration at the instance group level that overrides the default Amazon VPC configuration of the SageMaker HyperPod cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideVpcConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.VpcConfigProperty overrideVpcConfig) {
                this.overrideVpcConfig = overrideVpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getScheduledUpdateConfig}
             * @param scheduledUpdateConfig The configuration object of the schedule that SageMaker follows when updating the AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledUpdateConfig(software.amazon.awscdk.IResolvable scheduledUpdateConfig) {
                this.scheduledUpdateConfig = scheduledUpdateConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getScheduledUpdateConfig}
             * @param scheduledUpdateConfig The configuration object of the schedule that SageMaker follows when updating the AMI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledUpdateConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.ScheduledUpdateConfigProperty scheduledUpdateConfig) {
                this.scheduledUpdateConfig = scheduledUpdateConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getThreadsPerCore}
             * @param threadsPerCore The number of threads per CPU core you specified under <code>CreateCluster</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threadsPerCore(java.lang.Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceGroupProperty#getTrainingPlanArn}
             * @param trainingPlanArn The Amazon Resource Name (ARN) of the training plan to use for this cluster instance group.
             *                        For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker Training Plan, see CreateTrainingPlan.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trainingPlanArn(java.lang.String trainingPlanArn) {
                this.trainingPlanArn = trainingPlanArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterInstanceGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterInstanceGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterInstanceGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterInstanceGroupProperty {
            private final java.lang.String executionRole;
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceGroupName;
            private final java.lang.String instanceType;
            private final java.lang.Object lifeCycleConfig;
            private final java.lang.Number currentCount;
            private final java.lang.String imageId;
            private final java.lang.Object instanceStorageConfigs;
            private final java.util.List<java.lang.String> onStartDeepHealthChecks;
            private final java.lang.Object overrideVpcConfig;
            private final java.lang.Object scheduledUpdateConfig;
            private final java.lang.Number threadsPerCore;
            private final java.lang.String trainingPlanArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceGroupName = software.amazon.jsii.Kernel.get(this, "instanceGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lifeCycleConfig = software.amazon.jsii.Kernel.get(this, "lifeCycleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.currentCount = software.amazon.jsii.Kernel.get(this, "currentCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.imageId = software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceStorageConfigs = software.amazon.jsii.Kernel.get(this, "instanceStorageConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onStartDeepHealthChecks = software.amazon.jsii.Kernel.get(this, "onStartDeepHealthChecks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.overrideVpcConfig = software.amazon.jsii.Kernel.get(this, "overrideVpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scheduledUpdateConfig = software.amazon.jsii.Kernel.get(this, "scheduledUpdateConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threadsPerCore = software.amazon.jsii.Kernel.get(this, "threadsPerCore", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.trainingPlanArn = software.amazon.jsii.Kernel.get(this, "trainingPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceGroupName = java.util.Objects.requireNonNull(builder.instanceGroupName, "instanceGroupName is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.lifeCycleConfig = java.util.Objects.requireNonNull(builder.lifeCycleConfig, "lifeCycleConfig is required");
                this.currentCount = builder.currentCount;
                this.imageId = builder.imageId;
                this.instanceStorageConfigs = builder.instanceStorageConfigs;
                this.onStartDeepHealthChecks = builder.onStartDeepHealthChecks;
                this.overrideVpcConfig = builder.overrideVpcConfig;
                this.scheduledUpdateConfig = builder.scheduledUpdateConfig;
                this.threadsPerCore = builder.threadsPerCore;
                this.trainingPlanArn = builder.trainingPlanArn;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceGroupName() {
                return this.instanceGroupName;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Object getLifeCycleConfig() {
                return this.lifeCycleConfig;
            }

            @Override
            public final java.lang.Number getCurrentCount() {
                return this.currentCount;
            }

            @Override
            public final java.lang.String getImageId() {
                return this.imageId;
            }

            @Override
            public final java.lang.Object getInstanceStorageConfigs() {
                return this.instanceStorageConfigs;
            }

            @Override
            public final java.util.List<java.lang.String> getOnStartDeepHealthChecks() {
                return this.onStartDeepHealthChecks;
            }

            @Override
            public final java.lang.Object getOverrideVpcConfig() {
                return this.overrideVpcConfig;
            }

            @Override
            public final java.lang.Object getScheduledUpdateConfig() {
                return this.scheduledUpdateConfig;
            }

            @Override
            public final java.lang.Number getThreadsPerCore() {
                return this.threadsPerCore;
            }

            @Override
            public final java.lang.String getTrainingPlanArn() {
                return this.trainingPlanArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceGroupName", om.valueToTree(this.getInstanceGroupName()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("lifeCycleConfig", om.valueToTree(this.getLifeCycleConfig()));
                if (this.getCurrentCount() != null) {
                    data.set("currentCount", om.valueToTree(this.getCurrentCount()));
                }
                if (this.getImageId() != null) {
                    data.set("imageId", om.valueToTree(this.getImageId()));
                }
                if (this.getInstanceStorageConfigs() != null) {
                    data.set("instanceStorageConfigs", om.valueToTree(this.getInstanceStorageConfigs()));
                }
                if (this.getOnStartDeepHealthChecks() != null) {
                    data.set("onStartDeepHealthChecks", om.valueToTree(this.getOnStartDeepHealthChecks()));
                }
                if (this.getOverrideVpcConfig() != null) {
                    data.set("overrideVpcConfig", om.valueToTree(this.getOverrideVpcConfig()));
                }
                if (this.getScheduledUpdateConfig() != null) {
                    data.set("scheduledUpdateConfig", om.valueToTree(this.getScheduledUpdateConfig()));
                }
                if (this.getThreadsPerCore() != null) {
                    data.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                }
                if (this.getTrainingPlanArn() != null) {
                    data.set("trainingPlanArn", om.valueToTree(this.getTrainingPlanArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterInstanceGroupProperty.Jsii$Proxy that = (ClusterInstanceGroupProperty.Jsii$Proxy) o;

                if (!executionRole.equals(that.executionRole)) return false;
                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceGroupName.equals(that.instanceGroupName)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!lifeCycleConfig.equals(that.lifeCycleConfig)) return false;
                if (this.currentCount != null ? !this.currentCount.equals(that.currentCount) : that.currentCount != null) return false;
                if (this.imageId != null ? !this.imageId.equals(that.imageId) : that.imageId != null) return false;
                if (this.instanceStorageConfigs != null ? !this.instanceStorageConfigs.equals(that.instanceStorageConfigs) : that.instanceStorageConfigs != null) return false;
                if (this.onStartDeepHealthChecks != null ? !this.onStartDeepHealthChecks.equals(that.onStartDeepHealthChecks) : that.onStartDeepHealthChecks != null) return false;
                if (this.overrideVpcConfig != null ? !this.overrideVpcConfig.equals(that.overrideVpcConfig) : that.overrideVpcConfig != null) return false;
                if (this.scheduledUpdateConfig != null ? !this.scheduledUpdateConfig.equals(that.scheduledUpdateConfig) : that.scheduledUpdateConfig != null) return false;
                if (this.threadsPerCore != null ? !this.threadsPerCore.equals(that.threadsPerCore) : that.threadsPerCore != null) return false;
                return this.trainingPlanArn != null ? this.trainingPlanArn.equals(that.trainingPlanArn) : that.trainingPlanArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.executionRole.hashCode();
                result = 31 * result + (this.instanceCount.hashCode());
                result = 31 * result + (this.instanceGroupName.hashCode());
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.lifeCycleConfig.hashCode());
                result = 31 * result + (this.currentCount != null ? this.currentCount.hashCode() : 0);
                result = 31 * result + (this.imageId != null ? this.imageId.hashCode() : 0);
                result = 31 * result + (this.instanceStorageConfigs != null ? this.instanceStorageConfigs.hashCode() : 0);
                result = 31 * result + (this.onStartDeepHealthChecks != null ? this.onStartDeepHealthChecks.hashCode() : 0);
                result = 31 * result + (this.overrideVpcConfig != null ? this.overrideVpcConfig.hashCode() : 0);
                result = 31 * result + (this.scheduledUpdateConfig != null ? this.scheduledUpdateConfig.hashCode() : 0);
                result = 31 * result + (this.threadsPerCore != null ? this.threadsPerCore.hashCode() : 0);
                result = 31 * result + (this.trainingPlanArn != null ? this.trainingPlanArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the configuration for attaching additional storage to the instances in the SageMaker HyperPod cluster instance group.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-release-notes.html#sagemaker-hyperpod-release-notes-20240620">SageMaker HyperPod release notes: June 20, 2024</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterInstanceStorageConfigProperty clusterInstanceStorageConfigProperty = ClusterInstanceStorageConfigProperty.builder()
     *         .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
     *                 .volumeSizeInGb(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterInstanceStorageConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterInstanceStorageConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in the SageMaker HyperPod cluster instance group.
         * <p>
         * The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html#cfn-sagemaker-cluster-clusterinstancestorageconfig-ebsvolumeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterinstancestorageconfig.html#cfn-sagemaker-cluster-clusterinstancestorageconfig-ebsvolumeconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsVolumeConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterInstanceStorageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterInstanceStorageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterInstanceStorageConfigProperty> {
            java.lang.Object ebsVolumeConfig;

            /**
             * Sets the value of {@link ClusterInstanceStorageConfigProperty#getEbsVolumeConfig}
             * @param ebsVolumeConfig Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in the SageMaker HyperPod cluster instance group.
             *                        The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsVolumeConfig(software.amazon.awscdk.IResolvable ebsVolumeConfig) {
                this.ebsVolumeConfig = ebsVolumeConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterInstanceStorageConfigProperty#getEbsVolumeConfig}
             * @param ebsVolumeConfig Defines the configuration for attaching additional Amazon Elastic Block Store (EBS) volumes to the instances in the SageMaker HyperPod cluster instance group.
             *                        The additional EBS volume is attached to each instance within the SageMaker HyperPod cluster instance group and mounted to <code>/opt/sagemaker</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsVolumeConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterEbsVolumeConfigProperty ebsVolumeConfig) {
                this.ebsVolumeConfig = ebsVolumeConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterInstanceStorageConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterInstanceStorageConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterInstanceStorageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterInstanceStorageConfigProperty {
            private final java.lang.Object ebsVolumeConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsVolumeConfig = software.amazon.jsii.Kernel.get(this, "ebsVolumeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsVolumeConfig = builder.ebsVolumeConfig;
            }

            @Override
            public final java.lang.Object getEbsVolumeConfig() {
                return this.ebsVolumeConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsVolumeConfig() != null) {
                    data.set("ebsVolumeConfig", om.valueToTree(this.getEbsVolumeConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterInstanceStorageConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterInstanceStorageConfigProperty.Jsii$Proxy that = (ClusterInstanceStorageConfigProperty.Jsii$Proxy) o;

                return this.ebsVolumeConfig != null ? this.ebsVolumeConfig.equals(that.ebsVolumeConfig) : that.ebsVolumeConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsVolumeConfig != null ? this.ebsVolumeConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The lifecycle configuration for a SageMaker HyperPod cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterLifeCycleConfigProperty clusterLifeCycleConfigProperty = ClusterLifeCycleConfigProperty.builder()
     *         .onCreate("onCreate")
     *         .sourceS3Uri("sourceS3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterLifeCycleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterLifeCycleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterLifeCycleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file name of the entrypoint script of lifecycle scripts under <code>SourceS3Uri</code> .
         * <p>
         * This entrypoint script runs during cluster creation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-oncreate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-oncreate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOnCreate();

        /**
         * An Amazon S3 bucket path where your lifecycle scripts are stored.
         * <p>
         * <blockquote>
         * <p>
         * Make sure that the S3 bucket path starts with <code>s3://sagemaker-</code> . The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod">IAM role for SageMaker HyperPod</a> has the managed <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html"><code>AmazonSageMakerClusterInstanceRolePolicy</code></a> attached, which allows access to S3 buckets with the specific prefix <code>sagemaker-</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-sources3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterlifecycleconfig.html#cfn-sagemaker-cluster-clusterlifecycleconfig-sources3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceS3Uri();

        /**
         * @return a {@link Builder} of {@link ClusterLifeCycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterLifeCycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterLifeCycleConfigProperty> {
            java.lang.String onCreate;
            java.lang.String sourceS3Uri;

            /**
             * Sets the value of {@link ClusterLifeCycleConfigProperty#getOnCreate}
             * @param onCreate The file name of the entrypoint script of lifecycle scripts under <code>SourceS3Uri</code> . This parameter is required.
             *                 This entrypoint script runs during cluster creation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onCreate(java.lang.String onCreate) {
                this.onCreate = onCreate;
                return this;
            }

            /**
             * Sets the value of {@link ClusterLifeCycleConfigProperty#getSourceS3Uri}
             * @param sourceS3Uri An Amazon S3 bucket path where your lifecycle scripts are stored. This parameter is required.
             *                    <blockquote>
             *                    <p>
             *                    Make sure that the S3 bucket path starts with <code>s3://sagemaker-</code> . The <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod">IAM role for SageMaker HyperPod</a> has the managed <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html"><code>AmazonSageMakerClusterInstanceRolePolicy</code></a> attached, which allows access to S3 buckets with the specific prefix <code>sagemaker-</code> .
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceS3Uri(java.lang.String sourceS3Uri) {
                this.sourceS3Uri = sourceS3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterLifeCycleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterLifeCycleConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterLifeCycleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterLifeCycleConfigProperty {
            private final java.lang.String onCreate;
            private final java.lang.String sourceS3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onCreate = software.amazon.jsii.Kernel.get(this, "onCreate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceS3Uri = software.amazon.jsii.Kernel.get(this, "sourceS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onCreate = java.util.Objects.requireNonNull(builder.onCreate, "onCreate is required");
                this.sourceS3Uri = java.util.Objects.requireNonNull(builder.sourceS3Uri, "sourceS3Uri is required");
            }

            @Override
            public final java.lang.String getOnCreate() {
                return this.onCreate;
            }

            @Override
            public final java.lang.String getSourceS3Uri() {
                return this.sourceS3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("onCreate", om.valueToTree(this.getOnCreate()));
                data.set("sourceS3Uri", om.valueToTree(this.getSourceS3Uri()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterLifeCycleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterLifeCycleConfigProperty.Jsii$Proxy that = (ClusterLifeCycleConfigProperty.Jsii$Proxy) o;

                if (!onCreate.equals(that.onCreate)) return false;
                return this.sourceS3Uri.equals(that.sourceS3Uri);
            }

            @Override
            public final int hashCode() {
                int result = this.onCreate.hashCode();
                result = 31 * result + (this.sourceS3Uri.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration for the Amazon EKS cluster that is used as the orchestrator for the SageMaker HyperPod cluster.
     * <p>
     * This includes the Amazon Resource Name (ARN) of the EKS cluster
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterOrchestratorEksConfigProperty clusterOrchestratorEksConfigProperty = ClusterOrchestratorEksConfigProperty.builder()
     *         .clusterArn("clusterArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterOrchestratorEksConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterOrchestratorEksConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html#cfn-sagemaker-cluster-clusterorchestratoreksconfig-clusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterorchestratoreksconfig.html#cfn-sagemaker-cluster-clusterorchestratoreksconfig-clusterarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterArn();

        /**
         * @return a {@link Builder} of {@link ClusterOrchestratorEksConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterOrchestratorEksConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterOrchestratorEksConfigProperty> {
            java.lang.String clusterArn;

            /**
             * Sets the value of {@link ClusterOrchestratorEksConfigProperty#getClusterArn}
             * @param clusterArn The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterArn(java.lang.String clusterArn) {
                this.clusterArn = clusterArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterOrchestratorEksConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterOrchestratorEksConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterOrchestratorEksConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterOrchestratorEksConfigProperty {
            private final java.lang.String clusterArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterArn = software.amazon.jsii.Kernel.get(this, "clusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterArn = java.util.Objects.requireNonNull(builder.clusterArn, "clusterArn is required");
            }

            @Override
            public final java.lang.String getClusterArn() {
                return this.clusterArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterArn", om.valueToTree(this.getClusterArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterOrchestratorEksConfigProperty.Jsii$Proxy that = (ClusterOrchestratorEksConfigProperty.Jsii$Proxy) o;

                return this.clusterArn.equals(that.clusterArn);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Details of a restricted instance group in a SageMaker HyperPod cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterRestrictedInstanceGroupProperty clusterRestrictedInstanceGroupProperty = ClusterRestrictedInstanceGroupProperty.builder()
     *         .environmentConfig(EnvironmentConfigProperty.builder()
     *                 .fSxLustreConfig(FSxLustreConfigProperty.builder()
     *                         .perUnitStorageThroughput(123)
     *                         .sizeInGiB(123)
     *                         .build())
     *                 .build())
     *         .executionRole("executionRole")
     *         .instanceCount(123)
     *         .instanceGroupName("instanceGroupName")
     *         .instanceType("instanceType")
     *         // the properties below are optional
     *         .currentCount(123)
     *         .instanceStorageConfigs(List.of(ClusterInstanceStorageConfigProperty.builder()
     *                 .ebsVolumeConfig(ClusterEbsVolumeConfigProperty.builder()
     *                         .volumeSizeInGb(123)
     *                         .build())
     *                 .build()))
     *         .onStartDeepHealthChecks(List.of("onStartDeepHealthChecks"))
     *         .overrideVpcConfig(VpcConfigProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .threadsPerCore(123)
     *         .trainingPlanArn("trainingPlanArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterRestrictedInstanceGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterRestrictedInstanceGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterRestrictedInstanceGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for the restricted instance groups (RIG) environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-environmentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-environmentconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnvironmentConfig();

        /**
         * The execution role for the instance group to assume.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-executionrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

        /**
         * The number of instances you specified to add to the restricted instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-instancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * The name of the instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-instancegroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-instancegroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceGroupName();

        /**
         * The instance type of the instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The number of instances that are currently in the restricted instance group of a SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-currentcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-currentcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCurrentCount() {
            return null;
        }

        /**
         * The instance storage configuration for the instance group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-instancestorageconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-instancestorageconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceStorageConfigs() {
            return null;
        }

        /**
         * Nodes will undergo advanced stress test to detect and replace faulty instances, based on the type of deep health check(s) passed in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-onstartdeephealthchecks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-onstartdeephealthchecks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOnStartDeepHealthChecks() {
            return null;
        }

        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
         * <p>
         * You can control access to and from your resources by configuring a VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-overridevpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-overridevpcconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrideVpcConfig() {
            return null;
        }

        /**
         * The number you specified to TreadsPerCore in CreateCluster for enabling or disabling multithreading.
         * <p>
         * For instance types that support multithreading, you can specify 1 for disabling multithreading and 2 for enabling multithreading.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-threadspercore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-threadspercore</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThreadsPerCore() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the training plan to use for this cluster restricted instance group.
         * <p>
         * For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker Training Plan, see CreateTrainingPlan.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-trainingplanarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-clusterrestrictedinstancegroup.html#cfn-sagemaker-cluster-clusterrestrictedinstancegroup-trainingplanarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrainingPlanArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterRestrictedInstanceGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterRestrictedInstanceGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterRestrictedInstanceGroupProperty> {
            java.lang.Object environmentConfig;
            java.lang.String executionRole;
            java.lang.Number instanceCount;
            java.lang.String instanceGroupName;
            java.lang.String instanceType;
            java.lang.Number currentCount;
            java.lang.Object instanceStorageConfigs;
            java.util.List<java.lang.String> onStartDeepHealthChecks;
            java.lang.Object overrideVpcConfig;
            java.lang.Number threadsPerCore;
            java.lang.String trainingPlanArn;

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getEnvironmentConfig}
             * @param environmentConfig The configuration for the restricted instance groups (RIG) environment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentConfig(software.amazon.awscdk.IResolvable environmentConfig) {
                this.environmentConfig = environmentConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getEnvironmentConfig}
             * @param environmentConfig The configuration for the restricted instance groups (RIG) environment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.EnvironmentConfigProperty environmentConfig) {
                this.environmentConfig = environmentConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getExecutionRole}
             * @param executionRole The execution role for the instance group to assume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRole(java.lang.String executionRole) {
                this.executionRole = executionRole;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getInstanceCount}
             * @param instanceCount The number of instances you specified to add to the restricted instance group of a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getInstanceGroupName}
             * @param instanceGroupName The name of the instance group of a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceGroupName(java.lang.String instanceGroupName) {
                this.instanceGroupName = instanceGroupName;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getInstanceType}
             * @param instanceType The instance type of the instance group of a SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getCurrentCount}
             * @param currentCount The number of instances that are currently in the restricted instance group of a SageMaker HyperPod cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentCount(java.lang.Number currentCount) {
                this.currentCount = currentCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getInstanceStorageConfigs}
             * @param instanceStorageConfigs The instance storage configuration for the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceStorageConfigs(software.amazon.awscdk.IResolvable instanceStorageConfigs) {
                this.instanceStorageConfigs = instanceStorageConfigs;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getInstanceStorageConfigs}
             * @param instanceStorageConfigs The instance storage configuration for the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceStorageConfigs(java.util.List<? extends java.lang.Object> instanceStorageConfigs) {
                this.instanceStorageConfigs = instanceStorageConfigs;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getOnStartDeepHealthChecks}
             * @param onStartDeepHealthChecks Nodes will undergo advanced stress test to detect and replace faulty instances, based on the type of deep health check(s) passed in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onStartDeepHealthChecks(java.util.List<java.lang.String> onStartDeepHealthChecks) {
                this.onStartDeepHealthChecks = onStartDeepHealthChecks;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getOverrideVpcConfig}
             * @param overrideVpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
             *                          You can control access to and from your resources by configuring a VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideVpcConfig(software.amazon.awscdk.IResolvable overrideVpcConfig) {
                this.overrideVpcConfig = overrideVpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getOverrideVpcConfig}
             * @param overrideVpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
             *                          You can control access to and from your resources by configuring a VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideVpcConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.VpcConfigProperty overrideVpcConfig) {
                this.overrideVpcConfig = overrideVpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getThreadsPerCore}
             * @param threadsPerCore The number you specified to TreadsPerCore in CreateCluster for enabling or disabling multithreading.
             *                       For instance types that support multithreading, you can specify 1 for disabling multithreading and 2 for enabling multithreading.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threadsPerCore(java.lang.Number threadsPerCore) {
                this.threadsPerCore = threadsPerCore;
                return this;
            }

            /**
             * Sets the value of {@link ClusterRestrictedInstanceGroupProperty#getTrainingPlanArn}
             * @param trainingPlanArn The Amazon Resource Name (ARN) of the training plan to use for this cluster restricted instance group.
             *                        For more information about how to reserve GPU capacity for your SageMaker HyperPod clusters using Amazon SageMaker Training Plan, see CreateTrainingPlan.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trainingPlanArn(java.lang.String trainingPlanArn) {
                this.trainingPlanArn = trainingPlanArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterRestrictedInstanceGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterRestrictedInstanceGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterRestrictedInstanceGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterRestrictedInstanceGroupProperty {
            private final java.lang.Object environmentConfig;
            private final java.lang.String executionRole;
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceGroupName;
            private final java.lang.String instanceType;
            private final java.lang.Number currentCount;
            private final java.lang.Object instanceStorageConfigs;
            private final java.util.List<java.lang.String> onStartDeepHealthChecks;
            private final java.lang.Object overrideVpcConfig;
            private final java.lang.Number threadsPerCore;
            private final java.lang.String trainingPlanArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.environmentConfig = software.amazon.jsii.Kernel.get(this, "environmentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceGroupName = software.amazon.jsii.Kernel.get(this, "instanceGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.currentCount = software.amazon.jsii.Kernel.get(this, "currentCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceStorageConfigs = software.amazon.jsii.Kernel.get(this, "instanceStorageConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onStartDeepHealthChecks = software.amazon.jsii.Kernel.get(this, "onStartDeepHealthChecks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.overrideVpcConfig = software.amazon.jsii.Kernel.get(this, "overrideVpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.threadsPerCore = software.amazon.jsii.Kernel.get(this, "threadsPerCore", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.trainingPlanArn = software.amazon.jsii.Kernel.get(this, "trainingPlanArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.environmentConfig = java.util.Objects.requireNonNull(builder.environmentConfig, "environmentConfig is required");
                this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceGroupName = java.util.Objects.requireNonNull(builder.instanceGroupName, "instanceGroupName is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.currentCount = builder.currentCount;
                this.instanceStorageConfigs = builder.instanceStorageConfigs;
                this.onStartDeepHealthChecks = builder.onStartDeepHealthChecks;
                this.overrideVpcConfig = builder.overrideVpcConfig;
                this.threadsPerCore = builder.threadsPerCore;
                this.trainingPlanArn = builder.trainingPlanArn;
            }

            @Override
            public final java.lang.Object getEnvironmentConfig() {
                return this.environmentConfig;
            }

            @Override
            public final java.lang.String getExecutionRole() {
                return this.executionRole;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceGroupName() {
                return this.instanceGroupName;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getCurrentCount() {
                return this.currentCount;
            }

            @Override
            public final java.lang.Object getInstanceStorageConfigs() {
                return this.instanceStorageConfigs;
            }

            @Override
            public final java.util.List<java.lang.String> getOnStartDeepHealthChecks() {
                return this.onStartDeepHealthChecks;
            }

            @Override
            public final java.lang.Object getOverrideVpcConfig() {
                return this.overrideVpcConfig;
            }

            @Override
            public final java.lang.Number getThreadsPerCore() {
                return this.threadsPerCore;
            }

            @Override
            public final java.lang.String getTrainingPlanArn() {
                return this.trainingPlanArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("environmentConfig", om.valueToTree(this.getEnvironmentConfig()));
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceGroupName", om.valueToTree(this.getInstanceGroupName()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getCurrentCount() != null) {
                    data.set("currentCount", om.valueToTree(this.getCurrentCount()));
                }
                if (this.getInstanceStorageConfigs() != null) {
                    data.set("instanceStorageConfigs", om.valueToTree(this.getInstanceStorageConfigs()));
                }
                if (this.getOnStartDeepHealthChecks() != null) {
                    data.set("onStartDeepHealthChecks", om.valueToTree(this.getOnStartDeepHealthChecks()));
                }
                if (this.getOverrideVpcConfig() != null) {
                    data.set("overrideVpcConfig", om.valueToTree(this.getOverrideVpcConfig()));
                }
                if (this.getThreadsPerCore() != null) {
                    data.set("threadsPerCore", om.valueToTree(this.getThreadsPerCore()));
                }
                if (this.getTrainingPlanArn() != null) {
                    data.set("trainingPlanArn", om.valueToTree(this.getTrainingPlanArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ClusterRestrictedInstanceGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterRestrictedInstanceGroupProperty.Jsii$Proxy that = (ClusterRestrictedInstanceGroupProperty.Jsii$Proxy) o;

                if (!environmentConfig.equals(that.environmentConfig)) return false;
                if (!executionRole.equals(that.executionRole)) return false;
                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceGroupName.equals(that.instanceGroupName)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (this.currentCount != null ? !this.currentCount.equals(that.currentCount) : that.currentCount != null) return false;
                if (this.instanceStorageConfigs != null ? !this.instanceStorageConfigs.equals(that.instanceStorageConfigs) : that.instanceStorageConfigs != null) return false;
                if (this.onStartDeepHealthChecks != null ? !this.onStartDeepHealthChecks.equals(that.onStartDeepHealthChecks) : that.onStartDeepHealthChecks != null) return false;
                if (this.overrideVpcConfig != null ? !this.overrideVpcConfig.equals(that.overrideVpcConfig) : that.overrideVpcConfig != null) return false;
                if (this.threadsPerCore != null ? !this.threadsPerCore.equals(that.threadsPerCore) : that.threadsPerCore != null) return false;
                return this.trainingPlanArn != null ? this.trainingPlanArn.equals(that.trainingPlanArn) : that.trainingPlanArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.environmentConfig.hashCode();
                result = 31 * result + (this.executionRole.hashCode());
                result = 31 * result + (this.instanceCount.hashCode());
                result = 31 * result + (this.instanceGroupName.hashCode());
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.currentCount != null ? this.currentCount.hashCode() : 0);
                result = 31 * result + (this.instanceStorageConfigs != null ? this.instanceStorageConfigs.hashCode() : 0);
                result = 31 * result + (this.onStartDeepHealthChecks != null ? this.onStartDeepHealthChecks.hashCode() : 0);
                result = 31 * result + (this.overrideVpcConfig != null ? this.overrideVpcConfig.hashCode() : 0);
                result = 31 * result + (this.threadsPerCore != null ? this.threadsPerCore.hashCode() : 0);
                result = 31 * result + (this.trainingPlanArn != null ? this.trainingPlanArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DeploymentConfigProperty deploymentConfigProperty = DeploymentConfigProperty.builder()
     *         .autoRollbackConfiguration(List.of(AlarmDetailsProperty.builder()
     *                 .alarmName("alarmName")
     *                 .build()))
     *         .rollingUpdatePolicy(RollingUpdatePolicyProperty.builder()
     *                 .maximumBatchSize(CapacitySizeConfigProperty.builder()
     *                         .type("type")
     *                         .value(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .rollbackMaximumBatchSize(CapacitySizeConfigProperty.builder()
     *                         .type("type")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .waitIntervalInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-deploymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-deploymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.DeploymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Automatic rollback configuration for handling endpoint deployment failures and recovery.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-deploymentconfig.html#cfn-sagemaker-cluster-deploymentconfig-autorollbackconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-deploymentconfig.html#cfn-sagemaker-cluster-deploymentconfig-autorollbackconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoRollbackConfiguration() {
            return null;
        }

        /**
         * Specifies a rolling deployment strategy for updating a SageMaker endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-deploymentconfig.html#cfn-sagemaker-cluster-deploymentconfig-rollingupdatepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-deploymentconfig.html#cfn-sagemaker-cluster-deploymentconfig-rollingupdatepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRollingUpdatePolicy() {
            return null;
        }

        /**
         * The duration in seconds that SageMaker waits before updating more instances in the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-deploymentconfig.html#cfn-sagemaker-cluster-deploymentconfig-waitintervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-deploymentconfig.html#cfn-sagemaker-cluster-deploymentconfig-waitintervalinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWaitIntervalInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentConfigProperty> {
            java.lang.Object autoRollbackConfiguration;
            java.lang.Object rollingUpdatePolicy;
            java.lang.Number waitIntervalInSeconds;

            /**
             * Sets the value of {@link DeploymentConfigProperty#getAutoRollbackConfiguration}
             * @param autoRollbackConfiguration Automatic rollback configuration for handling endpoint deployment failures and recovery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoRollbackConfiguration(software.amazon.awscdk.IResolvable autoRollbackConfiguration) {
                this.autoRollbackConfiguration = autoRollbackConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigProperty#getAutoRollbackConfiguration}
             * @param autoRollbackConfiguration Automatic rollback configuration for handling endpoint deployment failures and recovery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoRollbackConfiguration(java.util.List<? extends java.lang.Object> autoRollbackConfiguration) {
                this.autoRollbackConfiguration = autoRollbackConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigProperty#getRollingUpdatePolicy}
             * @param rollingUpdatePolicy Specifies a rolling deployment strategy for updating a SageMaker endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollingUpdatePolicy(software.amazon.awscdk.IResolvable rollingUpdatePolicy) {
                this.rollingUpdatePolicy = rollingUpdatePolicy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigProperty#getRollingUpdatePolicy}
             * @param rollingUpdatePolicy Specifies a rolling deployment strategy for updating a SageMaker endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollingUpdatePolicy(software.amazon.awscdk.services.sagemaker.CfnCluster.RollingUpdatePolicyProperty rollingUpdatePolicy) {
                this.rollingUpdatePolicy = rollingUpdatePolicy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigProperty#getWaitIntervalInSeconds}
             * @param waitIntervalInSeconds The duration in seconds that SageMaker waits before updating more instances in the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitIntervalInSeconds(java.lang.Number waitIntervalInSeconds) {
                this.waitIntervalInSeconds = waitIntervalInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentConfigProperty {
            private final java.lang.Object autoRollbackConfiguration;
            private final java.lang.Object rollingUpdatePolicy;
            private final java.lang.Number waitIntervalInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoRollbackConfiguration = software.amazon.jsii.Kernel.get(this, "autoRollbackConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rollingUpdatePolicy = software.amazon.jsii.Kernel.get(this, "rollingUpdatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.waitIntervalInSeconds = software.amazon.jsii.Kernel.get(this, "waitIntervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
                this.rollingUpdatePolicy = builder.rollingUpdatePolicy;
                this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
            }

            @Override
            public final java.lang.Object getAutoRollbackConfiguration() {
                return this.autoRollbackConfiguration;
            }

            @Override
            public final java.lang.Object getRollingUpdatePolicy() {
                return this.rollingUpdatePolicy;
            }

            @Override
            public final java.lang.Number getWaitIntervalInSeconds() {
                return this.waitIntervalInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoRollbackConfiguration() != null) {
                    data.set("autoRollbackConfiguration", om.valueToTree(this.getAutoRollbackConfiguration()));
                }
                if (this.getRollingUpdatePolicy() != null) {
                    data.set("rollingUpdatePolicy", om.valueToTree(this.getRollingUpdatePolicy()));
                }
                if (this.getWaitIntervalInSeconds() != null) {
                    data.set("waitIntervalInSeconds", om.valueToTree(this.getWaitIntervalInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.DeploymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentConfigProperty.Jsii$Proxy that = (DeploymentConfigProperty.Jsii$Proxy) o;

                if (this.autoRollbackConfiguration != null ? !this.autoRollbackConfiguration.equals(that.autoRollbackConfiguration) : that.autoRollbackConfiguration != null) return false;
                if (this.rollingUpdatePolicy != null ? !this.rollingUpdatePolicy.equals(that.rollingUpdatePolicy) : that.rollingUpdatePolicy != null) return false;
                return this.waitIntervalInSeconds != null ? this.waitIntervalInSeconds.equals(that.waitIntervalInSeconds) : that.waitIntervalInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.hashCode() : 0;
                result = 31 * result + (this.rollingUpdatePolicy != null ? this.rollingUpdatePolicy.hashCode() : 0);
                result = 31 * result + (this.waitIntervalInSeconds != null ? this.waitIntervalInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the restricted instance groups (RIG) environment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * EnvironmentConfigProperty environmentConfigProperty = EnvironmentConfigProperty.builder()
     *         .fSxLustreConfig(FSxLustreConfigProperty.builder()
     *                 .perUnitStorageThroughput(123)
     *                 .sizeInGiB(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-environmentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-environmentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.EnvironmentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-environmentconfig.html#cfn-sagemaker-cluster-environmentconfig-fsxlustreconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-environmentconfig.html#cfn-sagemaker-cluster-environmentconfig-fsxlustreconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFSxLustreConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentConfigProperty> {
            java.lang.Object fSxLustreConfig;

            /**
             * Sets the value of {@link EnvironmentConfigProperty#getFSxLustreConfig}
             * @param fSxLustreConfig Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fSxLustreConfig(software.amazon.awscdk.IResolvable fSxLustreConfig) {
                this.fSxLustreConfig = fSxLustreConfig;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentConfigProperty#getFSxLustreConfig}
             * @param fSxLustreConfig Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fSxLustreConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.FSxLustreConfigProperty fSxLustreConfig) {
                this.fSxLustreConfig = fSxLustreConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentConfigProperty {
            private final java.lang.Object fSxLustreConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fSxLustreConfig = software.amazon.jsii.Kernel.get(this, "fSxLustreConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fSxLustreConfig = builder.fSxLustreConfig;
            }

            @Override
            public final java.lang.Object getFSxLustreConfig() {
                return this.fSxLustreConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFSxLustreConfig() != null) {
                    data.set("fSxLustreConfig", om.valueToTree(this.getFSxLustreConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.EnvironmentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentConfigProperty.Jsii$Proxy that = (EnvironmentConfigProperty.Jsii$Proxy) o;

                return this.fSxLustreConfig != null ? this.fSxLustreConfig.equals(that.fSxLustreConfig) : that.fSxLustreConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fSxLustreConfig != null ? this.fSxLustreConfig.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * FSxLustreConfigProperty fSxLustreConfigProperty = FSxLustreConfigProperty.builder()
     *         .perUnitStorageThroughput(123)
     *         .sizeInGiB(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-fsxlustreconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-fsxlustreconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.FSxLustreConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FSxLustreConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FSxLustreConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The throughput capacity of the Amazon FSx for Lustre file system, measured in MB/s per TiB of storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-fsxlustreconfig.html#cfn-sagemaker-cluster-fsxlustreconfig-perunitstoragethroughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-fsxlustreconfig.html#cfn-sagemaker-cluster-fsxlustreconfig-perunitstoragethroughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPerUnitStorageThroughput();

        /**
         * The storage capacity of the Amazon FSx for Lustre file system, specified in gibibytes (GiB).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-fsxlustreconfig.html#cfn-sagemaker-cluster-fsxlustreconfig-sizeingib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-fsxlustreconfig.html#cfn-sagemaker-cluster-fsxlustreconfig-sizeingib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSizeInGiB();

        /**
         * @return a {@link Builder} of {@link FSxLustreConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FSxLustreConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FSxLustreConfigProperty> {
            java.lang.Number perUnitStorageThroughput;
            java.lang.Number sizeInGiB;

            /**
             * Sets the value of {@link FSxLustreConfigProperty#getPerUnitStorageThroughput}
             * @param perUnitStorageThroughput The throughput capacity of the Amazon FSx for Lustre file system, measured in MB/s per TiB of storage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perUnitStorageThroughput(java.lang.Number perUnitStorageThroughput) {
                this.perUnitStorageThroughput = perUnitStorageThroughput;
                return this;
            }

            /**
             * Sets the value of {@link FSxLustreConfigProperty#getSizeInGiB}
             * @param sizeInGiB The storage capacity of the Amazon FSx for Lustre file system, specified in gibibytes (GiB). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInGiB(java.lang.Number sizeInGiB) {
                this.sizeInGiB = sizeInGiB;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FSxLustreConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FSxLustreConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FSxLustreConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FSxLustreConfigProperty {
            private final java.lang.Number perUnitStorageThroughput;
            private final java.lang.Number sizeInGiB;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.perUnitStorageThroughput = software.amazon.jsii.Kernel.get(this, "perUnitStorageThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeInGiB = software.amazon.jsii.Kernel.get(this, "sizeInGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.perUnitStorageThroughput = java.util.Objects.requireNonNull(builder.perUnitStorageThroughput, "perUnitStorageThroughput is required");
                this.sizeInGiB = java.util.Objects.requireNonNull(builder.sizeInGiB, "sizeInGiB is required");
            }

            @Override
            public final java.lang.Number getPerUnitStorageThroughput() {
                return this.perUnitStorageThroughput;
            }

            @Override
            public final java.lang.Number getSizeInGiB() {
                return this.sizeInGiB;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("perUnitStorageThroughput", om.valueToTree(this.getPerUnitStorageThroughput()));
                data.set("sizeInGiB", om.valueToTree(this.getSizeInGiB()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.FSxLustreConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FSxLustreConfigProperty.Jsii$Proxy that = (FSxLustreConfigProperty.Jsii$Proxy) o;

                if (!perUnitStorageThroughput.equals(that.perUnitStorageThroughput)) return false;
                return this.sizeInGiB.equals(that.sizeInGiB);
            }

            @Override
            public final int hashCode() {
                int result = this.perUnitStorageThroughput.hashCode();
                result = 31 * result + (this.sizeInGiB.hashCode());
                return result;
            }
        }
    }
    /**
     * The orchestrator for a SageMaker HyperPod cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * OrchestratorProperty orchestratorProperty = OrchestratorProperty.builder()
     *         .eks(ClusterOrchestratorEksConfigProperty.builder()
     *                 .clusterArn("clusterArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.OrchestratorProperty")
    @software.amazon.jsii.Jsii.Proxy(OrchestratorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrchestratorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html#cfn-sagemaker-cluster-orchestrator-eks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-orchestrator.html#cfn-sagemaker-cluster-orchestrator-eks</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEks();

        /**
         * @return a {@link Builder} of {@link OrchestratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrchestratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrchestratorProperty> {
            java.lang.Object eks;

            /**
             * Sets the value of {@link OrchestratorProperty#getEks}
             * @param eks The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eks(software.amazon.awscdk.IResolvable eks) {
                this.eks = eks;
                return this;
            }

            /**
             * Sets the value of {@link OrchestratorProperty#getEks}
             * @param eks The configuration of the Amazon EKS orchestrator cluster for the SageMaker HyperPod cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eks(software.amazon.awscdk.services.sagemaker.CfnCluster.ClusterOrchestratorEksConfigProperty eks) {
                this.eks = eks;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrchestratorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrchestratorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrchestratorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrchestratorProperty {
            private final java.lang.Object eks;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eks = software.amazon.jsii.Kernel.get(this, "eks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eks = java.util.Objects.requireNonNull(builder.eks, "eks is required");
            }

            @Override
            public final java.lang.Object getEks() {
                return this.eks;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eks", om.valueToTree(this.getEks()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.OrchestratorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrchestratorProperty.Jsii$Proxy that = (OrchestratorProperty.Jsii$Proxy) o;

                return this.eks.equals(that.eks);
            }

            @Override
            public final int hashCode() {
                int result = this.eks.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a rolling deployment strategy for updating a SageMaker endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * RollingUpdatePolicyProperty rollingUpdatePolicyProperty = RollingUpdatePolicyProperty.builder()
     *         .maximumBatchSize(CapacitySizeConfigProperty.builder()
     *                 .type("type")
     *                 .value(123)
     *                 .build())
     *         // the properties below are optional
     *         .rollbackMaximumBatchSize(CapacitySizeConfigProperty.builder()
     *                 .type("type")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-rollingupdatepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-rollingupdatepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.RollingUpdatePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(RollingUpdatePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RollingUpdatePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet.
         * <p>
         * Value must be between 5% to 50% of the variant's total instance count.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-rollingupdatepolicy.html#cfn-sagemaker-cluster-rollingupdatepolicy-maximumbatchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-rollingupdatepolicy.html#cfn-sagemaker-cluster-rollingupdatepolicy-maximumbatchsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMaximumBatchSize();

        /**
         * Batch size for rollback to the old endpoint fleet.
         * <p>
         * Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-rollingupdatepolicy.html#cfn-sagemaker-cluster-rollingupdatepolicy-rollbackmaximumbatchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-rollingupdatepolicy.html#cfn-sagemaker-cluster-rollingupdatepolicy-rollbackmaximumbatchsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRollbackMaximumBatchSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RollingUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RollingUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RollingUpdatePolicyProperty> {
            java.lang.Object maximumBatchSize;
            java.lang.Object rollbackMaximumBatchSize;

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getMaximumBatchSize}
             * @param maximumBatchSize Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. This parameter is required.
             *                         Value must be between 5% to 50% of the variant's total instance count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchSize(software.amazon.awscdk.IResolvable maximumBatchSize) {
                this.maximumBatchSize = maximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getMaximumBatchSize}
             * @param maximumBatchSize Batch size for each rolling step to provision capacity and turn on traffic on the new endpoint fleet, and terminate capacity on the old endpoint fleet. This parameter is required.
             *                         Value must be between 5% to 50% of the variant's total instance count.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchSize(software.amazon.awscdk.services.sagemaker.CfnCluster.CapacitySizeConfigProperty maximumBatchSize) {
                this.maximumBatchSize = maximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getRollbackMaximumBatchSize}
             * @param rollbackMaximumBatchSize Batch size for rollback to the old endpoint fleet.
             *                                 Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollbackMaximumBatchSize(software.amazon.awscdk.IResolvable rollbackMaximumBatchSize) {
                this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link RollingUpdatePolicyProperty#getRollbackMaximumBatchSize}
             * @param rollbackMaximumBatchSize Batch size for rollback to the old endpoint fleet.
             *                                 Each rolling step to provision capacity and turn on traffic on the old endpoint fleet, and terminate capacity on the new endpoint fleet. If this field is absent, the default value will be set to 100% of total capacity which means to bring up the whole capacity of the old fleet at once during rollback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollbackMaximumBatchSize(software.amazon.awscdk.services.sagemaker.CfnCluster.CapacitySizeConfigProperty rollbackMaximumBatchSize) {
                this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RollingUpdatePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RollingUpdatePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RollingUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RollingUpdatePolicyProperty {
            private final java.lang.Object maximumBatchSize;
            private final java.lang.Object rollbackMaximumBatchSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumBatchSize = software.amazon.jsii.Kernel.get(this, "maximumBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rollbackMaximumBatchSize = software.amazon.jsii.Kernel.get(this, "rollbackMaximumBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumBatchSize = java.util.Objects.requireNonNull(builder.maximumBatchSize, "maximumBatchSize is required");
                this.rollbackMaximumBatchSize = builder.rollbackMaximumBatchSize;
            }

            @Override
            public final java.lang.Object getMaximumBatchSize() {
                return this.maximumBatchSize;
            }

            @Override
            public final java.lang.Object getRollbackMaximumBatchSize() {
                return this.rollbackMaximumBatchSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maximumBatchSize", om.valueToTree(this.getMaximumBatchSize()));
                if (this.getRollbackMaximumBatchSize() != null) {
                    data.set("rollbackMaximumBatchSize", om.valueToTree(this.getRollbackMaximumBatchSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.RollingUpdatePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RollingUpdatePolicyProperty.Jsii$Proxy that = (RollingUpdatePolicyProperty.Jsii$Proxy) o;

                if (!maximumBatchSize.equals(that.maximumBatchSize)) return false;
                return this.rollbackMaximumBatchSize != null ? this.rollbackMaximumBatchSize.equals(that.rollbackMaximumBatchSize) : that.rollbackMaximumBatchSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximumBatchSize.hashCode();
                result = 31 * result + (this.rollbackMaximumBatchSize != null ? this.rollbackMaximumBatchSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration object of the schedule that SageMaker follows when updating the AMI.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ScheduledUpdateConfigProperty scheduledUpdateConfigProperty = ScheduledUpdateConfigProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         // the properties below are optional
     *         .deploymentConfig(DeploymentConfigProperty.builder()
     *                 .autoRollbackConfiguration(List.of(AlarmDetailsProperty.builder()
     *                         .alarmName("alarmName")
     *                         .build()))
     *                 .rollingUpdatePolicy(RollingUpdatePolicyProperty.builder()
     *                         .maximumBatchSize(CapacitySizeConfigProperty.builder()
     *                                 .type("type")
     *                                 .value(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .rollbackMaximumBatchSize(CapacitySizeConfigProperty.builder()
     *                                 .type("type")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .waitIntervalInSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-scheduledupdateconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-scheduledupdateconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.ScheduledUpdateConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduledUpdateConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduledUpdateConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A cron expression that specifies the schedule that SageMaker follows when updating the AMI.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-scheduledupdateconfig.html#cfn-sagemaker-cluster-scheduledupdateconfig-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-scheduledupdateconfig.html#cfn-sagemaker-cluster-scheduledupdateconfig-scheduleexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

        /**
         * The configuration to use when updating the AMI versions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-scheduledupdateconfig.html#cfn-sagemaker-cluster-scheduledupdateconfig-deploymentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-scheduledupdateconfig.html#cfn-sagemaker-cluster-scheduledupdateconfig-deploymentconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduledUpdateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduledUpdateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduledUpdateConfigProperty> {
            java.lang.String scheduleExpression;
            java.lang.Object deploymentConfig;

            /**
             * Sets the value of {@link ScheduledUpdateConfigProperty#getScheduleExpression}
             * @param scheduleExpression A cron expression that specifies the schedule that SageMaker follows when updating the AMI. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledUpdateConfigProperty#getDeploymentConfig}
             * @param deploymentConfig The configuration to use when updating the AMI versions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentConfig(software.amazon.awscdk.IResolvable deploymentConfig) {
                this.deploymentConfig = deploymentConfig;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledUpdateConfigProperty#getDeploymentConfig}
             * @param deploymentConfig The configuration to use when updating the AMI versions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentConfig(software.amazon.awscdk.services.sagemaker.CfnCluster.DeploymentConfigProperty deploymentConfig) {
                this.deploymentConfig = deploymentConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduledUpdateConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduledUpdateConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduledUpdateConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledUpdateConfigProperty {
            private final java.lang.String scheduleExpression;
            private final java.lang.Object deploymentConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deploymentConfig = software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
                this.deploymentConfig = builder.deploymentConfig;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            public final java.lang.Object getDeploymentConfig() {
                return this.deploymentConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                if (this.getDeploymentConfig() != null) {
                    data.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.ScheduledUpdateConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduledUpdateConfigProperty.Jsii$Proxy that = (ScheduledUpdateConfigProperty.Jsii$Proxy) o;

                if (!scheduleExpression.equals(that.scheduleExpression)) return false;
                return this.deploymentConfig != null ? this.deploymentConfig.equals(that.deploymentConfig) : that.deploymentConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression.hashCode();
                result = 31 * result + (this.deploymentConfig != null ? this.deploymentConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     * <p>
     * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnCluster.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> .
         * <p>
         * Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The ID of the subnets in the VPC to which you want to connect your training job or model.
         * <p>
         * For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-cluster-vpcconfig.html#cfn-sagemaker-cluster-vpcconfig-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> . This parameter is required.
             *                         Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets The ID of the subnets in the VPC to which you want to connect your training job or model. This parameter is required.
             *                For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnCluster.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.sagemaker.CfnClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the SageMaker HyperPod cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-clustername</a>
         * @param clusterName The name of the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props().clusterName(clusterName);
            return this;
        }

        /**
         * The instance groups of the SageMaker HyperPod cluster.
         * <p>
         * To delete an instance group, remove it from the array.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups</a>
         * @param instanceGroups The instance groups of the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceGroups(final software.amazon.awscdk.IResolvable instanceGroups) {
            this.props().instanceGroups(instanceGroups);
            return this;
        }
        /**
         * The instance groups of the SageMaker HyperPod cluster.
         * <p>
         * To delete an instance group, remove it from the array.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-instancegroups</a>
         * @param instanceGroups The instance groups of the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceGroups(final java.util.List<? extends java.lang.Object> instanceGroups) {
            this.props().instanceGroups(instanceGroups);
            return this;
        }

        /**
         * Determines the scaling strategy for the SageMaker HyperPod cluster.
         * <p>
         * When set to 'Continuous', enables continuous scaling which dynamically manages node provisioning. If the parameter is omitted, uses the standard scaling approach in previous release.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-nodeprovisioningmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-nodeprovisioningmode</a>
         * @param nodeProvisioningMode Determines the scaling strategy for the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProvisioningMode(final java.lang.String nodeProvisioningMode) {
            this.props().nodeProvisioningMode(nodeProvisioningMode);
            return this;
        }

        /**
         * Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod.
         * <p>
         * Available values are <code>Automatic</code> for enabling and <code>None</code> for disabling.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-noderecovery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-noderecovery</a>
         * @param nodeRecovery Specifies whether to enable or disable the automatic node recovery feature of SageMaker HyperPod. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeRecovery(final java.lang.String nodeRecovery) {
            this.props().nodeRecovery(nodeRecovery);
            return this;
        }

        /**
         * The orchestrator type for the SageMaker HyperPod cluster.
         * <p>
         * Currently, <code>'eks'</code> is the only available option.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator</a>
         * @param orchestrator The orchestrator type for the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder orchestrator(final software.amazon.awscdk.IResolvable orchestrator) {
            this.props().orchestrator(orchestrator);
            return this;
        }
        /**
         * The orchestrator type for the SageMaker HyperPod cluster.
         * <p>
         * Currently, <code>'eks'</code> is the only available option.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-orchestrator</a>
         * @param orchestrator The orchestrator type for the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder orchestrator(final software.amazon.awscdk.services.sagemaker.CfnCluster.OrchestratorProperty orchestrator) {
            this.props().orchestrator(orchestrator);
            return this;
        }

        /**
         * The restricted instance groups of the SageMaker HyperPod cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-restrictedinstancegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-restrictedinstancegroups</a>
         * @param restrictedInstanceGroups The restricted instance groups of the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restrictedInstanceGroups(final software.amazon.awscdk.IResolvable restrictedInstanceGroups) {
            this.props().restrictedInstanceGroups(restrictedInstanceGroups);
            return this;
        }
        /**
         * The restricted instance groups of the SageMaker HyperPod cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-restrictedinstancegroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-restrictedinstancegroups</a>
         * @param restrictedInstanceGroups The restricted instance groups of the SageMaker HyperPod cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restrictedInstanceGroups(final java.util.List<? extends java.lang.Object> restrictedInstanceGroups) {
            this.props().restrictedInstanceGroups(restrictedInstanceGroups);
            return this;
        }

        /**
         * A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources.
         * <p>
         * You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints. For more information on adding tags to SageMaker resources, see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html">AddTags</a> .
         * <p>
         * For more information on adding metadata to your AWS resources with tagging, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> . For advice on best practices for managing AWS resources with tagging, see <a href="https://docs.aws.amazon.com/https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging Best Practices: Implement an Effective AWS Resource Tagging Strategy</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-tags</a>
         * @param tags A tag object that consists of a key and an optional value, used to manage metadata for SageMaker AWS resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
         * <p>
         * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig</a>
         * @param vpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.IResolvable vpcConfig) {
            this.props().vpcConfig(vpcConfig);
            return this;
        }
        /**
         * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
         * <p>
         * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-cluster.html#cfn-sagemaker-cluster-vpcconfig</a>
         * @param vpcConfig Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(final software.amazon.awscdk.services.sagemaker.CfnCluster.VpcConfigProperty vpcConfig) {
            this.props().vpcConfig(vpcConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnCluster build() {
            return new software.amazon.awscdk.services.sagemaker.CfnCluster(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.sagemaker.CfnClusterProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.sagemaker.CfnClusterProps.Builder();
            }
            return this.props;
        }
    }
}
