package software.amazon.awscdk.services.sagemaker;

/**
 * Creates an inference component, which is a SageMaker AI hosting object that you can use to deploy a model to an endpoint.
 * <p>
 * In the inference component settings, you specify the model, the endpoint, and how the model utilizes the resources that the endpoint hosts. You can optimize resource utilization by tailoring how the required CPU cores, accelerators, and memory are allocated. You can deploy multiple inference components to an endpoint, where each inference component contains one model and the resource utilization needs for that individual model. After you deploy an inference component, you can directly invoke the associated model when you use the InvokeEndpoint API action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnInferenceComponent cfnInferenceComponent = CfnInferenceComponent.Builder.create(this, "MyCfnInferenceComponent")
 *         .endpointName("endpointName")
 *         .specification(InferenceComponentSpecificationProperty.builder()
 *                 .baseInferenceComponentName("baseInferenceComponentName")
 *                 .computeResourceRequirements(InferenceComponentComputeResourceRequirementsProperty.builder()
 *                         .maxMemoryRequiredInMb(123)
 *                         .minMemoryRequiredInMb(123)
 *                         .numberOfAcceleratorDevicesRequired(123)
 *                         .numberOfCpuCoresRequired(123)
 *                         .build())
 *                 .container(InferenceComponentContainerSpecificationProperty.builder()
 *                         .artifactUrl("artifactUrl")
 *                         .deployedImage(DeployedImageProperty.builder()
 *                                 .resolutionTime("resolutionTime")
 *                                 .resolvedImage("resolvedImage")
 *                                 .specifiedImage("specifiedImage")
 *                                 .build())
 *                         .environment(Map.of(
 *                                 "environmentKey", "environment"))
 *                         .image("image")
 *                         .build())
 *                 .modelName("modelName")
 *                 .startupParameters(InferenceComponentStartupParametersProperty.builder()
 *                         .containerStartupHealthCheckTimeoutInSeconds(123)
 *                         .modelDataDownloadTimeoutInSeconds(123)
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .deploymentConfig(InferenceComponentDeploymentConfigProperty.builder()
 *                 .autoRollbackConfiguration(AutoRollbackConfigurationProperty.builder()
 *                         .alarms(List.of(AlarmProperty.builder()
 *                                 .alarmName("alarmName")
 *                                 .build()))
 *                         .build())
 *                 .rollingUpdatePolicy(InferenceComponentRollingUpdatePolicyProperty.builder()
 *                         .maximumBatchSize(InferenceComponentCapacitySizeProperty.builder()
 *                                 .type("type")
 *                                 .value(123)
 *                                 .build())
 *                         .maximumExecutionTimeoutInSeconds(123)
 *                         .rollbackMaximumBatchSize(InferenceComponentCapacitySizeProperty.builder()
 *                                 .type("type")
 *                                 .value(123)
 *                                 .build())
 *                         .waitIntervalInSeconds(123)
 *                         .build())
 *                 .build())
 *         .endpointArn("endpointArn")
 *         .inferenceComponentName("inferenceComponentName")
 *         .runtimeConfig(InferenceComponentRuntimeConfigProperty.builder()
 *                 .copyCount(123)
 *                 .currentCopyCount(123)
 *                 .desiredCopyCount(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .variantName("variantName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:39.905Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent")
public class CfnInferenceComponent extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnInferenceComponent(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInferenceComponent(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInferenceComponent(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnInferenceComponentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time when the inference component was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The failure reason if the inference component is in a failed state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFailureReason() {
        return software.amazon.jsii.Kernel.get(this, "attrFailureReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInferenceComponentArn() {
        return software.amazon.jsii.Kernel.get(this, "attrInferenceComponentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInferenceComponentStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrInferenceComponentStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time when the inference component was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The number of runtime copies of the model container that are currently deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrRuntimeConfigCurrentCopyCount() {
        return software.amazon.jsii.Kernel.get(this, "attrRuntimeConfigCurrentCopyCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of runtime copies of the model container that you requested to deploy with the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrRuntimeConfigDesiredCopyCount() {
        return software.amazon.jsii.Kernel.get(this, "attrRuntimeConfigDesiredCopyCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrSpecificationContainerDeployedImage() {
        return software.amazon.jsii.Kernel.get(this, "attrSpecificationContainerDeployedImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the endpoint that hosts the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEndpointName() {
        return software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the endpoint that hosts the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointName", java.util.Objects.requireNonNull(value, "endpointName is required"));
    }

    /**
     * The specification for the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSpecification() {
        return software.amazon.jsii.Kernel.get(this, "specification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The specification for the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "specification", java.util.Objects.requireNonNull(value, "specification is required"));
    }

    /**
     * The specification for the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpecification(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentSpecificationProperty value) {
        software.amazon.jsii.Kernel.set(this, "specification", java.util.Objects.requireNonNull(value, "specification is required"));
    }

    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentConfig() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfig", value);
    }

    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentDeploymentConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfig", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointArn() {
        return software.amazon.jsii.Kernel.get(this, "endpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointArn", value);
    }

    /**
     * The name of the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInferenceComponentName() {
        return software.amazon.jsii.Kernel.get(this, "inferenceComponentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInferenceComponentName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "inferenceComponentName", value);
    }

    /**
     * The runtime config for the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeConfig() {
        return software.amazon.jsii.Kernel.get(this, "runtimeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The runtime config for the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "runtimeConfig", value);
    }

    /**
     * The runtime config for the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentRuntimeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "runtimeConfig", value);
    }

    /**
     * An array of tags to apply to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of tags to apply to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The name of the production variant that hosts the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVariantName() {
        return software.amazon.jsii.Kernel.get(this, "variantName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the production variant that hosts the inference component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariantName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "variantName", value);
    }
    /**
     * An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AlarmProperty alarmProperty = AlarmProperty.builder()
     *         .alarmName("alarmName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-alarm.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-alarm.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.AlarmProperty")
    @software.amazon.jsii.Jsii.Proxy(AlarmProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AlarmProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a CloudWatch alarm in your account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-alarm.html#cfn-sagemaker-inferencecomponent-alarm-alarmname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-alarm.html#cfn-sagemaker-inferencecomponent-alarm-alarmname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlarmName();

        /**
         * @return a {@link Builder} of {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AlarmProperty> {
            java.lang.String alarmName;

            /**
             * Sets the value of {@link AlarmProperty#getAlarmName}
             * @param alarmName The name of a CloudWatch alarm in your account. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmName(java.lang.String alarmName) {
                this.alarmName = alarmName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AlarmProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AlarmProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AlarmProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AlarmProperty {
            private final java.lang.String alarmName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmName = software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmName = java.util.Objects.requireNonNull(builder.alarmName, "alarmName is required");
            }

            @Override
            public final java.lang.String getAlarmName() {
                return this.alarmName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmName", om.valueToTree(this.getAlarmName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.AlarmProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AlarmProperty.Jsii$Proxy that = (AlarmProperty.Jsii$Proxy) o;

                return this.alarmName.equals(that.alarmName);
            }

            @Override
            public final int hashCode() {
                int result = this.alarmName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * AutoRollbackConfigurationProperty autoRollbackConfigurationProperty = AutoRollbackConfigurationProperty.builder()
     *         .alarms(List.of(AlarmProperty.builder()
     *                 .alarmName("alarmName")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-autorollbackconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-autorollbackconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.AutoRollbackConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoRollbackConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoRollbackConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-autorollbackconfiguration.html#cfn-sagemaker-inferencecomponent-autorollbackconfiguration-alarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-autorollbackconfiguration.html#cfn-sagemaker-inferencecomponent-autorollbackconfiguration-alarms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAlarms();

        /**
         * @return a {@link Builder} of {@link AutoRollbackConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoRollbackConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoRollbackConfigurationProperty> {
            java.lang.Object alarms;

            /**
             * Sets the value of {@link AutoRollbackConfigurationProperty#getAlarms}
             * @param alarms the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(software.amazon.awscdk.IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link AutoRollbackConfigurationProperty#getAlarms}
             * @param alarms the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(java.util.List<? extends java.lang.Object> alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoRollbackConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoRollbackConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoRollbackConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoRollbackConfigurationProperty {
            private final java.lang.Object alarms;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarms = java.util.Objects.requireNonNull(builder.alarms, "alarms is required");
            }

            @Override
            public final java.lang.Object getAlarms() {
                return this.alarms;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarms", om.valueToTree(this.getAlarms()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.AutoRollbackConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoRollbackConfigurationProperty.Jsii$Proxy that = (AutoRollbackConfigurationProperty.Jsii$Proxy) o;

                return this.alarms.equals(that.alarms);
            }

            @Override
            public final int hashCode() {
                int result = this.alarms.hashCode();
                return result;
            }
        }
    }
    /**
     * Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariant.html">ProductionVariant</a> .
     * <p>
     * If you used the <code>registry/repository[:tag]</code> form to specify the image path of the primary container when you created the model hosted in this <code>ProductionVariant</code> , the path resolves to a path of the form <code>registry/repository[&#64;digest]</code> . A digest is a hash value that identifies a specific version of an image. For information about Amazon ECR paths, see <a href="https://docs.aws.amazon.com//AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an Image</a> in the <em>Amazon ECR User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DeployedImageProperty deployedImageProperty = DeployedImageProperty.builder()
     *         .resolutionTime("resolutionTime")
     *         .resolvedImage("resolvedImage")
     *         .specifiedImage("specifiedImage")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.DeployedImageProperty")
    @software.amazon.jsii.Jsii.Proxy(DeployedImageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeployedImageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The date and time when the image path for the model resolved to the <code>ResolvedImage</code>.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html#cfn-sagemaker-inferencecomponent-deployedimage-resolutiontime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html#cfn-sagemaker-inferencecomponent-deployedimage-resolutiontime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResolutionTime() {
            return null;
        }

        /**
         * The specific digest path of the image hosted in this <code>ProductionVariant</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html#cfn-sagemaker-inferencecomponent-deployedimage-resolvedimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html#cfn-sagemaker-inferencecomponent-deployedimage-resolvedimage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResolvedImage() {
            return null;
        }

        /**
         * The image path you specified when you created the model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html#cfn-sagemaker-inferencecomponent-deployedimage-specifiedimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-deployedimage.html#cfn-sagemaker-inferencecomponent-deployedimage-specifiedimage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSpecifiedImage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeployedImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeployedImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeployedImageProperty> {
            java.lang.String resolutionTime;
            java.lang.String resolvedImage;
            java.lang.String specifiedImage;

            /**
             * Sets the value of {@link DeployedImageProperty#getResolutionTime}
             * @param resolutionTime The date and time when the image path for the model resolved to the <code>ResolvedImage</code>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolutionTime(java.lang.String resolutionTime) {
                this.resolutionTime = resolutionTime;
                return this;
            }

            /**
             * Sets the value of {@link DeployedImageProperty#getResolvedImage}
             * @param resolvedImage The specific digest path of the image hosted in this <code>ProductionVariant</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resolvedImage(java.lang.String resolvedImage) {
                this.resolvedImage = resolvedImage;
                return this;
            }

            /**
             * Sets the value of {@link DeployedImageProperty#getSpecifiedImage}
             * @param specifiedImage The image path you specified when you created the model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder specifiedImage(java.lang.String specifiedImage) {
                this.specifiedImage = specifiedImage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeployedImageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeployedImageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeployedImageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeployedImageProperty {
            private final java.lang.String resolutionTime;
            private final java.lang.String resolvedImage;
            private final java.lang.String specifiedImage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resolutionTime = software.amazon.jsii.Kernel.get(this, "resolutionTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resolvedImage = software.amazon.jsii.Kernel.get(this, "resolvedImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.specifiedImage = software.amazon.jsii.Kernel.get(this, "specifiedImage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resolutionTime = builder.resolutionTime;
                this.resolvedImage = builder.resolvedImage;
                this.specifiedImage = builder.specifiedImage;
            }

            @Override
            public final java.lang.String getResolutionTime() {
                return this.resolutionTime;
            }

            @Override
            public final java.lang.String getResolvedImage() {
                return this.resolvedImage;
            }

            @Override
            public final java.lang.String getSpecifiedImage() {
                return this.specifiedImage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResolutionTime() != null) {
                    data.set("resolutionTime", om.valueToTree(this.getResolutionTime()));
                }
                if (this.getResolvedImage() != null) {
                    data.set("resolvedImage", om.valueToTree(this.getResolvedImage()));
                }
                if (this.getSpecifiedImage() != null) {
                    data.set("specifiedImage", om.valueToTree(this.getSpecifiedImage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.DeployedImageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeployedImageProperty.Jsii$Proxy that = (DeployedImageProperty.Jsii$Proxy) o;

                if (this.resolutionTime != null ? !this.resolutionTime.equals(that.resolutionTime) : that.resolutionTime != null) return false;
                if (this.resolvedImage != null ? !this.resolvedImage.equals(that.resolvedImage) : that.resolvedImage != null) return false;
                return this.specifiedImage != null ? this.specifiedImage.equals(that.specifiedImage) : that.specifiedImage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resolutionTime != null ? this.resolutionTime.hashCode() : 0;
                result = 31 * result + (this.resolvedImage != null ? this.resolvedImage.hashCode() : 0);
                result = 31 * result + (this.specifiedImage != null ? this.specifiedImage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the type and size of the endpoint capacity to activate for a rolling deployment or a rollback strategy.
     * <p>
     * You can specify your batches as either of the following:
     * <p>
     * <ul>
     * <li>A count of inference component copies</li>
     * <li>The overall percentage or your fleet</li>
     * </ul>
     * <p>
     * For a rollback strategy, if you don't specify the fields in this object, or if you set the <code>Value</code> parameter to 100%, then SageMaker AI uses a blue/green rollback strategy and rolls all traffic back to the blue fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * InferenceComponentCapacitySizeProperty inferenceComponentCapacitySizeProperty = InferenceComponentCapacitySizeProperty.builder()
     *         .type("type")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcapacitysize.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcapacitysize.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceComponentCapacitySizeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceComponentCapacitySizeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the endpoint capacity type.
         * <p>
         * <ul>
         * <li><strong>COPY_COUNT</strong> - The endpoint activates based on the number of inference component copies.</li>
         * <li><strong>CAPACITY_PERCENT</strong> - The endpoint activates based on the specified percentage of capacity.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcapacitysize.html#cfn-sagemaker-inferencecomponent-inferencecomponentcapacitysize-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcapacitysize.html#cfn-sagemaker-inferencecomponent-inferencecomponentcapacitysize-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Defines the capacity size, either as a number of inference component copies or a capacity percentage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcapacitysize.html#cfn-sagemaker-inferencecomponent-inferencecomponentcapacitysize-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcapacitysize.html#cfn-sagemaker-inferencecomponent-inferencecomponentcapacitysize-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link InferenceComponentCapacitySizeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceComponentCapacitySizeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceComponentCapacitySizeProperty> {
            java.lang.String type;
            java.lang.Number value;

            /**
             * Sets the value of {@link InferenceComponentCapacitySizeProperty#getType}
             * @param type Specifies the endpoint capacity type. This parameter is required.
             *             <ul>
             *             <li><strong>COPY_COUNT</strong> - The endpoint activates based on the number of inference component copies.</li>
             *             <li><strong>CAPACITY_PERCENT</strong> - The endpoint activates based on the specified percentage of capacity.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentCapacitySizeProperty#getValue}
             * @param value Defines the capacity size, either as a number of inference component copies or a capacity percentage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceComponentCapacitySizeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceComponentCapacitySizeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceComponentCapacitySizeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceComponentCapacitySizeProperty {
            private final java.lang.String type;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceComponentCapacitySizeProperty.Jsii$Proxy that = (InferenceComponentCapacitySizeProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines the compute resources to allocate to run a model, plus any adapter models, that you assign to an inference component.
     * <p>
     * These resources include CPU cores, accelerators, and memory.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * InferenceComponentComputeResourceRequirementsProperty inferenceComponentComputeResourceRequirementsProperty = InferenceComponentComputeResourceRequirementsProperty.builder()
     *         .maxMemoryRequiredInMb(123)
     *         .minMemoryRequiredInMb(123)
     *         .numberOfAcceleratorDevicesRequired(123)
     *         .numberOfCpuCoresRequired(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentComputeResourceRequirementsProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceComponentComputeResourceRequirementsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceComponentComputeResourceRequirementsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum MB of memory to allocate to run a model that you assign to an inference component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-maxmemoryrequiredinmb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-maxmemoryrequiredinmb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxMemoryRequiredInMb() {
            return null;
        }

        /**
         * The minimum MB of memory to allocate to run a model that you assign to an inference component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-minmemoryrequiredinmb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-minmemoryrequiredinmb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinMemoryRequiredInMb() {
            return null;
        }

        /**
         * The number of accelerators to allocate to run a model that you assign to an inference component.
         * <p>
         * Accelerators include GPUs and AWS Inferentia.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-numberofacceleratordevicesrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-numberofacceleratordevicesrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfAcceleratorDevicesRequired() {
            return null;
        }

        /**
         * The number of CPU cores to allocate to run a model that you assign to an inference component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-numberofcpucoresrequired">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements.html#cfn-sagemaker-inferencecomponent-inferencecomponentcomputeresourcerequirements-numberofcpucoresrequired</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfCpuCoresRequired() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceComponentComputeResourceRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceComponentComputeResourceRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceComponentComputeResourceRequirementsProperty> {
            java.lang.Number maxMemoryRequiredInMb;
            java.lang.Number minMemoryRequiredInMb;
            java.lang.Number numberOfAcceleratorDevicesRequired;
            java.lang.Number numberOfCpuCoresRequired;

            /**
             * Sets the value of {@link InferenceComponentComputeResourceRequirementsProperty#getMaxMemoryRequiredInMb}
             * @param maxMemoryRequiredInMb The maximum MB of memory to allocate to run a model that you assign to an inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxMemoryRequiredInMb(java.lang.Number maxMemoryRequiredInMb) {
                this.maxMemoryRequiredInMb = maxMemoryRequiredInMb;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentComputeResourceRequirementsProperty#getMinMemoryRequiredInMb}
             * @param minMemoryRequiredInMb The minimum MB of memory to allocate to run a model that you assign to an inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minMemoryRequiredInMb(java.lang.Number minMemoryRequiredInMb) {
                this.minMemoryRequiredInMb = minMemoryRequiredInMb;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentComputeResourceRequirementsProperty#getNumberOfAcceleratorDevicesRequired}
             * @param numberOfAcceleratorDevicesRequired The number of accelerators to allocate to run a model that you assign to an inference component.
             *                                           Accelerators include GPUs and AWS Inferentia.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfAcceleratorDevicesRequired(java.lang.Number numberOfAcceleratorDevicesRequired) {
                this.numberOfAcceleratorDevicesRequired = numberOfAcceleratorDevicesRequired;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentComputeResourceRequirementsProperty#getNumberOfCpuCoresRequired}
             * @param numberOfCpuCoresRequired The number of CPU cores to allocate to run a model that you assign to an inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfCpuCoresRequired(java.lang.Number numberOfCpuCoresRequired) {
                this.numberOfCpuCoresRequired = numberOfCpuCoresRequired;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceComponentComputeResourceRequirementsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceComponentComputeResourceRequirementsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceComponentComputeResourceRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceComponentComputeResourceRequirementsProperty {
            private final java.lang.Number maxMemoryRequiredInMb;
            private final java.lang.Number minMemoryRequiredInMb;
            private final java.lang.Number numberOfAcceleratorDevicesRequired;
            private final java.lang.Number numberOfCpuCoresRequired;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxMemoryRequiredInMb = software.amazon.jsii.Kernel.get(this, "maxMemoryRequiredInMb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minMemoryRequiredInMb = software.amazon.jsii.Kernel.get(this, "minMemoryRequiredInMb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.numberOfAcceleratorDevicesRequired = software.amazon.jsii.Kernel.get(this, "numberOfAcceleratorDevicesRequired", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.numberOfCpuCoresRequired = software.amazon.jsii.Kernel.get(this, "numberOfCpuCoresRequired", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxMemoryRequiredInMb = builder.maxMemoryRequiredInMb;
                this.minMemoryRequiredInMb = builder.minMemoryRequiredInMb;
                this.numberOfAcceleratorDevicesRequired = builder.numberOfAcceleratorDevicesRequired;
                this.numberOfCpuCoresRequired = builder.numberOfCpuCoresRequired;
            }

            @Override
            public final java.lang.Number getMaxMemoryRequiredInMb() {
                return this.maxMemoryRequiredInMb;
            }

            @Override
            public final java.lang.Number getMinMemoryRequiredInMb() {
                return this.minMemoryRequiredInMb;
            }

            @Override
            public final java.lang.Number getNumberOfAcceleratorDevicesRequired() {
                return this.numberOfAcceleratorDevicesRequired;
            }

            @Override
            public final java.lang.Number getNumberOfCpuCoresRequired() {
                return this.numberOfCpuCoresRequired;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxMemoryRequiredInMb() != null) {
                    data.set("maxMemoryRequiredInMb", om.valueToTree(this.getMaxMemoryRequiredInMb()));
                }
                if (this.getMinMemoryRequiredInMb() != null) {
                    data.set("minMemoryRequiredInMb", om.valueToTree(this.getMinMemoryRequiredInMb()));
                }
                if (this.getNumberOfAcceleratorDevicesRequired() != null) {
                    data.set("numberOfAcceleratorDevicesRequired", om.valueToTree(this.getNumberOfAcceleratorDevicesRequired()));
                }
                if (this.getNumberOfCpuCoresRequired() != null) {
                    data.set("numberOfCpuCoresRequired", om.valueToTree(this.getNumberOfCpuCoresRequired()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentComputeResourceRequirementsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceComponentComputeResourceRequirementsProperty.Jsii$Proxy that = (InferenceComponentComputeResourceRequirementsProperty.Jsii$Proxy) o;

                if (this.maxMemoryRequiredInMb != null ? !this.maxMemoryRequiredInMb.equals(that.maxMemoryRequiredInMb) : that.maxMemoryRequiredInMb != null) return false;
                if (this.minMemoryRequiredInMb != null ? !this.minMemoryRequiredInMb.equals(that.minMemoryRequiredInMb) : that.minMemoryRequiredInMb != null) return false;
                if (this.numberOfAcceleratorDevicesRequired != null ? !this.numberOfAcceleratorDevicesRequired.equals(that.numberOfAcceleratorDevicesRequired) : that.numberOfAcceleratorDevicesRequired != null) return false;
                return this.numberOfCpuCoresRequired != null ? this.numberOfCpuCoresRequired.equals(that.numberOfCpuCoresRequired) : that.numberOfCpuCoresRequired == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxMemoryRequiredInMb != null ? this.maxMemoryRequiredInMb.hashCode() : 0;
                result = 31 * result + (this.minMemoryRequiredInMb != null ? this.minMemoryRequiredInMb.hashCode() : 0);
                result = 31 * result + (this.numberOfAcceleratorDevicesRequired != null ? this.numberOfAcceleratorDevicesRequired.hashCode() : 0);
                result = 31 * result + (this.numberOfCpuCoresRequired != null ? this.numberOfCpuCoresRequired.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a container that provides the runtime environment for a model that you deploy with an inference component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * InferenceComponentContainerSpecificationProperty inferenceComponentContainerSpecificationProperty = InferenceComponentContainerSpecificationProperty.builder()
     *         .artifactUrl("artifactUrl")
     *         .deployedImage(DeployedImageProperty.builder()
     *                 .resolutionTime("resolutionTime")
     *                 .resolvedImage("resolvedImage")
     *                 .specifiedImage("specifiedImage")
     *                 .build())
     *         .environment(Map.of(
     *                 "environmentKey", "environment"))
     *         .image("image")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentContainerSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceComponentContainerSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceComponentContainerSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 path where the model artifacts, which result from model training, are stored.
         * <p>
         * This path must point to a single gzip compressed tar archive (.tar.gz suffix).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-artifacturl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-artifacturl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getArtifactUrl() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-deployedimage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-deployedimage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeployedImage() {
            return null;
        }

        /**
         * The environment variables to set in the Docker container.
         * <p>
         * Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-environment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image for the model is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-image">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentcontainerspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentcontainerspecification-image</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceComponentContainerSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceComponentContainerSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceComponentContainerSpecificationProperty> {
            java.lang.String artifactUrl;
            java.lang.Object deployedImage;
            java.lang.Object environment;
            java.lang.String image;

            /**
             * Sets the value of {@link InferenceComponentContainerSpecificationProperty#getArtifactUrl}
             * @param artifactUrl The Amazon S3 path where the model artifacts, which result from model training, are stored.
             *                    This path must point to a single gzip compressed tar archive (.tar.gz suffix).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder artifactUrl(java.lang.String artifactUrl) {
                this.artifactUrl = artifactUrl;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentContainerSpecificationProperty#getDeployedImage}
             * @param deployedImage the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deployedImage(software.amazon.awscdk.IResolvable deployedImage) {
                this.deployedImage = deployedImage;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentContainerSpecificationProperty#getDeployedImage}
             * @param deployedImage the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deployedImage(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.DeployedImageProperty deployedImage) {
                this.deployedImage = deployedImage;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentContainerSpecificationProperty#getEnvironment}
             * @param environment The environment variables to set in the Docker container.
             *                    Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentContainerSpecificationProperty#getEnvironment}
             * @param environment The environment variables to set in the Docker container.
             *                    Each key and value in the Environment string-to-string map can have length of up to 1024. We support up to 16 entries in the map.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentContainerSpecificationProperty#getImage}
             * @param image The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image for the model is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceComponentContainerSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceComponentContainerSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceComponentContainerSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceComponentContainerSpecificationProperty {
            private final java.lang.String artifactUrl;
            private final java.lang.Object deployedImage;
            private final java.lang.Object environment;
            private final java.lang.String image;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.artifactUrl = software.amazon.jsii.Kernel.get(this, "artifactUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.deployedImage = software.amazon.jsii.Kernel.get(this, "deployedImage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.artifactUrl = builder.artifactUrl;
                this.deployedImage = builder.deployedImage;
                this.environment = builder.environment;
                this.image = builder.image;
            }

            @Override
            public final java.lang.String getArtifactUrl() {
                return this.artifactUrl;
            }

            @Override
            public final java.lang.Object getDeployedImage() {
                return this.deployedImage;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getArtifactUrl() != null) {
                    data.set("artifactUrl", om.valueToTree(this.getArtifactUrl()));
                }
                if (this.getDeployedImage() != null) {
                    data.set("deployedImage", om.valueToTree(this.getDeployedImage()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getImage() != null) {
                    data.set("image", om.valueToTree(this.getImage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentContainerSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceComponentContainerSpecificationProperty.Jsii$Proxy that = (InferenceComponentContainerSpecificationProperty.Jsii$Proxy) o;

                if (this.artifactUrl != null ? !this.artifactUrl.equals(that.artifactUrl) : that.artifactUrl != null) return false;
                if (this.deployedImage != null ? !this.deployedImage.equals(that.deployedImage) : that.deployedImage != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                return this.image != null ? this.image.equals(that.image) : that.image == null;
            }

            @Override
            public final int hashCode() {
                int result = this.artifactUrl != null ? this.artifactUrl.hashCode() : 0;
                result = 31 * result + (this.deployedImage != null ? this.deployedImage.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The deployment configuration for an endpoint that hosts inference components.
     * <p>
     * The configuration includes the desired deployment strategy and rollback settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * InferenceComponentDeploymentConfigProperty inferenceComponentDeploymentConfigProperty = InferenceComponentDeploymentConfigProperty.builder()
     *         .autoRollbackConfiguration(AutoRollbackConfigurationProperty.builder()
     *                 .alarms(List.of(AlarmProperty.builder()
     *                         .alarmName("alarmName")
     *                         .build()))
     *                 .build())
     *         .rollingUpdatePolicy(InferenceComponentRollingUpdatePolicyProperty.builder()
     *                 .maximumBatchSize(InferenceComponentCapacitySizeProperty.builder()
     *                         .type("type")
     *                         .value(123)
     *                         .build())
     *                 .maximumExecutionTimeoutInSeconds(123)
     *                 .rollbackMaximumBatchSize(InferenceComponentCapacitySizeProperty.builder()
     *                         .type("type")
     *                         .value(123)
     *                         .build())
     *                 .waitIntervalInSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentDeploymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceComponentDeploymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceComponentDeploymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig-autorollbackconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig-autorollbackconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoRollbackConfiguration() {
            return null;
        }

        /**
         * Specifies a rolling deployment strategy for updating a SageMaker AI endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig-rollingupdatepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentdeploymentconfig-rollingupdatepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRollingUpdatePolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceComponentDeploymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceComponentDeploymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceComponentDeploymentConfigProperty> {
            java.lang.Object autoRollbackConfiguration;
            java.lang.Object rollingUpdatePolicy;

            /**
             * Sets the value of {@link InferenceComponentDeploymentConfigProperty#getAutoRollbackConfiguration}
             * @param autoRollbackConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoRollbackConfiguration(software.amazon.awscdk.IResolvable autoRollbackConfiguration) {
                this.autoRollbackConfiguration = autoRollbackConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentDeploymentConfigProperty#getAutoRollbackConfiguration}
             * @param autoRollbackConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoRollbackConfiguration(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.AutoRollbackConfigurationProperty autoRollbackConfiguration) {
                this.autoRollbackConfiguration = autoRollbackConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentDeploymentConfigProperty#getRollingUpdatePolicy}
             * @param rollingUpdatePolicy Specifies a rolling deployment strategy for updating a SageMaker AI endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollingUpdatePolicy(software.amazon.awscdk.IResolvable rollingUpdatePolicy) {
                this.rollingUpdatePolicy = rollingUpdatePolicy;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentDeploymentConfigProperty#getRollingUpdatePolicy}
             * @param rollingUpdatePolicy Specifies a rolling deployment strategy for updating a SageMaker AI endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollingUpdatePolicy(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentRollingUpdatePolicyProperty rollingUpdatePolicy) {
                this.rollingUpdatePolicy = rollingUpdatePolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceComponentDeploymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceComponentDeploymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceComponentDeploymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceComponentDeploymentConfigProperty {
            private final java.lang.Object autoRollbackConfiguration;
            private final java.lang.Object rollingUpdatePolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoRollbackConfiguration = software.amazon.jsii.Kernel.get(this, "autoRollbackConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rollingUpdatePolicy = software.amazon.jsii.Kernel.get(this, "rollingUpdatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
                this.rollingUpdatePolicy = builder.rollingUpdatePolicy;
            }

            @Override
            public final java.lang.Object getAutoRollbackConfiguration() {
                return this.autoRollbackConfiguration;
            }

            @Override
            public final java.lang.Object getRollingUpdatePolicy() {
                return this.rollingUpdatePolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoRollbackConfiguration() != null) {
                    data.set("autoRollbackConfiguration", om.valueToTree(this.getAutoRollbackConfiguration()));
                }
                if (this.getRollingUpdatePolicy() != null) {
                    data.set("rollingUpdatePolicy", om.valueToTree(this.getRollingUpdatePolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentDeploymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceComponentDeploymentConfigProperty.Jsii$Proxy that = (InferenceComponentDeploymentConfigProperty.Jsii$Proxy) o;

                if (this.autoRollbackConfiguration != null ? !this.autoRollbackConfiguration.equals(that.autoRollbackConfiguration) : that.autoRollbackConfiguration != null) return false;
                return this.rollingUpdatePolicy != null ? this.rollingUpdatePolicy.equals(that.rollingUpdatePolicy) : that.rollingUpdatePolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.hashCode() : 0;
                result = 31 * result + (this.rollingUpdatePolicy != null ? this.rollingUpdatePolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a rolling deployment strategy for updating a SageMaker AI inference component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * InferenceComponentRollingUpdatePolicyProperty inferenceComponentRollingUpdatePolicyProperty = InferenceComponentRollingUpdatePolicyProperty.builder()
     *         .maximumBatchSize(InferenceComponentCapacitySizeProperty.builder()
     *                 .type("type")
     *                 .value(123)
     *                 .build())
     *         .maximumExecutionTimeoutInSeconds(123)
     *         .rollbackMaximumBatchSize(InferenceComponentCapacitySizeProperty.builder()
     *                 .type("type")
     *                 .value(123)
     *                 .build())
     *         .waitIntervalInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentRollingUpdatePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceComponentRollingUpdatePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceComponentRollingUpdatePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The batch size for each rolling step in the deployment process.
         * <p>
         * For each step, SageMaker AI provisions capacity on the new endpoint fleet, routes traffic to that fleet, and terminates capacity on the old endpoint fleet. The value must be between 5% to 50% of the copy count of the inference component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html#cfn-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy-maximumbatchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html#cfn-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy-maximumbatchsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMaximumBatchSize() {
            return null;
        }

        /**
         * The time limit for the total deployment.
         * <p>
         * Exceeding this limit causes a timeout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html#cfn-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy-maximumexecutiontimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html#cfn-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy-maximumexecutiontimeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumExecutionTimeoutInSeconds() {
            return null;
        }

        /**
         * The batch size for a rollback to the old endpoint fleet.
         * <p>
         * If this field is absent, the value is set to the default, which is 100% of the total capacity. When the default is used, SageMaker AI provisions the entire capacity of the old fleet at once during rollback.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html#cfn-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy-rollbackmaximumbatchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html#cfn-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy-rollbackmaximumbatchsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRollbackMaximumBatchSize() {
            return null;
        }

        /**
         * The length of the baking period, during which SageMaker AI monitors alarms for each batch on the new fleet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html#cfn-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy-waitintervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy.html#cfn-sagemaker-inferencecomponent-inferencecomponentrollingupdatepolicy-waitintervalinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWaitIntervalInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceComponentRollingUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceComponentRollingUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceComponentRollingUpdatePolicyProperty> {
            java.lang.Object maximumBatchSize;
            java.lang.Number maximumExecutionTimeoutInSeconds;
            java.lang.Object rollbackMaximumBatchSize;
            java.lang.Number waitIntervalInSeconds;

            /**
             * Sets the value of {@link InferenceComponentRollingUpdatePolicyProperty#getMaximumBatchSize}
             * @param maximumBatchSize The batch size for each rolling step in the deployment process.
             *                         For each step, SageMaker AI provisions capacity on the new endpoint fleet, routes traffic to that fleet, and terminates capacity on the old endpoint fleet. The value must be between 5% to 50% of the copy count of the inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchSize(software.amazon.awscdk.IResolvable maximumBatchSize) {
                this.maximumBatchSize = maximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentRollingUpdatePolicyProperty#getMaximumBatchSize}
             * @param maximumBatchSize The batch size for each rolling step in the deployment process.
             *                         For each step, SageMaker AI provisions capacity on the new endpoint fleet, routes traffic to that fleet, and terminates capacity on the old endpoint fleet. The value must be between 5% to 50% of the copy count of the inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBatchSize(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty maximumBatchSize) {
                this.maximumBatchSize = maximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentRollingUpdatePolicyProperty#getMaximumExecutionTimeoutInSeconds}
             * @param maximumExecutionTimeoutInSeconds The time limit for the total deployment.
             *                                         Exceeding this limit causes a timeout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumExecutionTimeoutInSeconds(java.lang.Number maximumExecutionTimeoutInSeconds) {
                this.maximumExecutionTimeoutInSeconds = maximumExecutionTimeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentRollingUpdatePolicyProperty#getRollbackMaximumBatchSize}
             * @param rollbackMaximumBatchSize The batch size for a rollback to the old endpoint fleet.
             *                                 If this field is absent, the value is set to the default, which is 100% of the total capacity. When the default is used, SageMaker AI provisions the entire capacity of the old fleet at once during rollback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollbackMaximumBatchSize(software.amazon.awscdk.IResolvable rollbackMaximumBatchSize) {
                this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentRollingUpdatePolicyProperty#getRollbackMaximumBatchSize}
             * @param rollbackMaximumBatchSize The batch size for a rollback to the old endpoint fleet.
             *                                 If this field is absent, the value is set to the default, which is 100% of the total capacity. When the default is used, SageMaker AI provisions the entire capacity of the old fleet at once during rollback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollbackMaximumBatchSize(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentCapacitySizeProperty rollbackMaximumBatchSize) {
                this.rollbackMaximumBatchSize = rollbackMaximumBatchSize;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentRollingUpdatePolicyProperty#getWaitIntervalInSeconds}
             * @param waitIntervalInSeconds The length of the baking period, during which SageMaker AI monitors alarms for each batch on the new fleet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder waitIntervalInSeconds(java.lang.Number waitIntervalInSeconds) {
                this.waitIntervalInSeconds = waitIntervalInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceComponentRollingUpdatePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceComponentRollingUpdatePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceComponentRollingUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceComponentRollingUpdatePolicyProperty {
            private final java.lang.Object maximumBatchSize;
            private final java.lang.Number maximumExecutionTimeoutInSeconds;
            private final java.lang.Object rollbackMaximumBatchSize;
            private final java.lang.Number waitIntervalInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumBatchSize = software.amazon.jsii.Kernel.get(this, "maximumBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumExecutionTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "maximumExecutionTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rollbackMaximumBatchSize = software.amazon.jsii.Kernel.get(this, "rollbackMaximumBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.waitIntervalInSeconds = software.amazon.jsii.Kernel.get(this, "waitIntervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumBatchSize = builder.maximumBatchSize;
                this.maximumExecutionTimeoutInSeconds = builder.maximumExecutionTimeoutInSeconds;
                this.rollbackMaximumBatchSize = builder.rollbackMaximumBatchSize;
                this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
            }

            @Override
            public final java.lang.Object getMaximumBatchSize() {
                return this.maximumBatchSize;
            }

            @Override
            public final java.lang.Number getMaximumExecutionTimeoutInSeconds() {
                return this.maximumExecutionTimeoutInSeconds;
            }

            @Override
            public final java.lang.Object getRollbackMaximumBatchSize() {
                return this.rollbackMaximumBatchSize;
            }

            @Override
            public final java.lang.Number getWaitIntervalInSeconds() {
                return this.waitIntervalInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaximumBatchSize() != null) {
                    data.set("maximumBatchSize", om.valueToTree(this.getMaximumBatchSize()));
                }
                if (this.getMaximumExecutionTimeoutInSeconds() != null) {
                    data.set("maximumExecutionTimeoutInSeconds", om.valueToTree(this.getMaximumExecutionTimeoutInSeconds()));
                }
                if (this.getRollbackMaximumBatchSize() != null) {
                    data.set("rollbackMaximumBatchSize", om.valueToTree(this.getRollbackMaximumBatchSize()));
                }
                if (this.getWaitIntervalInSeconds() != null) {
                    data.set("waitIntervalInSeconds", om.valueToTree(this.getWaitIntervalInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentRollingUpdatePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceComponentRollingUpdatePolicyProperty.Jsii$Proxy that = (InferenceComponentRollingUpdatePolicyProperty.Jsii$Proxy) o;

                if (this.maximumBatchSize != null ? !this.maximumBatchSize.equals(that.maximumBatchSize) : that.maximumBatchSize != null) return false;
                if (this.maximumExecutionTimeoutInSeconds != null ? !this.maximumExecutionTimeoutInSeconds.equals(that.maximumExecutionTimeoutInSeconds) : that.maximumExecutionTimeoutInSeconds != null) return false;
                if (this.rollbackMaximumBatchSize != null ? !this.rollbackMaximumBatchSize.equals(that.rollbackMaximumBatchSize) : that.rollbackMaximumBatchSize != null) return false;
                return this.waitIntervalInSeconds != null ? this.waitIntervalInSeconds.equals(that.waitIntervalInSeconds) : that.waitIntervalInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximumBatchSize != null ? this.maximumBatchSize.hashCode() : 0;
                result = 31 * result + (this.maximumExecutionTimeoutInSeconds != null ? this.maximumExecutionTimeoutInSeconds.hashCode() : 0);
                result = 31 * result + (this.rollbackMaximumBatchSize != null ? this.rollbackMaximumBatchSize.hashCode() : 0);
                result = 31 * result + (this.waitIntervalInSeconds != null ? this.waitIntervalInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Runtime settings for a model that is deployed with an inference component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * InferenceComponentRuntimeConfigProperty inferenceComponentRuntimeConfigProperty = InferenceComponentRuntimeConfigProperty.builder()
     *         .copyCount(123)
     *         .currentCopyCount(123)
     *         .desiredCopyCount(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentruntimeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentruntimeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentRuntimeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceComponentRuntimeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceComponentRuntimeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of runtime copies of the model container to deploy with the inference component.
         * <p>
         * Each copy can serve inference requests.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentruntimeconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentruntimeconfig-copycount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentruntimeconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentruntimeconfig-copycount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCopyCount() {
            return null;
        }

        /**
         * The number of runtime copies of the model container that are currently deployed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentruntimeconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentruntimeconfig-currentcopycount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentruntimeconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentruntimeconfig-currentcopycount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCurrentCopyCount() {
            return null;
        }

        /**
         * The number of runtime copies of the model container that you requested to deploy with the inference component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentruntimeconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentruntimeconfig-desiredcopycount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentruntimeconfig.html#cfn-sagemaker-inferencecomponent-inferencecomponentruntimeconfig-desiredcopycount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCopyCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceComponentRuntimeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceComponentRuntimeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceComponentRuntimeConfigProperty> {
            java.lang.Number copyCount;
            java.lang.Number currentCopyCount;
            java.lang.Number desiredCopyCount;

            /**
             * Sets the value of {@link InferenceComponentRuntimeConfigProperty#getCopyCount}
             * @param copyCount The number of runtime copies of the model container to deploy with the inference component.
             *                  Each copy can serve inference requests.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyCount(java.lang.Number copyCount) {
                this.copyCount = copyCount;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentRuntimeConfigProperty#getCurrentCopyCount}
             * @param currentCopyCount The number of runtime copies of the model container that are currently deployed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentCopyCount(java.lang.Number currentCopyCount) {
                this.currentCopyCount = currentCopyCount;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentRuntimeConfigProperty#getDesiredCopyCount}
             * @param desiredCopyCount The number of runtime copies of the model container that you requested to deploy with the inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder desiredCopyCount(java.lang.Number desiredCopyCount) {
                this.desiredCopyCount = desiredCopyCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceComponentRuntimeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceComponentRuntimeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceComponentRuntimeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceComponentRuntimeConfigProperty {
            private final java.lang.Number copyCount;
            private final java.lang.Number currentCopyCount;
            private final java.lang.Number desiredCopyCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.copyCount = software.amazon.jsii.Kernel.get(this, "copyCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.currentCopyCount = software.amazon.jsii.Kernel.get(this, "currentCopyCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.desiredCopyCount = software.amazon.jsii.Kernel.get(this, "desiredCopyCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.copyCount = builder.copyCount;
                this.currentCopyCount = builder.currentCopyCount;
                this.desiredCopyCount = builder.desiredCopyCount;
            }

            @Override
            public final java.lang.Number getCopyCount() {
                return this.copyCount;
            }

            @Override
            public final java.lang.Number getCurrentCopyCount() {
                return this.currentCopyCount;
            }

            @Override
            public final java.lang.Number getDesiredCopyCount() {
                return this.desiredCopyCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCopyCount() != null) {
                    data.set("copyCount", om.valueToTree(this.getCopyCount()));
                }
                if (this.getCurrentCopyCount() != null) {
                    data.set("currentCopyCount", om.valueToTree(this.getCurrentCopyCount()));
                }
                if (this.getDesiredCopyCount() != null) {
                    data.set("desiredCopyCount", om.valueToTree(this.getDesiredCopyCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentRuntimeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceComponentRuntimeConfigProperty.Jsii$Proxy that = (InferenceComponentRuntimeConfigProperty.Jsii$Proxy) o;

                if (this.copyCount != null ? !this.copyCount.equals(that.copyCount) : that.copyCount != null) return false;
                if (this.currentCopyCount != null ? !this.currentCopyCount.equals(that.currentCopyCount) : that.currentCopyCount != null) return false;
                return this.desiredCopyCount != null ? this.desiredCopyCount.equals(that.desiredCopyCount) : that.desiredCopyCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.copyCount != null ? this.copyCount.hashCode() : 0;
                result = 31 * result + (this.currentCopyCount != null ? this.currentCopyCount.hashCode() : 0);
                result = 31 * result + (this.desiredCopyCount != null ? this.desiredCopyCount.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details about the resources to deploy with this inference component, including the model, container, and compute resources.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * InferenceComponentSpecificationProperty inferenceComponentSpecificationProperty = InferenceComponentSpecificationProperty.builder()
     *         .baseInferenceComponentName("baseInferenceComponentName")
     *         .computeResourceRequirements(InferenceComponentComputeResourceRequirementsProperty.builder()
     *                 .maxMemoryRequiredInMb(123)
     *                 .minMemoryRequiredInMb(123)
     *                 .numberOfAcceleratorDevicesRequired(123)
     *                 .numberOfCpuCoresRequired(123)
     *                 .build())
     *         .container(InferenceComponentContainerSpecificationProperty.builder()
     *                 .artifactUrl("artifactUrl")
     *                 .deployedImage(DeployedImageProperty.builder()
     *                         .resolutionTime("resolutionTime")
     *                         .resolvedImage("resolvedImage")
     *                         .specifiedImage("specifiedImage")
     *                         .build())
     *                 .environment(Map.of(
     *                         "environmentKey", "environment"))
     *                 .image("image")
     *                 .build())
     *         .modelName("modelName")
     *         .startupParameters(InferenceComponentStartupParametersProperty.builder()
     *                 .containerStartupHealthCheckTimeoutInSeconds(123)
     *                 .modelDataDownloadTimeoutInSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceComponentSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceComponentSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of an existing inference component that is to contain the inference component that you're creating with your request.
         * <p>
         * Specify this parameter only if your request is meant to create an adapter inference component. An adapter inference component contains the path to an adapter model. The purpose of the adapter model is to tailor the inference output of a base foundation model, which is hosted by the base inference component. The adapter inference component uses the compute resources that you assigned to the base inference component.
         * <p>
         * When you create an adapter inference component, use the <code>Container</code> parameter to specify the location of the adapter artifacts. In the parameter value, use the <code>ArtifactUrl</code> parameter of the <code>InferenceComponentContainerSpecification</code> data type.
         * <p>
         * Before you can create an adapter inference component, you must have an existing inference component that contains the foundation model that you want to adapt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-baseinferencecomponentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-baseinferencecomponentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBaseInferenceComponentName() {
            return null;
        }

        /**
         * The compute resources allocated to run the model, plus any adapter models, that you assign to the inference component.
         * <p>
         * Omit this parameter if your request is meant to create an adapter inference component. An adapter inference component is loaded by a base inference component, and it uses the compute resources of the base inference component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-computeresourcerequirements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-computeresourcerequirements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComputeResourceRequirements() {
            return null;
        }

        /**
         * Defines a container that provides the runtime environment for a model that you deploy with an inference component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-container">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-container</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainer() {
            return null;
        }

        /**
         * The name of an existing SageMaker AI model object in your account that you want to deploy with the inference component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-modelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-modelname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModelName() {
            return null;
        }

        /**
         * Settings that take effect while the model container starts up.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-startupparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentspecification.html#cfn-sagemaker-inferencecomponent-inferencecomponentspecification-startupparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStartupParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceComponentSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceComponentSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceComponentSpecificationProperty> {
            java.lang.String baseInferenceComponentName;
            java.lang.Object computeResourceRequirements;
            java.lang.Object container;
            java.lang.String modelName;
            java.lang.Object startupParameters;

            /**
             * Sets the value of {@link InferenceComponentSpecificationProperty#getBaseInferenceComponentName}
             * @param baseInferenceComponentName The name of an existing inference component that is to contain the inference component that you're creating with your request.
             *                                   Specify this parameter only if your request is meant to create an adapter inference component. An adapter inference component contains the path to an adapter model. The purpose of the adapter model is to tailor the inference output of a base foundation model, which is hosted by the base inference component. The adapter inference component uses the compute resources that you assigned to the base inference component.
             *                                   <p>
             *                                   When you create an adapter inference component, use the <code>Container</code> parameter to specify the location of the adapter artifacts. In the parameter value, use the <code>ArtifactUrl</code> parameter of the <code>InferenceComponentContainerSpecification</code> data type.
             *                                   <p>
             *                                   Before you can create an adapter inference component, you must have an existing inference component that contains the foundation model that you want to adapt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseInferenceComponentName(java.lang.String baseInferenceComponentName) {
                this.baseInferenceComponentName = baseInferenceComponentName;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentSpecificationProperty#getComputeResourceRequirements}
             * @param computeResourceRequirements The compute resources allocated to run the model, plus any adapter models, that you assign to the inference component.
             *                                    Omit this parameter if your request is meant to create an adapter inference component. An adapter inference component is loaded by a base inference component, and it uses the compute resources of the base inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeResourceRequirements(software.amazon.awscdk.IResolvable computeResourceRequirements) {
                this.computeResourceRequirements = computeResourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentSpecificationProperty#getComputeResourceRequirements}
             * @param computeResourceRequirements The compute resources allocated to run the model, plus any adapter models, that you assign to the inference component.
             *                                    Omit this parameter if your request is meant to create an adapter inference component. An adapter inference component is loaded by a base inference component, and it uses the compute resources of the base inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder computeResourceRequirements(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentComputeResourceRequirementsProperty computeResourceRequirements) {
                this.computeResourceRequirements = computeResourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentSpecificationProperty#getContainer}
             * @param container Defines a container that provides the runtime environment for a model that you deploy with an inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder container(software.amazon.awscdk.IResolvable container) {
                this.container = container;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentSpecificationProperty#getContainer}
             * @param container Defines a container that provides the runtime environment for a model that you deploy with an inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder container(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentContainerSpecificationProperty container) {
                this.container = container;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentSpecificationProperty#getModelName}
             * @param modelName The name of an existing SageMaker AI model object in your account that you want to deploy with the inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelName(java.lang.String modelName) {
                this.modelName = modelName;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentSpecificationProperty#getStartupParameters}
             * @param startupParameters Settings that take effect while the model container starts up.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startupParameters(software.amazon.awscdk.IResolvable startupParameters) {
                this.startupParameters = startupParameters;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentSpecificationProperty#getStartupParameters}
             * @param startupParameters Settings that take effect while the model container starts up.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startupParameters(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentStartupParametersProperty startupParameters) {
                this.startupParameters = startupParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceComponentSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceComponentSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceComponentSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceComponentSpecificationProperty {
            private final java.lang.String baseInferenceComponentName;
            private final java.lang.Object computeResourceRequirements;
            private final java.lang.Object container;
            private final java.lang.String modelName;
            private final java.lang.Object startupParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseInferenceComponentName = software.amazon.jsii.Kernel.get(this, "baseInferenceComponentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.computeResourceRequirements = software.amazon.jsii.Kernel.get(this, "computeResourceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.container = software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelName = software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startupParameters = software.amazon.jsii.Kernel.get(this, "startupParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseInferenceComponentName = builder.baseInferenceComponentName;
                this.computeResourceRequirements = builder.computeResourceRequirements;
                this.container = builder.container;
                this.modelName = builder.modelName;
                this.startupParameters = builder.startupParameters;
            }

            @Override
            public final java.lang.String getBaseInferenceComponentName() {
                return this.baseInferenceComponentName;
            }

            @Override
            public final java.lang.Object getComputeResourceRequirements() {
                return this.computeResourceRequirements;
            }

            @Override
            public final java.lang.Object getContainer() {
                return this.container;
            }

            @Override
            public final java.lang.String getModelName() {
                return this.modelName;
            }

            @Override
            public final java.lang.Object getStartupParameters() {
                return this.startupParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBaseInferenceComponentName() != null) {
                    data.set("baseInferenceComponentName", om.valueToTree(this.getBaseInferenceComponentName()));
                }
                if (this.getComputeResourceRequirements() != null) {
                    data.set("computeResourceRequirements", om.valueToTree(this.getComputeResourceRequirements()));
                }
                if (this.getContainer() != null) {
                    data.set("container", om.valueToTree(this.getContainer()));
                }
                if (this.getModelName() != null) {
                    data.set("modelName", om.valueToTree(this.getModelName()));
                }
                if (this.getStartupParameters() != null) {
                    data.set("startupParameters", om.valueToTree(this.getStartupParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceComponentSpecificationProperty.Jsii$Proxy that = (InferenceComponentSpecificationProperty.Jsii$Proxy) o;

                if (this.baseInferenceComponentName != null ? !this.baseInferenceComponentName.equals(that.baseInferenceComponentName) : that.baseInferenceComponentName != null) return false;
                if (this.computeResourceRequirements != null ? !this.computeResourceRequirements.equals(that.computeResourceRequirements) : that.computeResourceRequirements != null) return false;
                if (this.container != null ? !this.container.equals(that.container) : that.container != null) return false;
                if (this.modelName != null ? !this.modelName.equals(that.modelName) : that.modelName != null) return false;
                return this.startupParameters != null ? this.startupParameters.equals(that.startupParameters) : that.startupParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.baseInferenceComponentName != null ? this.baseInferenceComponentName.hashCode() : 0;
                result = 31 * result + (this.computeResourceRequirements != null ? this.computeResourceRequirements.hashCode() : 0);
                result = 31 * result + (this.container != null ? this.container.hashCode() : 0);
                result = 31 * result + (this.modelName != null ? this.modelName.hashCode() : 0);
                result = 31 * result + (this.startupParameters != null ? this.startupParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings that take effect while the model container starts up.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * InferenceComponentStartupParametersProperty inferenceComponentStartupParametersProperty = InferenceComponentStartupParametersProperty.builder()
     *         .containerStartupHealthCheckTimeoutInSeconds(123)
     *         .modelDataDownloadTimeoutInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentstartupparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentstartupparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentStartupParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(InferenceComponentStartupParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InferenceComponentStartupParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting.
         * <p>
         * For more information about health check, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests">How Your Container Should Respond to Health Check (Ping) Requests</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentstartupparameters.html#cfn-sagemaker-inferencecomponent-inferencecomponentstartupparameters-containerstartuphealthchecktimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentstartupparameters.html#cfn-sagemaker-inferencecomponent-inferencecomponentstartupparameters-containerstartuphealthchecktimeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerStartupHealthCheckTimeoutInSeconds() {
            return null;
        }

        /**
         * The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this inference component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentstartupparameters.html#cfn-sagemaker-inferencecomponent-inferencecomponentstartupparameters-modeldatadownloadtimeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-inferencecomponent-inferencecomponentstartupparameters.html#cfn-sagemaker-inferencecomponent-inferencecomponentstartupparameters-modeldatadownloadtimeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getModelDataDownloadTimeoutInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InferenceComponentStartupParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InferenceComponentStartupParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InferenceComponentStartupParametersProperty> {
            java.lang.Number containerStartupHealthCheckTimeoutInSeconds;
            java.lang.Number modelDataDownloadTimeoutInSeconds;

            /**
             * Sets the value of {@link InferenceComponentStartupParametersProperty#getContainerStartupHealthCheckTimeoutInSeconds}
             * @param containerStartupHealthCheckTimeoutInSeconds The timeout value, in seconds, for your inference container to pass health check by Amazon S3 Hosting.
             *                                                    For more information about health check, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests">How Your Container Should Respond to Health Check (Ping) Requests</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerStartupHealthCheckTimeoutInSeconds(java.lang.Number containerStartupHealthCheckTimeoutInSeconds) {
                this.containerStartupHealthCheckTimeoutInSeconds = containerStartupHealthCheckTimeoutInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link InferenceComponentStartupParametersProperty#getModelDataDownloadTimeoutInSeconds}
             * @param modelDataDownloadTimeoutInSeconds The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this inference component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelDataDownloadTimeoutInSeconds(java.lang.Number modelDataDownloadTimeoutInSeconds) {
                this.modelDataDownloadTimeoutInSeconds = modelDataDownloadTimeoutInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InferenceComponentStartupParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InferenceComponentStartupParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InferenceComponentStartupParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InferenceComponentStartupParametersProperty {
            private final java.lang.Number containerStartupHealthCheckTimeoutInSeconds;
            private final java.lang.Number modelDataDownloadTimeoutInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerStartupHealthCheckTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "containerStartupHealthCheckTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.modelDataDownloadTimeoutInSeconds = software.amazon.jsii.Kernel.get(this, "modelDataDownloadTimeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerStartupHealthCheckTimeoutInSeconds = builder.containerStartupHealthCheckTimeoutInSeconds;
                this.modelDataDownloadTimeoutInSeconds = builder.modelDataDownloadTimeoutInSeconds;
            }

            @Override
            public final java.lang.Number getContainerStartupHealthCheckTimeoutInSeconds() {
                return this.containerStartupHealthCheckTimeoutInSeconds;
            }

            @Override
            public final java.lang.Number getModelDataDownloadTimeoutInSeconds() {
                return this.modelDataDownloadTimeoutInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerStartupHealthCheckTimeoutInSeconds() != null) {
                    data.set("containerStartupHealthCheckTimeoutInSeconds", om.valueToTree(this.getContainerStartupHealthCheckTimeoutInSeconds()));
                }
                if (this.getModelDataDownloadTimeoutInSeconds() != null) {
                    data.set("modelDataDownloadTimeoutInSeconds", om.valueToTree(this.getModelDataDownloadTimeoutInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponent.InferenceComponentStartupParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InferenceComponentStartupParametersProperty.Jsii$Proxy that = (InferenceComponentStartupParametersProperty.Jsii$Proxy) o;

                if (this.containerStartupHealthCheckTimeoutInSeconds != null ? !this.containerStartupHealthCheckTimeoutInSeconds.equals(that.containerStartupHealthCheckTimeoutInSeconds) : that.containerStartupHealthCheckTimeoutInSeconds != null) return false;
                return this.modelDataDownloadTimeoutInSeconds != null ? this.modelDataDownloadTimeoutInSeconds.equals(that.modelDataDownloadTimeoutInSeconds) : that.modelDataDownloadTimeoutInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerStartupHealthCheckTimeoutInSeconds != null ? this.containerStartupHealthCheckTimeoutInSeconds.hashCode() : 0;
                result = 31 * result + (this.modelDataDownloadTimeoutInSeconds != null ? this.modelDataDownloadTimeoutInSeconds.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnInferenceComponent}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnInferenceComponent> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnInferenceComponentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnInferenceComponentProps.Builder();
        }

        /**
         * The name of the endpoint that hosts the inference component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-endpointname</a>
         * @param endpointName The name of the endpoint that hosts the inference component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(final java.lang.String endpointName) {
            this.props.endpointName(endpointName);
            return this;
        }

        /**
         * The specification for the inference component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-specification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-specification</a>
         * @param specification The specification for the inference component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder specification(final software.amazon.awscdk.IResolvable specification) {
            this.props.specification(specification);
            return this;
        }
        /**
         * The specification for the inference component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-specification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-specification</a>
         * @param specification The specification for the inference component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder specification(final software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentSpecificationProperty specification) {
            this.props.specification(specification);
            return this;
        }

        /**
         * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-deploymentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-deploymentconfig</a>
         * @param deploymentConfig The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(final software.amazon.awscdk.IResolvable deploymentConfig) {
            this.props.deploymentConfig(deploymentConfig);
            return this;
        }
        /**
         * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-deploymentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-deploymentconfig</a>
         * @param deploymentConfig The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(final software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentDeploymentConfigProperty deploymentConfig) {
            this.props.deploymentConfig(deploymentConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-endpointarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-endpointarn</a>
         * @param endpointArn The Amazon Resource Name (ARN) of the endpoint that hosts the inference component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointArn(final java.lang.String endpointArn) {
            this.props.endpointArn(endpointArn);
            return this;
        }

        /**
         * The name of the inference component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-inferencecomponentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-inferencecomponentname</a>
         * @param inferenceComponentName The name of the inference component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceComponentName(final java.lang.String inferenceComponentName) {
            this.props.inferenceComponentName(inferenceComponentName);
            return this;
        }

        /**
         * The runtime config for the inference component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-runtimeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-runtimeconfig</a>
         * @param runtimeConfig The runtime config for the inference component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfig(final software.amazon.awscdk.IResolvable runtimeConfig) {
            this.props.runtimeConfig(runtimeConfig);
            return this;
        }
        /**
         * The runtime config for the inference component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-runtimeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-runtimeconfig</a>
         * @param runtimeConfig The runtime config for the inference component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfig(final software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentRuntimeConfigProperty runtimeConfig) {
            this.props.runtimeConfig(runtimeConfig);
            return this;
        }

        /**
         * An array of tags to apply to the resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-tags</a>
         * @param tags An array of tags to apply to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The name of the production variant that hosts the inference component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-variantname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-variantname</a>
         * @param variantName The name of the production variant that hosts the inference component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variantName(final java.lang.String variantName) {
            this.props.variantName(variantName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnInferenceComponent}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnInferenceComponent build() {
            return new software.amazon.awscdk.services.sagemaker.CfnInferenceComponent(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
