package software.amazon.awscdk.services.scheduler.targets;

/**
 * Use an Amazon SQS Queue as a target for AWS EventBridge Scheduler.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * String payload = "test";
 * String messageGroupId = "id";
 * Queue queue = Queue.Builder.create(this, "MyQueue")
 *         .fifo(true)
 *         .contentBasedDeduplication(true)
 *         .build();
 * SqsSendMessage target = SqsSendMessage.Builder.create(queue)
 *         .input(ScheduleTargetInput.fromText(payload))
 *         .messageGroupId(messageGroupId)
 *         .build();
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.minutes(1)))
 *         .target(target)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:40.317Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler_targets.SqsSendMessage")
public class SqsSendMessage extends software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBase implements software.amazon.awscdk.services.scheduler.IScheduleTarget {

    protected SqsSendMessage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsSendMessage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsSendMessage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.scheduler.targets.SqsSendMessageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required"), props });
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsSendMessage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void addTargetActionToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
        software.amazon.jsii.Kernel.call(this, "addTargetActionToRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * @param _schedule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ScheduleTargetConfig bindBaseTargetConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.ISchedule _schedule) {
        return software.amazon.jsii.Kernel.call(this, "bindBaseTargetConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_schedule, "_schedule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.scheduler.targets.SqsSendMessage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.scheduler.targets.SqsSendMessage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param queue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.sqs.IQueue queue) {
            return new Builder(queue);
        }

        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private software.amazon.awscdk.services.scheduler.targets.SqsSendMessageProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
        }

        /**
         * The SQS queue to be used as deadLetterQueue.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * Input passed to the target.
         * <p>
         * Default: - no input.
         * <p>
         * @return {@code this}
         * @param input Input passed to the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.scheduler.ScheduleTargetInput input) {
            this.props().input(input);
            return this;
        }

        /**
         * The maximum age of a request that Scheduler sends to a target for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Scheduler sends to a target for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the target returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the target returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf.
         * <p>
         * If none provided templates target will automatically create an IAM role with all the minimum necessary
         * permissions to interact with the templated target. If you wish you may specify your own IAM role, then the templated targets
         * will grant minimal required permissions.
         * <p>
         * Default: - created by target
         * <p>
         * @return {@code this}
         * @param role An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * The FIFO message group ID to use as the target.
         * <p>
         * This must be specified when the target is a FIFO queue. If you specify
         * a FIFO queue as a target, the queue must have content-based deduplication enabled.
         * <p>
         * A length of <code>messageGroupId</code> must be between 1 and 128.
         * <p>
         * Default: - no message group ID
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-scheduler-schedule-sqsparameters.html#cfn-scheduler-schedule-sqsparameters-messagegroupid">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-scheduler-schedule-sqsparameters.html#cfn-scheduler-schedule-sqsparameters-messagegroupid</a>
         * @param messageGroupId The FIFO message group ID to use as the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageGroupId(final java.lang.String messageGroupId) {
            this.props().messageGroupId(messageGroupId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.scheduler.targets.SqsSendMessage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.scheduler.targets.SqsSendMessage build() {
            return new software.amazon.awscdk.services.scheduler.targets.SqsSendMessage(
                this.queue,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.scheduler.targets.SqsSendMessageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.scheduler.targets.SqsSendMessageProps.Builder();
            }
            return this.props;
        }
    }
}
