package software.amazon.awscdk.services.scheduler.targets;

/**
 * Properties for a Universal Target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.cron(CronOptionsWithTimezone.builder()
 *                 .minute("0")
 *                 .hour("0")
 *                 .build()))
 *         .target(Universal.Builder.create()
 *                 .service("rds")
 *                 .action("stopDBCluster")
 *                 .input(ScheduleTargetInput.fromObject(Map.of(
 *                         "DbClusterIdentifier", "my-db")))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:40.319Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler_targets.UniversalTargetProps")
@software.amazon.jsii.Jsii.Proxy(UniversalTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UniversalTargetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBaseProps {

    /**
     * The API action to call. Must be camelCase.
     * <p>
     * You cannot use read-only API actions such as common GET operations.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#unsupported-api-actions">https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#unsupported-api-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAction();

    /**
     * The AWS service to call.
     * <p>
     * This must be in lowercase.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getService();

    /**
     * The IAM policy statements needed to invoke the target. These statements are attached to the Scheduler's role.
     * <p>
     * Note that the default may not be the correct actions as not all AWS services follows the same IAM action pattern, or there may be more actions needed to invoke the target.
     * <p>
     * Default: - Policy with `service:action` action only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UniversalTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UniversalTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UniversalTargetProps> {
        java.lang.String action;
        java.lang.String service;
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> policyStatements;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.services.scheduler.ScheduleTargetInput input;
        software.amazon.awscdk.Duration maxEventAge;
        java.lang.Number retryAttempts;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link UniversalTargetProps#getAction}
         * @param action The API action to call. Must be camelCase. This parameter is required.
         *               You cannot use read-only API actions such as common GET operations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link UniversalTargetProps#getService}
         * @param service The AWS service to call. This parameter is required.
         *                This must be in lowercase.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link UniversalTargetProps#getPolicyStatements}
         * @param policyStatements The IAM policy statements needed to invoke the target. These statements are attached to the Scheduler's role.
         *                         Note that the default may not be the correct actions as not all AWS services follows the same IAM action pattern, or there may be more actions needed to invoke the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder policyStatements(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> policyStatements) {
            this.policyStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)policyStatements;
            return this;
        }

        /**
         * Sets the value of {@link UniversalTargetProps#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue.
         *                        The events not successfully delivered are automatically retried for a specified period of time,
         *                        depending on the retry policy of the target.
         *                        If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link UniversalTargetProps#getInput}
         * @param input Input passed to the target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(software.amazon.awscdk.services.scheduler.ScheduleTargetInput input) {
            this.input = input;
            return this;
        }

        /**
         * Sets the value of {@link UniversalTargetProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Scheduler sends to a target for processing.
         *                    Minimum value of 60.
         *                    Maximum value of 86400.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link UniversalTargetProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the target returns an error.
         *                      Minimum value of 0.
         *                      Maximum value of 185.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link UniversalTargetProps#getRole}
         * @param role An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf.
         *             If none provided templates target will automatically create an IAM role with all the minimum necessary
         *             permissions to interact with the templated target. If you wish you may specify your own IAM role, then the templated targets
         *             will grant minimal required permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UniversalTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UniversalTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UniversalTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UniversalTargetProps {
        private final java.lang.String action;
        private final java.lang.String service;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> policyStatements;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.services.scheduler.ScheduleTargetInput input;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final java.lang.Number retryAttempts;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyStatements = software.amazon.jsii.Kernel.get(this, "policyStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.scheduler.ScheduleTargetInput.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            this.service = java.util.Objects.requireNonNull(builder.service, "service is required");
            this.policyStatements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.policyStatements;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.input = builder.input;
            this.maxEventAge = builder.maxEventAge;
            this.retryAttempts = builder.retryAttempts;
            this.role = builder.role;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getService() {
            return this.service;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getPolicyStatements() {
            return this.policyStatements;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.services.scheduler.ScheduleTargetInput getInput() {
            return this.input;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getPolicyStatements() != null) {
                data.set("policyStatements", om.valueToTree(this.getPolicyStatements()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getInput() != null) {
                data.set("input", om.valueToTree(this.getInput()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler_targets.UniversalTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UniversalTargetProps.Jsii$Proxy that = (UniversalTargetProps.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (!service.equals(that.service)) return false;
            if (this.policyStatements != null ? !this.policyStatements.equals(that.policyStatements) : that.policyStatements != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.policyStatements != null ? this.policyStatements.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
