package software.amazon.awscdk.services.ses;

/**
 * A rule added at the top of the rule set to drop spam/virus.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * ReceiptRule receiptRule;
 * IReceiptRuleAction receiptRuleAction;
 * ReceiptRuleSet receiptRuleSet;
 * DropSpamReceiptRule dropSpamReceiptRule = DropSpamReceiptRule.Builder.create(this, "MyDropSpamReceiptRule")
 *         .ruleSet(receiptRuleSet)
 *         // the properties below are optional
 *         .actions(List.of(receiptRuleAction))
 *         .after(receiptRule)
 *         .enabled(false)
 *         .receiptRuleName("receiptRuleName")
 *         .recipients(List.of("recipients"))
 *         .scanEnabled(false)
 *         .tlsPolicy(TlsPolicy.OPTIONAL)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda-example-functions.html">https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda-example-functions.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:40.747Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.DropSpamReceiptRule")
public class DropSpamReceiptRule extends software.constructs.Construct {

    protected DropSpamReceiptRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DropSpamReceiptRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ses.DropSpamReceiptRule.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DropSpamReceiptRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.DropSpamReceiptRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ReceiptRule getRule() {
        return software.amazon.jsii.Kernel.get(this, "rule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.ReceiptRule.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ses.DropSpamReceiptRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ses.DropSpamReceiptRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ses.DropSpamReceiptRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ses.DropSpamReceiptRuleProps.Builder();
        }

        /**
         * An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule.
         * <p>
         * Default: - No actions.
         * <p>
         * @return {@code this}
         * @param actions An ordered list of actions to perform on messages that match at least one of the recipient email addresses or domains specified in the receipt rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.List<? extends software.amazon.awscdk.services.ses.IReceiptRuleAction> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * An existing rule after which the new rule will be placed.
         * <p>
         * Default: - The new rule is inserted at the beginning of the rule list.
         * <p>
         * @return {@code this}
         * @param after An existing rule after which the new rule will be placed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder after(final software.amazon.awscdk.services.ses.IReceiptRule after) {
            this.props.after(after);
            return this;
        }

        /**
         * Whether the rule is active.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Whether the rule is active. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The name for the rule.
         * <p>
         * Default: - A CloudFormation generated name.
         * <p>
         * @return {@code this}
         * @param receiptRuleName The name for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder receiptRuleName(final java.lang.String receiptRuleName) {
            this.props.receiptRuleName(receiptRuleName);
            return this;
        }

        /**
         * The recipient domains and email addresses that the receipt rule applies to.
         * <p>
         * Default: - Match all recipients under all verified domains.
         * <p>
         * @return {@code this}
         * @param recipients The recipient domains and email addresses that the receipt rule applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipients(final java.util.List<java.lang.String> recipients) {
            this.props.recipients(recipients);
            return this;
        }

        /**
         * Whether to scan for spam and viruses.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param scanEnabled Whether to scan for spam and viruses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanEnabled(final java.lang.Boolean scanEnabled) {
            this.props.scanEnabled(scanEnabled);
            return this;
        }

        /**
         * Whether Amazon SES should require that incoming email is delivered over a connection encrypted with Transport Layer Security (TLS).
         * <p>
         * Default: - Optional which will not check for TLS.
         * <p>
         * @return {@code this}
         * @param tlsPolicy Whether Amazon SES should require that incoming email is delivered over a connection encrypted with Transport Layer Security (TLS). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsPolicy(final software.amazon.awscdk.services.ses.TlsPolicy tlsPolicy) {
            this.props.tlsPolicy(tlsPolicy);
            return this;
        }

        /**
         * The name of the rule set that the receipt rule will be added to.
         * <p>
         * @return {@code this}
         * @param ruleSet The name of the rule set that the receipt rule will be added to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSet(final software.amazon.awscdk.services.ses.IReceiptRuleSet ruleSet) {
            this.props.ruleSet(ruleSet);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ses.DropSpamReceiptRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ses.DropSpamReceiptRule build() {
            return new software.amazon.awscdk.services.ses.DropSpamReceiptRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
