package software.amazon.awscdk.services.ses;

/**
 * An object that defines an Amazon Data Firehose destination for email events.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * ConfigurationSet myConfigurationSet;
 * IDeliveryStream firehoseDeliveryStream;
 * IRole iamRole;
 * // Create IAM Role automatically
 * myConfigurationSet.addEventDestination("ToFirehose", ConfigurationSetEventDestinationOptions.builder()
 *         .destination(EventDestination.firehoseDeliveryStream(FirehoseDeliveryStreamDestination.builder()
 *                 .deliveryStream(firehoseDeliveryStream)
 *                 .build()))
 *         .build());
 * // Specify your IAM Role
 * myConfigurationSet.addEventDestination("ToFirehose", ConfigurationSetEventDestinationOptions.builder()
 *         .destination(EventDestination.firehoseDeliveryStream(FirehoseDeliveryStreamDestination.builder()
 *                 .deliveryStream(firehoseDeliveryStream)
 *                 .role(iamRole)
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:40.750Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.FirehoseDeliveryStreamDestination")
@software.amazon.jsii.Jsii.Proxy(FirehoseDeliveryStreamDestination.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FirehoseDeliveryStreamDestination extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Data Firehose stream that the Amazon SES API v2 sends email events to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream getDeliveryStream();

    /**
     * The IAM role that the Amazon SES API v2 uses to send email events to the Amazon Data Firehose stream.
     * <p>
     * Default: - Create IAM Role for Amazon Data Firehose Delivery stream
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FirehoseDeliveryStreamDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FirehoseDeliveryStreamDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FirehoseDeliveryStreamDestination> {
        software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link FirehoseDeliveryStreamDestination#getDeliveryStream}
         * @param deliveryStream The Amazon Data Firehose stream that the Amazon SES API v2 sends email events to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStream(software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream) {
            this.deliveryStream = deliveryStream;
            return this;
        }

        /**
         * Sets the value of {@link FirehoseDeliveryStreamDestination#getRole}
         * @param role The IAM role that the Amazon SES API v2 uses to send email events to the Amazon Data Firehose stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FirehoseDeliveryStreamDestination}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FirehoseDeliveryStreamDestination build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FirehoseDeliveryStreamDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirehoseDeliveryStreamDestination {
        private final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream deliveryStream;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deliveryStream = software.amazon.jsii.Kernel.get(this, "deliveryStream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deliveryStream = java.util.Objects.requireNonNull(builder.deliveryStream, "deliveryStream is required");
            this.role = builder.role;
        }

        @Override
        public final software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream getDeliveryStream() {
            return this.deliveryStream;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("deliveryStream", om.valueToTree(this.getDeliveryStream()));
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.FirehoseDeliveryStreamDestination"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FirehoseDeliveryStreamDestination.Jsii$Proxy that = (FirehoseDeliveryStreamDestination.Jsii$Proxy) o;

            if (!deliveryStream.equals(that.deliveryStream)) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deliveryStream.hashCode();
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
