package software.amazon.awscdk.services.sns;

/**
 * Options for customising the retry policy of the delivery of SNS messages to HTTP/S endpoints.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic myTopic = new Topic(this, "MyTopic");
 * myTopic.addSubscription(
 * UrlSubscription.Builder.create("https://foobar.com/")
 *         .deliveryPolicy(DeliveryPolicy.builder()
 *                 .healthyRetryPolicy(HealthyRetryPolicy.builder()
 *                         .minDelayTarget(Duration.seconds(5))
 *                         .maxDelayTarget(Duration.seconds(10))
 *                         .numRetries(6)
 *                         .backoffFunction(BackoffFunction.EXPONENTIAL)
 *                         .build())
 *                 .throttlePolicy(ThrottlePolicy.builder()
 *                         .maxReceivesPerSecond(10)
 *                         .build())
 *                 .requestPolicy(RequestPolicy.builder()
 *                         .headerContentType("application/json")
 *                         .build())
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:40.827Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.HealthyRetryPolicy")
@software.amazon.jsii.Jsii.Proxy(HealthyRetryPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HealthyRetryPolicy extends software.amazon.jsii.JsiiSerializable {

    /**
     * The model for backoff between retries.
     * <p>
     * Default: - linear
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.BackoffFunction getBackoffFunction() {
        return null;
    }

    /**
     * The maximum delay for a retry.
     * <p>
     * Must be at least <code>minDelayTarget</code> less than 3,600 seconds, and correspond to a whole number of seconds,
     * <p>
     * Default: - 20 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMaxDelayTarget() {
        return null;
    }

    /**
     * The minimum delay for a retry.
     * <p>
     * Must be at least one second, not exceed <code>maxDelayTarget</code>, and correspond to a whole number of seconds.
     * <p>
     * Default: - 20 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getMinDelayTarget() {
        return null;
    }

    /**
     * The number of retries in the post-backoff phase, with the maximum delay between them.
     * <p>
     * Must be zero or greater
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumMaxDelayRetries() {
        return null;
    }

    /**
     * The number of retries in the pre-backoff phase, with the specified minimum delay between them.
     * <p>
     * Must be zero or greater
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumMinDelayRetries() {
        return null;
    }

    /**
     * The number of retries to be done immediately, with no delay between them.
     * <p>
     * Must be zero or greater.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumNoDelayRetries() {
        return null;
    }

    /**
     * The total number of retries, including immediate, pre-backoff, backoff, and post-backoff retries.
     * <p>
     * Must be greater than or equal to zero and not exceed 100.
     * <p>
     * Default: 3
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getNumRetries() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HealthyRetryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HealthyRetryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HealthyRetryPolicy> {
        software.amazon.awscdk.services.sns.BackoffFunction backoffFunction;
        software.amazon.awscdk.Duration maxDelayTarget;
        software.amazon.awscdk.Duration minDelayTarget;
        java.lang.Number numMaxDelayRetries;
        java.lang.Number numMinDelayRetries;
        java.lang.Number numNoDelayRetries;
        java.lang.Number numRetries;

        /**
         * Sets the value of {@link HealthyRetryPolicy#getBackoffFunction}
         * @param backoffFunction The model for backoff between retries.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backoffFunction(software.amazon.awscdk.services.sns.BackoffFunction backoffFunction) {
            this.backoffFunction = backoffFunction;
            return this;
        }

        /**
         * Sets the value of {@link HealthyRetryPolicy#getMaxDelayTarget}
         * @param maxDelayTarget The maximum delay for a retry.
         *                       Must be at least <code>minDelayTarget</code> less than 3,600 seconds, and correspond to a whole number of seconds,
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxDelayTarget(software.amazon.awscdk.Duration maxDelayTarget) {
            this.maxDelayTarget = maxDelayTarget;
            return this;
        }

        /**
         * Sets the value of {@link HealthyRetryPolicy#getMinDelayTarget}
         * @param minDelayTarget The minimum delay for a retry.
         *                       Must be at least one second, not exceed <code>maxDelayTarget</code>, and correspond to a whole number of seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minDelayTarget(software.amazon.awscdk.Duration minDelayTarget) {
            this.minDelayTarget = minDelayTarget;
            return this;
        }

        /**
         * Sets the value of {@link HealthyRetryPolicy#getNumMaxDelayRetries}
         * @param numMaxDelayRetries The number of retries in the post-backoff phase, with the maximum delay between them.
         *                           Must be zero or greater
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numMaxDelayRetries(java.lang.Number numMaxDelayRetries) {
            this.numMaxDelayRetries = numMaxDelayRetries;
            return this;
        }

        /**
         * Sets the value of {@link HealthyRetryPolicy#getNumMinDelayRetries}
         * @param numMinDelayRetries The number of retries in the pre-backoff phase, with the specified minimum delay between them.
         *                           Must be zero or greater
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numMinDelayRetries(java.lang.Number numMinDelayRetries) {
            this.numMinDelayRetries = numMinDelayRetries;
            return this;
        }

        /**
         * Sets the value of {@link HealthyRetryPolicy#getNumNoDelayRetries}
         * @param numNoDelayRetries The number of retries to be done immediately, with no delay between them.
         *                          Must be zero or greater.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numNoDelayRetries(java.lang.Number numNoDelayRetries) {
            this.numNoDelayRetries = numNoDelayRetries;
            return this;
        }

        /**
         * Sets the value of {@link HealthyRetryPolicy#getNumRetries}
         * @param numRetries The total number of retries, including immediate, pre-backoff, backoff, and post-backoff retries.
         *                   Must be greater than or equal to zero and not exceed 100.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numRetries(java.lang.Number numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HealthyRetryPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HealthyRetryPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HealthyRetryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthyRetryPolicy {
        private final software.amazon.awscdk.services.sns.BackoffFunction backoffFunction;
        private final software.amazon.awscdk.Duration maxDelayTarget;
        private final software.amazon.awscdk.Duration minDelayTarget;
        private final java.lang.Number numMaxDelayRetries;
        private final java.lang.Number numMinDelayRetries;
        private final java.lang.Number numNoDelayRetries;
        private final java.lang.Number numRetries;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backoffFunction = software.amazon.jsii.Kernel.get(this, "backoffFunction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.BackoffFunction.class));
            this.maxDelayTarget = software.amazon.jsii.Kernel.get(this, "maxDelayTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.minDelayTarget = software.amazon.jsii.Kernel.get(this, "minDelayTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.numMaxDelayRetries = software.amazon.jsii.Kernel.get(this, "numMaxDelayRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.numMinDelayRetries = software.amazon.jsii.Kernel.get(this, "numMinDelayRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.numNoDelayRetries = software.amazon.jsii.Kernel.get(this, "numNoDelayRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.numRetries = software.amazon.jsii.Kernel.get(this, "numRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backoffFunction = builder.backoffFunction;
            this.maxDelayTarget = builder.maxDelayTarget;
            this.minDelayTarget = builder.minDelayTarget;
            this.numMaxDelayRetries = builder.numMaxDelayRetries;
            this.numMinDelayRetries = builder.numMinDelayRetries;
            this.numNoDelayRetries = builder.numNoDelayRetries;
            this.numRetries = builder.numRetries;
        }

        @Override
        public final software.amazon.awscdk.services.sns.BackoffFunction getBackoffFunction() {
            return this.backoffFunction;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxDelayTarget() {
            return this.maxDelayTarget;
        }

        @Override
        public final software.amazon.awscdk.Duration getMinDelayTarget() {
            return this.minDelayTarget;
        }

        @Override
        public final java.lang.Number getNumMaxDelayRetries() {
            return this.numMaxDelayRetries;
        }

        @Override
        public final java.lang.Number getNumMinDelayRetries() {
            return this.numMinDelayRetries;
        }

        @Override
        public final java.lang.Number getNumNoDelayRetries() {
            return this.numNoDelayRetries;
        }

        @Override
        public final java.lang.Number getNumRetries() {
            return this.numRetries;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBackoffFunction() != null) {
                data.set("backoffFunction", om.valueToTree(this.getBackoffFunction()));
            }
            if (this.getMaxDelayTarget() != null) {
                data.set("maxDelayTarget", om.valueToTree(this.getMaxDelayTarget()));
            }
            if (this.getMinDelayTarget() != null) {
                data.set("minDelayTarget", om.valueToTree(this.getMinDelayTarget()));
            }
            if (this.getNumMaxDelayRetries() != null) {
                data.set("numMaxDelayRetries", om.valueToTree(this.getNumMaxDelayRetries()));
            }
            if (this.getNumMinDelayRetries() != null) {
                data.set("numMinDelayRetries", om.valueToTree(this.getNumMinDelayRetries()));
            }
            if (this.getNumNoDelayRetries() != null) {
                data.set("numNoDelayRetries", om.valueToTree(this.getNumNoDelayRetries()));
            }
            if (this.getNumRetries() != null) {
                data.set("numRetries", om.valueToTree(this.getNumRetries()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.HealthyRetryPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HealthyRetryPolicy.Jsii$Proxy that = (HealthyRetryPolicy.Jsii$Proxy) o;

            if (this.backoffFunction != null ? !this.backoffFunction.equals(that.backoffFunction) : that.backoffFunction != null) return false;
            if (this.maxDelayTarget != null ? !this.maxDelayTarget.equals(that.maxDelayTarget) : that.maxDelayTarget != null) return false;
            if (this.minDelayTarget != null ? !this.minDelayTarget.equals(that.minDelayTarget) : that.minDelayTarget != null) return false;
            if (this.numMaxDelayRetries != null ? !this.numMaxDelayRetries.equals(that.numMaxDelayRetries) : that.numMaxDelayRetries != null) return false;
            if (this.numMinDelayRetries != null ? !this.numMinDelayRetries.equals(that.numMinDelayRetries) : that.numMinDelayRetries != null) return false;
            if (this.numNoDelayRetries != null ? !this.numNoDelayRetries.equals(that.numNoDelayRetries) : that.numNoDelayRetries != null) return false;
            return this.numRetries != null ? this.numRetries.equals(that.numRetries) : that.numRetries == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backoffFunction != null ? this.backoffFunction.hashCode() : 0;
            result = 31 * result + (this.maxDelayTarget != null ? this.maxDelayTarget.hashCode() : 0);
            result = 31 * result + (this.minDelayTarget != null ? this.minDelayTarget.hashCode() : 0);
            result = 31 * result + (this.numMaxDelayRetries != null ? this.numMaxDelayRetries.hashCode() : 0);
            result = 31 * result + (this.numMinDelayRetries != null ? this.numMinDelayRetries.hashCode() : 0);
            result = 31 * result + (this.numNoDelayRetries != null ? this.numNoDelayRetries.hashCode() : 0);
            result = 31 * result + (this.numRetries != null ? this.numRetries.hashCode() : 0);
            return result;
        }
    }
}
