package software.amazon.awscdk.services.stepfunctions;

/**
 * Interface for Result Writer configuration props.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * // create a bucket
 * Bucket bucket = new Bucket(this, "Bucket");
 * // create a WriterConfig
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "Distributed Map State")
 *         .resultWriterV2(ResultWriterV2.Builder.create()
 *                 .bucket(bucket)
 *                 .prefix("my-prefix")
 *                 .writerConfig(Map.of(
 *                         "outputType", OutputType.JSONL,
 *                         "transformation", Transformation.NONE))
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass State"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:41.162Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ResultWriterV2Props")
@software.amazon.jsii.Jsii.Proxy(ResultWriterV2Props.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResultWriterV2Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 Bucket in which to save Map Run results.
     * <p>
     * Default: - specify a bucket
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getBucket() {
        return null;
    }

    /**
     * S3 bucket name in which to save Map Run results, as JsonPath.
     * <p>
     * Default: - no bucket path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketNamePath() {
        return null;
    }

    /**
     * S3 prefix in which to save Map Run results.
     * <p>
     * Default: - No prefix
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return null;
    }

    /**
     * Configuration to format the output of the Child Workflow executions.
     * <p>
     * Default: - Specify both Transformation and OutputType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.WriterConfig getWriterConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResultWriterV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResultWriterV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResultWriterV2Props> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.String bucketNamePath;
        java.lang.String prefix;
        software.amazon.awscdk.services.stepfunctions.WriterConfig writerConfig;

        /**
         * Sets the value of {@link ResultWriterV2Props#getBucket}
         * @param bucket S3 Bucket in which to save Map Run results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link ResultWriterV2Props#getBucketNamePath}
         * @param bucketNamePath S3 bucket name in which to save Map Run results, as JsonPath.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNamePath(java.lang.String bucketNamePath) {
            this.bucketNamePath = bucketNamePath;
            return this;
        }

        /**
         * Sets the value of {@link ResultWriterV2Props#getPrefix}
         * @param prefix S3 prefix in which to save Map Run results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Sets the value of {@link ResultWriterV2Props#getWriterConfig}
         * @param writerConfig Configuration to format the output of the Child Workflow executions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writerConfig(software.amazon.awscdk.services.stepfunctions.WriterConfig writerConfig) {
            this.writerConfig = writerConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResultWriterV2Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResultWriterV2Props build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResultWriterV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResultWriterV2Props {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String bucketNamePath;
        private final java.lang.String prefix;
        private final software.amazon.awscdk.services.stepfunctions.WriterConfig writerConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.bucketNamePath = software.amazon.jsii.Kernel.get(this, "bucketNamePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.writerConfig = software.amazon.jsii.Kernel.get(this, "writerConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.WriterConfig.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = builder.bucket;
            this.bucketNamePath = builder.bucketNamePath;
            this.prefix = builder.prefix;
            this.writerConfig = builder.writerConfig;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getBucketNamePath() {
            return this.bucketNamePath;
        }

        @Override
        public final java.lang.String getPrefix() {
            return this.prefix;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.WriterConfig getWriterConfig() {
            return this.writerConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucket() != null) {
                data.set("bucket", om.valueToTree(this.getBucket()));
            }
            if (this.getBucketNamePath() != null) {
                data.set("bucketNamePath", om.valueToTree(this.getBucketNamePath()));
            }
            if (this.getPrefix() != null) {
                data.set("prefix", om.valueToTree(this.getPrefix()));
            }
            if (this.getWriterConfig() != null) {
                data.set("writerConfig", om.valueToTree(this.getWriterConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.ResultWriterV2Props"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResultWriterV2Props.Jsii$Proxy that = (ResultWriterV2Props.Jsii$Proxy) o;

            if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
            if (this.bucketNamePath != null ? !this.bucketNamePath.equals(that.bucketNamePath) : that.bucketNamePath != null) return false;
            if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
            return this.writerConfig != null ? this.writerConfig.equals(that.writerConfig) : that.writerConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket != null ? this.bucket.hashCode() : 0;
            result = 31 * result + (this.bucketNamePath != null ? this.bucketNamePath.hashCode() : 0);
            result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
            result = 31 * result + (this.writerConfig != null ? this.writerConfig.hashCode() : 0);
            return result;
        }
    }
}
