package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * A configuration specification to be used when provisioning virtual clusters, which can include configurations for applications and software bundled with Amazon EMR on EKS.
 * <p>
 * A configuration consists of a classification, properties, and optional nested configurations.
 * A classification refers to an application-specific configuration file.
 * Properties are the settings you want to change in that file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.tasks.*;
 * ApplicationConfiguration applicationConfiguration_;
 * Classification classification;
 * ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.builder()
 *         .classification(classification)
 *         // the properties below are optional
 *         .nestedConfig(List.of(applicationConfiguration_))
 *         .properties(Map.of(
 *                 "propertiesKey", "properties"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:41.227Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.ApplicationConfiguration")
@software.amazon.jsii.Jsii.Proxy(ApplicationConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * The classification within a configuration.
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 1024.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.Classification getClassification();

    /**
     * A list of additional configurations to apply within a configuration object.
     * <p>
     * Array Members: Maximum number of 100 items.
     * <p>
     * Default: - No other configurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ApplicationConfiguration> getNestedConfig() {
        return null;
    }

    /**
     * A set of properties specified within a configuration classification.
     * <p>
     * Map Entries: Maximum number of 100 items.
     * <p>
     * Default: - No properties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApplicationConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationConfiguration> {
        software.amazon.awscdk.services.stepfunctions.tasks.Classification classification;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ApplicationConfiguration> nestedConfig;
        java.util.Map<java.lang.String, java.lang.String> properties;

        /**
         * Sets the value of {@link ApplicationConfiguration#getClassification}
         * @param classification The classification within a configuration. This parameter is required.
         *                       Length Constraints: Minimum length of 1. Maximum length of 1024.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classification(software.amazon.awscdk.services.stepfunctions.tasks.Classification classification) {
            this.classification = classification;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationConfiguration#getNestedConfig}
         * @param nestedConfig A list of additional configurations to apply within a configuration object.
         *                     Array Members: Maximum number of 100 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder nestedConfig(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.ApplicationConfiguration> nestedConfig) {
            this.nestedConfig = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ApplicationConfiguration>)nestedConfig;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationConfiguration#getProperties}
         * @param properties A set of properties specified within a configuration classification.
         *                   Map Entries: Maximum number of 100 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(java.util.Map<java.lang.String, java.lang.String> properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationConfiguration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationConfiguration {
        private final software.amazon.awscdk.services.stepfunctions.tasks.Classification classification;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ApplicationConfiguration> nestedConfig;
        private final java.util.Map<java.lang.String, java.lang.String> properties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.classification = software.amazon.jsii.Kernel.get(this, "classification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Classification.class));
            this.nestedConfig = software.amazon.jsii.Kernel.get(this, "nestedConfig", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ApplicationConfiguration.class)));
            this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.classification = java.util.Objects.requireNonNull(builder.classification, "classification is required");
            this.nestedConfig = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ApplicationConfiguration>)builder.nestedConfig;
            this.properties = builder.properties;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.Classification getClassification() {
            return this.classification;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ApplicationConfiguration> getNestedConfig() {
            return this.nestedConfig;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getProperties() {
            return this.properties;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("classification", om.valueToTree(this.getClassification()));
            if (this.getNestedConfig() != null) {
                data.set("nestedConfig", om.valueToTree(this.getNestedConfig()));
            }
            if (this.getProperties() != null) {
                data.set("properties", om.valueToTree(this.getProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.ApplicationConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationConfiguration.Jsii$Proxy that = (ApplicationConfiguration.Jsii$Proxy) o;

            if (!classification.equals(that.classification)) return false;
            if (this.nestedConfig != null ? !this.nestedConfig.equals(that.nestedConfig) : that.nestedConfig != null) return false;
            return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
        }

        @Override
        public final int hashCode() {
            int result = this.classification.hashCode();
            result = 31 * result + (this.nestedConfig != null ? this.nestedConfig.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            return result;
        }
    }
}
