package software.amazon.awscdk.services.vpclattice;

/**
 * Properties for defining a <code>CfnResourceConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.vpclattice.*;
 * CfnResourceConfigurationProps cfnResourceConfigurationProps = CfnResourceConfigurationProps.builder()
 *         .name("name")
 *         .resourceConfigurationType("resourceConfigurationType")
 *         // the properties below are optional
 *         .allowAssociationToSharableServiceNetwork(false)
 *         .portRanges(List.of("portRanges"))
 *         .protocolType("protocolType")
 *         .resourceConfigurationAuthType("resourceConfigurationAuthType")
 *         .resourceConfigurationDefinition(ResourceConfigurationDefinitionProperty.builder()
 *                 .arnResource("arnResource")
 *                 .dnsResource(DnsResourceProperty.builder()
 *                         .domainName("domainName")
 *                         .ipAddressType("ipAddressType")
 *                         .build())
 *                 .ipResource("ipResource")
 *                 .build())
 *         .resourceConfigurationGroupId("resourceConfigurationGroupId")
 *         .resourceGatewayId("resourceGatewayId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:41.857Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_vpclattice.CfnResourceConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnResourceConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResourceConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the resource configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The type of resource configuration. A resource configuration can be one of the following types:.
     * <p>
     * <ul>
     * <li><em>SINGLE</em> - A single resource.</li>
     * <li><em>GROUP</em> - A group of resources. You must create a group resource configuration before you create a child resource configuration.</li>
     * <li><em>CHILD</em> - A single resource that is part of a group resource configuration.</li>
     * <li><em>ARN</em> - An AWS resource.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceConfigurationType();

    /**
     * Specifies whether the resource configuration can be associated with a sharable service network.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-allowassociationtosharableservicenetwork">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-allowassociationtosharableservicenetwork</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowAssociationToSharableServiceNetwork() {
        return null;
    }

    /**
     * (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for example: 1-65535).
     * <p>
     * You can separate port ranges using commas (for example: 1,2,22-30).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-portranges">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-portranges</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPortRanges() {
        return null;
    }

    /**
     * (SINGLE, GROUP) The protocol accepted by the resource configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-protocoltype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-protocoltype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProtocolType() {
        return null;
    }

    /**
     * The auth type for the resource configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationauthtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationauthtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceConfigurationAuthType() {
        return null;
    }

    /**
     * Identifies the resource configuration in one of the following ways:.
     * <p>
     * <ul>
     * <li><em>Amazon Resource Name (ARN)</em> - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.</li>
     * <li><em>Domain name</em> - Any domain name that is publicly resolvable.</li>
     * <li><em>IP address</em> - For IPv4 and IPv6, only IP addresses in the VPC are supported.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationdefinition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourceConfigurationDefinition() {
        return null;
    }

    /**
     * The ID of the group resource configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationgroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourceconfigurationgroupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceConfigurationGroupId() {
        return null;
    }

    /**
     * The ID of the resource gateway.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourcegatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-resourcegatewayid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceGatewayId() {
        return null;
    }

    /**
     * The tags for the resource configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-vpclattice-resourceconfiguration.html#cfn-vpclattice-resourceconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResourceConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResourceConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResourceConfigurationProps> {
        java.lang.String name;
        java.lang.String resourceConfigurationType;
        java.lang.Object allowAssociationToSharableServiceNetwork;
        java.util.List<java.lang.String> portRanges;
        java.lang.String protocolType;
        java.lang.String resourceConfigurationAuthType;
        java.lang.Object resourceConfigurationDefinition;
        java.lang.String resourceConfigurationGroupId;
        java.lang.String resourceGatewayId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getName}
         * @param name The name of the resource configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getResourceConfigurationType}
         * @param resourceConfigurationType The type of resource configuration. A resource configuration can be one of the following types:. This parameter is required.
         *                                  <ul>
         *                                  <li><em>SINGLE</em> - A single resource.</li>
         *                                  <li><em>GROUP</em> - A group of resources. You must create a group resource configuration before you create a child resource configuration.</li>
         *                                  <li><em>CHILD</em> - A single resource that is part of a group resource configuration.</li>
         *                                  <li><em>ARN</em> - An AWS resource.</li>
         *                                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationType(java.lang.String resourceConfigurationType) {
            this.resourceConfigurationType = resourceConfigurationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getAllowAssociationToSharableServiceNetwork}
         * @param allowAssociationToSharableServiceNetwork Specifies whether the resource configuration can be associated with a sharable service network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAssociationToSharableServiceNetwork(java.lang.Boolean allowAssociationToSharableServiceNetwork) {
            this.allowAssociationToSharableServiceNetwork = allowAssociationToSharableServiceNetwork;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getAllowAssociationToSharableServiceNetwork}
         * @param allowAssociationToSharableServiceNetwork Specifies whether the resource configuration can be associated with a sharable service network.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAssociationToSharableServiceNetwork(software.amazon.awscdk.IResolvable allowAssociationToSharableServiceNetwork) {
            this.allowAssociationToSharableServiceNetwork = allowAssociationToSharableServiceNetwork;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getPortRanges}
         * @param portRanges (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for example: 1-65535).
         *                   You can separate port ranges using commas (for example: 1,2,22-30).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder portRanges(java.util.List<java.lang.String> portRanges) {
            this.portRanges = portRanges;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getProtocolType}
         * @param protocolType (SINGLE, GROUP) The protocol accepted by the resource configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolType(java.lang.String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getResourceConfigurationAuthType}
         * @param resourceConfigurationAuthType The auth type for the resource configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationAuthType(java.lang.String resourceConfigurationAuthType) {
            this.resourceConfigurationAuthType = resourceConfigurationAuthType;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getResourceConfigurationDefinition}
         * @param resourceConfigurationDefinition Identifies the resource configuration in one of the following ways:.
         *                                        <ul>
         *                                        <li><em>Amazon Resource Name (ARN)</em> - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.</li>
         *                                        <li><em>Domain name</em> - Any domain name that is publicly resolvable.</li>
         *                                        <li><em>IP address</em> - For IPv4 and IPv6, only IP addresses in the VPC are supported.</li>
         *                                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationDefinition(software.amazon.awscdk.IResolvable resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getResourceConfigurationDefinition}
         * @param resourceConfigurationDefinition Identifies the resource configuration in one of the following ways:.
         *                                        <ul>
         *                                        <li><em>Amazon Resource Name (ARN)</em> - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.</li>
         *                                        <li><em>Domain name</em> - Any domain name that is publicly resolvable.</li>
         *                                        <li><em>IP address</em> - For IPv4 and IPv6, only IP addresses in the VPC are supported.</li>
         *                                        </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationDefinition(software.amazon.awscdk.services.vpclattice.CfnResourceConfiguration.ResourceConfigurationDefinitionProperty resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getResourceConfigurationGroupId}
         * @param resourceConfigurationGroupId The ID of the group resource configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfigurationGroupId(java.lang.String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getResourceGatewayId}
         * @param resourceGatewayId The ID of the resource gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceGatewayId(java.lang.String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
            return this;
        }

        /**
         * Sets the value of {@link CfnResourceConfigurationProps#getTags}
         * @param tags The tags for the resource configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResourceConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResourceConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResourceConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResourceConfigurationProps {
        private final java.lang.String name;
        private final java.lang.String resourceConfigurationType;
        private final java.lang.Object allowAssociationToSharableServiceNetwork;
        private final java.util.List<java.lang.String> portRanges;
        private final java.lang.String protocolType;
        private final java.lang.String resourceConfigurationAuthType;
        private final java.lang.Object resourceConfigurationDefinition;
        private final java.lang.String resourceConfigurationGroupId;
        private final java.lang.String resourceGatewayId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceConfigurationType = software.amazon.jsii.Kernel.get(this, "resourceConfigurationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allowAssociationToSharableServiceNetwork = software.amazon.jsii.Kernel.get(this, "allowAssociationToSharableServiceNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.portRanges = software.amazon.jsii.Kernel.get(this, "portRanges", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.protocolType = software.amazon.jsii.Kernel.get(this, "protocolType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceConfigurationAuthType = software.amazon.jsii.Kernel.get(this, "resourceConfigurationAuthType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceConfigurationDefinition = software.amazon.jsii.Kernel.get(this, "resourceConfigurationDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceConfigurationGroupId = software.amazon.jsii.Kernel.get(this, "resourceConfigurationGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceGatewayId = software.amazon.jsii.Kernel.get(this, "resourceGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.resourceConfigurationType = java.util.Objects.requireNonNull(builder.resourceConfigurationType, "resourceConfigurationType is required");
            this.allowAssociationToSharableServiceNetwork = builder.allowAssociationToSharableServiceNetwork;
            this.portRanges = builder.portRanges;
            this.protocolType = builder.protocolType;
            this.resourceConfigurationAuthType = builder.resourceConfigurationAuthType;
            this.resourceConfigurationDefinition = builder.resourceConfigurationDefinition;
            this.resourceConfigurationGroupId = builder.resourceConfigurationGroupId;
            this.resourceGatewayId = builder.resourceGatewayId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getResourceConfigurationType() {
            return this.resourceConfigurationType;
        }

        @Override
        public final java.lang.Object getAllowAssociationToSharableServiceNetwork() {
            return this.allowAssociationToSharableServiceNetwork;
        }

        @Override
        public final java.util.List<java.lang.String> getPortRanges() {
            return this.portRanges;
        }

        @Override
        public final java.lang.String getProtocolType() {
            return this.protocolType;
        }

        @Override
        public final java.lang.String getResourceConfigurationAuthType() {
            return this.resourceConfigurationAuthType;
        }

        @Override
        public final java.lang.Object getResourceConfigurationDefinition() {
            return this.resourceConfigurationDefinition;
        }

        @Override
        public final java.lang.String getResourceConfigurationGroupId() {
            return this.resourceConfigurationGroupId;
        }

        @Override
        public final java.lang.String getResourceGatewayId() {
            return this.resourceGatewayId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("resourceConfigurationType", om.valueToTree(this.getResourceConfigurationType()));
            if (this.getAllowAssociationToSharableServiceNetwork() != null) {
                data.set("allowAssociationToSharableServiceNetwork", om.valueToTree(this.getAllowAssociationToSharableServiceNetwork()));
            }
            if (this.getPortRanges() != null) {
                data.set("portRanges", om.valueToTree(this.getPortRanges()));
            }
            if (this.getProtocolType() != null) {
                data.set("protocolType", om.valueToTree(this.getProtocolType()));
            }
            if (this.getResourceConfigurationAuthType() != null) {
                data.set("resourceConfigurationAuthType", om.valueToTree(this.getResourceConfigurationAuthType()));
            }
            if (this.getResourceConfigurationDefinition() != null) {
                data.set("resourceConfigurationDefinition", om.valueToTree(this.getResourceConfigurationDefinition()));
            }
            if (this.getResourceConfigurationGroupId() != null) {
                data.set("resourceConfigurationGroupId", om.valueToTree(this.getResourceConfigurationGroupId()));
            }
            if (this.getResourceGatewayId() != null) {
                data.set("resourceGatewayId", om.valueToTree(this.getResourceGatewayId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_vpclattice.CfnResourceConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResourceConfigurationProps.Jsii$Proxy that = (CfnResourceConfigurationProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!resourceConfigurationType.equals(that.resourceConfigurationType)) return false;
            if (this.allowAssociationToSharableServiceNetwork != null ? !this.allowAssociationToSharableServiceNetwork.equals(that.allowAssociationToSharableServiceNetwork) : that.allowAssociationToSharableServiceNetwork != null) return false;
            if (this.portRanges != null ? !this.portRanges.equals(that.portRanges) : that.portRanges != null) return false;
            if (this.protocolType != null ? !this.protocolType.equals(that.protocolType) : that.protocolType != null) return false;
            if (this.resourceConfigurationAuthType != null ? !this.resourceConfigurationAuthType.equals(that.resourceConfigurationAuthType) : that.resourceConfigurationAuthType != null) return false;
            if (this.resourceConfigurationDefinition != null ? !this.resourceConfigurationDefinition.equals(that.resourceConfigurationDefinition) : that.resourceConfigurationDefinition != null) return false;
            if (this.resourceConfigurationGroupId != null ? !this.resourceConfigurationGroupId.equals(that.resourceConfigurationGroupId) : that.resourceConfigurationGroupId != null) return false;
            if (this.resourceGatewayId != null ? !this.resourceGatewayId.equals(that.resourceGatewayId) : that.resourceGatewayId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.resourceConfigurationType.hashCode());
            result = 31 * result + (this.allowAssociationToSharableServiceNetwork != null ? this.allowAssociationToSharableServiceNetwork.hashCode() : 0);
            result = 31 * result + (this.portRanges != null ? this.portRanges.hashCode() : 0);
            result = 31 * result + (this.protocolType != null ? this.protocolType.hashCode() : 0);
            result = 31 * result + (this.resourceConfigurationAuthType != null ? this.resourceConfigurationAuthType.hashCode() : 0);
            result = 31 * result + (this.resourceConfigurationDefinition != null ? this.resourceConfigurationDefinition.hashCode() : 0);
            result = 31 * result + (this.resourceConfigurationGroupId != null ? this.resourceConfigurationGroupId.hashCode() : 0);
            result = 31 * result + (this.resourceGatewayId != null ? this.resourceGatewayId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
