package software.amazon.awscdk.services.waf.regional;

/**
 * Properties for defining a <code>CfnGeoMatchSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.waf.regional.*;
 * CfnGeoMatchSetProps cfnGeoMatchSetProps = CfnGeoMatchSetProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .geoMatchConstraints(List.of(GeoMatchConstraintProperty.builder()
 *                 .type("type")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-geomatchset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-geomatchset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:41.930Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnGeoMatchSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnGeoMatchSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGeoMatchSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A friendly name or description of the <code>GeoMatchSet</code> .
     * <p>
     * You can't change the name of an <code>GeoMatchSet</code> after you create it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-geomatchset.html#cfn-wafregional-geomatchset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-geomatchset.html#cfn-wafregional-geomatchset-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An array of <code>GeoMatchConstraint</code> objects, which contain the country that you want AWS WAF to search for.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-geomatchset.html#cfn-wafregional-geomatchset-geomatchconstraints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-geomatchset.html#cfn-wafregional-geomatchset-geomatchconstraints</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGeoMatchConstraints() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGeoMatchSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGeoMatchSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGeoMatchSetProps> {
        java.lang.String name;
        java.lang.Object geoMatchConstraints;

        /**
         * Sets the value of {@link CfnGeoMatchSetProps#getName}
         * @param name A friendly name or description of the <code>GeoMatchSet</code> . This parameter is required.
         *             You can't change the name of an <code>GeoMatchSet</code> after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnGeoMatchSetProps#getGeoMatchConstraints}
         * @param geoMatchConstraints An array of <code>GeoMatchConstraint</code> objects, which contain the country that you want AWS WAF to search for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoMatchConstraints(software.amazon.awscdk.IResolvable geoMatchConstraints) {
            this.geoMatchConstraints = geoMatchConstraints;
            return this;
        }

        /**
         * Sets the value of {@link CfnGeoMatchSetProps#getGeoMatchConstraints}
         * @param geoMatchConstraints An array of <code>GeoMatchConstraint</code> objects, which contain the country that you want AWS WAF to search for.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder geoMatchConstraints(java.util.List<? extends java.lang.Object> geoMatchConstraints) {
            this.geoMatchConstraints = geoMatchConstraints;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGeoMatchSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGeoMatchSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGeoMatchSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGeoMatchSetProps {
        private final java.lang.String name;
        private final java.lang.Object geoMatchConstraints;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.geoMatchConstraints = software.amazon.jsii.Kernel.get(this, "geoMatchConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.geoMatchConstraints = builder.geoMatchConstraints;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getGeoMatchConstraints() {
            return this.geoMatchConstraints;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getGeoMatchConstraints() != null) {
                data.set("geoMatchConstraints", om.valueToTree(this.getGeoMatchConstraints()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafregional.CfnGeoMatchSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGeoMatchSetProps.Jsii$Proxy that = (CfnGeoMatchSetProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            return this.geoMatchConstraints != null ? this.geoMatchConstraints.equals(that.geoMatchConstraints) : that.geoMatchConstraints == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.geoMatchConstraints != null ? this.geoMatchConstraints.hashCode() : 0);
            return result;
        }
    }
}
