package software.amazon.awscdk.services.workspacesweb;

/**
 * The data protection settings resource that can be associated with a web portal.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.workspacesweb.*;
 * CfnDataProtectionSettings cfnDataProtectionSettings = CfnDataProtectionSettings.Builder.create(this, "MyCfnDataProtectionSettings")
 *         .additionalEncryptionContext(Map.of(
 *                 "additionalEncryptionContextKey", "additionalEncryptionContext"))
 *         .customerManagedKey("customerManagedKey")
 *         .description("description")
 *         .displayName("displayName")
 *         .inlineRedactionConfiguration(InlineRedactionConfigurationProperty.builder()
 *                 .inlineRedactionPatterns(List.of(InlineRedactionPatternProperty.builder()
 *                         .redactionPlaceHolder(RedactionPlaceHolderProperty.builder()
 *                                 .redactionPlaceHolderType("redactionPlaceHolderType")
 *                                 // the properties below are optional
 *                                 .redactionPlaceHolderText("redactionPlaceHolderText")
 *                                 .build())
 *                         // the properties below are optional
 *                         .builtInPatternId("builtInPatternId")
 *                         .confidenceLevel(123)
 *                         .customPattern(CustomPatternProperty.builder()
 *                                 .patternName("patternName")
 *                                 .patternRegex("patternRegex")
 *                                 // the properties below are optional
 *                                 .keywordRegex("keywordRegex")
 *                                 .patternDescription("patternDescription")
 *                                 .build())
 *                         .enforcedUrls(List.of("enforcedUrls"))
 *                         .exemptUrls(List.of("exemptUrls"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .globalConfidenceLevel(123)
 *                 .globalEnforcedUrls(List.of("globalEnforcedUrls"))
 *                 .globalExemptUrls(List.of("globalExemptUrls"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.113.0 (build fc68b25)", date = "2025-09-02T11:25:42.261Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnDataProtectionSettings")
public class CfnDataProtectionSettings extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnDataProtectionSettings(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataProtectionSettings(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataProtectionSettings(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettingsProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataProtectionSettings(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A list of web portal ARNs that this data protection settings resource is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrAssociatedPortalArns() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrAssociatedPortalArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The creation date timestamp of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationDate() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the data protection settings resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataProtectionSettingsArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDataProtectionSettingsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The additional encryption context of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalEncryptionContext() {
        return software.amazon.jsii.Kernel.get(this, "additionalEncryptionContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The additional encryption context of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalEncryptionContext(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "additionalEncryptionContext", value);
    }

    /**
     * The additional encryption context of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalEncryptionContext(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "additionalEncryptionContext", value);
    }

    /**
     * The customer managed key used to encrypt sensitive information in the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomerManagedKey() {
        return software.amazon.jsii.Kernel.get(this, "customerManagedKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The customer managed key used to encrypt sensitive information in the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerManagedKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customerManagedKey", value);
    }

    /**
     * The description of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The display name of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The display name of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", value);
    }

    /**
     * The inline redaction configuration for the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInlineRedactionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "inlineRedactionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The inline redaction configuration for the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInlineRedactionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "inlineRedactionConfiguration", value);
    }

    /**
     * The inline redaction configuration for the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInlineRedactionConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings.InlineRedactionConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "inlineRedactionConfiguration", value);
    }

    /**
     * The tags of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags of the data protection settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The pattern configuration for redacting custom data types in session.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.workspacesweb.*;
     * CustomPatternProperty customPatternProperty = CustomPatternProperty.builder()
     *         .patternName("patternName")
     *         .patternRegex("patternRegex")
     *         // the properties below are optional
     *         .keywordRegex("keywordRegex")
     *         .patternDescription("patternDescription")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnDataProtectionSettings.CustomPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The pattern name for the custom pattern.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html#cfn-workspacesweb-dataprotectionsettings-custompattern-patternname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html#cfn-workspacesweb-dataprotectionsettings-custompattern-patternname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPatternName();

        /**
         * The pattern regex for the customer pattern.
         * <p>
         * The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example: “/ab+c/gi”.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html#cfn-workspacesweb-dataprotectionsettings-custompattern-patternregex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html#cfn-workspacesweb-dataprotectionsettings-custompattern-patternregex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPatternRegex();

        /**
         * The keyword regex for the customer pattern.
         * <p>
         * After there is a match to the pattern regex, the keyword regex is used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example, “/ab+c/gi”
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html#cfn-workspacesweb-dataprotectionsettings-custompattern-keywordregex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html#cfn-workspacesweb-dataprotectionsettings-custompattern-keywordregex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeywordRegex() {
            return null;
        }

        /**
         * The pattern description for the customer pattern.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html#cfn-workspacesweb-dataprotectionsettings-custompattern-patterndescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-custompattern.html#cfn-workspacesweb-dataprotectionsettings-custompattern-patterndescription</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPatternDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomPatternProperty> {
            java.lang.String patternName;
            java.lang.String patternRegex;
            java.lang.String keywordRegex;
            java.lang.String patternDescription;

            /**
             * Sets the value of {@link CustomPatternProperty#getPatternName}
             * @param patternName The pattern name for the custom pattern. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternName(java.lang.String patternName) {
                this.patternName = patternName;
                return this;
            }

            /**
             * Sets the value of {@link CustomPatternProperty#getPatternRegex}
             * @param patternRegex The pattern regex for the customer pattern. This parameter is required.
             *                     The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example: “/ab+c/gi”.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternRegex(java.lang.String patternRegex) {
                this.patternRegex = patternRegex;
                return this;
            }

            /**
             * Sets the value of {@link CustomPatternProperty#getKeywordRegex}
             * @param keywordRegex The keyword regex for the customer pattern.
             *                     After there is a match to the pattern regex, the keyword regex is used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example, “/ab+c/gi”
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keywordRegex(java.lang.String keywordRegex) {
                this.keywordRegex = keywordRegex;
                return this;
            }

            /**
             * Sets the value of {@link CustomPatternProperty#getPatternDescription}
             * @param patternDescription The pattern description for the customer pattern.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder patternDescription(java.lang.String patternDescription) {
                this.patternDescription = patternDescription;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPatternProperty {
            private final java.lang.String patternName;
            private final java.lang.String patternRegex;
            private final java.lang.String keywordRegex;
            private final java.lang.String patternDescription;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.patternName = software.amazon.jsii.Kernel.get(this, "patternName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.patternRegex = software.amazon.jsii.Kernel.get(this, "patternRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keywordRegex = software.amazon.jsii.Kernel.get(this, "keywordRegex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.patternDescription = software.amazon.jsii.Kernel.get(this, "patternDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.patternName = java.util.Objects.requireNonNull(builder.patternName, "patternName is required");
                this.patternRegex = java.util.Objects.requireNonNull(builder.patternRegex, "patternRegex is required");
                this.keywordRegex = builder.keywordRegex;
                this.patternDescription = builder.patternDescription;
            }

            @Override
            public final java.lang.String getPatternName() {
                return this.patternName;
            }

            @Override
            public final java.lang.String getPatternRegex() {
                return this.patternRegex;
            }

            @Override
            public final java.lang.String getKeywordRegex() {
                return this.keywordRegex;
            }

            @Override
            public final java.lang.String getPatternDescription() {
                return this.patternDescription;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("patternName", om.valueToTree(this.getPatternName()));
                data.set("patternRegex", om.valueToTree(this.getPatternRegex()));
                if (this.getKeywordRegex() != null) {
                    data.set("keywordRegex", om.valueToTree(this.getKeywordRegex()));
                }
                if (this.getPatternDescription() != null) {
                    data.set("patternDescription", om.valueToTree(this.getPatternDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesweb.CfnDataProtectionSettings.CustomPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomPatternProperty.Jsii$Proxy that = (CustomPatternProperty.Jsii$Proxy) o;

                if (!patternName.equals(that.patternName)) return false;
                if (!patternRegex.equals(that.patternRegex)) return false;
                if (this.keywordRegex != null ? !this.keywordRegex.equals(that.keywordRegex) : that.keywordRegex != null) return false;
                return this.patternDescription != null ? this.patternDescription.equals(that.patternDescription) : that.patternDescription == null;
            }

            @Override
            public final int hashCode() {
                int result = this.patternName.hashCode();
                result = 31 * result + (this.patternRegex.hashCode());
                result = 31 * result + (this.keywordRegex != null ? this.keywordRegex.hashCode() : 0);
                result = 31 * result + (this.patternDescription != null ? this.patternDescription.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for in-session inline redaction.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.workspacesweb.*;
     * InlineRedactionConfigurationProperty inlineRedactionConfigurationProperty = InlineRedactionConfigurationProperty.builder()
     *         .inlineRedactionPatterns(List.of(InlineRedactionPatternProperty.builder()
     *                 .redactionPlaceHolder(RedactionPlaceHolderProperty.builder()
     *                         .redactionPlaceHolderType("redactionPlaceHolderType")
     *                         // the properties below are optional
     *                         .redactionPlaceHolderText("redactionPlaceHolderText")
     *                         .build())
     *                 // the properties below are optional
     *                 .builtInPatternId("builtInPatternId")
     *                 .confidenceLevel(123)
     *                 .customPattern(CustomPatternProperty.builder()
     *                         .patternName("patternName")
     *                         .patternRegex("patternRegex")
     *                         // the properties below are optional
     *                         .keywordRegex("keywordRegex")
     *                         .patternDescription("patternDescription")
     *                         .build())
     *                 .enforcedUrls(List.of("enforcedUrls"))
     *                 .exemptUrls(List.of("exemptUrls"))
     *                 .build()))
     *         // the properties below are optional
     *         .globalConfidenceLevel(123)
     *         .globalEnforcedUrls(List.of("globalEnforcedUrls"))
     *         .globalExemptUrls(List.of("globalExemptUrls"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnDataProtectionSettings.InlineRedactionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InlineRedactionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InlineRedactionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The inline redaction patterns to be enabled for the inline redaction configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration-inlineredactionpatterns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration-inlineredactionpatterns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInlineRedactionPatterns();

        /**
         * The global confidence level for the inline redaction configuration.
         * <p>
         * This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration-globalconfidencelevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration-globalconfidencelevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGlobalConfidenceLevel() {
            return null;
        }

        /**
         * The global enforced URL configuration for the inline redaction configuration.
         * <p>
         * This is applied to patterns that do not have a pattern-level enforced URL list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration-globalenforcedurls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration-globalenforcedurls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGlobalEnforcedUrls() {
            return null;
        }

        /**
         * The global exempt URL configuration for the inline redaction configuration.
         * <p>
         * This is applied to patterns that do not have a pattern-level exempt URL list.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration-globalexempturls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionconfiguration.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration-globalexempturls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGlobalExemptUrls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InlineRedactionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InlineRedactionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InlineRedactionConfigurationProperty> {
            java.lang.Object inlineRedactionPatterns;
            java.lang.Number globalConfidenceLevel;
            java.util.List<java.lang.String> globalEnforcedUrls;
            java.util.List<java.lang.String> globalExemptUrls;

            /**
             * Sets the value of {@link InlineRedactionConfigurationProperty#getInlineRedactionPatterns}
             * @param inlineRedactionPatterns The inline redaction patterns to be enabled for the inline redaction configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlineRedactionPatterns(software.amazon.awscdk.IResolvable inlineRedactionPatterns) {
                this.inlineRedactionPatterns = inlineRedactionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionConfigurationProperty#getInlineRedactionPatterns}
             * @param inlineRedactionPatterns The inline redaction patterns to be enabled for the inline redaction configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inlineRedactionPatterns(java.util.List<? extends java.lang.Object> inlineRedactionPatterns) {
                this.inlineRedactionPatterns = inlineRedactionPatterns;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionConfigurationProperty#getGlobalConfidenceLevel}
             * @param globalConfidenceLevel The global confidence level for the inline redaction configuration.
             *                              This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalConfidenceLevel(java.lang.Number globalConfidenceLevel) {
                this.globalConfidenceLevel = globalConfidenceLevel;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionConfigurationProperty#getGlobalEnforcedUrls}
             * @param globalEnforcedUrls The global enforced URL configuration for the inline redaction configuration.
             *                           This is applied to patterns that do not have a pattern-level enforced URL list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalEnforcedUrls(java.util.List<java.lang.String> globalEnforcedUrls) {
                this.globalEnforcedUrls = globalEnforcedUrls;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionConfigurationProperty#getGlobalExemptUrls}
             * @param globalExemptUrls The global exempt URL configuration for the inline redaction configuration.
             *                         This is applied to patterns that do not have a pattern-level exempt URL list.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder globalExemptUrls(java.util.List<java.lang.String> globalExemptUrls) {
                this.globalExemptUrls = globalExemptUrls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InlineRedactionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InlineRedactionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InlineRedactionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InlineRedactionConfigurationProperty {
            private final java.lang.Object inlineRedactionPatterns;
            private final java.lang.Number globalConfidenceLevel;
            private final java.util.List<java.lang.String> globalEnforcedUrls;
            private final java.util.List<java.lang.String> globalExemptUrls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inlineRedactionPatterns = software.amazon.jsii.Kernel.get(this, "inlineRedactionPatterns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.globalConfidenceLevel = software.amazon.jsii.Kernel.get(this, "globalConfidenceLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.globalEnforcedUrls = software.amazon.jsii.Kernel.get(this, "globalEnforcedUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.globalExemptUrls = software.amazon.jsii.Kernel.get(this, "globalExemptUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inlineRedactionPatterns = java.util.Objects.requireNonNull(builder.inlineRedactionPatterns, "inlineRedactionPatterns is required");
                this.globalConfidenceLevel = builder.globalConfidenceLevel;
                this.globalEnforcedUrls = builder.globalEnforcedUrls;
                this.globalExemptUrls = builder.globalExemptUrls;
            }

            @Override
            public final java.lang.Object getInlineRedactionPatterns() {
                return this.inlineRedactionPatterns;
            }

            @Override
            public final java.lang.Number getGlobalConfidenceLevel() {
                return this.globalConfidenceLevel;
            }

            @Override
            public final java.util.List<java.lang.String> getGlobalEnforcedUrls() {
                return this.globalEnforcedUrls;
            }

            @Override
            public final java.util.List<java.lang.String> getGlobalExemptUrls() {
                return this.globalExemptUrls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inlineRedactionPatterns", om.valueToTree(this.getInlineRedactionPatterns()));
                if (this.getGlobalConfidenceLevel() != null) {
                    data.set("globalConfidenceLevel", om.valueToTree(this.getGlobalConfidenceLevel()));
                }
                if (this.getGlobalEnforcedUrls() != null) {
                    data.set("globalEnforcedUrls", om.valueToTree(this.getGlobalEnforcedUrls()));
                }
                if (this.getGlobalExemptUrls() != null) {
                    data.set("globalExemptUrls", om.valueToTree(this.getGlobalExemptUrls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesweb.CfnDataProtectionSettings.InlineRedactionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InlineRedactionConfigurationProperty.Jsii$Proxy that = (InlineRedactionConfigurationProperty.Jsii$Proxy) o;

                if (!inlineRedactionPatterns.equals(that.inlineRedactionPatterns)) return false;
                if (this.globalConfidenceLevel != null ? !this.globalConfidenceLevel.equals(that.globalConfidenceLevel) : that.globalConfidenceLevel != null) return false;
                if (this.globalEnforcedUrls != null ? !this.globalEnforcedUrls.equals(that.globalEnforcedUrls) : that.globalEnforcedUrls != null) return false;
                return this.globalExemptUrls != null ? this.globalExemptUrls.equals(that.globalExemptUrls) : that.globalExemptUrls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inlineRedactionPatterns.hashCode();
                result = 31 * result + (this.globalConfidenceLevel != null ? this.globalConfidenceLevel.hashCode() : 0);
                result = 31 * result + (this.globalEnforcedUrls != null ? this.globalEnforcedUrls.hashCode() : 0);
                result = 31 * result + (this.globalExemptUrls != null ? this.globalExemptUrls.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The set of patterns that determine the data types redacted in session.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.workspacesweb.*;
     * InlineRedactionPatternProperty inlineRedactionPatternProperty = InlineRedactionPatternProperty.builder()
     *         .redactionPlaceHolder(RedactionPlaceHolderProperty.builder()
     *                 .redactionPlaceHolderType("redactionPlaceHolderType")
     *                 // the properties below are optional
     *                 .redactionPlaceHolderText("redactionPlaceHolderText")
     *                 .build())
     *         // the properties below are optional
     *         .builtInPatternId("builtInPatternId")
     *         .confidenceLevel(123)
     *         .customPattern(CustomPatternProperty.builder()
     *                 .patternName("patternName")
     *                 .patternRegex("patternRegex")
     *                 // the properties below are optional
     *                 .keywordRegex("keywordRegex")
     *                 .patternDescription("patternDescription")
     *                 .build())
     *         .enforcedUrls(List.of("enforcedUrls"))
     *         .exemptUrls(List.of("exemptUrls"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnDataProtectionSettings.InlineRedactionPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(InlineRedactionPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InlineRedactionPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-redactionplaceholder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-redactionplaceholder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRedactionPlaceHolder();

        /**
         * The built-in pattern from the list of preconfigured patterns.
         * <p>
         * Either a customPattern or builtInPatternId is required. To view the entire list of data types and their corresponding built-in pattern IDs, see <a href="https://docs.aws.amazon.com/workspaces-web/latest/adminguide/base-inline-redaction.html">Base inline redaction</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-builtinpatternid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-builtinpatternid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBuiltInPatternId() {
            return null;
        }

        /**
         * The confidence level for inline redaction pattern.
         * <p>
         * This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global confidence level.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-confidencelevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-confidencelevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConfidenceLevel() {
            return null;
        }

        /**
         * The configuration for a custom pattern.
         * <p>
         * Either a customPattern or builtInPatternId is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-custompattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-custompattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomPattern() {
            return null;
        }

        /**
         * The enforced URL configuration for the inline redaction pattern.
         * <p>
         * This will override the global enforced URL configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-enforcedurls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-enforcedurls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEnforcedUrls() {
            return null;
        }

        /**
         * The exempt URL configuration for the inline redaction pattern.
         * <p>
         * This will override the global exempt URL configuration for the inline redaction pattern.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-exempturls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-inlineredactionpattern.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionpattern-exempturls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExemptUrls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InlineRedactionPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InlineRedactionPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InlineRedactionPatternProperty> {
            java.lang.Object redactionPlaceHolder;
            java.lang.String builtInPatternId;
            java.lang.Number confidenceLevel;
            java.lang.Object customPattern;
            java.util.List<java.lang.String> enforcedUrls;
            java.util.List<java.lang.String> exemptUrls;

            /**
             * Sets the value of {@link InlineRedactionPatternProperty#getRedactionPlaceHolder}
             * @param redactionPlaceHolder The redaction placeholder that will replace the redacted text in session for the inline redaction pattern. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redactionPlaceHolder(software.amazon.awscdk.IResolvable redactionPlaceHolder) {
                this.redactionPlaceHolder = redactionPlaceHolder;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionPatternProperty#getRedactionPlaceHolder}
             * @param redactionPlaceHolder The redaction placeholder that will replace the redacted text in session for the inline redaction pattern. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redactionPlaceHolder(software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings.RedactionPlaceHolderProperty redactionPlaceHolder) {
                this.redactionPlaceHolder = redactionPlaceHolder;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionPatternProperty#getBuiltInPatternId}
             * @param builtInPatternId The built-in pattern from the list of preconfigured patterns.
             *                         Either a customPattern or builtInPatternId is required. To view the entire list of data types and their corresponding built-in pattern IDs, see <a href="https://docs.aws.amazon.com/workspaces-web/latest/adminguide/base-inline-redaction.html">Base inline redaction</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder builtInPatternId(java.lang.String builtInPatternId) {
                this.builtInPatternId = builtInPatternId;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionPatternProperty#getConfidenceLevel}
             * @param confidenceLevel The confidence level for inline redaction pattern.
             *                        This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global confidence level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confidenceLevel(java.lang.Number confidenceLevel) {
                this.confidenceLevel = confidenceLevel;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionPatternProperty#getCustomPattern}
             * @param customPattern The configuration for a custom pattern.
             *                      Either a customPattern or builtInPatternId is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPattern(software.amazon.awscdk.IResolvable customPattern) {
                this.customPattern = customPattern;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionPatternProperty#getCustomPattern}
             * @param customPattern The configuration for a custom pattern.
             *                      Either a customPattern or builtInPatternId is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customPattern(software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings.CustomPatternProperty customPattern) {
                this.customPattern = customPattern;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionPatternProperty#getEnforcedUrls}
             * @param enforcedUrls The enforced URL configuration for the inline redaction pattern.
             *                     This will override the global enforced URL configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforcedUrls(java.util.List<java.lang.String> enforcedUrls) {
                this.enforcedUrls = enforcedUrls;
                return this;
            }

            /**
             * Sets the value of {@link InlineRedactionPatternProperty#getExemptUrls}
             * @param exemptUrls The exempt URL configuration for the inline redaction pattern.
             *                   This will override the global exempt URL configuration for the inline redaction pattern.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exemptUrls(java.util.List<java.lang.String> exemptUrls) {
                this.exemptUrls = exemptUrls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InlineRedactionPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InlineRedactionPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InlineRedactionPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InlineRedactionPatternProperty {
            private final java.lang.Object redactionPlaceHolder;
            private final java.lang.String builtInPatternId;
            private final java.lang.Number confidenceLevel;
            private final java.lang.Object customPattern;
            private final java.util.List<java.lang.String> enforcedUrls;
            private final java.util.List<java.lang.String> exemptUrls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.redactionPlaceHolder = software.amazon.jsii.Kernel.get(this, "redactionPlaceHolder", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.builtInPatternId = software.amazon.jsii.Kernel.get(this, "builtInPatternId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.confidenceLevel = software.amazon.jsii.Kernel.get(this, "confidenceLevel", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customPattern = software.amazon.jsii.Kernel.get(this, "customPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enforcedUrls = software.amazon.jsii.Kernel.get(this, "enforcedUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.exemptUrls = software.amazon.jsii.Kernel.get(this, "exemptUrls", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.redactionPlaceHolder = java.util.Objects.requireNonNull(builder.redactionPlaceHolder, "redactionPlaceHolder is required");
                this.builtInPatternId = builder.builtInPatternId;
                this.confidenceLevel = builder.confidenceLevel;
                this.customPattern = builder.customPattern;
                this.enforcedUrls = builder.enforcedUrls;
                this.exemptUrls = builder.exemptUrls;
            }

            @Override
            public final java.lang.Object getRedactionPlaceHolder() {
                return this.redactionPlaceHolder;
            }

            @Override
            public final java.lang.String getBuiltInPatternId() {
                return this.builtInPatternId;
            }

            @Override
            public final java.lang.Number getConfidenceLevel() {
                return this.confidenceLevel;
            }

            @Override
            public final java.lang.Object getCustomPattern() {
                return this.customPattern;
            }

            @Override
            public final java.util.List<java.lang.String> getEnforcedUrls() {
                return this.enforcedUrls;
            }

            @Override
            public final java.util.List<java.lang.String> getExemptUrls() {
                return this.exemptUrls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("redactionPlaceHolder", om.valueToTree(this.getRedactionPlaceHolder()));
                if (this.getBuiltInPatternId() != null) {
                    data.set("builtInPatternId", om.valueToTree(this.getBuiltInPatternId()));
                }
                if (this.getConfidenceLevel() != null) {
                    data.set("confidenceLevel", om.valueToTree(this.getConfidenceLevel()));
                }
                if (this.getCustomPattern() != null) {
                    data.set("customPattern", om.valueToTree(this.getCustomPattern()));
                }
                if (this.getEnforcedUrls() != null) {
                    data.set("enforcedUrls", om.valueToTree(this.getEnforcedUrls()));
                }
                if (this.getExemptUrls() != null) {
                    data.set("exemptUrls", om.valueToTree(this.getExemptUrls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesweb.CfnDataProtectionSettings.InlineRedactionPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InlineRedactionPatternProperty.Jsii$Proxy that = (InlineRedactionPatternProperty.Jsii$Proxy) o;

                if (!redactionPlaceHolder.equals(that.redactionPlaceHolder)) return false;
                if (this.builtInPatternId != null ? !this.builtInPatternId.equals(that.builtInPatternId) : that.builtInPatternId != null) return false;
                if (this.confidenceLevel != null ? !this.confidenceLevel.equals(that.confidenceLevel) : that.confidenceLevel != null) return false;
                if (this.customPattern != null ? !this.customPattern.equals(that.customPattern) : that.customPattern != null) return false;
                if (this.enforcedUrls != null ? !this.enforcedUrls.equals(that.enforcedUrls) : that.enforcedUrls != null) return false;
                return this.exemptUrls != null ? this.exemptUrls.equals(that.exemptUrls) : that.exemptUrls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.redactionPlaceHolder.hashCode();
                result = 31 * result + (this.builtInPatternId != null ? this.builtInPatternId.hashCode() : 0);
                result = 31 * result + (this.confidenceLevel != null ? this.confidenceLevel.hashCode() : 0);
                result = 31 * result + (this.customPattern != null ? this.customPattern.hashCode() : 0);
                result = 31 * result + (this.enforcedUrls != null ? this.enforcedUrls.hashCode() : 0);
                result = 31 * result + (this.exemptUrls != null ? this.exemptUrls.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The redaction placeholder that will replace the redacted text in session.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.workspacesweb.*;
     * RedactionPlaceHolderProperty redactionPlaceHolderProperty = RedactionPlaceHolderProperty.builder()
     *         .redactionPlaceHolderType("redactionPlaceHolderType")
     *         // the properties below are optional
     *         .redactionPlaceHolderText("redactionPlaceHolderText")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-redactionplaceholder.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-redactionplaceholder.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_workspacesweb.CfnDataProtectionSettings.RedactionPlaceHolderProperty")
    @software.amazon.jsii.Jsii.Proxy(RedactionPlaceHolderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedactionPlaceHolderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The redaction placeholder type that will replace the redacted text in session.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-redactionplaceholder.html#cfn-workspacesweb-dataprotectionsettings-redactionplaceholder-redactionplaceholdertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-redactionplaceholder.html#cfn-workspacesweb-dataprotectionsettings-redactionplaceholder-redactionplaceholdertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRedactionPlaceHolderType();

        /**
         * The redaction placeholder text that will replace the redacted text in session for the custom text redaction placeholder type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-redactionplaceholder.html#cfn-workspacesweb-dataprotectionsettings-redactionplaceholder-redactionplaceholdertext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspacesweb-dataprotectionsettings-redactionplaceholder.html#cfn-workspacesweb-dataprotectionsettings-redactionplaceholder-redactionplaceholdertext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRedactionPlaceHolderText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedactionPlaceHolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedactionPlaceHolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedactionPlaceHolderProperty> {
            java.lang.String redactionPlaceHolderType;
            java.lang.String redactionPlaceHolderText;

            /**
             * Sets the value of {@link RedactionPlaceHolderProperty#getRedactionPlaceHolderType}
             * @param redactionPlaceHolderType The redaction placeholder type that will replace the redacted text in session. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redactionPlaceHolderType(java.lang.String redactionPlaceHolderType) {
                this.redactionPlaceHolderType = redactionPlaceHolderType;
                return this;
            }

            /**
             * Sets the value of {@link RedactionPlaceHolderProperty#getRedactionPlaceHolderText}
             * @param redactionPlaceHolderText The redaction placeholder text that will replace the redacted text in session for the custom text redaction placeholder type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redactionPlaceHolderText(java.lang.String redactionPlaceHolderText) {
                this.redactionPlaceHolderText = redactionPlaceHolderText;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedactionPlaceHolderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedactionPlaceHolderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedactionPlaceHolderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedactionPlaceHolderProperty {
            private final java.lang.String redactionPlaceHolderType;
            private final java.lang.String redactionPlaceHolderText;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.redactionPlaceHolderType = software.amazon.jsii.Kernel.get(this, "redactionPlaceHolderType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.redactionPlaceHolderText = software.amazon.jsii.Kernel.get(this, "redactionPlaceHolderText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.redactionPlaceHolderType = java.util.Objects.requireNonNull(builder.redactionPlaceHolderType, "redactionPlaceHolderType is required");
                this.redactionPlaceHolderText = builder.redactionPlaceHolderText;
            }

            @Override
            public final java.lang.String getRedactionPlaceHolderType() {
                return this.redactionPlaceHolderType;
            }

            @Override
            public final java.lang.String getRedactionPlaceHolderText() {
                return this.redactionPlaceHolderText;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("redactionPlaceHolderType", om.valueToTree(this.getRedactionPlaceHolderType()));
                if (this.getRedactionPlaceHolderText() != null) {
                    data.set("redactionPlaceHolderText", om.valueToTree(this.getRedactionPlaceHolderText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_workspacesweb.CfnDataProtectionSettings.RedactionPlaceHolderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedactionPlaceHolderProperty.Jsii$Proxy that = (RedactionPlaceHolderProperty.Jsii$Proxy) o;

                if (!redactionPlaceHolderType.equals(that.redactionPlaceHolderType)) return false;
                return this.redactionPlaceHolderText != null ? this.redactionPlaceHolderText.equals(that.redactionPlaceHolderText) : that.redactionPlaceHolderText == null;
            }

            @Override
            public final int hashCode() {
                int result = this.redactionPlaceHolderType.hashCode();
                result = 31 * result + (this.redactionPlaceHolderText != null ? this.redactionPlaceHolderText.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettingsProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The additional encryption context of the data protection settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-additionalencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-additionalencryptioncontext</a>
         * @param additionalEncryptionContext The additional encryption context of the data protection settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(final java.util.Map<java.lang.String, java.lang.String> additionalEncryptionContext) {
            this.props().additionalEncryptionContext(additionalEncryptionContext);
            return this;
        }
        /**
         * The additional encryption context of the data protection settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-additionalencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-additionalencryptioncontext</a>
         * @param additionalEncryptionContext The additional encryption context of the data protection settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(final software.amazon.awscdk.IResolvable additionalEncryptionContext) {
            this.props().additionalEncryptionContext(additionalEncryptionContext);
            return this;
        }

        /**
         * The customer managed key used to encrypt sensitive information in the data protection settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-customermanagedkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-customermanagedkey</a>
         * @param customerManagedKey The customer managed key used to encrypt sensitive information in the data protection settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerManagedKey(final java.lang.String customerManagedKey) {
            this.props().customerManagedKey(customerManagedKey);
            return this;
        }

        /**
         * The description of the data protection settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-description</a>
         * @param description The description of the data protection settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * The display name of the data protection settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-displayname</a>
         * @param displayName The display name of the data protection settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props().displayName(displayName);
            return this;
        }

        /**
         * The inline redaction configuration for the data protection settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration</a>
         * @param inlineRedactionConfiguration The inline redaction configuration for the data protection settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlineRedactionConfiguration(final software.amazon.awscdk.IResolvable inlineRedactionConfiguration) {
            this.props().inlineRedactionConfiguration(inlineRedactionConfiguration);
            return this;
        }
        /**
         * The inline redaction configuration for the data protection settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-inlineredactionconfiguration</a>
         * @param inlineRedactionConfiguration The inline redaction configuration for the data protection settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlineRedactionConfiguration(final software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings.InlineRedactionConfigurationProperty inlineRedactionConfiguration) {
            this.props().inlineRedactionConfiguration(inlineRedactionConfiguration);
            return this;
        }

        /**
         * The tags of the data protection settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspacesweb-dataprotectionsettings.html#cfn-workspacesweb-dataprotectionsettings-tags</a>
         * @param tags The tags of the data protection settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings build() {
            return new software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettings(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettingsProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.workspacesweb.CfnDataProtectionSettingsProps.Builder();
            }
            return this.props;
        }
    }
}
