package software.amazon.awscdk;

/**
 * A reference to a ModuleDefaultVersion resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * ModuleDefaultVersionReference moduleDefaultVersionReference = ModuleDefaultVersionReference.builder()
 *         .moduleDefaultVersionArn("moduleDefaultVersionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:56.880Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.ModuleDefaultVersionReference")
@software.amazon.jsii.Jsii.Proxy(ModuleDefaultVersionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ModuleDefaultVersionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the ModuleDefaultVersion resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModuleDefaultVersionArn();

    /**
     * @return a {@link Builder} of {@link ModuleDefaultVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ModuleDefaultVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ModuleDefaultVersionReference> {
        java.lang.String moduleDefaultVersionArn;

        /**
         * Sets the value of {@link ModuleDefaultVersionReference#getModuleDefaultVersionArn}
         * @param moduleDefaultVersionArn The Arn of the ModuleDefaultVersion resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder moduleDefaultVersionArn(java.lang.String moduleDefaultVersionArn) {
            this.moduleDefaultVersionArn = moduleDefaultVersionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ModuleDefaultVersionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ModuleDefaultVersionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ModuleDefaultVersionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModuleDefaultVersionReference {
        private final java.lang.String moduleDefaultVersionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.moduleDefaultVersionArn = software.amazon.jsii.Kernel.get(this, "moduleDefaultVersionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.moduleDefaultVersionArn = java.util.Objects.requireNonNull(builder.moduleDefaultVersionArn, "moduleDefaultVersionArn is required");
        }

        @Override
        public final java.lang.String getModuleDefaultVersionArn() {
            return this.moduleDefaultVersionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("moduleDefaultVersionArn", om.valueToTree(this.getModuleDefaultVersionArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.ModuleDefaultVersionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ModuleDefaultVersionReference.Jsii$Proxy that = (ModuleDefaultVersionReference.Jsii$Proxy) o;

            return this.moduleDefaultVersionArn.equals(that.moduleDefaultVersionArn);
        }

        @Override
        public final int hashCode() {
            int result = this.moduleDefaultVersionArn.hashCode();
            return result;
        }
    }
}
