package software.amazon.awscdk;

/**
 * Options for referencing a secret value from Secrets Manager.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * BitBucketSourceCredentials.Builder.create(this, "CodeBuildBitBucketCreds")
 *         .username(SecretValue.secretsManager("my-bitbucket-creds", SecretsManagerSecretOptions.builder().jsonField("username").build()))
 *         .password(SecretValue.secretsManager("my-bitbucket-creds", SecretsManagerSecretOptions.builder().jsonField("password").build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:56.898Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.SecretsManagerSecretOptions")
@software.amazon.jsii.Jsii.Proxy(SecretsManagerSecretOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecretsManagerSecretOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The key of a JSON field to retrieve.
     * <p>
     * This can only be used if the secret
     * stores a JSON object.
     * <p>
     * Default: - returns all the content stored in the Secrets Manager secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getJsonField() {
        return null;
    }

    /**
     * Specifies the unique identifier of the version of the secret you want to use.
     * <p>
     * Can specify at most one of <code>versionId</code> and <code>versionStage</code>.
     * <p>
     * Default: AWSCURRENT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionId() {
        return null;
    }

    /**
     * Specifies the secret version that you want to retrieve by the staging label attached to the version.
     * <p>
     * Can specify at most one of <code>versionId</code> and <code>versionStage</code>.
     * <p>
     * Default: AWSCURRENT
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionStage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecretsManagerSecretOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecretsManagerSecretOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecretsManagerSecretOptions> {
        java.lang.String jsonField;
        java.lang.String versionId;
        java.lang.String versionStage;

        /**
         * Sets the value of {@link SecretsManagerSecretOptions#getJsonField}
         * @param jsonField The key of a JSON field to retrieve.
         *                  This can only be used if the secret
         *                  stores a JSON object.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonField(java.lang.String jsonField) {
            this.jsonField = jsonField;
            return this;
        }

        /**
         * Sets the value of {@link SecretsManagerSecretOptions#getVersionId}
         * @param versionId Specifies the unique identifier of the version of the secret you want to use.
         *                  Can specify at most one of <code>versionId</code> and <code>versionStage</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionId(java.lang.String versionId) {
            this.versionId = versionId;
            return this;
        }

        /**
         * Sets the value of {@link SecretsManagerSecretOptions#getVersionStage}
         * @param versionStage Specifies the secret version that you want to retrieve by the staging label attached to the version.
         *                     Can specify at most one of <code>versionId</code> and <code>versionStage</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionStage(java.lang.String versionStage) {
            this.versionStage = versionStage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretsManagerSecretOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecretsManagerSecretOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecretsManagerSecretOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretsManagerSecretOptions {
        private final java.lang.String jsonField;
        private final java.lang.String versionId;
        private final java.lang.String versionStage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.jsonField = software.amazon.jsii.Kernel.get(this, "jsonField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionId = software.amazon.jsii.Kernel.get(this, "versionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.versionStage = software.amazon.jsii.Kernel.get(this, "versionStage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.jsonField = builder.jsonField;
            this.versionId = builder.versionId;
            this.versionStage = builder.versionStage;
        }

        @Override
        public final java.lang.String getJsonField() {
            return this.jsonField;
        }

        @Override
        public final java.lang.String getVersionId() {
            return this.versionId;
        }

        @Override
        public final java.lang.String getVersionStage() {
            return this.versionStage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getJsonField() != null) {
                data.set("jsonField", om.valueToTree(this.getJsonField()));
            }
            if (this.getVersionId() != null) {
                data.set("versionId", om.valueToTree(this.getVersionId()));
            }
            if (this.getVersionStage() != null) {
                data.set("versionStage", om.valueToTree(this.getVersionStage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.SecretsManagerSecretOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecretsManagerSecretOptions.Jsii$Proxy that = (SecretsManagerSecretOptions.Jsii$Proxy) o;

            if (this.jsonField != null ? !this.jsonField.equals(that.jsonField) : that.jsonField != null) return false;
            if (this.versionId != null ? !this.versionId.equals(that.versionId) : that.versionId != null) return false;
            return this.versionStage != null ? this.versionStage.equals(that.versionStage) : that.versionStage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.jsonField != null ? this.jsonField.hashCode() : 0;
            result = 31 * result + (this.versionId != null ? this.versionId.hashCode() : 0);
            result = 31 * result + (this.versionStage != null ? this.versionStage.hashCode() : 0);
            return result;
        }
    }
}
