package software.amazon.awscdk;

/**
 * A reference to a WaitCondition resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * WaitConditionReference waitConditionReference = WaitConditionReference.builder()
 *         .waitConditionId("waitConditionId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:56.956Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.WaitConditionReference")
@software.amazon.jsii.Jsii.Proxy(WaitConditionReference.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WaitConditionReference extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Id of the WaitCondition resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWaitConditionId();

    /**
     * @return a {@link Builder} of {@link WaitConditionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WaitConditionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WaitConditionReference> {
        java.lang.String waitConditionId;

        /**
         * Sets the value of {@link WaitConditionReference#getWaitConditionId}
         * @param waitConditionId The Id of the WaitCondition resource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitConditionId(java.lang.String waitConditionId) {
            this.waitConditionId = waitConditionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WaitConditionReference}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WaitConditionReference build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WaitConditionReference}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WaitConditionReference {
        private final java.lang.String waitConditionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.waitConditionId = software.amazon.jsii.Kernel.get(this, "waitConditionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.waitConditionId = java.util.Objects.requireNonNull(builder.waitConditionId, "waitConditionId is required");
        }

        @Override
        public final java.lang.String getWaitConditionId() {
            return this.waitConditionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("waitConditionId", om.valueToTree(this.getWaitConditionId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.WaitConditionReference"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WaitConditionReference.Jsii$Proxy that = (WaitConditionReference.Jsii$Proxy) o;

            return this.waitConditionId.equals(that.waitConditionId);
        }

        @Override
        public final int hashCode() {
            int result = this.waitConditionId.hashCode();
            return result;
        }
    }
}
