package software.amazon.awscdk.aws_apigatewayv2_authorizers;

/**
 * Authorize WebSocket Api routes via a lambda function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizer;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration;
 * // This function handles your auth logic
 * Function authHandler;
 * // This function handles your WebSocket requests
 * Function handler;
 * WebSocketLambdaAuthorizer authorizer = new WebSocketLambdaAuthorizer("Authorizer", authHandler);
 * WebSocketLambdaIntegration integration = new WebSocketLambdaIntegration("Integration", handler);
 * WebSocketApi.Builder.create(this, "WebSocketApi")
 *         .connectRouteOptions(WebSocketRouteOptions.builder()
 *                 .integration(integration)
 *                 .authorizer(authorizer)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:57.654Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizer")
public class WebSocketLambdaAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer {

    protected WebSocketLambdaAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WebSocketLambdaAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id This parameter is required.
     * @param handler This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketLambdaAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * @param id This parameter is required.
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WebSocketLambdaAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction handler) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Bind this authorizer to a specified WebSocket route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteAuthorizerBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id This parameter is required.
         * @param handler This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id, final software.amazon.awscdk.services.lambda.IFunction handler) {
            return new Builder(id, handler);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizerProps.Builder props;

        private Builder(final java.lang.String id, final software.amazon.awscdk.services.lambda.IFunction handler) {
            this.id = id;
            this.handler = handler;
        }

        /**
         * The name of the authorizer.
         * <p>
         * Default: - same value as `id` passed in the constructor.
         * <p>
         * @return {@code this}
         * @param authorizerName The name of the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props().authorizerName(authorizerName);
            return this;
        }

        /**
         * The identity source for which authorization is requested.
         * <p>
         * Request parameter match <code>'route.request.querystring|header.[a-zA-z0-9._-]+'</code>.
         * Staged variable match <code>'stageVariables.[a-zA-Z0-9._-]+'</code>.
         * Context parameter match <code>'context.[a-zA-Z0-9._-]+'</code>.
         * <p>
         * Default: ['route.request.header.Authorization']
         * <p>
         * @return {@code this}
         * @param identitySource The identity source for which authorization is requested. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(final java.util.List<java.lang.String> identitySource) {
            this.props().identitySource(identitySource);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizer build() {
            return new software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizer(
                this.id,
                this.handler,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizerProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.aws_apigatewayv2_authorizers.WebSocketLambdaAuthorizerProps.Builder();
            }
            return this.props;
        }
    }
}
