package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * The StepFunctions integration resource for HTTP API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegration;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * StateMachine stateMachine;
 * HttpApi httpApi;
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/start")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpStepFunctionsIntegration.Builder.create("StartExecutionIntegration")
 *                 .stateMachine(stateMachine)
 *                 .subtype(HttpIntegrationSubtype.STEPFUNCTIONS_START_EXECUTION)
 *                 .build())
 *         .build());
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/start-sync")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpStepFunctionsIntegration.Builder.create("StartSyncExecutionIntegration")
 *                 .stateMachine(stateMachine)
 *                 .subtype(HttpIntegrationSubtype.STEPFUNCTIONS_START_SYNC_EXECUTION)
 *                 .build())
 *         .build());
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/stop")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpStepFunctionsIntegration.Builder.create("StopExecutionIntegration")
 *                 .stateMachine(stateMachine)
 *                 .subtype(HttpIntegrationSubtype.STEPFUNCTIONS_STOP_EXECUTION)
 *                 // For the `STOP_EXECUTION` subtype, it is necessary to specify the `executionArn`.
 *                 .parameterMapping(new ParameterMapping().custom("ExecutionArn", "$request.querystring.executionArn"))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:57.666Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.HttpStepFunctionsIntegration")
public class HttpStepFunctionsIntegration extends software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration {

    protected HttpStepFunctionsIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpStepFunctionsIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param props properties to configure the integration. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpStepFunctionsIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Bind this integration to the route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id id of the underlying integration construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id) {
            return new Builder(id);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegrationProps.Builder props;

        private Builder(final java.lang.String id) {
            this.id = id;
            this.props = new software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegrationProps.Builder();
        }

        /**
         * Statemachine that Integrates with API Gateway.
         * <p>
         * @return {@code this}
         * @param stateMachine Statemachine that Integrates with API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachine(final software.amazon.awscdk.services.stepfunctions.StateMachine stateMachine) {
            this.props.stateMachine(stateMachine);
            return this;
        }

        /**
         * Specifies how to transform HTTP requests before sending them to the backend.
         * <p>
         * When the subtype is either <code>START_EXECUTION</code> or <code>START_SYNC_EXECUTION</code>,
         * it is necessary to specify the <code>StateMachineArn</code>.
         * Conversely, when the subtype is <code>STOP_EXECUTION</code>, the <code>ExecutionArn</code> must be specified.
         * <p>
         * Default: - specify only `StateMachineArn`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.props.parameterMapping(parameterMapping);
            return this;
        }

        /**
         * The subtype of the HTTP integration.
         * <p>
         * Only subtypes starting with STEPFUNCTIONS_ can be specified.
         * <p>
         * Default: HttpIntegrationSubtype.STEPFUNCTIONS_START_EXECUTION
         * <p>
         * @return {@code this}
         * @param subtype The subtype of the HTTP integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subtype(final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype) {
            this.props.subtype(subtype);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegration build() {
            return new software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegration(
                this.id,
                this.props.build()
            );
        }
    }
}
