package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * Properties to initialize <code>HttpStepFunctionsIntegration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpStepFunctionsIntegration;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * StateMachine stateMachine;
 * HttpApi httpApi;
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/start")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpStepFunctionsIntegration.Builder.create("StartExecutionIntegration")
 *                 .stateMachine(stateMachine)
 *                 .subtype(HttpIntegrationSubtype.STEPFUNCTIONS_START_EXECUTION)
 *                 .build())
 *         .build());
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/start-sync")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpStepFunctionsIntegration.Builder.create("StartSyncExecutionIntegration")
 *                 .stateMachine(stateMachine)
 *                 .subtype(HttpIntegrationSubtype.STEPFUNCTIONS_START_SYNC_EXECUTION)
 *                 .build())
 *         .build());
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/stop")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpStepFunctionsIntegration.Builder.create("StopExecutionIntegration")
 *                 .stateMachine(stateMachine)
 *                 .subtype(HttpIntegrationSubtype.STEPFUNCTIONS_STOP_EXECUTION)
 *                 // For the `STOP_EXECUTION` subtype, it is necessary to specify the `executionArn`.
 *                 .parameterMapping(new ParameterMapping().custom("ExecutionArn", "$request.querystring.executionArn"))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.118.0 (build 02eec31)", date = "2025-11-10T13:39:57.667Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.HttpStepFunctionsIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(HttpStepFunctionsIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpStepFunctionsIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Statemachine that Integrates with API Gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachine getStateMachine();

    /**
     * Specifies how to transform HTTP requests before sending them to the backend.
     * <p>
     * When the subtype is either <code>START_EXECUTION</code> or <code>START_SYNC_EXECUTION</code>,
     * it is necessary to specify the <code>StateMachineArn</code>.
     * Conversely, when the subtype is <code>STOP_EXECUTION</code>, the <code>ExecutionArn</code> must be specified.
     * <p>
     * Default: - specify only `StateMachineArn`
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
        return null;
    }

    /**
     * The subtype of the HTTP integration.
     * <p>
     * Only subtypes starting with STEPFUNCTIONS_ can be specified.
     * <p>
     * Default: HttpIntegrationSubtype.STEPFUNCTIONS_START_EXECUTION
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype getSubtype() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpStepFunctionsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpStepFunctionsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpStepFunctionsIntegrationProps> {
        software.amazon.awscdk.services.stepfunctions.StateMachine stateMachine;
        software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype;

        /**
         * Sets the value of {@link HttpStepFunctionsIntegrationProps#getStateMachine}
         * @param stateMachine Statemachine that Integrates with API Gateway. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachine(software.amazon.awscdk.services.stepfunctions.StateMachine stateMachine) {
            this.stateMachine = stateMachine;
            return this;
        }

        /**
         * Sets the value of {@link HttpStepFunctionsIntegrationProps#getParameterMapping}
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend.
         *                         When the subtype is either <code>START_EXECUTION</code> or <code>START_SYNC_EXECUTION</code>,
         *                         it is necessary to specify the <code>StateMachineArn</code>.
         *                         Conversely, when the subtype is <code>STOP_EXECUTION</code>, the <code>ExecutionArn</code> must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.parameterMapping = parameterMapping;
            return this;
        }

        /**
         * Sets the value of {@link HttpStepFunctionsIntegrationProps#getSubtype}
         * @param subtype The subtype of the HTTP integration.
         *                Only subtypes starting with STEPFUNCTIONS_ can be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subtype(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpStepFunctionsIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpStepFunctionsIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpStepFunctionsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpStepFunctionsIntegrationProps {
        private final software.amazon.awscdk.services.stepfunctions.StateMachine stateMachine;
        private final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping;
        private final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stateMachine = software.amazon.jsii.Kernel.get(this, "stateMachine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateMachine.class));
            this.parameterMapping = software.amazon.jsii.Kernel.get(this, "parameterMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ParameterMapping.class));
            this.subtype = software.amazon.jsii.Kernel.get(this, "subtype", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stateMachine = java.util.Objects.requireNonNull(builder.stateMachine, "stateMachine is required");
            this.parameterMapping = builder.parameterMapping;
            this.subtype = builder.subtype;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.StateMachine getStateMachine() {
            return this.stateMachine;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ParameterMapping getParameterMapping() {
            return this.parameterMapping;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype getSubtype() {
            return this.subtype;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stateMachine", om.valueToTree(this.getStateMachine()));
            if (this.getParameterMapping() != null) {
                data.set("parameterMapping", om.valueToTree(this.getParameterMapping()));
            }
            if (this.getSubtype() != null) {
                data.set("subtype", om.valueToTree(this.getSubtype()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2_integrations.HttpStepFunctionsIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpStepFunctionsIntegrationProps.Jsii$Proxy that = (HttpStepFunctionsIntegrationProps.Jsii$Proxy) o;

            if (!stateMachine.equals(that.stateMachine)) return false;
            if (this.parameterMapping != null ? !this.parameterMapping.equals(that.parameterMapping) : that.parameterMapping != null) return false;
            return this.subtype != null ? this.subtype.equals(that.subtype) : that.subtype == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stateMachine.hashCode();
            result = 31 * result + (this.parameterMapping != null ? this.parameterMapping.hashCode() : 0);
            result = 31 * result + (this.subtype != null ? this.subtype.hashCode() : 0);
            return result;
        }
    }
}
